/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.server.s2s;

import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.modules.extension.xep0220_server_dailback.DialbackIdGenerator;
import org.apache.vysper.xmpp.protocol.ResponseStanzaContainer;
import org.apache.vysper.xmpp.protocol.ResponseStanzaContainerImpl;
import org.apache.vysper.xmpp.protocol.SessionStateHolder;
import org.apache.vysper.xmpp.protocol.StanzaHandler;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.server.SessionState;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeaturesHandler
implements StanzaHandler {
    private static final Logger LOG = LoggerFactory.getLogger(FeaturesHandler.class);

    public String getName() {
        return "features";
    }

    public boolean verify(Stanza stanza) {
        if (stanza == null) {
            return false;
        }
        if (!this.getName().equals(stanza.getName())) {
            return false;
        }
        String namespaceURI = stanza.getNamespaceURI();
        if (namespaceURI == null) {
            return false;
        }
        return namespaceURI.equals("http://etherx.jabber.org/streams");
    }

    public boolean isSessionRequired() {
        return true;
    }

    public ResponseStanzaContainer execute(Stanza stanza, ServerRuntimeContext serverRuntimeContext, boolean isOutboundStanza, SessionContext sessionContext, SessionStateHolder sessionStateHolder) {
        if (sessionStateHolder.getState() != SessionState.AUTHENTICATED) {
            Entity otherServer = sessionContext.getInitiatingEntity();
            if (this.startTlsSupported(stanza) && serverRuntimeContext.getSslContext() != null) {
                LOG.info("XMPP server connector to {} is starting TLS", (Object)otherServer);
                Stanza startTlsStanza = (Stanza)new StanzaBuilder("starttls", "urn:ietf:params:xml:ns:xmpp-tls").build();
                return new ResponseStanzaContainerImpl(startTlsStanza);
            }
            if (this.dialbackSupported(stanza)) {
                Entity originating = serverRuntimeContext.getServerEnitity();
                String dailbackId = new DialbackIdGenerator().generate(otherServer, originating, sessionContext.getSessionId());
                Stanza dbResult = (Stanza)((StanzaBuilder)((StanzaBuilder)((StanzaBuilder)new StanzaBuilder("result", "jabber:server:dialback", "db").addAttribute("from", originating.getDomain())).addAttribute("to", otherServer.getDomain())).addText(dailbackId)).build();
                return new ResponseStanzaContainerImpl(dbResult);
            }
            throw new RuntimeException("Unsupported features");
        }
        return null;
    }

    private boolean startTlsSupported(Stanza stanza) {
        return !stanza.getInnerElementsNamed("starttls", "urn:ietf:params:xml:ns:xmpp-tls").isEmpty();
    }

    private boolean dialbackSupported(Stanza stanza) {
        return !stanza.getInnerElementsNamed("dialback", "urn:xmpp:features:dialback").isEmpty();
    }
}

