/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.server.s2s;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.UnresolvedAddressException;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterChainBuilder;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoConnector;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.ssl.SslFilter;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.apache.vysper.mina.MinaBackedSessionContext;
import org.apache.vysper.mina.StanzaLoggingFilter;
import org.apache.vysper.mina.codec.XMPPProtocolCodecFactory;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.delivery.failure.RemoteServerNotFoundException;
import org.apache.vysper.xmpp.delivery.failure.RemoteServerTimeoutException;
import org.apache.vysper.xmpp.modules.extension.xep0119_xmppping.XmppPingListener;
import org.apache.vysper.xmpp.modules.extension.xep0119_xmppping.XmppPingModule;
import org.apache.vysper.xmpp.modules.extension.xep0220_server_dailback.DbResultHandler;
import org.apache.vysper.xmpp.modules.extension.xep0220_server_dailback.DbVerifyHandler;
import org.apache.vysper.xmpp.modules.extension.xep0220_server_dailback.DialbackIdGenerator;
import org.apache.vysper.xmpp.protocol.ResponseStanzaContainer;
import org.apache.vysper.xmpp.protocol.SessionStateHolder;
import org.apache.vysper.xmpp.protocol.StanzaHandler;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.server.SessionState;
import org.apache.vysper.xmpp.server.XMPPVersion;
import org.apache.vysper.xmpp.server.response.ServerResponses;
import org.apache.vysper.xmpp.server.s2s.FeaturesHandler;
import org.apache.vysper.xmpp.server.s2s.TlsProceedHandler;
import org.apache.vysper.xmpp.server.s2s.XMPPServerConnector;
import org.apache.vysper.xmpp.server.s2s.XmppEndpointResolver;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultXMPPServerConnector
implements XmppPingListener,
XMPPServerConnector {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultXMPPServerConnector.class);
    private ServerRuntimeContext serverRuntimeContext;
    private MinaBackedSessionContext sessionContext;
    private Entity otherServer;
    private SessionStateHolder sessionStateHolder = new SessionStateHolder();
    private IoConnector connector;
    private int connectTimeout = 30000;
    private int xmppHandshakeTimeout = 30000;
    private int pingPeriod = 30000;
    private int pingTimeout = 10000;
    private boolean closed = false;
    private SessionContext dialbackSessionContext;
    private SessionStateHolder dialbackSessionStateHolder;
    private Timer pingTimer;

    public DefaultXMPPServerConnector(Entity otherServer, ServerRuntimeContext serverRuntimeContext, SessionContext dialbackSessionContext, SessionStateHolder dialbackSessionStateHolder) {
        this.serverRuntimeContext = serverRuntimeContext;
        this.otherServer = otherServer;
        this.dialbackSessionContext = dialbackSessionContext;
        this.dialbackSessionStateHolder = dialbackSessionStateHolder;
    }

    public synchronized void start() throws RemoteServerNotFoundException, RemoteServerTimeoutException {
        LOG.info("Starting XMPP server connector to {}", (Object)this.otherServer);
        CountDownLatch authenticatedLatch = new CountDownLatch(1);
        boolean successfullyConnected = false;
        XmppEndpointResolver resolver = new XmppEndpointResolver();
        List<XmppEndpointResolver.ResolvedAddress> addresses = resolver.resolveXmppServer(this.otherServer.getDomain());
        Throwable lastException = null;
        if (!addresses.isEmpty()) {
            for (XmppEndpointResolver.ResolvedAddress address : addresses) {
                LOG.info("Connecting to XMPP server {} at {}", (Object)this.otherServer, (Object)address.getAddress());
                this.connector = this.createConnector(authenticatedLatch);
                ConnectFuture connectFuture = this.connector.connect((SocketAddress)address.getAddress());
                if (connectFuture.awaitUninterruptibly((long)this.connectTimeout) && connectFuture.isConnected()) {
                    try {
                        if (authenticatedLatch.await(this.xmppHandshakeTimeout, TimeUnit.MILLISECONDS)) {
                            successfullyConnected = true;
                            break;
                        }
                        LOG.warn("XMPP handshake with {} at () timed out", (Object)this.otherServer, (Object)address.getAddress());
                    }
                    catch (InterruptedException e) {
                        throw new RemoteServerTimeoutException("Connection to " + this.otherServer + " was interrupted", e);
                    }
                }
                lastException = connectFuture.getException();
                LOG.warn("Failed connecting to XMPP server " + this.otherServer + " at " + address.getAddress(), connectFuture.getException());
                this.connector.dispose();
                this.connector = null;
            }
        } else {
            throw new RemoteServerNotFoundException("DNS lookup of remote server failed");
        }
        if (!successfullyConnected) {
            String exceptionMsg = "Failed to connect to XMPP server at " + this.otherServer;
            if (lastException instanceof UnresolvedAddressException) {
                throw new RemoteServerNotFoundException(exceptionMsg);
            }
            throw new RemoteServerTimeoutException(exceptionMsg);
        }
    }

    private NioSocketConnector createConnector(CountDownLatch authenticatedLatch) {
        NioSocketConnector connector = new NioSocketConnector();
        DefaultIoFilterChainBuilder filterChainBuilder = new DefaultIoFilterChainBuilder();
        filterChainBuilder.addLast("xmppCodec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new XMPPProtocolCodecFactory()));
        filterChainBuilder.addLast("loggingFilter", (IoFilter)new StanzaLoggingFilter());
        connector.setFilterChainBuilder((IoFilterChainBuilder)filterChainBuilder);
        connector.setHandler((IoHandler)new ConnectorIoHandler(authenticatedLatch));
        return connector;
    }

    private void startPinging() {
        if (this.pingTimer == null && this.serverRuntimeContext.getModule(XmppPingModule.class) != null) {
            this.pingTimer = new Timer("pingtimer", true);
            this.pingTimer.schedule((TimerTask)new PingTask(), this.pingPeriod, (long)this.pingPeriod);
        }
    }

    public void write(Stanza stanza) {
        this.sessionContext.write(stanza);
    }

    public void close() {
        this.closed = true;
        if (!this.closed) {
            LOG.info("XMPP server connector to {} closing", (Object)this.otherServer);
            this.sessionContext.close();
            this.connector.dispose();
            this.pingTimer.cancel();
            LOG.info("XMPP server connector to {} closed", (Object)this.otherServer);
        }
    }

    public void pong() {
    }

    public void timeout() {
        LOG.debug("XMPP server connector to {} timed out, closing", (Object)this.otherServer);
        this.close();
    }

    public boolean isClosed() {
        return this.closed;
    }

    private class PingTask
    extends TimerTask {
        private PingTask() {
        }

        public void run() {
            XmppPingModule pingModule = DefaultXMPPServerConnector.this.serverRuntimeContext.getModule(XmppPingModule.class);
            pingModule.ping(DefaultXMPPServerConnector.this, DefaultXMPPServerConnector.this.serverRuntimeContext.getServerEnitity(), DefaultXMPPServerConnector.this.otherServer, DefaultXMPPServerConnector.this.pingTimeout, DefaultXMPPServerConnector.this);
        }
    }

    private final class ConnectorIoHandler
    extends IoHandlerAdapter {
        private final List<StanzaHandler> handlers = Arrays.asList(new DbVerifyHandler(), new DbResultHandler(), new TlsProceedHandler(), new FeaturesHandler());
        private final CountDownLatch authenticatedLatch;

        private ConnectorIoHandler(CountDownLatch authenticatedLatch) {
            this.authenticatedLatch = authenticatedLatch;
        }

        public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
            if (cause instanceof IOException) {
                DefaultXMPPServerConnector.this.close();
            } else {
                LOG.warn("Exception thrown by XMPP server connector to " + DefaultXMPPServerConnector.this.otherServer + ", probably a bug in Vysper", cause);
            }
        }

        private StanzaHandler lookupHandler(Stanza stanza) {
            for (StanzaHandler handler : this.handlers) {
                if (!handler.verify(stanza)) continue;
                return handler;
            }
            return null;
        }

        public void messageReceived(IoSession session, Object message) throws Exception {
            if (message == SslFilter.SESSION_SECURED) {
                DefaultXMPPServerConnector.this.sessionStateHolder.setState(SessionState.ENCRYPTED);
                LOG.info("XMPP server connector to {} secured using TLS", (Object)DefaultXMPPServerConnector.this.otherServer);
                LOG.debug("XMPP server connector to {} restarting stream", (Object)DefaultXMPPServerConnector.this.otherServer);
                DefaultXMPPServerConnector.this.sessionContext.setIsReopeningXMLStream();
                Stanza opener = new ServerResponses().getStreamOpenerForServerConnector(DefaultXMPPServerConnector.this.serverRuntimeContext.getServerEnitity(), DefaultXMPPServerConnector.this.otherServer, XMPPVersion.VERSION_1_0, DefaultXMPPServerConnector.this.sessionContext);
                DefaultXMPPServerConnector.this.sessionContext.write(opener);
            } else if (message == SslFilter.SESSION_UNSECURED) {
                DefaultXMPPServerConnector.this.close();
            } else if (message instanceof Stanza) {
                Stanza stanza = (Stanza)((Object)message);
                StanzaHandler handler = this.lookupHandler(stanza);
                if (handler != null) {
                    ResponseStanzaContainer container = handler.execute(stanza, DefaultXMPPServerConnector.this.serverRuntimeContext, false, DefaultXMPPServerConnector.this.sessionContext, DefaultXMPPServerConnector.this.sessionStateHolder);
                    if (container != null && container.hasResponse()) {
                        DefaultXMPPServerConnector.this.sessionContext.write(container.getResponseStanza());
                    }
                    if (DefaultXMPPServerConnector.this.sessionStateHolder.getState() == SessionState.AUTHENTICATED) {
                        LOG.info("XMPP server connector to {} authenticated", (Object)DefaultXMPPServerConnector.this.otherServer);
                        this.authenticatedLatch.countDown();
                        DefaultXMPPServerConnector.this.startPinging();
                    }
                } else if (stanza.getName().equals("stream")) {
                    DefaultXMPPServerConnector.this.sessionContext.setSessionId(stanza.getAttributeValue("id"));
                    DefaultXMPPServerConnector.this.sessionContext.setInitiatingEntity(DefaultXMPPServerConnector.this.otherServer);
                    String version = stanza.getAttributeValue("version");
                    if (version == null) {
                        String dailbackId = new DialbackIdGenerator().generate(DefaultXMPPServerConnector.this.otherServer, DefaultXMPPServerConnector.this.serverRuntimeContext.getServerEnitity(), DefaultXMPPServerConnector.this.sessionContext.getSessionId());
                        Stanza dbResult = (Stanza)((StanzaBuilder)((StanzaBuilder)((StanzaBuilder)new StanzaBuilder("result", "jabber:server:dialback", "db").addAttribute("from", DefaultXMPPServerConnector.this.serverRuntimeContext.getServerEnitity().getDomain())).addAttribute("to", DefaultXMPPServerConnector.this.otherServer.getDomain())).addText(dailbackId)).build();
                        DefaultXMPPServerConnector.this.write(dbResult);
                    }
                    if (DefaultXMPPServerConnector.this.dialbackSessionContext != null) {
                        DefaultXMPPServerConnector.this.sessionContext.putAttribute("DIALBACK_SESSION_CONTEXT", DefaultXMPPServerConnector.this.dialbackSessionContext);
                        DefaultXMPPServerConnector.this.sessionContext.putAttribute("DIALBACK_SESSION_STATE_HOLDER", DefaultXMPPServerConnector.this.dialbackSessionStateHolder);
                        DefaultXMPPServerConnector.this.sessionContext.setInitiatingEntity(DefaultXMPPServerConnector.this.otherServer);
                        DefaultXMPPServerConnector.this.sessionStateHolder.setState(SessionState.AUTHENTICATED);
                        this.authenticatedLatch.countDown();
                    }
                }
            } else {
                throw new RuntimeException("Only handles SSL events and stanzas, got: " + message.getClass());
            }
        }

        public void sessionClosed(IoSession session) throws Exception {
            LOG.info("XMPP server connector socket closed, closing connector");
            DefaultXMPPServerConnector.this.close();
        }

        public void sessionOpened(IoSession session) throws Exception {
            DefaultXMPPServerConnector.this.sessionContext = new MinaBackedSessionContext(DefaultXMPPServerConnector.this.serverRuntimeContext, DefaultXMPPServerConnector.this.sessionStateHolder, session);
            DefaultXMPPServerConnector.this.sessionStateHolder.setState(SessionState.INITIATED);
            Stanza opener = new ServerResponses().getStreamOpenerForServerConnector(DefaultXMPPServerConnector.this.serverRuntimeContext.getServerEnitity(), DefaultXMPPServerConnector.this.otherServer, XMPPVersion.VERSION_1_0, DefaultXMPPServerConnector.this.sessionContext);
            DefaultXMPPServerConnector.this.sessionContext.write(opener);
        }
    }
}

