/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0050_adhoc_commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xml.fragment.XMLSemanticError;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.modules.core.base.handler.DefaultIQHandler;
import org.apache.vysper.xmpp.modules.extension.xep0050_adhoc_commands.AdhocCommandHandler;
import org.apache.vysper.xmpp.modules.extension.xep0050_adhoc_commands.AdhocCommandSupport;
import org.apache.vysper.xmpp.modules.extension.xep0050_adhoc_commands.Note;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.server.response.ServerErrorResponses;
import org.apache.vysper.xmpp.stanza.IQStanza;
import org.apache.vysper.xmpp.stanza.IQStanzaType;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;
import org.apache.vysper.xmpp.stanza.StanzaErrorCondition;
import org.apache.vysper.xmpp.stanza.StanzaErrorType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdhocCommandIQHandler
extends DefaultIQHandler {
    protected final Collection<AdhocCommandSupport> adhocCommandSupporters;
    protected final Map<String, AdhocCommandHandler> runningCommands = new HashMap<String, AdhocCommandHandler>();

    public AdhocCommandIQHandler(Collection<AdhocCommandSupport> adhocCommandSupporters) {
        this.adhocCommandSupporters = adhocCommandSupporters;
    }

    @Override
    protected boolean verifyNamespace(Stanza stanza) {
        return this.verifyInnerNamespace(stanza, "http://jabber.org/protocol/commands");
    }

    @Override
    protected boolean verifyInnerElement(Stanza stanza) {
        return this.verifyInnerElementWorker(stanza, "command");
    }

    @Override
    protected Stanza handleSet(IQStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext) {
        String action;
        String requestedSessionId;
        String commandNode;
        Entity from = stanza.getFrom();
        if (from == null) {
            from = sessionContext.getInitiatingEntity();
        }
        AdhocCommandHandler commandHandler = null;
        List commandElements = null;
        try {
            XMLElement commandElement = stanza.getSingleInnerElementsNamed("command");
            if (commandElement == null) {
                return ServerErrorResponses.getStanzaError(StanzaErrorCondition.BAD_REQUEST, stanza, StanzaErrorType.MODIFY, "command is missing", null, null);
            }
            commandNode = commandElement.getAttributeValue("node");
            requestedSessionId = commandElement.getAttributeValue("sessionid");
            action = commandElement.getAttributeValue("action");
            if (StringUtils.isEmpty((String)requestedSessionId)) {
                for (AdhocCommandSupport commandSupport : this.adhocCommandSupporters) {
                    commandHandler = commandSupport.getCommandHandler(commandNode, from);
                    if (commandHandler == null) continue;
                    this.runningCommands.put(commandHandler.getSessionId(), commandHandler);
                    break;
                }
            } else {
                commandHandler = this.runningCommands.get(requestedSessionId);
                if (commandHandler == null) {
                    return ServerErrorResponses.getStanzaError(StanzaErrorCondition.BAD_REQUEST, stanza, StanzaErrorType.CANCEL, "command session id not found: " + requestedSessionId, null, null);
                }
            }
            commandElements = commandElement.getInnerElements();
        }
        catch (XMLSemanticError xmlSemanticError) {
            return ServerErrorResponses.getStanzaError(StanzaErrorCondition.BAD_REQUEST, stanza, StanzaErrorType.MODIFY, "command is not well-formed", null, null);
        }
        if ("cancel".equals(action)) {
            this.runningCommands.remove(requestedSessionId);
            return this.buildResponse(stanza, from, commandNode, requestedSessionId, "canceled");
        }
        if (commandHandler == null) {
            return ServerErrorResponses.getStanzaError(StanzaErrorCondition.FORBIDDEN, stanza, StanzaErrorType.CANCEL, "command is not available", null, null);
        }
        ArrayList<Note> notes = new ArrayList<Note>();
        XMLElement result = commandHandler.process(commandElements, notes);
        String sessionId = commandHandler.getSessionId();
        boolean isExecuting = commandHandler.isExecuting();
        Stanza response = this.buildResponse(stanza, from, commandNode, sessionId, isExecuting ? "executing" : "completed", result, notes, commandHandler.isPrevAllowed(), commandHandler.isNextAllowed());
        return response;
    }

    private Stanza buildResponse(IQStanza stanza, Entity from, String commandNode, String sessionId, String status) {
        return this.buildResponse(stanza, from, commandNode, sessionId, status, null, null, false, false);
    }

    private Stanza buildResponse(IQStanza stanza, Entity from, String commandNode, String sessionId, String status, XMLElement result, List<Note> notes, boolean isPrevAllowed, boolean isNextAllowed) {
        StanzaBuilder iqStanza = StanzaBuilder.createIQStanza(null, from, IQStanzaType.RESULT, stanza.getID());
        iqStanza.startInnerElement("command");
        iqStanza.declareNamespace("", "http://jabber.org/protocol/commands");
        iqStanza.addAttribute("node", commandNode);
        iqStanza.addAttribute("sessionid", sessionId);
        iqStanza.addAttribute("status", status);
        if (notes != null && notes.size() > 0) {
            for (Note note : notes) {
                iqStanza.startInnerElement("note");
                iqStanza.addAttribute("type", note.getType().name());
                if (note.getText() != null) {
                    iqStanza.addText(note.getText());
                }
                iqStanza.endInnerElement();
            }
        }
        if (isNextAllowed || isPrevAllowed) {
            iqStanza.startInnerElement("action");
            if (isPrevAllowed) {
                ((StanzaBuilder)iqStanza.startInnerElement("prev")).endInnerElement();
            }
            if (isNextAllowed) {
                ((StanzaBuilder)iqStanza.startInnerElement("next")).endInnerElement();
            }
            iqStanza.endInnerElement();
        }
        if (result != null) {
            iqStanza.addPreparedElement(result);
        }
        iqStanza.endInnerElement();
        return (Stanza)iqStanza.build();
    }

    @Override
    protected Stanza handleGet(IQStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext) {
        Entity to = stanza.getTo();
        Entity from = stanza.getFrom();
        if (from == null) {
            from = sessionContext.getInitiatingEntity();
        }
        StanzaBuilder stanzaBuilder = StanzaBuilder.createIQStanza(stanza.getTo(), stanza.getFrom(), IQStanzaType.RESULT, stanza.getID());
        return (Stanza)stanzaBuilder.build();
    }
}

