/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.authorization;

import java.util.HashMap;
import java.util.Map;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.addressing.EntityImpl;
import org.apache.vysper.xmpp.authorization.AccountCreationException;
import org.apache.vysper.xmpp.authorization.AccountManagement;
import org.apache.vysper.xmpp.authorization.UserAuthorization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleUserAuthorization
implements UserAuthorization,
AccountManagement {
    private final Map<Entity, String> userPasswordMap = new HashMap<Entity, String>();

    public SimpleUserAuthorization() {
    }

    public SimpleUserAuthorization(Map<Entity, String> userPasswordMap) {
        this.userPasswordMap.putAll(userPasswordMap);
    }

    @Override
    public void addUser(Entity username, String password) {
        this.userPasswordMap.put(username, password);
    }

    @Override
    public void changePassword(Entity username, String password) throws AccountCreationException {
        if (!this.userPasswordMap.containsKey(username)) {
            throw new AccountCreationException("could not change password for unknown user " + username);
        }
        this.userPasswordMap.put(username, password);
    }

    @Override
    public boolean verifyCredentials(Entity jid, String passwordCleartext, Object credentials) {
        return this.verify(jid.getBareJID(), passwordCleartext);
    }

    @Override
    public boolean verifyCredentials(String username, String passwordCleartext, Object credentials) {
        return this.verify(EntityImpl.parseUnchecked(username).getBareJID(), passwordCleartext);
    }

    @Override
    public boolean verifyAccountExists(Entity jid) {
        return this.userPasswordMap.get(jid.getBareJID()) != null;
    }

    private boolean verify(Entity username, String passwordCleartext) {
        return passwordCleartext.equals(this.userPasswordMap.get(username));
    }
}

