/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.BitSet;
import org.apache.jackrabbit.core.query.lucene.CachingIndexReader;
import org.apache.jackrabbit.core.query.lucene.CommittableIndexReader;
import org.apache.jackrabbit.core.query.lucene.DocId;
import org.apache.jackrabbit.core.query.lucene.RefCountingIndexReader;
import org.apache.jackrabbit.core.query.lucene.SharedIndexReader;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermPositions;

class ReadOnlyIndexReader
extends RefCountingIndexReader {
    private final SharedIndexReader reader;
    private final BitSet deleted;
    private long deletedDocsVersion;

    public ReadOnlyIndexReader(SharedIndexReader reader, BitSet deleted, long deletedDocsVersion) {
        super((IndexReader)reader);
        this.reader = reader;
        this.deleted = deleted;
        this.deletedDocsVersion = deletedDocsVersion;
        reader.acquire();
    }

    long getDeletedDocsVersion() {
        return this.deletedDocsVersion;
    }

    long getCreationTick() {
        return this.reader.getCreationTick();
    }

    void updateDeletedDocs(CommittableIndexReader reader) {
        int maxDoc = reader.maxDoc();
        for (int i = 0; i < maxDoc; ++i) {
            if (!reader.isDeleted(i)) continue;
            this.deleted.set(i);
        }
        this.deletedDocsVersion = reader.getModificationCount();
    }

    public DocId getParent(int n) throws IOException {
        return this.getBase().getParent(n, this.deleted);
    }

    public SharedIndexReader getBase() {
        return (SharedIndexReader)this.in;
    }

    public boolean isDeleted(int n) {
        return this.deleted.get(n);
    }

    public boolean hasDeletions() {
        return !this.deleted.isEmpty();
    }

    public int numDocs() {
        return this.maxDoc() - this.deleted.cardinality();
    }

    protected final void doDelete(int docNum) {
        throw new UnsupportedOperationException("IndexReader is read-only");
    }

    protected final void doUndeleteAll() {
        throw new UnsupportedOperationException("IndexReader is read-only");
    }

    protected final void doCommit() {
        throw new UnsupportedOperationException("IndexReader is read-only");
    }

    public TermDocs termDocs(Term term) throws IOException {
        Object td = this.reader.termDocs(term);
        if (td != CachingIndexReader.EMPTY) {
            td = new FilteredTermDocs((TermDocs)td);
        }
        return td;
    }

    public TermDocs termDocs() throws IOException {
        return new FilteredTermDocs(super.termDocs());
    }

    public TermPositions termPositions() throws IOException {
        return new FilteredTermPositions(super.termPositions());
    }

    private final class FilteredTermPositions
    extends FilteredTermDocs
    implements TermPositions {
        public FilteredTermPositions(TermPositions in) {
            super((TermDocs)in);
        }

        public int nextPosition() throws IOException {
            return ((TermPositions)this.in).nextPosition();
        }

        public int getPayloadLength() {
            return ((TermPositions)this.in).getPayloadLength();
        }

        public byte[] getPayload(byte[] data, int offset) throws IOException {
            return ((TermPositions)this.in).getPayload(data, offset);
        }

        public boolean isPayloadAvailable() {
            return ((TermPositions)this.in).isPayloadAvailable();
        }
    }

    private class FilteredTermDocs
    extends FilterIndexReader.FilterTermDocs {
        public FilteredTermDocs(TermDocs in) {
            super(in);
        }

        public boolean next() throws IOException {
            boolean hasNext = super.next();
            while (hasNext && ReadOnlyIndexReader.this.deleted.get(super.doc())) {
                hasNext = super.next();
            }
            return hasNext;
        }

        public int read(int[] docs, int[] freqs) throws IOException {
            int count;
            for (count = 0; count < docs.length && this.next(); ++count) {
                docs[count] = this.doc();
                freqs[count] = this.freq();
            }
            return count;
        }

        public boolean skipTo(int i) throws IOException {
            boolean exists = super.skipTo(i);
            while (exists && ReadOnlyIndexReader.this.deleted.get(this.doc())) {
                exists = this.next();
            }
            return exists;
        }
    }
}

