/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.nodetype.NodeDefinitionImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.security.authorization.acl.ACLEditor;
import org.apache.jackrabbit.core.security.user.UserManagerImpl;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;

public abstract class SecurityItemModifier {
    protected SecurityItemModifier() {
        Class<?> cl = this.getClass();
        if (!(cl.equals(UserManagerImpl.class) || cl.equals(ACLEditor.class) || cl.equals(org.apache.jackrabbit.core.security.authorization.principalbased.ACLEditor.class))) {
            throw new IllegalArgumentException("Only UserManagerImpl and ACLEditor may extend from the SecurityItemModifier");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodeImpl addSecurityNode(NodeImpl parentImpl, Name name, Name ntName) throws RepositoryException, PathNotFoundException, LockException, ConstraintViolationException, ItemExistsException, VersionException {
        NodeImpl nodeImpl = parentImpl;
        synchronized (nodeImpl) {
            parentImpl.checkSetProperty();
            NodeTypeImpl nodeType = parentImpl.session.getNodeTypeManager().getNodeType(ntName);
            NodeDefinitionImpl def = parentImpl.getApplicableChildNodeDefinition(name, ntName);
            NodeState thisState = (NodeState)parentImpl.getItemState();
            ChildNodeEntry cne = thisState.getChildNodeEntry(name, 1);
            if (cne != null) {
                if (!def.allowsSameNameSiblings()) {
                    throw new ItemExistsException();
                }
                NodeId newId = cne.getId();
                NodeImpl n = (NodeImpl)parentImpl.session.getItemManager().getItem(newId);
                if (!n.getDefinition().allowsSameNameSiblings()) {
                    throw new ItemExistsException();
                }
            }
            return parentImpl.createChildNode(name, def, nodeType, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Property setSecurityProperty(NodeImpl parentImpl, Name name, Value value) throws RepositoryException, PathNotFoundException, LockException, ConstraintViolationException, ItemExistsException, VersionException {
        NodeImpl nodeImpl = parentImpl;
        synchronized (nodeImpl) {
            parentImpl.checkSetProperty();
            InternalValue intVs = InternalValue.create(value, parentImpl.session);
            return parentImpl.internalSetProperty(name, intVs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Property setSecurityProperty(NodeImpl parentImpl, Name name, Value[] values) throws RepositoryException, PathNotFoundException, LockException, ConstraintViolationException, ItemExistsException, VersionException {
        NodeImpl nodeImpl = parentImpl;
        synchronized (nodeImpl) {
            parentImpl.checkSetProperty();
            InternalValue[] intVs = new InternalValue[values.length];
            for (int i = 0; i < values.length; ++i) {
                intVs[i] = InternalValue.create(values[i], parentImpl.session);
            }
            return parentImpl.internalSetProperty(name, intVs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSecurityItem(ItemImpl itemImpl) throws LockException, VersionException, AccessDeniedException, ItemNotFoundException, RepositoryException {
        NodeImpl n;
        NodeImpl nodeImpl = n = itemImpl.isNode() ? (NodeImpl)itemImpl : (NodeImpl)itemImpl.getParent();
        synchronized (nodeImpl) {
            n.checkSetProperty();
            itemImpl.internalRemove(true);
        }
    }
}

