/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.condition;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Condition;
import org.assertj.core.condition.Join;
import org.assertj.core.description.Description;

public class NestableCondition<ACTUAL, NESTED>
extends Join<ACTUAL> {
    private final String descriptionPrefix;

    @SafeVarargs
    public static <ACTUAL, NESTED> Condition<ACTUAL> nestable(String descriptionPrefix, Function<ACTUAL, NESTED> extractor, Condition<NESTED> ... conditions) {
        return new NestableCondition<ACTUAL, NESTED>(descriptionPrefix, Arrays.stream(conditions), extractor);
    }

    @SafeVarargs
    public static <ACTUAL> Condition<ACTUAL> nestable(String descriptionPrefix, Condition<ACTUAL> ... conditions) {
        return new NestableCondition(descriptionPrefix, Arrays.stream(conditions));
    }

    private NestableCondition(String descriptionPrefix, Stream<Condition<NESTED>> conditions, Function<ACTUAL, NESTED> extractor) {
        super(NestableCondition.compose(conditions, extractor));
        this.descriptionPrefix = descriptionPrefix;
    }

    private NestableCondition(String descriptionPrefix, Stream<Condition<ACTUAL>> conditions) {
        super(conditions.collect(Collectors.toList()));
        this.descriptionPrefix = descriptionPrefix;
    }

    @Override
    public boolean matches(ACTUAL value) {
        return this.conditions.stream().allMatch(condition -> condition.matches(value));
    }

    @Override
    public String descriptionPrefix() {
        return this.descriptionPrefix;
    }

    private static <ACTUAL, NESTED> List<Condition<ACTUAL>> compose(Stream<Condition<NESTED>> conditions, Function<ACTUAL, NESTED> extractor) {
        return conditions.map(condition -> NestableCondition.compose(condition, extractor)).collect(Collectors.toList());
    }

    private static <ACTUAL, NESTED> Condition<ACTUAL> compose(final Condition<NESTED> condition, final Function<ACTUAL, NESTED> extractor) {
        return new Condition<ACTUAL>(){

            @Override
            public boolean matches(ACTUAL value) {
                return condition.matches(extractor.apply(value));
            }

            @Override
            public Description conditionDescriptionWithStatus(ACTUAL actual) {
                return condition.conditionDescriptionWithStatus(extractor.apply(actual));
            }
        };
    }
}

