/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.List;
import java.util.Map;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.DefaultLifecycles;
import org.apache.maven.lifecycle.MissingProjectException;
import org.apache.maven.lifecycle.NoGoalSpecifiedException;
import org.apache.maven.lifecycle.internal.BuildListCalculator;
import org.apache.maven.lifecycle.internal.ExecutionEventCatapult;
import org.apache.maven.lifecycle.internal.LifecycleDebugLogger;
import org.apache.maven.lifecycle.internal.LifecycleTaskSegmentCalculator;
import org.apache.maven.lifecycle.internal.ProjectBuildList;
import org.apache.maven.lifecycle.internal.ProjectIndex;
import org.apache.maven.lifecycle.internal.ReactorBuildStatus;
import org.apache.maven.lifecycle.internal.ReactorContext;
import org.apache.maven.lifecycle.internal.TaskSegment;
import org.apache.maven.lifecycle.internal.builder.Builder;
import org.apache.maven.lifecycle.internal.builder.BuilderNotFoundException;
import org.apache.maven.session.scope.internal.SessionScope;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

@Component(role=LifecycleStarter.class)
public class LifecycleStarter {
    @Requirement
    private ExecutionEventCatapult eventCatapult;
    @Requirement
    private DefaultLifecycles defaultLifeCycles;
    @Requirement
    private Logger logger;
    @Requirement
    private BuildListCalculator buildListCalculator;
    @Requirement
    private LifecycleDebugLogger lifecycleDebugLogger;
    @Requirement
    private LifecycleTaskSegmentCalculator lifecycleTaskSegmentCalculator;
    @Requirement
    private Map<String, Builder> builders;
    @Requirement
    private SessionScope sessionScope;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(MavenSession session) {
        this.eventCatapult.fire(ExecutionEvent.Type.SessionStarted, session, null);
        ReactorContext reactorContext = null;
        ProjectBuildList projectBuilds = null;
        MavenExecutionResult result = session.getResult();
        try {
            if (this.buildExecutionRequiresProject(session) && this.projectIsNotPresent(session)) {
                throw new MissingProjectException("The goal you specified requires a project to execute but there is no POM in this directory (" + session.getExecutionRootDirectory() + "). Please verify you invoked Maven from the correct directory.");
            }
            List<TaskSegment> taskSegments = this.lifecycleTaskSegmentCalculator.calculateTaskSegments(session);
            projectBuilds = this.buildListCalculator.calculateProjectBuilds(session, taskSegments);
            if (projectBuilds.isEmpty()) {
                throw new NoGoalSpecifiedException("No goals have been specified for this build. You must specify a valid lifecycle phase or a goal in the format <plugin-prefix>:<goal> or <plugin-group-id>:<plugin-artifact-id>[:<plugin-version>]:<goal>. Available lifecycle phases are: " + this.defaultLifeCycles.getLifecyclePhaseList() + ".");
            }
            ProjectIndex projectIndex = new ProjectIndex(session.getProjects());
            if (this.logger.isDebugEnabled()) {
                this.lifecycleDebugLogger.debugReactorPlan(projectBuilds);
            }
            ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
            ReactorBuildStatus reactorBuildStatus = new ReactorBuildStatus(session.getProjectDependencyGraph());
            reactorContext = new ReactorContext(result, projectIndex, oldContextClassLoader, reactorBuildStatus);
            String builderId = session.getRequest().getBuilderId();
            Builder builder = this.builders.get(builderId);
            if (builder == null) {
                throw new BuilderNotFoundException(String.format("The builder requested using id = %s cannot be found", builderId));
            }
            int degreeOfConcurrency = session.getRequest().getDegreeOfConcurrency();
            if (degreeOfConcurrency > 1) {
                this.logger.info("");
                this.logger.info(String.format("Using the %s implementation with a thread count of %d", builder.getClass().getSimpleName(), degreeOfConcurrency));
            }
            builder.build(session, reactorContext, projectBuilds, taskSegments, reactorBuildStatus);
        }
        catch (Exception e) {
            result.addException(e);
        }
        finally {
            this.eventCatapult.fire(ExecutionEvent.Type.SessionEnded, session, null);
        }
    }

    private boolean buildExecutionRequiresProject(MavenSession session) {
        return this.lifecycleTaskSegmentCalculator.requiresProject(session);
    }

    private boolean projectIsNotPresent(MavenSession session) {
        return !session.getRequest().isProjectPresent();
    }
}

