/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import org.apache.log4j.Category;
import org.opensaml.MalformedException;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SAMLNameIdentifier
extends SAMLObject
implements Cloneable {
    protected String name = null;
    protected String nameQualifier = null;
    protected String format = null;
    protected static Hashtable formatMap = new Hashtable();
    public static final String FORMAT_UNSPECIFIED = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
    public static final String FORMAT_EMAIL = "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress";
    public static final String FORMAT_X509 = "urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName";
    public static final String FORMAT_WINDOWS = "urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName";

    public static void regFactory(String string, String string2) {
        formatMap.put(string, string2);
    }

    public static void unregFactory(String string) {
        formatMap.remove(string);
    }

    public static SAMLNameIdentifier getInstance(Element element) throws SAMLException {
        if (element == null) {
            throw new MalformedException("SAMLNameIdentifier.getInstance() given an empty DOM");
        }
        try {
            String string = (String)formatMap.get(element.getAttributeNS(null, "Format"));
            if (string == null) {
                return new SAMLNameIdentifier(element);
            }
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[]{Element.class};
            Object[] objectArray = new Object[]{element};
            Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
            return (SAMLNameIdentifier)constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLNameIdentifier.getInstance() unable to locate implementation class for NameIdentifier", (Exception)classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLNameIdentifier.getInstance() unable to bind to constructor for NameIdentifier", (Exception)noSuchMethodException);
        }
        catch (InstantiationException instantiationException) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLNameIdentifier.getInstance() unable to build implementation object for NameIdentifier", (Exception)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLNameIdentifier.getInstance() unable to access implementation of NameIdentifier", (Exception)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof SAMLException) {
                throw (SAMLException)throwable;
            }
            throw new SAMLException(SAMLException.REQUESTER, "SAMLNameIdentifier.getInstance() caught unknown exception while building NameIdentifier object: " + throwable.getMessage());
        }
    }

    public static SAMLNameIdentifier getInstance(InputStream inputStream) throws SAMLException {
        try {
            Document document = XML.parserPool.parse(inputStream);
            return SAMLNameIdentifier.getInstance(document.getDocumentElement());
        }
        catch (SAXException sAXException) {
            Category.getInstance((String)"SAMLNameIdentifier").error((Object)("caught an exception while parsing a stream:\n" + sAXException.getMessage()));
            throw new MalformedException("SAMLNameIdentifier.getInstance() caught exception while parsing a stream", (Exception)sAXException);
        }
        catch (IOException iOException) {
            Category.getInstance((String)"SAMLNameIdentifier").error((Object)("caught an exception while parsing a stream:\n" + iOException.getMessage()));
            throw new MalformedException("SAMLNameIdentifier.getInstance() caught exception while parsing a stream", (Exception)iOException);
        }
    }

    public static SAMLNameIdentifier getInstance(String string) throws SAMLException {
        try {
            if (string == null) {
                return new SAMLNameIdentifier();
            }
            String string2 = (String)formatMap.get(string);
            if (string2 == null) {
                return new SAMLNameIdentifier(null, null, string);
            }
            Class<?> clazz = Class.forName(string2);
            Class[] classArray = new Class[]{String.class, String.class, String.class};
            Object[] objectArray = new Object[]{null, null, string};
            Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
            return (SAMLNameIdentifier)constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLNameIdentifier.getInstance() unable to locate implementation class for NameIdentifier", (Exception)classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLNameIdentifier.getInstance() unable to bind to constructor for NameIdentifier", (Exception)noSuchMethodException);
        }
        catch (InstantiationException instantiationException) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLNameIdentifier.getInstance() unable to build implementation object for NameIdentifier", (Exception)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLNameIdentifier.getInstance() unable to access implementation of NameIdentifier", (Exception)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof SAMLException) {
                throw (SAMLException)throwable;
            }
            throw new SAMLException(SAMLException.REQUESTER, "SAMLNameIdentifier.getInstance() caught unknown exception while building NameIdentifier object: " + throwable.getMessage());
        }
    }

    public SAMLNameIdentifier() {
    }

    public SAMLNameIdentifier(String string, String string2, String string3) throws SAMLException {
        this.name = XML.assign(string);
        this.nameQualifier = XML.assign(string2);
        this.format = XML.assign(string3);
    }

    public SAMLNameIdentifier(Element element) throws SAMLException {
        this.fromDOM(element);
    }

    public SAMLNameIdentifier(InputStream inputStream) throws SAMLException {
        this.fromDOM(SAMLNameIdentifier.fromStream(inputStream));
    }

    public void fromDOM(Element element) throws SAMLException {
        super.fromDOM(element);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:assertion", "NameIdentifier")) {
            throw new MalformedException("SAMLNameIdentifier.fromDOM() requires saml:NameIdentifier at root");
        }
        this.nameQualifier = XML.assign(element.getAttributeNS(null, "NameQualifier"));
        this.format = XML.assign(element.getAttributeNS(null, "Format"));
        this.name = XML.assign(element.getFirstChild().getNodeValue());
        this.checkValidity();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (XML.isEmpty(string)) {
            throw new IllegalArgumentException("name cannot be empty");
        }
        this.name = string;
        this.setDirty(true);
    }

    public String getNameQualifier() {
        return this.nameQualifier;
    }

    public void setNameQualifier(String string) {
        this.nameQualifier = XML.assign(string);
        this.setDirty(true);
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String string) {
        this.format = XML.assign(string);
        this.setDirty(true);
    }

    protected Element buildRoot(Document document, boolean bl) {
        Element element = document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "NameIdentifier");
        if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        }
        return element;
    }

    public Node toDOM(Document document, boolean bl) throws SAMLException {
        super.toDOM(document, bl);
        Element element = (Element)this.root;
        if (this.dirty) {
            if (!XML.isEmpty(this.nameQualifier)) {
                element.setAttributeNS(null, "NameQualifier", this.nameQualifier);
            }
            if (!XML.isEmpty(this.format)) {
                element.setAttributeNS(null, "Format", this.format);
            }
            element.appendChild(document.createTextNode(this.name));
            this.setDirty(false);
        } else if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        }
        return this.root;
    }

    public void checkValidity() throws SAMLException {
        if (XML.isEmpty(this.name)) {
            throw new MalformedException("NameIdentifier is invalid, requires name");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return (SAMLNameIdentifier)super.clone();
    }
}

