/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.AggregationOptions;
import com.mongodb.AggregationOutput;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.BulkWriteOperation;
import com.mongodb.BulkWriteResult;
import com.mongodb.Bytes;
import com.mongodb.CommandResult;
import com.mongodb.Cursor;
import com.mongodb.DB;
import com.mongodb.DBCursor;
import com.mongodb.DBDecoder;
import com.mongodb.DBDecoderFactory;
import com.mongodb.DBEncoder;
import com.mongodb.DBEncoderFactory;
import com.mongodb.DBObject;
import com.mongodb.GroupCommand;
import com.mongodb.InsertOptions;
import com.mongodb.LazyDBList;
import com.mongodb.LazyDBObject;
import com.mongodb.MapReduceCommand;
import com.mongodb.MapReduceOutput;
import com.mongodb.MongoException;
import com.mongodb.MongoInternalException;
import com.mongodb.ParallelScanOptions;
import com.mongodb.QueryOpBuilder;
import com.mongodb.QueryResultIterator;
import com.mongodb.ReadPreference;
import com.mongodb.ReflectionDBObject;
import com.mongodb.ServerVersion;
import com.mongodb.WriteConcern;
import com.mongodb.WriteRequest;
import com.mongodb.WriteResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.bson.types.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DBCollection {
    final DB _db;
    @Deprecated
    protected final String _name;
    @Deprecated
    protected final String _fullName;
    @Deprecated
    protected List<DBObject> _hintFields;
    private WriteConcern _concern = null;
    private ReadPreference _readPref = null;
    private DBDecoderFactory _decoderFactory;
    private DBEncoderFactory _encoderFactory;
    final Bytes.OptionHolder _options;
    @Deprecated
    protected Class _objectClass = null;
    private Map<String, Class> _internalClass = Collections.synchronizedMap(new HashMap());
    private ReflectionDBObject.JavaWrapper _wrapper = null;
    @Deprecated
    private final Set<String> _createdIndexes = new HashSet<String>();

    public WriteResult insert(DBObject[] arr, WriteConcern concern) {
        return this.insert(arr, concern, this.getDBEncoder());
    }

    public WriteResult insert(DBObject[] arr, WriteConcern concern, DBEncoder encoder) {
        return this.insert(Arrays.asList(arr), concern, encoder);
    }

    public WriteResult insert(DBObject o, WriteConcern concern) {
        return this.insert(Arrays.asList(o), concern);
    }

    public WriteResult insert(DBObject ... arr) {
        return this.insert(arr, this.getWriteConcern());
    }

    public WriteResult insert(WriteConcern concern, DBObject ... arr) {
        return this.insert(arr, concern);
    }

    public WriteResult insert(List<DBObject> list) {
        return this.insert(list, this.getWriteConcern());
    }

    public WriteResult insert(List<DBObject> list, WriteConcern concern) {
        return this.insert(list, concern, this.getDBEncoder());
    }

    public WriteResult insert(List<DBObject> list, WriteConcern concern, DBEncoder encoder) {
        return this.insertImpl(list, concern, encoder, null);
    }

    protected abstract WriteResult insertImpl(List<DBObject> var1, WriteConcern var2, DBEncoder var3, Boolean var4);

    public WriteResult insert(List<DBObject> documents, InsertOptions insertOptions) {
        WriteConcern writeConcern;
        WriteConcern writeConcern2 = writeConcern = insertOptions.getWriteConcern() != null ? insertOptions.getWriteConcern() : this.getWriteConcern();
        if (insertOptions.isContinueOnError()) {
            writeConcern = writeConcern.continueOnError(true);
        }
        DBEncoder dbEncoder = insertOptions.getDbEncoder() != null ? insertOptions.getDbEncoder() : this.getDBEncoder();
        return this.insertImpl(documents, writeConcern, dbEncoder, insertOptions.getBypassDocumentValidation());
    }

    public WriteResult update(DBObject q, DBObject o, boolean upsert, boolean multi, WriteConcern concern) {
        return this.update(q, o, upsert, multi, concern, this.getDBEncoder());
    }

    public WriteResult update(DBObject q, DBObject o, boolean upsert, boolean multi, WriteConcern concern, DBEncoder encoder) {
        return this.updateImpl(q, o, upsert, multi, concern, null, encoder);
    }

    public WriteResult update(DBObject q, DBObject o, boolean upsert, boolean multi, WriteConcern concern, boolean bypassDocumentValidation, DBEncoder encoder) {
        return this.updateImpl(q, o, upsert, multi, concern, bypassDocumentValidation, encoder);
    }

    protected abstract WriteResult updateImpl(DBObject var1, DBObject var2, boolean var3, boolean var4, WriteConcern var5, Boolean var6, DBEncoder var7);

    public WriteResult update(DBObject q, DBObject o, boolean upsert, boolean multi) {
        return this.update(q, o, upsert, multi, this.getWriteConcern());
    }

    public WriteResult update(DBObject q, DBObject o) {
        return this.update(q, o, false, false);
    }

    public WriteResult updateMulti(DBObject q, DBObject o) {
        return this.update(q, o, false, true);
    }

    @Deprecated
    protected abstract void doapply(DBObject var1);

    public WriteResult remove(DBObject o, WriteConcern concern) {
        return this.remove(o, concern, this.getDBEncoder());
    }

    public abstract WriteResult remove(DBObject var1, WriteConcern var2, DBEncoder var3);

    public WriteResult remove(DBObject o) {
        return this.remove(o, this.getWriteConcern());
    }

    abstract QueryResultIterator find(DBObject var1, DBObject var2, int var3, int var4, int var5, int var6, ReadPreference var7, DBDecoder var8);

    abstract QueryResultIterator find(DBObject var1, DBObject var2, int var3, int var4, int var5, int var6, ReadPreference var7, DBDecoder var8, DBEncoder var9);

    @Deprecated
    public DBCursor find(DBObject query, DBObject fields, int numToSkip, int batchSize, int options) {
        return this.find(query, fields, numToSkip, batchSize).addOption(options);
    }

    @Deprecated
    public DBCursor find(DBObject query, DBObject fields, int numToSkip, int batchSize) {
        DBCursor cursor = this.find(query, fields).skip(numToSkip).batchSize(batchSize);
        return cursor;
    }

    public DBObject findOne(Object id) {
        return this.findOne(id, null);
    }

    public DBObject findOne(Object id, DBObject projection) {
        return this.findOne(new BasicDBObject("_id", id), projection);
    }

    public DBObject findAndModify(DBObject query, DBObject fields, DBObject sort, boolean remove, DBObject update, boolean returnNew, boolean upsert) {
        return this.findAndModify(query, fields, sort, remove, update, returnNew, upsert, this.getWriteConcern());
    }

    public DBObject findAndModify(DBObject query, DBObject fields, DBObject sort, boolean remove, DBObject update, boolean returnNew, boolean upsert, WriteConcern writeConcern) {
        return this.findAndModifyImpl(query, fields, sort, remove, update, returnNew, upsert, null, 0L, TimeUnit.MILLISECONDS, writeConcern);
    }

    public DBObject findAndModify(DBObject query, DBObject fields, DBObject sort, boolean remove, DBObject update, boolean returnNew, boolean upsert, long maxTime, TimeUnit maxTimeUnit) {
        return this.findAndModify(query, fields, sort, remove, update, returnNew, upsert, maxTime, maxTimeUnit, this.getWriteConcern());
    }

    public DBObject findAndModify(DBObject query, DBObject fields, DBObject sort, boolean remove, DBObject update, boolean returnNew, boolean upsert, long maxTime, TimeUnit maxTimeUnit, WriteConcern writeConcern) {
        return this.findAndModifyImpl(query, fields, sort, remove, update, returnNew, upsert, null, maxTime, maxTimeUnit, writeConcern);
    }

    public DBObject findAndModify(DBObject query, DBObject fields, DBObject sort, boolean remove, DBObject update, boolean returnNew, boolean upsert, boolean bypassDocumentValidation, long maxTime, TimeUnit maxTimeUnit) {
        return this.findAndModify(query, fields, sort, remove, update, returnNew, upsert, bypassDocumentValidation, maxTime, maxTimeUnit, this.getWriteConcern());
    }

    public DBObject findAndModify(DBObject query, DBObject fields, DBObject sort, boolean remove, DBObject update, boolean returnNew, boolean upsert, boolean bypassDocumentValidation, long maxTime, TimeUnit maxTimeUnit, WriteConcern writeConcern) {
        return this.findAndModifyImpl(query, fields, sort, remove, update, returnNew, upsert, bypassDocumentValidation, maxTime, maxTimeUnit, writeConcern);
    }

    protected abstract DBObject findAndModifyImpl(DBObject var1, DBObject var2, DBObject var3, boolean var4, DBObject var5, boolean var6, boolean var7, Boolean var8, long var9, TimeUnit var11, WriteConcern var12);

    DBObject replaceWithObjectClass(DBObject oldObj) {
        if (oldObj == null || this.getObjectClass() == null & this._internalClass.isEmpty()) {
            return oldObj;
        }
        DBObject newObj = this.instantiateObjectClassInstance();
        for (String key : oldObj.keySet()) {
            newObj.put(key, oldObj.get(key));
        }
        return newObj;
    }

    private DBObject instantiateObjectClassInstance() {
        try {
            return (DBObject)this.getObjectClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new MongoInternalException("can't create instance of type " + this.getObjectClass(), e);
        }
        catch (IllegalAccessException e) {
            throw new MongoInternalException("can't create instance of type " + this.getObjectClass(), e);
        }
    }

    public DBObject findAndModify(DBObject query, DBObject sort, DBObject update) {
        return this.findAndModify(query, null, sort, false, update, false, false);
    }

    public DBObject findAndModify(DBObject query, DBObject update) {
        return this.findAndModify(query, null, null, false, update, false, false);
    }

    public DBObject findAndRemove(DBObject query) {
        return this.findAndModify(query, null, null, true, null, false, false);
    }

    public void createIndex(String name) {
        this.createIndex(new BasicDBObject(name, (Object)1));
    }

    public void createIndex(DBObject keys) {
        this.createIndex(keys, this.defaultOptions(keys));
    }

    public void createIndex(DBObject keys, DBObject options) {
        this.createIndex(keys, options, this.getDBEncoder());
    }

    public void createIndex(DBObject keys, String name) {
        this.createIndex(keys, name, false);
    }

    public void createIndex(DBObject keys, String name, boolean unique) {
        DBObject options = this.defaultOptions(keys);
        if (name != null && name.length() > 0) {
            options.put("name", name);
        }
        if (unique) {
            options.put("unique", Boolean.TRUE);
        }
        this.createIndex(keys, options);
    }

    @Deprecated
    public abstract void createIndex(DBObject var1, DBObject var2, DBEncoder var3);

    @Deprecated
    public void ensureIndex(String name) {
        this.ensureIndex(new BasicDBObject(name, (Object)1));
    }

    @Deprecated
    public void ensureIndex(DBObject keys) {
        this.ensureIndex(keys, this.defaultOptions(keys));
    }

    @Deprecated
    public void ensureIndex(DBObject keys, String name) {
        this.ensureIndex(keys, name, false);
    }

    @Deprecated
    public void ensureIndex(DBObject keys, String name, boolean unique) {
        DBObject options = this.defaultOptions(keys);
        if (name != null && name.length() > 0) {
            options.put("name", name);
        }
        if (unique) {
            options.put("unique", Boolean.TRUE);
        }
        this.ensureIndex(keys, options);
    }

    @Deprecated
    public void ensureIndex(DBObject keys, DBObject optionsIN) {
        if (this.checkReadOnly(false)) {
            return;
        }
        DBObject options = this.defaultOptions(keys);
        for (String k : optionsIN.keySet()) {
            options.put(k, optionsIN.get(k));
        }
        String name = options.get("name").toString();
        if (this._createdIndexes.contains(name)) {
            return;
        }
        this.createIndex(keys, options);
        this._createdIndexes.add(name);
    }

    @Deprecated
    public void resetIndexCache() {
        this._createdIndexes.clear();
    }

    DBObject defaultOptions(DBObject keys) {
        BasicDBObject o = new BasicDBObject();
        o.put("name", (Object)DBCollection.genIndexName(keys));
        o.put("ns", (Object)this._fullName);
        return o;
    }

    @Deprecated
    public static String genIndexName(DBObject keys) {
        StringBuilder name = new StringBuilder();
        for (String s : keys.keySet()) {
            if (name.length() > 0) {
                name.append('_');
            }
            name.append(s).append('_');
            Object val = keys.get(s);
            if (!(val instanceof Number) && !(val instanceof String)) continue;
            name.append(val.toString().replace(' ', '_'));
        }
        return name.toString();
    }

    public void setHintFields(List<DBObject> indexes) {
        this._hintFields = indexes;
    }

    protected List<DBObject> getHintFields() {
        return this._hintFields;
    }

    public DBCursor find(DBObject ref) {
        return new DBCursor(this, ref, null, this.getReadPreference());
    }

    public DBCursor find(DBObject ref, DBObject keys) {
        return new DBCursor(this, ref, keys, this.getReadPreference());
    }

    public DBCursor find() {
        return new DBCursor(this, null, null, this.getReadPreference());
    }

    public DBObject findOne() {
        return this.findOne(new BasicDBObject());
    }

    public DBObject findOne(DBObject o) {
        return this.findOne(o, null, null, this.getReadPreference());
    }

    public DBObject findOne(DBObject o, DBObject fields) {
        return this.findOne(o, fields, null, this.getReadPreference());
    }

    public DBObject findOne(DBObject o, DBObject fields, DBObject orderBy) {
        return this.findOne(o, fields, orderBy, this.getReadPreference());
    }

    public DBObject findOne(DBObject o, DBObject fields, ReadPreference readPref) {
        return this.findOne(o, fields, null, readPref);
    }

    public DBObject findOne(DBObject o, DBObject fields, DBObject orderBy, ReadPreference readPref) {
        return this.findOne(o, fields, orderBy, readPref, 0L, TimeUnit.MILLISECONDS);
    }

    DBObject findOne(DBObject o, DBObject fields, DBObject orderBy, ReadPreference readPref, long maxTime, TimeUnit maxTimeUnit) {
        QueryResultIterator i;
        DBObject obj;
        QueryOpBuilder queryOpBuilder = new QueryOpBuilder().addQuery(o).addOrderBy(orderBy).addMaxTimeMS(TimeUnit.MILLISECONDS.convert(maxTime, maxTimeUnit));
        if (this.getDB().getMongo().isMongosConnection()) {
            queryOpBuilder.addReadPreference(readPref);
        }
        DBObject dBObject = obj = (i = this.find(queryOpBuilder.get(), fields, 0, -1, 0, this.getOptions(), readPref, this.getDecoder())).hasNext() ? (DBObject)i.next() : null;
        if (obj != null && fields != null && fields.keySet().size() > 0) {
            obj.markAsPartialObject();
        }
        return obj;
    }

    DBDecoder getDecoder() {
        return this.getDBDecoderFactory() != null ? this.getDBDecoderFactory().create() : null;
    }

    private DBEncoder getDBEncoder() {
        return this.getDBEncoderFactory() != null ? this.getDBEncoderFactory().create() : null;
    }

    @Deprecated
    public Object apply(DBObject document) {
        return this.apply(document, true);
    }

    @Deprecated
    public Object apply(DBObject document, boolean ensureId) {
        Object id = document.get("_id");
        if (ensureId && id == null) {
            id = ObjectId.get();
            document.put("_id", id);
        }
        this.doapply(document);
        return id;
    }

    public WriteResult save(DBObject jo) {
        return this.save(jo, this.getWriteConcern());
    }

    public WriteResult save(DBObject jo, WriteConcern concern) {
        if (this.checkReadOnly(true)) {
            return null;
        }
        this._checkObject(jo, false, false);
        Object id = jo.get("_id");
        if (id == null || id instanceof ObjectId && ((ObjectId)id).isNew()) {
            if (id != null) {
                ((ObjectId)id).notNew();
            }
            if (concern == null) {
                return this.insert(jo);
            }
            return this.insert(jo, concern);
        }
        BasicDBObject q = new BasicDBObject();
        q.put("_id", id);
        if (concern == null) {
            return this.update(q, jo, true, false);
        }
        return this.update(q, jo, true, false, concern);
    }

    public void dropIndexes() {
        this.dropIndexes("*");
    }

    public void dropIndexes(String name) {
        DBObject cmd = BasicDBObjectBuilder.start().add("deleteIndexes", this.getName()).add("index", name).get();
        this.resetIndexCache();
        CommandResult res = this._db.command(cmd);
        if (res.ok() || res.getErrorMessage().contains("ns not found")) {
            return;
        }
        res.throwOnError();
    }

    public void drop() {
        this.resetIndexCache();
        CommandResult res = this._db.command(BasicDBObjectBuilder.start().add("drop", this.getName()).get());
        if (res.ok() || res.getErrorMessage().contains("ns not found")) {
            return;
        }
        res.throwOnError();
    }

    public long count() {
        return this.getCount(new BasicDBObject(), null);
    }

    public long count(DBObject query) {
        return this.getCount(query, null);
    }

    public long count(DBObject query, ReadPreference readPrefs) {
        return this.getCount(query, null, readPrefs);
    }

    public long getCount() {
        return this.getCount(new BasicDBObject(), null);
    }

    public long getCount(ReadPreference readPrefs) {
        return this.getCount(new BasicDBObject(), null, readPrefs);
    }

    public long getCount(DBObject query) {
        return this.getCount(query, null);
    }

    public long getCount(DBObject query, DBObject fields) {
        return this.getCount(query, fields, 0L, 0L);
    }

    public long getCount(DBObject query, DBObject fields, ReadPreference readPrefs) {
        return this.getCount(query, fields, 0L, 0L, readPrefs);
    }

    public long getCount(DBObject query, DBObject fields, long limit, long skip) {
        return this.getCount(query, fields, limit, skip, this.getReadPreference());
    }

    public long getCount(DBObject query, DBObject fields, long limit, long skip, ReadPreference readPrefs) {
        return this.getCount(query, fields, limit, skip, readPrefs, 0L, TimeUnit.MILLISECONDS);
    }

    long getCount(DBObject query, DBObject fields, long limit, long skip, ReadPreference readPrefs, long maxTime, TimeUnit maxTimeUnit) {
        return this.getCount(query, fields, limit, skip, readPrefs, maxTime, maxTimeUnit, null);
    }

    long getCount(DBObject query, DBObject fields, long limit, long skip, ReadPreference readPrefs, long maxTime, TimeUnit maxTimeUnit, Object hint) {
        CommandResult res;
        BasicDBObject cmd = new BasicDBObject();
        cmd.put("count", (Object)this.getName());
        cmd.put("query", (Object)query);
        if (fields != null) {
            cmd.put("fields", (Object)fields);
        }
        if (limit > 0L) {
            cmd.put("limit", (Object)limit);
        }
        if (skip > 0L) {
            cmd.put("skip", (Object)skip);
        }
        if (maxTime > 0L) {
            cmd.put("maxTimeMS", (Object)TimeUnit.MILLISECONDS.convert(maxTime, maxTimeUnit));
        }
        if (hint != null) {
            cmd.put("hint", hint);
        }
        if (!(res = this._db.command((DBObject)cmd, this.getOptions(), readPrefs)).ok()) {
            String errmsg = res.getErrorMessage();
            if (errmsg.equals("ns does not exist") || errmsg.equals("ns missing")) {
                return 0L;
            }
            res.throwOnError();
        }
        return res.getLong("n");
    }

    CommandResult command(DBObject cmd, int options, ReadPreference readPrefs) {
        return this._db.command(cmd, this.getOptions(), readPrefs);
    }

    public DBCollection rename(String newName) {
        return this.rename(newName, false);
    }

    public DBCollection rename(String newName, boolean dropTarget) {
        CommandResult ret = this._db.getSisterDB("admin").command(BasicDBObjectBuilder.start().add("renameCollection", this._fullName).add("to", this._db._name + "." + newName).add("dropTarget", dropTarget).get());
        ret.throwOnError();
        this.resetIndexCache();
        return this._db.getCollection(newName);
    }

    public DBObject group(DBObject key, DBObject cond, DBObject initial, String reduce) {
        return this.group(key, cond, initial, reduce, null);
    }

    public DBObject group(DBObject key, DBObject cond, DBObject initial, String reduce, String finalize) {
        GroupCommand cmd = new GroupCommand(this, key, cond, initial, reduce, finalize);
        return this.group(cmd);
    }

    public DBObject group(DBObject key, DBObject cond, DBObject initial, String reduce, String finalize, ReadPreference readPrefs) {
        GroupCommand cmd = new GroupCommand(this, key, cond, initial, reduce, finalize);
        return this.group(cmd, readPrefs);
    }

    public DBObject group(GroupCommand cmd) {
        return this.group(cmd, this.getReadPreference());
    }

    public DBObject group(GroupCommand cmd, ReadPreference readPrefs) {
        CommandResult res = this._db.command(cmd.toDBObject(), this.getOptions(), readPrefs);
        res.throwOnError();
        return (DBObject)res.get("retval");
    }

    @Deprecated
    public DBObject group(DBObject args) {
        args.put("ns", this.getName());
        CommandResult res = this._db.command((DBObject)new BasicDBObject("group", args), this.getOptions(), this.getReadPreference());
        res.throwOnError();
        return (DBObject)res.get("retval");
    }

    public List distinct(String key) {
        return this.distinct(key, new BasicDBObject());
    }

    public List distinct(String key, ReadPreference readPrefs) {
        return this.distinct(key, new BasicDBObject(), readPrefs);
    }

    public List distinct(String key, DBObject query) {
        return this.distinct(key, query, this.getReadPreference());
    }

    public List distinct(String key, DBObject query, ReadPreference readPrefs) {
        DBObject c = BasicDBObjectBuilder.start().add("distinct", this.getName()).add("key", key).add("query", query).get();
        CommandResult res = this._db.command(c, this.getOptions(), readPrefs);
        res.throwOnError();
        return (List)res.get("values");
    }

    public MapReduceOutput mapReduce(String map, String reduce, String outputTarget, DBObject query) {
        return this.mapReduce(new MapReduceCommand(this, map, reduce, outputTarget, MapReduceCommand.OutputType.REPLACE, query));
    }

    public MapReduceOutput mapReduce(String map, String reduce, String outputTarget, MapReduceCommand.OutputType outputType, DBObject query) {
        return this.mapReduce(new MapReduceCommand(this, map, reduce, outputTarget, outputType, query));
    }

    public MapReduceOutput mapReduce(String map, String reduce, String outputTarget, MapReduceCommand.OutputType outputType, DBObject query, ReadPreference readPrefs) {
        MapReduceCommand command = new MapReduceCommand(this, map, reduce, outputTarget, outputType, query);
        command.setReadPreference(readPrefs);
        return this.mapReduce(command);
    }

    public MapReduceOutput mapReduce(MapReduceCommand command) {
        DBObject cmd = command.toDBObject();
        CommandResult res = this._db.command(cmd, this.getOptions(), command.getReadPreference() != null ? command.getReadPreference() : this.getReadPreference());
        res.throwOnError();
        return new MapReduceOutput(this, cmd, res);
    }

    @Deprecated
    public MapReduceOutput mapReduce(DBObject command) {
        if (command.get("mapreduce") == null && command.get("mapReduce") == null) {
            throw new IllegalArgumentException("need mapreduce arg");
        }
        CommandResult res = this._db.command(command, this.getOptions(), this.getReadPreference());
        res.throwOnError();
        return new MapReduceOutput(this, command, res);
    }

    @Deprecated
    public AggregationOutput aggregate(DBObject firstOp, DBObject ... additionalOps) {
        ArrayList<DBObject> pipeline = new ArrayList<DBObject>();
        pipeline.add(firstOp);
        Collections.addAll(pipeline, additionalOps);
        return this.aggregate(pipeline);
    }

    public AggregationOutput aggregate(List<DBObject> pipeline) {
        return this.aggregate(pipeline, this.getReadPreference());
    }

    public AggregationOutput aggregate(List<DBObject> pipeline, ReadPreference readPreference) {
        AggregationOptions options = AggregationOptions.builder().outputMode(AggregationOptions.OutputMode.INLINE).build();
        DBObject command = this.prepareAggregationCommand(pipeline, options, null);
        CommandResult res = this._db.command(command, this.getOptions(), readPreference);
        res.throwOnError();
        return new AggregationOutput(command, res);
    }

    public Cursor aggregate(List<DBObject> pipeline, AggregationOptions options) {
        return this.aggregate(pipeline, options, this.getReadPreference());
    }

    public abstract Cursor aggregate(List<DBObject> var1, AggregationOptions var2, ReadPreference var3);

    public CommandResult explainAggregate(List<DBObject> pipeline, AggregationOptions options) {
        DBObject command = this.prepareAggregationCommand(pipeline, options, null);
        command.put("explain", true);
        CommandResult res = this._db.command(command, this.getOptions(), this.getReadPreference());
        res.throwOnError();
        return res;
    }

    public abstract List<Cursor> parallelScan(ParallelScanOptions var1);

    public BulkWriteOperation initializeOrderedBulkOperation() {
        return new BulkWriteOperation(true, this);
    }

    public BulkWriteOperation initializeUnorderedBulkOperation() {
        return new BulkWriteOperation(false, this);
    }

    BulkWriteResult executeBulkWriteOperation(boolean ordered, Boolean bypassDocumentValidation, List<WriteRequest> requests) {
        return this.executeBulkWriteOperation(ordered, bypassDocumentValidation, requests, this.getWriteConcern());
    }

    BulkWriteResult executeBulkWriteOperation(boolean ordered, Boolean bypassDocumentValidation, List<WriteRequest> requests, WriteConcern writeConcern) {
        return this.executeBulkWriteOperation(ordered, bypassDocumentValidation, requests, writeConcern, this.getDBEncoder());
    }

    abstract BulkWriteResult executeBulkWriteOperation(boolean var1, Boolean var2, List<WriteRequest> var3, WriteConcern var4, DBEncoder var5);

    DBObject prepareAggregationCommand(List<DBObject> pipeline, AggregationOptions options, ServerVersion serverVersion) {
        if (pipeline.isEmpty()) {
            throw new MongoException("Aggregation pipelines can not be empty");
        }
        BasicDBObject command = new BasicDBObject("aggregate", this.getName());
        command.put("pipeline", (Object)pipeline);
        if (options.getOutputMode() == AggregationOptions.OutputMode.CURSOR) {
            BasicDBObject cursor = new BasicDBObject();
            if (options.getBatchSize() != null) {
                cursor.put("batchSize", (Object)options.getBatchSize());
            }
            command.put("cursor", (Object)cursor);
        }
        if (options.getMaxTime(TimeUnit.MILLISECONDS) > 0L) {
            command.put("maxTimeMS", (Object)options.getMaxTime(TimeUnit.MILLISECONDS));
        }
        if (options.getAllowDiskUse() != null) {
            command.put("allowDiskUse", (Object)options.getAllowDiskUse());
        }
        if (this.getBypassDocumentValidationForServerVersion(options.getBypassDocumentValidation(), serverVersion) != null) {
            command.put("bypassDocumentValidation", (Object)options.getBypassDocumentValidation());
        }
        return command;
    }

    Boolean getBypassDocumentValidationForServerVersion(Boolean bypassDocumentValidation, ServerVersion serverVersion) {
        if (bypassDocumentValidation == null) {
            return null;
        }
        return serverVersion.compareTo(new ServerVersion(3, 2)) >= 0 ? bypassDocumentValidation : null;
    }

    public abstract List<DBObject> getIndexInfo();

    public void dropIndex(DBObject keys) {
        this.dropIndexes(DBCollection.genIndexName(keys));
    }

    public void dropIndex(String indexName) {
        this.dropIndexes(indexName);
    }

    public CommandResult getStats() {
        return this.getDB().command((DBObject)new BasicDBObject("collstats", this.getName()), this.getOptions(), this.getReadPreference());
    }

    public boolean isCapped() {
        CommandResult stats = this.getStats();
        Object capped = stats.get("capped");
        return capped != null && (capped.equals(1) || capped.equals(true));
    }

    protected DBCollection(DB base, String name) {
        this._db = base;
        this._name = name;
        this._fullName = this._db.getName() + "." + name;
        this._options = new Bytes.OptionHolder(this._db._options);
    }

    @Deprecated
    protected DBObject _checkObject(DBObject o, boolean canBeNull, boolean query) {
        if (o == null) {
            if (canBeNull) {
                return null;
            }
            throw new IllegalArgumentException("can't be null");
        }
        if (o.isPartialObject() && !query) {
            throw new IllegalArgumentException("can't save partial objects");
        }
        if (!query) {
            this._checkKeys(o);
        }
        return o;
    }

    private void _checkKeys(DBObject o) {
        if (o instanceof LazyDBObject || o instanceof LazyDBList) {
            return;
        }
        for (String s : o.keySet()) {
            this.validateKey(s);
            this._checkValue(o.get(s));
        }
    }

    private void _checkKeys(Map<String, Object> o) {
        for (Map.Entry<String, Object> cur : o.entrySet()) {
            this.validateKey(cur.getKey());
            this._checkValue(cur.getValue());
        }
    }

    private void _checkValues(List list) {
        for (Object cur : list) {
            this._checkValue(cur);
        }
    }

    private void _checkValue(Object value) {
        if (value instanceof DBObject) {
            this._checkKeys((DBObject)value);
        } else if (value instanceof Map) {
            this._checkKeys((Map)value);
        } else if (value instanceof List) {
            this._checkValues((List)value);
        }
    }

    private void validateKey(String s) {
        if (s.contains("\u0000")) {
            throw new IllegalArgumentException("Document field names can't have a NULL character. (Bad Key: '" + s + "')");
        }
        if (s.contains(".")) {
            throw new IllegalArgumentException("Document field names can't have a . in them. (Bad Key: '" + s + "')");
        }
        if (s.startsWith("$")) {
            throw new IllegalArgumentException("Document field names can't start with '$' (Bad Key: '" + s + "')");
        }
    }

    public DBCollection getCollection(String n) {
        return this._db.getCollection(this._name + "." + n);
    }

    public String getName() {
        return this._name;
    }

    public String getFullName() {
        return this._fullName;
    }

    public DB getDB() {
        return this._db;
    }

    @Deprecated
    protected boolean checkReadOnly(boolean strict) {
        if (!this._db._readOnly) {
            return false;
        }
        if (!strict) {
            return true;
        }
        throw new IllegalStateException("db is read only");
    }

    public int hashCode() {
        return this._fullName.hashCode();
    }

    public boolean equals(Object o) {
        return o == this;
    }

    public String toString() {
        return this._name;
    }

    public void setObjectClass(Class c) {
        if (c == null) {
            this._wrapper = null;
            this._objectClass = null;
            return;
        }
        if (!DBObject.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException(c.getName() + " is not a DBObject");
        }
        this._objectClass = c;
        this._wrapper = ReflectionDBObject.class.isAssignableFrom(c) ? ReflectionDBObject.getWrapper(c) : null;
    }

    public Class getObjectClass() {
        return this._objectClass;
    }

    public void setInternalClass(String path, Class c) {
        this._internalClass.put(path, c);
    }

    protected Class getInternalClass(String path) {
        Class c = this._internalClass.get(path);
        if (c != null) {
            return c;
        }
        if (this._wrapper == null) {
            return null;
        }
        return this._wrapper.getInternalClass(path);
    }

    public void setWriteConcern(WriteConcern writeConcern) {
        this._concern = writeConcern;
    }

    public WriteConcern getWriteConcern() {
        if (this._concern != null) {
            return this._concern;
        }
        return this._db.getWriteConcern();
    }

    public void setReadPreference(ReadPreference preference) {
        this._readPref = preference;
    }

    public ReadPreference getReadPreference() {
        if (this._readPref != null) {
            return this._readPref;
        }
        return this._db.getReadPreference();
    }

    @Deprecated
    public void slaveOk() {
        this.addOption(4);
    }

    public void addOption(int option) {
        this._options.add(option);
    }

    public void setOptions(int options) {
        this._options.set(options);
    }

    public void resetOptions() {
        this._options.reset();
    }

    public int getOptions() {
        return this._options.get();
    }

    public synchronized void setDBDecoderFactory(DBDecoderFactory fact) {
        this._decoderFactory = fact;
    }

    public synchronized DBDecoderFactory getDBDecoderFactory() {
        return this._decoderFactory;
    }

    public synchronized void setDBEncoderFactory(DBEncoderFactory fact) {
        this._encoderFactory = fact;
    }

    public synchronized DBEncoderFactory getDBEncoderFactory() {
        return this._encoderFactory;
    }
}

