/*
 * Decompiled with CFR 0.152.
 */
package thredds.crawlabledataset;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import thredds.crawlabledataset.CrawlableDataset;

public class CrawlableDatasetFactory {
    private static String defaultClassName = "thredds.crawlabledataset.CrawlableDatasetFile";

    public static CrawlableDataset createCrawlableDataset(String path, String className, Object configObj) throws IOException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, IllegalArgumentException, NullPointerException {
        if (path == null) {
            throw new NullPointerException("Given path must not be null.");
        }
        String tmpClassName = className == null ? defaultClassName : className;
        Class<?> crDsClass = Class.forName(tmpClassName);
        if (!CrawlableDataset.class.isAssignableFrom(crDsClass)) {
            throw new IllegalArgumentException("Requested class <" + className + "> not an implementation of thredds.crawlabledataset.CrawlableDataset.");
        }
        Class[] argTypes = new Class[]{String.class, Object.class};
        Object[] args = new Object[]{path, configObj};
        Constructor<?> constructor = crDsClass.getDeclaredConstructor(argTypes);
        try {
            return (CrawlableDataset)constructor.newInstance(args);
        }
        catch (InvocationTargetException e) {
            if (IOException.class.isAssignableFrom(e.getCause().getClass())) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    public static String normalizePath(String path) {
        String newPath = path.replaceAll("\\\\", "/");
        while (newPath.endsWith("/") && !newPath.equals("/")) {
            newPath = newPath.substring(0, newPath.length() - 1);
        }
        return newPath;
    }
}

