/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.support.wrapper;

import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.impl.DateTimeHelper;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.server.ProgressControlCmisService;
import org.apache.chemistry.opencmis.server.support.wrapper.AbstractCmisServiceWrapper;

public abstract class AbstractBindingCmisServiceWrapper
extends AbstractCmisServiceWrapper {
    private ProgressControlCmisService.Progress beforeCall = ProgressControlCmisService.Progress.CONTINUE;
    private ProgressControlCmisService.Progress afterCall = ProgressControlCmisService.Progress.CONTINUE;

    public AbstractBindingCmisServiceWrapper(CmisService service) {
        super(service);
    }

    @Override
    public ProgressControlCmisService.Progress beforeServiceCall() {
        return this.beforeCall;
    }

    @Override
    public ProgressControlCmisService.Progress afterServiceCall() {
        return this.afterCall;
    }

    public void setBeforeServiceCall(ProgressControlCmisService.Progress progress) {
        this.beforeCall = progress;
    }

    public void setAfterServiceCall(ProgressControlCmisService.Progress progress) {
        this.afterCall = progress;
    }

    public BindingType getBindingType() {
        String binding = this.getCallContext().getBinding();
        if ("atompub".equals(binding)) {
            return BindingType.ATOMPUB;
        }
        if ("browser".equals(binding)) {
            return BindingType.BROWSER;
        }
        if ("webservices".equals(binding)) {
            return BindingType.WEBSERVICES;
        }
        if ("local".equals(binding)) {
            return BindingType.LOCAL;
        }
        return BindingType.CUSTOM;
    }

    public HttpServletRequest getHttpServletRequest() {
        return (HttpServletRequest)this.getCallContext().get("httpServletRequest");
    }

    public HttpServletResponse getHttpServletResponse() {
        return (HttpServletResponse)this.getCallContext().get("httpServletResponse");
    }

    public String getRequestHeader(String name) {
        HttpServletRequest req = this.getHttpServletRequest();
        if (req == null) {
            return null;
        }
        return req.getHeader(name);
    }

    public Date getDateRequestHeader(String name) {
        return DateTimeHelper.parseHttpDateTime((String)this.getRequestHeader(name));
    }

    public void setResponseHeader(String name, String value) {
        HttpServletResponse resp = this.getHttpServletResponse();
        if (resp != null) {
            resp.setHeader(name, value);
        }
    }

    public void setResponseHeader(String name, Date value) {
        HttpServletResponse resp = this.getHttpServletResponse();
        if (resp != null) {
            resp.setHeader(name, DateTimeHelper.formatHttpDateTime((Date)value));
        }
    }

    public boolean isNotModified(Date date) {
        long modifiedSinceSecs;
        if (date == null) {
            return false;
        }
        Date modifiedSince = this.getDateRequestHeader("If-Modified-Since");
        if (modifiedSince == null) {
            return false;
        }
        long dateSecs = (long)Math.floor((double)date.getTime() / 1000.0);
        return dateSecs > (modifiedSinceSecs = (long)Math.floor((double)modifiedSince.getTime() / 1000.0));
    }
}

