/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftps;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPSClient;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.provider.GenericFileName;
import org.apache.commons.vfs2.provider.ftp.FtpClient;
import org.apache.commons.vfs2.provider.ftps.FtpsClientFactory;
import org.apache.commons.vfs2.provider.ftps.FtpsFileProvider;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;

class FtpsClientWrapper
implements FtpClient {
    private final GenericFileName root;
    private final FileSystemOptions fileSystemOptions;
    private FTPSClient ftpClient = null;

    FtpsClientWrapper(GenericFileName root, FileSystemOptions fileSystemOptions) throws FileSystemException {
        this.root = root;
        this.fileSystemOptions = fileSystemOptions;
        this.getFtpsClient();
    }

    public GenericFileName getRoot() {
        return this.root;
    }

    public FileSystemOptions getFileSystemOptions() {
        return this.fileSystemOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FTPSClient createClient() throws FileSystemException {
        FTPSClient fTPSClient;
        GenericFileName rootName = this.getRoot();
        UserAuthenticationData authData = null;
        try {
            authData = UserAuthenticatorUtils.authenticate(this.fileSystemOptions, FtpsFileProvider.AUTHENTICATOR_TYPES);
            fTPSClient = FtpsClientFactory.createConnection(rootName.getHostName(), rootName.getPort(), UserAuthenticatorUtils.getData(authData, UserAuthenticationData.USERNAME, UserAuthenticatorUtils.toChar(rootName.getUserName())), UserAuthenticatorUtils.getData(authData, UserAuthenticationData.PASSWORD, UserAuthenticatorUtils.toChar(rootName.getPassword())), rootName.getPath(), this.getFileSystemOptions());
        }
        catch (Throwable throwable) {
            UserAuthenticatorUtils.cleanup(authData);
            throw throwable;
        }
        UserAuthenticatorUtils.cleanup(authData);
        return fTPSClient;
    }

    private FTPSClient getFtpsClient() throws FileSystemException {
        if (this.ftpClient == null) {
            this.ftpClient = this.createClient();
        }
        return this.ftpClient;
    }

    public boolean isConnected() throws FileSystemException {
        return this.getFtpsClient().isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws IOException {
        try {
            this.getFtpsClient().disconnect();
        }
        finally {
            this.ftpClient = null;
        }
    }

    public FTPFile[] listFiles(String relPath) throws IOException {
        try {
            return this.getFtpsClient().listFiles(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpsClient().listFiles(relPath);
        }
    }

    public boolean removeDirectory(String relPath) throws IOException {
        try {
            return this.getFtpsClient().removeDirectory(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpsClient().removeDirectory(relPath);
        }
    }

    public boolean deleteFile(String relPath) throws IOException {
        try {
            return this.getFtpsClient().deleteFile(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpsClient().deleteFile(relPath);
        }
    }

    public boolean rename(String oldName, String newName) throws IOException {
        try {
            return this.getFtpsClient().rename(oldName, newName);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpsClient().rename(oldName, newName);
        }
    }

    public boolean makeDirectory(String relPath) throws IOException {
        try {
            return this.getFtpsClient().makeDirectory(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpsClient().makeDirectory(relPath);
        }
    }

    public boolean completePendingCommand() throws IOException {
        if (this.ftpClient != null) {
            return this.getFtpsClient().completePendingCommand();
        }
        return true;
    }

    public InputStream retrieveFileStream(String relPath) throws IOException {
        try {
            return this.getFtpsClient().retrieveFileStream(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpsClient().retrieveFileStream(relPath);
        }
    }

    public InputStream retrieveFileStream(String relPath, long restartOffset) throws IOException {
        try {
            FTPSClient client = this.getFtpsClient();
            client.setRestartOffset(restartOffset);
            return client.retrieveFileStream(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            FTPSClient client = this.getFtpsClient();
            client.setRestartOffset(restartOffset);
            return client.retrieveFileStream(relPath);
        }
    }

    public OutputStream appendFileStream(String relPath) throws IOException {
        try {
            return this.getFtpsClient().appendFileStream(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpsClient().appendFileStream(relPath);
        }
    }

    public OutputStream storeFileStream(String relPath) throws IOException {
        try {
            return this.getFtpsClient().storeFileStream(relPath);
        }
        catch (IOException e) {
            this.disconnect();
            return this.getFtpsClient().storeFileStream(relPath);
        }
    }

    public boolean abort() throws IOException {
        try {
            this.disconnect();
            return true;
        }
        catch (IOException e) {
            this.disconnect();
            return true;
        }
    }

    public String getReplyString() throws IOException {
        return this.getFtpsClient().getReplyString();
    }
}

