/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.commons.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class ClassLoaderUtil {
    private static ReentrantReadWriteLock LOCK = new ReentrantReadWriteLock();
    private static Map<Long, Map<String, ClassLoader>> CLASSLOADER_MAP = null;

    private ClassLoaderUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerBundleClassLoader(long bundleId, ClassLoader classLoader, List<String> classes) {
        if (classLoader == null || classes == null || classes.isEmpty()) {
            return;
        }
        HashMap<String, ClassLoader> bundleMap = new HashMap<String, ClassLoader>();
        for (String clazz : classes) {
            if (clazz == null || clazz.isEmpty()) continue;
            bundleMap.put(clazz, classLoader);
        }
        if (bundleMap.isEmpty()) {
            return;
        }
        LOCK.writeLock().lock();
        try {
            if (CLASSLOADER_MAP == null) {
                CLASSLOADER_MAP = new HashMap<Long, Map<String, ClassLoader>>();
            }
            CLASSLOADER_MAP.put(bundleId, bundleMap);
        }
        finally {
            LOCK.writeLock().unlock();
        }
    }

    public static void unregisterBundleClassLoader(long bundleId) {
        LOCK.writeLock().lock();
        try {
            if (CLASSLOADER_MAP != null) {
                CLASSLOADER_MAP.remove(bundleId);
            }
        }
        finally {
            LOCK.writeLock().unlock();
        }
    }

    public static void unregisterAllBundleClassLoaders() {
        LOCK.writeLock().lock();
        try {
            CLASSLOADER_MAP = null;
        }
        finally {
            LOCK.writeLock().unlock();
        }
    }

    public static Class<?> loadClass(String className) throws ClassNotFoundException {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        if (ccl == null) {
            try {
                return ClassLoaderUtil.loadClass(className, null);
            }
            catch (ClassNotFoundException cnf) {
                return ClassLoaderUtil.loadClassWithRegisteredClassLoaders(className);
            }
        }
        try {
            return ClassLoaderUtil.loadClass(className, ccl);
        }
        catch (ClassNotFoundException cnf) {
            try {
                return ClassLoaderUtil.loadClass(className, null);
            }
            catch (ClassNotFoundException cnf2) {
                return ClassLoaderUtil.loadClassWithRegisteredClassLoaders(className);
            }
        }
    }

    private static Class<?> loadClassWithRegisteredClassLoaders(String className) throws ClassNotFoundException {
        if (className == null) {
            throw new ClassNotFoundException("Class name is null!");
        }
        LOCK.readLock().lock();
        try {
            if (CLASSLOADER_MAP == null) {
                throw new ClassNotFoundException();
            }
            for (Map<String, ClassLoader> clm : CLASSLOADER_MAP.values()) {
                for (Map.Entry<String, ClassLoader> cle : clm.entrySet()) {
                    if (!cle.getKey().equals(className)) continue;
                    Class<?> clazz = ClassLoaderUtil.loadClass(className, cle.getValue());
                    return clazz;
                }
            }
            throw new ClassNotFoundException();
        }
        finally {
            LOCK.readLock().unlock();
        }
    }

    public static Class<?> loadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        if (classLoader == null) {
            return Class.forName(className);
        }
        return Class.forName(className, true, classLoader);
    }
}

