/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.output.filesystem;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.manifoldcf.agents.interfaces.IOutputAddActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputRemoveActivity;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.agents.output.BaseOutputConnector;
import org.apache.manifoldcf.agents.output.filesystem.FileOutputConfig;
import org.apache.manifoldcf.agents.output.filesystem.FileOutputParam;
import org.apache.manifoldcf.agents.output.filesystem.Messages;
import org.apache.manifoldcf.agents.output.filesystem.ParameterEnum;
import org.apache.manifoldcf.agents.system.Logging;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.core.interfaces.VersionContext;

public class FileOutputConnector
extends BaseOutputConnector {
    public static final String _rcsid = "@(#)$Id: FileOutputConnector.java 988245 2010-08-23 18:39:35Z minoru $";
    public static final String INGEST_ACTIVITY = "document ingest";
    public static final String REMOVE_ACTIVITY = "document deletion";
    protected static final String[] activitiesList = new String[]{"document ingest", "document deletion"};
    private static final String EDIT_CONFIGURATION_JS = "editConfiguration.js";
    private static final String EDIT_CONFIGURATION_HTML = "editConfiguration.html";
    private static final String VIEW_CONFIGURATION_HTML = "viewConfiguration.html";
    private static final String EDIT_SPECIFICATION_JS = "editSpecification.js";
    private static final String EDIT_SPECIFICATION_HTML = "editSpecification.html";
    private static final String VIEW_SPECIFICATION_HTML = "viewSpecification.html";

    public String[] getActivitiesList() {
        return activitiesList;
    }

    public void connect(ConfigParams configParameters) {
        super.connect(configParameters);
    }

    public void disconnect() throws ManifoldCFException {
        super.disconnect();
    }

    protected void getSession() throws ManifoldCFException, ServiceInterruption {
    }

    public String check() throws ManifoldCFException {
        try {
            this.getSession();
            return super.check();
        }
        catch (ServiceInterruption e) {
            return "Transient error: " + e.getMessage();
        }
    }

    public VersionContext getPipelineDescription(Specification spec) throws ManifoldCFException, ServiceInterruption {
        FileOutputSpecs specs = new FileOutputSpecs((ConfigurationNode)this.getSpecNode(spec));
        return new VersionContext(specs.toVersionString(), this.params, spec);
    }

    /*
     * Exception decompiling
     */
    public int addOrReplaceDocumentWithException(String documentURI, VersionContext outputDescription, RepositoryDocument document, String authorityNameString, IOutputAddActivity activities) throws ManifoldCFException, ServiceInterruption, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static void handleURISyntaxException(URISyntaxException e) throws ManifoldCFException, ServiceInterruption {
        Logging.agents.error((Object)("FileSystem: URISyntaxException: " + e.getMessage()), (Throwable)e);
        throw new ManifoldCFException(e.getMessage(), (Throwable)e);
    }

    protected static void handleSecurityException(SecurityException e) throws ManifoldCFException, ServiceInterruption {
        Logging.agents.error((Object)("FileSystem: SecurityException: " + e.getMessage()), (Throwable)e);
        throw new ManifoldCFException(e.getMessage(), (Throwable)e);
    }

    protected static void handleFileNotFoundException(FileNotFoundException e) throws ManifoldCFException, ServiceInterruption {
        Logging.agents.error((Object)("FileSystem: Path is illegal: " + e.getMessage()), (Throwable)e);
        throw new ManifoldCFException(e.getMessage(), (Throwable)e);
    }

    protected static void handleIOException(IOException e) throws ManifoldCFException, ServiceInterruption {
        if (!(e instanceof SocketTimeoutException) && e instanceof InterruptedIOException) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        long currentTime = System.currentTimeMillis();
        Logging.agents.warn((Object)("FileSystem: IO exception: " + e.getMessage()), (Throwable)e);
        throw new ServiceInterruption("IO exception: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 10800000L, -1, false);
    }

    /*
     * Exception decompiling
     */
    public void removeDocument(String documentURI, String outputDescription, IOutputRemoveActivity activities) throws ManifoldCFException, ServiceInterruption {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 17[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        super.outputSpecificationHeader(out, locale, os, connectionSequenceNumber, tabsArray);
        tabsArray.add(Messages.getString(locale, "FileConnector.PathTabName"));
        FileOutputConnector.outputResource(EDIT_SPECIFICATION_JS, out, locale, null, null, new Integer(connectionSequenceNumber), null);
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        super.outputSpecificationBody(out, locale, os, connectionSequenceNumber, actualSequenceNumber, tabName);
        FileOutputSpecs specs = this.getSpecParameters(os);
        FileOutputConnector.outputResource(EDIT_SPECIFICATION_HTML, out, locale, specs, tabName, new Integer(connectionSequenceNumber), new Integer(actualSequenceNumber));
    }

    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification os, int connectionSequenceNumber) throws ManifoldCFException {
        boolean bAdd;
        SpecificationNode specNode = this.getSpecNode(os);
        boolean bl = bAdd = specNode == null;
        if (bAdd) {
            specNode = new SpecificationNode("rootpath");
        }
        FileOutputSpecs.contextToSpecNode(variableContext, (ConfigurationNode)specNode, connectionSequenceNumber);
        if (bAdd) {
            os.addChild(os.getChildCount(), (ConfigurationNode)specNode);
        }
        return null;
    }

    public void viewSpecification(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        FileOutputConnector.outputResource(VIEW_SPECIFICATION_HTML, out, locale, this.getSpecParameters(os), null, new Integer(connectionSequenceNumber), null);
    }

    private final SpecificationNode getSpecNode(Specification os) {
        int l = os.getChildCount();
        for (int i = 0; i < l; ++i) {
            SpecificationNode node = os.getChild(i);
            if (!node.getType().equals("rootpath")) continue;
            return node;
        }
        return null;
    }

    private final FileOutputSpecs getSpecParameters(Specification os) throws ManifoldCFException {
        return new FileOutputSpecs((ConfigurationNode)this.getSpecNode(os));
    }

    private final FileOutputConfig getConfigParameters(ConfigParams configParams) {
        if (configParams == null) {
            configParams = this.getConfiguration();
        }
        return new FileOutputConfig(configParams);
    }

    private static void outputResource(String resName, IHTTPOutput out, Locale locale, FileOutputParam params, String tabName, Integer sequenceNumber, Integer currentSequenceNumber) throws ManifoldCFException {
        Map<String, String> paramMap = null;
        if (params != null) {
            paramMap = params.buildMap();
            if (tabName != null) {
                paramMap.put("TabName", tabName);
            }
            if (currentSequenceNumber != null) {
                paramMap.put("SelectedNum", currentSequenceNumber.toString());
            }
        } else {
            paramMap = new HashMap<String, String>();
        }
        if (sequenceNumber != null) {
            paramMap.put("SeqNum", sequenceNumber.toString());
        }
        Messages.outputResourceWithVelocity(out, locale, resName, paramMap, true);
    }

    private final String documentURItoFilePath(String documentURI) throws URISyntaxException, NullPointerException {
        StringBuffer path = new StringBuffer();
        URI uri = new URI(documentURI);
        if (SystemUtils.IS_OS_WINDOWS) {
            this.windowsFileName(path, uri);
        } else {
            this.unixFileName(path, uri);
        }
        return path.toString();
    }

    private final void windowsFileName(StringBuffer path, URI uri) {
        boolean endsWithSlash = false;
        if (uri.getScheme() != null) {
            path.append(uri.getScheme());
            path.append("/");
            endsWithSlash = true;
        }
        if (uri.getHost() != null) {
            path.append(uri.getHost());
            endsWithSlash = false;
            if (uri.getPort() != -1) {
                path.append("_");
                path.append(uri.getPort());
            }
            if (uri.getRawPath() != null) {
                if (uri.getRawPath().length() == 0) {
                    path.append("/");
                    endsWithSlash = true;
                } else if (uri.getRawPath().equals("/")) {
                    path.append(uri.getRawPath());
                    endsWithSlash = false;
                } else {
                    for (String name : uri.getRawPath().split("/")) {
                        if (name.length() <= 0) continue;
                        path.append("/");
                        path.append(this.convertWindowsString(name));
                        endsWithSlash = false;
                    }
                }
            }
            if (uri.getRawQuery() != null) {
                path.append("/");
                path.append(this.convertWindowsString(uri.getRawQuery()));
                endsWithSlash = false;
            }
        } else if (uri.getRawSchemeSpecificPart() != null) {
            for (String name : uri.getRawSchemeSpecificPart().split("/")) {
                if (name.length() <= 0) continue;
                path.append("/");
                path.append(this.convertWindowsString(name));
                endsWithSlash = false;
            }
        }
        if (endsWithSlash) {
            path.append(".content");
        }
    }

    private final String convertWindowsString(String input) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == ':' || c == '/' || c == '\\' | c == '*' | c == '\"' | c == '?' | c == '|' || c == '<' || c == '>') {
                sb.append('_');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private final void unixFileName(StringBuffer path, URI uri) {
        boolean endsWithSlash = false;
        if (uri.getScheme() != null) {
            path.append(uri.getScheme());
            path.append("/");
            endsWithSlash = true;
        }
        if (uri.getHost() != null) {
            path.append(uri.getHost());
            endsWithSlash = false;
            if (uri.getPort() != -1) {
                path.append(":");
                path.append(uri.getPort());
            }
            if (uri.getRawPath() != null) {
                if (uri.getRawPath().length() == 0) {
                    path.append("/");
                    endsWithSlash = true;
                } else if (uri.getRawPath().equals("/")) {
                    path.append(uri.getRawPath());
                    endsWithSlash = false;
                } else {
                    for (String name : uri.getRawPath().split("/")) {
                        if (name.length() <= 0) continue;
                        path.append("/");
                        path.append(this.convertUnixString(name));
                        endsWithSlash = false;
                    }
                }
            }
            if (uri.getRawQuery() != null) {
                path.append("?");
                path.append(this.convertUnixString(uri.getRawQuery()));
                endsWithSlash = false;
            }
        } else if (uri.getRawSchemeSpecificPart() != null) {
            for (String name : uri.getRawSchemeSpecificPart().split("/")) {
                if (name.length() <= 0) continue;
                path.append("/");
                path.append(this.convertUnixString(name));
                endsWithSlash = false;
            }
        }
        if (endsWithSlash) {
            path.append(".content");
        }
    }

    private final String convertUnixString(String input) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == ':') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    protected static class FileOutputSpecs
    extends FileOutputParam {
        private static final long serialVersionUID = 1859652730572662025L;
        public static final ParameterEnum[] SPECIFICATIONLIST = new ParameterEnum[]{ParameterEnum.ROOTPATH};
        private final String rootPath;

        public FileOutputSpecs(String versionString) throws ManifoldCFException {
            super(SPECIFICATIONLIST);
            int index = 0;
            for (ParameterEnum param : SPECIFICATIONLIST) {
                StringBuilder sb = new StringBuilder();
                index = FileOutputConnector.unpack((StringBuilder)sb, (String)versionString, (int)index, (char)'+');
                this.put(param, sb.toString());
            }
            this.rootPath = this.getRootPath();
        }

        public FileOutputSpecs(ConfigurationNode node) throws ManifoldCFException {
            super(SPECIFICATIONLIST);
            String rootPath = null;
            for (ParameterEnum param : SPECIFICATIONLIST) {
                String value = null;
                if (node != null) {
                    value = node.getAttributeValue(param.name());
                }
                if (value == null) {
                    value = param.defaultValue;
                }
                this.put(param, value);
            }
            this.rootPath = rootPath = this.getRootPath();
        }

        public static void contextToSpecNode(IPostParameters variableContext, ConfigurationNode specNode, int sequenceNumber) {
            for (ParameterEnum param : SPECIFICATIONLIST) {
                String p = variableContext.getParameter("s" + sequenceNumber + "_" + param.name().toLowerCase(Locale.ROOT));
                if (p == null) continue;
                specNode.setAttribute(param.name(), p);
            }
        }

        public String toVersionString() {
            StringBuilder sb = new StringBuilder();
            FileOutputConnector.pack((StringBuilder)sb, (String)this.rootPath, (char)'+');
            return sb.toString();
        }

        public String getRootPath() {
            return (String)this.get((Object)ParameterEnum.ROOTPATH);
        }

        private static final TreeSet<String> createStringSet(String content) throws ManifoldCFException {
            TreeSet<String> treeSet;
            block6: {
                TreeSet<String> set = new TreeSet<String>();
                BufferedReader br = null;
                StringReader sr = null;
                try {
                    sr = new StringReader(content);
                    br = new BufferedReader(sr);
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        if ((line = line.trim()).length() <= 0) continue;
                        set.add(line);
                    }
                    treeSet = set;
                    if (br == null) break block6;
                }
                catch (IOException e) {
                    try {
                        throw new ManifoldCFException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        if (br != null) {
                            IOUtils.closeQuietly(br);
                        }
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Reader)br);
            }
            return treeSet;
        }
    }
}

