/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.output.cmisoutput;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.api.SessionFactory;
import org.apache.chemistry.opencmis.client.runtime.ObjectIdImpl;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNameConstraintViolationException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumBaseObjectTypeIds;
import org.apache.commons.lang.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.manifoldcf.agents.interfaces.IOutputAddActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputRemoveActivity;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.agents.output.BaseOutputConnector;
import org.apache.manifoldcf.agents.output.cmisoutput.CmisOutputConfig;
import org.apache.manifoldcf.agents.output.cmisoutput.Messages;
import org.apache.manifoldcf.connectorcommon.fuzzyml.ReplayableInputStream;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPasswordMapperActivity;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.VersionContext;
import org.apache.manifoldcf.crawler.system.Logging;

public class CmisOutputConnector
extends BaseOutputConnector {
    protected static final String ACTIVITY_READ = "read document";
    protected static final String RELATIONSHIP_CHILD = "child";
    private static final String CMIS_SERVER_TAB_PROPERTY = "CmisOutputConnector.Server";
    private static final String EDIT_CONFIG_HEADER_FORWARD = "editConfiguration.js";
    private static final String EDIT_CONFIG_FORWARD_SERVER = "editConfiguration_Server.html";
    private static final String VIEW_CONFIG_FORWARD = "viewConfiguration.html";
    Session session = null;
    protected String username = null;
    protected String password = null;
    protected String protocol = null;
    protected String server = null;
    protected String port = null;
    protected String path = null;
    protected String repositoryId = null;
    protected String binding = null;
    protected String cmisQuery = null;
    protected String createTimestampTree = Boolean.FALSE.toString();
    protected VersioningState versioningState = VersioningState.NONE;
    protected SessionFactory factory = SessionFactoryImpl.newInstance();
    protected Map<String, String> parameters = new HashMap<String, String>();
    protected static final long timeToRelease = 300000L;
    protected long lastSessionFetch = -1L;
    protected Folder parentDropZoneFolder = null;
    protected static final String ACTIVITY_INJECTION = "Injection";
    protected static final String ACTIVITY_DELETE = "Delete";
    private static final String CMIS_PROPERTY_PREFIX = "cmis:";
    private static final int DOCUMENT_STATUS_ACCEPTED = 0;
    private static final String DOCUMENT_STATUS_ACCEPTED_DESC = "Injection OK - ";
    private static final String DOCUMENT_STATUS_REJECTED_DESC = "Injection KO - ";
    private static final int DOCUMENT_STATUS_REJECTED = 1;
    private static final String DOCUMENT_DELETION_STATUS_ACCEPTED = "Remove request accepted";
    private static final String DOCUMENT_DELETION_STATUS_REJECTED = "Remove request rejected";
    private static final String CONTENT_PATH_PARAM = "contentPath";

    public String[] getActivitiesList() {
        return new String[]{ACTIVITY_INJECTION, ACTIVITY_DELETE};
    }

    public void disconnect() throws ManifoldCFException {
        if (this.session != null) {
            DestroySessionThread t = new DestroySessionThread();
            try {
                t.start();
                t.join();
                Throwable thr = t.getException();
                if (thr != null) {
                    if (thr instanceof RemoteException) {
                        throw (RemoteException)thr;
                    }
                    throw (Error)thr;
                }
                this.session = null;
                this.lastSessionFetch = -1L;
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (RemoteException e) {
                Throwable e2 = e.getCause();
                if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                    throw new ManifoldCFException(e2.getMessage(), e2, 2);
                }
                this.session = null;
                this.lastSessionFetch = -1L;
                Logging.connectors.warn((Object)("CMIS: Transient remote exception closing session: " + e.getMessage()), (Throwable)e);
            }
        }
        this.username = null;
        this.password = null;
        this.protocol = null;
        this.server = null;
        this.port = null;
        this.path = null;
        this.binding = null;
        this.repositoryId = null;
        this.cmisQuery = null;
        this.createTimestampTree = Boolean.FALSE.toString();
        this.versioningState = VersioningState.NONE;
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
        this.username = this.params.getParameter("username");
        this.password = this.params.getParameter("password");
        this.protocol = this.params.getParameter("protocol");
        this.server = this.params.getParameter("server");
        this.port = this.params.getParameter("port");
        this.path = this.params.getParameter("path");
        this.binding = this.params.getParameter("binding");
        this.cmisQuery = this.params.getParameter("cmisQuery");
        this.createTimestampTree = this.params.getParameter("createTimestampTree");
        if (StringUtils.isNotEmpty((String)this.params.getParameter("versioningState"))) {
            this.versioningState = VersioningState.fromValue((String)this.params.getParameter("versioningState"));
        }
        if (StringUtils.isNotEmpty((String)this.params.getParameter("repositoryId"))) {
            this.repositoryId = this.params.getParameter("repositoryId");
        }
    }

    public String check() throws ManifoldCFException {
        try {
            this.checkConnection();
            return super.check();
        }
        catch (ServiceInterruption e) {
            return "Connection temporarily failed: " + e.getMessage();
        }
        catch (ManifoldCFException e) {
            return "Connection failed: " + e.getMessage();
        }
    }

    protected void getSession() throws ManifoldCFException, ServiceInterruption {
        if (this.session == null) {
            if (StringUtils.isEmpty((String)this.binding)) {
                throw new ManifoldCFException("Parameter binding required but not set");
            }
            if (StringUtils.isEmpty((String)this.username)) {
                throw new ManifoldCFException("Parameter username required but not set");
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("CMIS: Username = '" + this.username + "'"));
            }
            if (StringUtils.isEmpty((String)this.password)) {
                throw new ManifoldCFException("Parameter password required but not set");
            }
            Logging.connectors.debug((Object)"CMIS: Password exists");
            if (StringUtils.isEmpty((String)this.protocol)) {
                throw new ManifoldCFException("Parameter protocol required but not set");
            }
            if (StringUtils.isEmpty((String)this.server)) {
                throw new ManifoldCFException("Parameter server required but not set");
            }
            if (StringUtils.isEmpty((String)this.port)) {
                throw new ManifoldCFException("Parameter port required but not set");
            }
            if (StringUtils.isEmpty((String)this.path)) {
                throw new ManifoldCFException("Parameter path required but not set");
            }
            if (StringUtils.isEmpty((String)this.cmisQuery)) {
                throw new ManifoldCFException("Parameter cmisQuery required but not set");
            }
            GetSessionThread t = new GetSessionThread();
            try {
                t.start();
                t.join();
                Throwable thr = t.getException();
                if (thr != null) {
                    if (thr instanceof MalformedURLException) {
                        throw (MalformedURLException)thr;
                    }
                    if (thr instanceof NotBoundException) {
                        throw (NotBoundException)thr;
                    }
                    if (thr instanceof RemoteException) {
                        throw (RemoteException)thr;
                    }
                    if (thr instanceof CmisConnectionException) {
                        throw new ManifoldCFException("CMIS: Error during getting a new session: " + thr.getMessage(), thr);
                    }
                    if (thr instanceof CmisPermissionDeniedException) {
                        throw new ManifoldCFException("CMIS: Wrong credentials during getting a new session: " + thr.getMessage(), thr);
                    }
                    throw (Error)thr;
                }
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (MalformedURLException e) {
                throw new ManifoldCFException(e.getMessage(), (Throwable)e);
            }
            catch (NotBoundException e) {
                Logging.connectors.warn((Object)("CMIS: Server not up at the moment: " + e.getMessage()), (Throwable)e);
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption(e.getMessage(), currentTime + 60000L);
            }
            catch (RemoteException e) {
                Throwable e2 = e.getCause();
                if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                    throw new ManifoldCFException(e2.getMessage(), e2, 2);
                }
                Logging.connectors.warn((Object)("CMIS: Transient remote exception creating session: " + e.getMessage()), (Throwable)e);
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption(e.getMessage(), currentTime + 60000L);
            }
        }
        this.lastSessionFetch = System.currentTimeMillis();
    }

    protected void releaseCheck() throws ManifoldCFException {
        if (this.lastSessionFetch == -1L) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this.lastSessionFetch + 300000L) {
            DestroySessionThread t = new DestroySessionThread();
            try {
                t.start();
                t.join();
                Throwable thr = t.getException();
                if (thr != null) {
                    if (thr instanceof RemoteException) {
                        throw (RemoteException)thr;
                    }
                    throw (Error)thr;
                }
                this.session = null;
                this.lastSessionFetch = -1L;
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (RemoteException e) {
                Throwable e2 = e.getCause();
                if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                    throw new ManifoldCFException(e2.getMessage(), e2, 2);
                }
                this.session = null;
                this.lastSessionFetch = -1L;
                Logging.connectors.warn((Object)("CMIS: Transient remote exception closing session: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    protected void checkConnection() throws ManifoldCFException, ServiceInterruption {
        while (true) {
            boolean noSession = this.session == null;
            this.getSession();
            CheckConnectionThread t = new CheckConnectionThread();
            try {
                t.start();
                t.join();
                Throwable thr = t.getException();
                if (thr != null) {
                    if (thr instanceof RemoteException) {
                        throw (RemoteException)thr;
                    }
                    if (thr instanceof CmisConnectionException) {
                        throw new ManifoldCFException("CMIS: Error during checking connection: " + thr.getMessage(), thr);
                    }
                    throw (Error)thr;
                }
                return;
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (RemoteException e) {
                Throwable e2 = e.getCause();
                if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                    throw new ManifoldCFException(e2.getMessage(), e2, 2);
                }
                if (noSession) {
                    long currentTime = System.currentTimeMillis();
                    throw new ServiceInterruption("Transient error connecting to filenet service: " + e.getMessage(), currentTime + 60000L);
                }
                this.session = null;
                this.lastSessionFetch = -1L;
                continue;
            }
            break;
        }
    }

    public void poll() throws ManifoldCFException {
        if (this.lastSessionFetch == -1L) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this.lastSessionFetch + 300000L) {
            DestroySessionThread t = new DestroySessionThread();
            try {
                t.start();
                t.join();
                Throwable thr = t.getException();
                if (thr != null) {
                    if (thr instanceof RemoteException) {
                        throw (RemoteException)thr;
                    }
                    throw (Error)thr;
                }
                this.session = null;
                this.lastSessionFetch = -1L;
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (RemoteException e) {
                Throwable e2 = e.getCause();
                if (e2 instanceof InterruptedException || e2 instanceof InterruptedIOException) {
                    throw new ManifoldCFException(e2.getMessage(), e2, 2);
                }
                this.session = null;
                this.lastSessionFetch = -1L;
                Logging.connectors.warn((Object)("CMIS: Transient remote exception closing session: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public boolean isConnected() {
        return this.session != null;
    }

    private static void outputResource(String resName, IHTTPOutput out, Locale locale, Map<String, String> paramMap) throws ManifoldCFException {
        Messages.outputResourceWithVelocity(out, locale, resName, paramMap, true);
    }

    private static void fillInServerConfigurationMap(Map<String, String> newMap, IPasswordMapperActivity mapper, ConfigParams parameters) {
        String username = parameters.getParameter("username");
        String password = parameters.getParameter("password");
        String protocol = parameters.getParameter("protocol");
        String server = parameters.getParameter("server");
        String port = parameters.getParameter("port");
        String path = parameters.getParameter("path");
        String repositoryId = parameters.getParameter("repositoryId");
        String binding = parameters.getParameter("binding");
        String cmisQuery = parameters.getParameter("cmisQuery");
        String createTimestampTree = parameters.getParameter("createTimestampTree");
        String versioningState = parameters.getParameter("versioningState");
        if (username == null) {
            username = "";
        }
        password = password == null ? "" : mapper.mapPasswordToKey(password);
        if (protocol == null) {
            protocol = "http";
        }
        if (server == null) {
            server = "localhost";
        }
        if (port == null) {
            port = "9091";
        }
        if (path == null) {
            path = "/chemistry-opencmis-server-inmemory/atom";
        }
        if (repositoryId == null) {
            repositoryId = "";
        }
        if (binding == null) {
            binding = "atom";
        }
        if (cmisQuery == null) {
            cmisQuery = "SELECT * FROM cmis:folder WHERE cmis:name='Apache ManifoldCF'";
        }
        if (createTimestampTree == null) {
            createTimestampTree = CmisOutputConfig.CREATE_TIMESTAMP_TREE_DEFAULT_VALUE;
        }
        if (versioningState == null) {
            versioningState = CmisOutputConfig.VERSIONING_STATE_DEFAULT_VALUE;
        }
        newMap.put("username", username);
        newMap.put("password", password);
        newMap.put("protocol", protocol);
        newMap.put("server", server);
        newMap.put("port", port);
        newMap.put("path", path);
        newMap.put("repositoryId", repositoryId);
        newMap.put("binding", binding);
        newMap.put("cmisQuery", cmisQuery);
        newMap.put("createTimestampTree", createTimestampTree);
        newMap.put("versioningState", versioningState);
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        CmisOutputConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        CmisOutputConnector.outputResource(VIEW_CONFIG_FORWARD, out, locale, paramMap);
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, CMIS_SERVER_TAB_PROPERTY));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        CmisOutputConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        CmisOutputConnector.outputResource(EDIT_CONFIG_HEADER_FORWARD, out, locale, paramMap);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("TabName", tabName);
        CmisOutputConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        CmisOutputConnector.outputResource(EDIT_CONFIG_FORWARD_SERVER, out, locale, paramMap);
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, ConfigParams parameters) throws ManifoldCFException {
        String repositoryId;
        String versioningState;
        String createTimestampTree;
        String cmisQuery;
        String path;
        String port;
        String server;
        String protocol;
        String password;
        String username;
        String binding = variableContext.getParameter("binding");
        if (binding != null) {
            parameters.setParameter("binding", binding);
        }
        if ((username = variableContext.getParameter("username")) != null) {
            parameters.setParameter("username", username);
        }
        if ((password = variableContext.getParameter("password")) != null) {
            parameters.setParameter("password", variableContext.mapKeyToPassword(password));
        }
        if ((protocol = variableContext.getParameter("protocol")) != null) {
            parameters.setParameter("protocol", protocol);
        }
        if ((server = variableContext.getParameter("server")) != null && !StringUtils.contains((String)server, (char)'/')) {
            parameters.setParameter("server", server);
        }
        if ((port = variableContext.getParameter("port")) != null) {
            try {
                Integer.parseInt(port);
                parameters.setParameter("port", port);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((path = variableContext.getParameter("path")) != null) {
            parameters.setParameter("path", path);
        }
        if ((cmisQuery = variableContext.getParameter("cmisQuery")) != null) {
            parameters.setParameter("cmisQuery", cmisQuery);
        }
        if ((createTimestampTree = variableContext.getParameter("createTimestampTree")) != null) {
            parameters.setParameter("createTimestampTree", createTimestampTree);
        }
        if ((versioningState = variableContext.getParameter("versioningState")) != null) {
            parameters.setParameter("versioningState", versioningState);
        }
        if ((repositoryId = variableContext.getParameter("repositoryId")) != null) {
            parameters.setParameter("repositoryId", repositoryId);
        }
        return null;
    }

    protected static void handleIOException(IOException e, String context) throws ManifoldCFException, ServiceInterruption {
        if (e instanceof InterruptedIOException) {
            throw new ManifoldCFException(e.getMessage(), (Throwable)e, 2);
        }
        Logging.connectors.warn((Object)("CMIS: IOException " + context + ": " + e.getMessage()), (Throwable)e);
        throw new ManifoldCFException(e.getMessage(), (Throwable)e);
    }

    private boolean isDropZoneFolder(String cmisQuery) {
        boolean isDropZoneFolder = false;
        ItemIterable dropZoneItemIterable = this.session.query(cmisQuery, false);
        Iterator dropZoneIterator = dropZoneItemIterable.iterator();
        String baseTypeId = null;
        while (dropZoneIterator.hasNext()) {
            QueryResult dropZoneResult = (QueryResult)dropZoneIterator.next();
            baseTypeId = dropZoneResult.getPropertyByQueryName("cmis:baseTypeId").getFirstValue().toString();
            if (!StringUtils.isNotEmpty((String)baseTypeId) || !StringUtils.equals((String)baseTypeId, (String)EnumBaseObjectTypeIds.CMIS_FOLDER.value())) continue;
            String objectId = (String)dropZoneResult.getPropertyValueById("cmis:objectId");
            this.parentDropZoneFolder = (Folder)this.session.getObject(objectId);
            isDropZoneFolder = true;
        }
        return isDropZoneFolder;
    }

    private boolean isSourceRepoCmisCompliant(RepositoryDocument document) {
        Iterator fields = document.getFields();
        while (fields.hasNext()) {
            String fieldName = (String)fields.next();
            if (!StringUtils.startsWith((String)fieldName, (String)CMIS_PROPERTY_PREFIX)) continue;
            return true;
        }
        return false;
    }

    public int addOrReplaceDocumentWithException(String documentURI, VersionContext pipelineDescription, RepositoryDocument document, String authorityNameString, IOutputAddActivity activities) throws ManifoldCFException, ServiceInterruption, IOException {
        this.getSession();
        boolean isDropZoneFolder = this.isDropZoneFolder(this.cmisQuery);
        long startTime = System.currentTimeMillis();
        String resultDescription = "";
        Folder leafParent = null;
        String fileName = "";
        InputStream inputStream = null;
        ReplayableInputStream replayableInputStream = null;
        ContentStreamImpl contentStream = null;
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Long binaryLength = null;
        String mimeType = "";
        try {
            if (isDropZoneFolder) {
                String[] cmisObjectIdArray;
                fileName = document.getFileName();
                Date creationDate = document.getCreatedDate();
                Date lastModificationDate = document.getModifiedDate();
                String objectId = "";
                mimeType = document.getMimeType();
                binaryLength = document.getBinaryLength();
                String primaryPath = "";
                List sourcePath = document.getSourcePath();
                if (sourcePath != null && !sourcePath.isEmpty()) {
                    primaryPath = (String)sourcePath.get(0);
                }
                if (this.isSourceRepoCmisCompliant(document) && (cmisObjectIdArray = (String[])document.getField("cmis:objectId")) != null && cmisObjectIdArray.length > 0) {
                    objectId = cmisObjectIdArray[0];
                }
                properties.put("cmis:objectTypeId", EnumBaseObjectTypeIds.CMIS_DOCUMENT.value());
                properties.put("cmis:name", fileName);
                properties.put("cmis:creationDate", creationDate);
                properties.put("cmis:lastModificationDate", lastModificationDate);
                if (StringUtils.isNotEmpty((String)objectId)) {
                    ObjectIdImpl objId = new ObjectIdImpl(objectId);
                    properties.put("cmis:objectId", objId);
                }
                inputStream = document.getBinaryStream();
                replayableInputStream = new ReplayableInputStream(inputStream);
                contentStream = new ContentStreamImpl(fileName, BigInteger.valueOf(binaryLength), mimeType, (InputStream)replayableInputStream);
                leafParent = this.getOrCreateLeafParent(this.parentDropZoneFolder, creationDate, Boolean.valueOf(this.createTimestampTree), primaryPath);
                leafParent.createDocument(properties, (ContentStream)contentStream, this.versioningState);
                resultDescription = DOCUMENT_STATUS_ACCEPTED_DESC;
                int n = 0;
                return n;
            }
            resultDescription = DOCUMENT_STATUS_REJECTED_DESC;
            int creationDate = 1;
            return creationDate;
        }
        catch (CmisContentAlreadyExistsException | CmisNameConstraintViolationException e) {
            if (leafParent != null) {
                String documentFullPath = leafParent.getPath() + "/" + fileName;
                String newFileName = fileName + System.currentTimeMillis();
                Document currentContent = (Document)this.session.getObjectByPath(documentFullPath);
                currentContent.updateProperties(properties);
                replayableInputStream.restart(true);
                contentStream = new ContentStreamImpl(newFileName, BigInteger.valueOf(binaryLength), mimeType, replayableInputStream);
                currentContent.setContentStream((ContentStream)contentStream, true);
                Logging.connectors.warn((Object)("CMIS: Document already exists - Updating: " + documentFullPath));
            }
            resultDescription = DOCUMENT_STATUS_ACCEPTED_DESC;
            int n = 0;
            return n;
        }
        catch (Exception e) {
            resultDescription = DOCUMENT_STATUS_REJECTED_DESC;
            throw new ManifoldCFException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            activities.recordActivity(Long.valueOf(startTime), ACTIVITY_INJECTION, Long.valueOf(document.getBinaryLength()), documentURI, resultDescription, resultDescription);
        }
    }

    private Folder getOrCreateLeafParent(Folder folder, Date creationDate, boolean createTimestampTree, String primaryPath) {
        Folder leafParent = folder;
        if (createTimestampTree) {
            Folder dayFolder;
            GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"), Locale.ROOT);
            calendar.setTime(creationDate);
            String year = String.valueOf(calendar.get(1));
            String month = String.valueOf(calendar.get(2) + 1);
            String day = String.valueOf(calendar.get(5));
            Folder yearFolder = this.createFolderIfNotExist(leafParent, year);
            Folder monthFolder = this.createFolderIfNotExist(yearFolder, month);
            leafParent = dayFolder = this.createFolderIfNotExist(monthFolder, day);
        } else if (StringUtils.isNotEmpty((String)primaryPath)) {
            String[] primaryPathArray = StringUtils.split((String)primaryPath, (String)"/");
            leafParent = folder;
            for (int i = 0; i < primaryPathArray.length - 1; ++i) {
                Folder pathSegmentFolder;
                String pathSegment = primaryPathArray[i];
                leafParent = pathSegmentFolder = this.createFolderIfNotExist(leafParent, pathSegment);
            }
        }
        return leafParent;
    }

    private Folder createFolderIfNotExist(Folder leafParent, String folderName) {
        Folder folder = null;
        try {
            folder = (Folder)this.session.getObjectByPath(leafParent.getPath() + "/" + folderName);
        }
        catch (CmisObjectNotFoundException onfe) {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("cmis:objectTypeId", BaseTypeId.CMIS_FOLDER.value());
            props.put("cmis:name", folderName);
            folder = leafParent.createFolder(props);
            String folderId = folder.getId();
            String folderPath = folder.getPath();
            Logging.connectors.info((Object)("CMIS: Created a new folder - id: " + folderId + " | Path: " + folderPath));
        }
        return folder;
    }

    private String getContentPath(String documentURI) throws URISyntaxException, UnsupportedEncodingException {
        String contentPath = "";
        String documentURIWithFixedEncoding = StringUtils.replace((String)documentURI, (String)"%", (String)"_");
        documentURIWithFixedEncoding = StringUtils.replace((String)documentURIWithFixedEncoding, (String)" ", (String)"%20");
        documentURIWithFixedEncoding = StringUtils.replace((String)documentURIWithFixedEncoding, (String)"`", (String)"%60");
        documentURIWithFixedEncoding = StringUtils.replace((String)documentURIWithFixedEncoding, (String)"#", (String)"%23");
        List params = URLEncodedUtils.parse((URI)new URI(documentURIWithFixedEncoding), (Charset)StandardCharsets.UTF_8);
        for (NameValuePair param : params) {
            if (!StringUtils.equals((String)CONTENT_PATH_PARAM, (String)param.getName())) continue;
            contentPath = param.getValue();
        }
        return contentPath;
    }

    public void removeDocument(String documentURI, String outputDescription, IOutputRemoveActivity activities) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        long startTime = System.currentTimeMillis();
        String result = "";
        boolean isDropZoneFolder = this.isDropZoneFolder(this.cmisQuery);
        try {
            if (isDropZoneFolder && this.parentDropZoneFolder != null && StringUtils.isNotEmpty((String)documentURI)) {
                String parentDropZonePath = this.parentDropZoneFolder.getPath();
                String contentPath = this.getContentPath(documentURI);
                String fullDocumentURIinTargetRepo = parentDropZonePath + contentPath;
                if (this.session.existsPath(fullDocumentURIinTargetRepo)) {
                    this.session.deleteByPath(fullDocumentURIinTargetRepo);
                    result = DOCUMENT_DELETION_STATUS_ACCEPTED;
                } else {
                    result = DOCUMENT_DELETION_STATUS_REJECTED;
                }
            } else {
                result = DOCUMENT_DELETION_STATUS_REJECTED;
            }
        }
        catch (Exception e) {
            result = DOCUMENT_DELETION_STATUS_REJECTED;
            throw new ManifoldCFException(e.getMessage(), (Throwable)e);
        }
        finally {
            activities.recordActivity(Long.valueOf(startTime), ACTIVITY_DELETE, null, documentURI, null, result);
        }
    }

    protected class DestroySessionThread
    extends Thread {
        protected Throwable exception = null;

        public DestroySessionThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                CmisOutputConnector.this.session = null;
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public Throwable getException() {
            return this.exception;
        }
    }

    protected class CheckConnectionThread
    extends Thread {
        protected Throwable exception = null;

        public CheckConnectionThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                CmisOutputConnector.this.session.getRepositoryInfo();
            }
            catch (Throwable e) {
                Logging.connectors.warn((Object)("CMIS: Error checking repository: " + e.getMessage()), e);
                this.exception = e;
            }
        }

        public Throwable getException() {
            return this.exception;
        }
    }

    protected class GetSessionThread
    extends Thread {
        protected Throwable exception = null;

        public GetSessionThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                CmisOutputConnector.this.parameters.clear();
                CmisOutputConnector.this.parameters.put("org.apache.chemistry.opencmis.user", CmisOutputConnector.this.username);
                CmisOutputConnector.this.parameters.put("org.apache.chemistry.opencmis.password", CmisOutputConnector.this.password);
                String endpoint = CmisOutputConnector.this.protocol + "://" + CmisOutputConnector.this.server + ":" + CmisOutputConnector.this.port + CmisOutputConnector.this.path;
                if ("atom".equals(CmisOutputConnector.this.binding)) {
                    CmisOutputConnector.this.parameters.put("org.apache.chemistry.opencmis.binding.atompub.url", endpoint);
                    CmisOutputConnector.this.parameters.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.ATOMPUB.value());
                } else if ("ws".equals(CmisOutputConnector.this.binding)) {
                    CmisOutputConnector.this.parameters.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.WEBSERVICES.value());
                    CmisOutputConnector.this.parameters.put("org.apache.chemistry.opencmis.binding.webservices.ACLService", endpoint + "/ACLService?wsdl");
                    CmisOutputConnector.this.parameters.put("org.apache.chemistry.opencmis.binding.webservices.DiscoveryService", endpoint + "/DiscoveryService?wsdl");
                    CmisOutputConnector.this.parameters.put("org.apache.chemistry.opencmis.binding.webservices.MultiFilingService", endpoint + "/MultiFilingService?wsdl");
                    CmisOutputConnector.this.parameters.put("org.apache.chemistry.opencmis.binding.webservices.NavigationService", endpoint + "/NavigationService?wsdl");
                    CmisOutputConnector.this.parameters.put("org.apache.chemistry.opencmis.binding.webservices.ObjectService", endpoint + "/ObjectService?wsdl");
                    CmisOutputConnector.this.parameters.put("org.apache.chemistry.opencmis.binding.webservices.PolicyService", endpoint + "/PolicyService?wsdl");
                    CmisOutputConnector.this.parameters.put("org.apache.chemistry.opencmis.binding.webservices.RelationshipService", endpoint + "/RelationshipService?wsdl");
                    CmisOutputConnector.this.parameters.put("org.apache.chemistry.opencmis.binding.webservices.RepositoryService", endpoint + "/RepositoryService?wsdl");
                    CmisOutputConnector.this.parameters.put("org.apache.chemistry.opencmis.binding.webservices.VersioningService", endpoint + "/VersioningService?wsdl");
                }
                if (StringUtils.isEmpty((String)CmisOutputConnector.this.repositoryId)) {
                    List repos = null;
                    try {
                        repos = CmisOutputConnector.this.factory.getRepositories(CmisOutputConnector.this.parameters);
                        CmisOutputConnector.this.session = ((Repository)repos.get(0)).createSession();
                    }
                    catch (Exception e) {
                        Logging.connectors.error((Object)("CMIS: Error during getting CMIS repositories. Please check the endpoint parameters: " + e.getMessage()), (Throwable)e);
                        this.exception = e;
                    }
                } else {
                    CmisOutputConnector.this.parameters.put("org.apache.chemistry.opencmis.session.repository.id", CmisOutputConnector.this.repositoryId);
                    try {
                        CmisOutputConnector.this.session = CmisOutputConnector.this.factory.createSession(CmisOutputConnector.this.parameters);
                    }
                    catch (Exception e) {
                        Logging.connectors.error((Object)("CMIS: Error during the creation of the new session. Please check the endpoint parameters: " + e.getMessage()), (Throwable)e);
                        this.exception = e;
                    }
                }
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public Throwable getException() {
            return this.exception;
        }
    }
}

