/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.zip;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.VfsLog;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.zip.ZipFileObject;
import org.apache.commons.vfs2.provider.zip.ZipFileProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipFileSystem
extends AbstractFileSystem
implements FileSystem {
    private static final Log LOG = LogFactory.getLog(ZipFileSystem.class);
    private final File file;
    private ZipFile zipFile;

    public ZipFileSystem(AbstractFileName rootName, FileObject parentLayer, FileSystemOptions fileSystemOptions) throws FileSystemException {
        super(rootName, parentLayer, fileSystemOptions);
        this.file = parentLayer.getFileSystem().replicateFile(parentLayer, Selectors.SELECT_SELF);
        if (!this.file.exists()) {
            this.zipFile = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws FileSystemException {
        super.init();
        try {
            ArrayList<ZipFileObject> strongRef = new ArrayList<ZipFileObject>(100);
            Enumeration<? extends ZipEntry> entries = this.getZipFile().entries();
            while (entries.hasMoreElements()) {
                ZipFileObject fileObj;
                ZipEntry entry = entries.nextElement();
                AbstractFileName name = (AbstractFileName)this.getFileSystemManager().resolveName(this.getRootName(), UriParser.encode(entry.getName()));
                if (entry.isDirectory() && this.getFileFromCache(name) != null) {
                    fileObj = (ZipFileObject)this.getFileFromCache(name);
                    fileObj.setZipEntry(entry);
                    continue;
                }
                fileObj = this.createZipFileObject(name, entry);
                this.putFileToCache(fileObj);
                strongRef.add(fileObj);
                fileObj.holdObject(strongRef);
                for (AbstractFileName parentName = (AbstractFileName)name.getParent(); parentName != null; parentName = (AbstractFileName)parentName.getParent()) {
                    ZipFileObject parent = (ZipFileObject)this.getFileFromCache(parentName);
                    if (parent == null) {
                        parent = this.createZipFileObject(parentName, null);
                        this.putFileToCache(parent);
                        strongRef.add(parent);
                        parent.holdObject(strongRef);
                    }
                    parent.attachChild(fileObj.getName());
                    fileObj = parent;
                }
            }
        }
        finally {
            this.closeCommunicationLink();
        }
    }

    protected ZipFile getZipFile() throws FileSystemException {
        if (this.zipFile == null && this.file.exists()) {
            ZipFile zipFile;
            this.zipFile = zipFile = this.createZipFile(this.file);
        }
        return this.zipFile;
    }

    protected ZipFileObject createZipFileObject(AbstractFileName name, ZipEntry entry) throws FileSystemException {
        return new ZipFileObject(name, entry, this, true);
    }

    protected ZipFile createZipFile(File file) throws FileSystemException {
        try {
            return new ZipFile(file);
        }
        catch (IOException ioe) {
            throw new FileSystemException("vfs.provider.zip/open-zip-file.error", file, (Throwable)ioe);
        }
    }

    @Override
    protected void doCloseCommunicationLink() {
        try {
            if (this.zipFile != null) {
                this.zipFile.close();
                this.zipFile = null;
            }
        }
        catch (IOException e) {
            VfsLog.warn(this.getLogger(), LOG, "vfs.provider.zip/close-zip-file.error :" + this.file, e);
        }
    }

    @Override
    protected void addCapabilities(Collection<Capability> caps) {
        caps.addAll(ZipFileProvider.capabilities);
    }

    @Override
    protected FileObject createFile(AbstractFileName name) throws FileSystemException {
        return new ZipFileObject(name, null, this, false);
    }
}

