/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.wiki;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.manifoldcf.agents.common.XMLContext;
import org.apache.manifoldcf.agents.common.XMLFileContext;
import org.apache.manifoldcf.agents.common.XMLStream;
import org.apache.manifoldcf.agents.common.XMLStringContext;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.connectorcommon.common.InterruptibleSocketFactory;
import org.apache.manifoldcf.connectorcommon.common.XThreadStringBuffer;
import org.apache.manifoldcf.connectorcommon.interfaces.IKeystoreManager;
import org.apache.manifoldcf.connectorcommon.interfaces.KeystoreManagerFactory;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.core.util.URLEncoder;
import org.apache.manifoldcf.crawler.connectors.BaseRepositoryConnector;
import org.apache.manifoldcf.crawler.connectors.wiki.BaseProcessingContext;
import org.apache.manifoldcf.crawler.connectors.wiki.Messages;
import org.apache.manifoldcf.crawler.connectors.wiki.SingleLevelContext;
import org.apache.manifoldcf.crawler.connectors.wiki.SingleLevelErrorContext;
import org.apache.manifoldcf.crawler.interfaces.IExistingVersions;
import org.apache.manifoldcf.crawler.interfaces.IProcessActivity;
import org.apache.manifoldcf.crawler.interfaces.ISeedingActivity;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.ui.util.Encoder;
import org.xml.sax.Attributes;

public class WikiConnector
extends BaseRepositoryConnector {
    public static final String _rcsid = "@(#)$Id: WikiConnector.java 1865954 2019-08-26 20:27:25Z schuch $";
    private static final String defaultAuthorityDenyToken = "DEAD_AUTHORITY";
    protected static final String ACTIVITY_FETCH = "fetch document";
    protected static final String[] activitiesList = new String[]{"fetch document"};
    protected boolean hasBeenSetup = false;
    protected String server = null;
    protected String baseURL = null;
    protected String userAgent = null;
    protected String serverLogin = null;
    protected String serverPass = null;
    protected String serverDomain = null;
    protected String accessRealm = null;
    protected String accessUser = null;
    protected String accessPassword = null;
    protected String proxyHost = null;
    protected String proxyPort = null;
    protected String proxyDomain = null;
    protected String proxyUsername = null;
    protected String proxyPassword = null;
    protected HttpClientConnectionManager connectionManager = null;
    protected HttpClient httpClient = null;
    private static String currentHost = null;

    public String[] getActivitiesList() {
        return activitiesList;
    }

    public String[] getBinNames(String documentIdentifier) {
        return new String[]{this.server};
    }

    public void connect(ConfigParams configParameters) {
        super.connect(configParameters);
        this.server = this.params.getParameter("Server name");
        this.serverLogin = this.params.getParameter("serverlogin");
        this.serverPass = this.params.getObfuscatedParameter("serverpass");
        this.serverDomain = this.params.getParameter("serverdomain");
        this.accessRealm = this.params.getParameter("accessrealm");
        this.accessUser = this.params.getParameter("accessuser");
        this.accessPassword = this.params.getObfuscatedParameter("accesspassword");
        this.proxyHost = this.params.getParameter("Proxy host");
        this.proxyPort = this.params.getParameter("Proxy port");
        this.proxyDomain = this.params.getParameter("Proxy domain");
        this.proxyUsername = this.params.getParameter("Proxy username");
        this.proxyPassword = this.params.getObfuscatedParameter("Proxy password");
    }

    protected void getSession() throws ManifoldCFException, ServiceInterruption {
        if (!this.hasBeenSetup) {
            String path;
            String portString;
            String emailAddress = this.params.getParameter("Email");
            this.userAgent = emailAddress != null ? "Mozilla/5.0 (ApacheManifoldCFWikiReader; " + (emailAddress == null ? "" : emailAddress) + ")" : null;
            String protocol = this.params.getParameter("Server protocol");
            if (protocol == null || protocol.length() == 0) {
                protocol = "http";
            }
            if ((portString = this.params.getParameter("Server port")) == null || portString.length() == 0) {
                portString = null;
            }
            if ((path = this.params.getParameter("Server path")) == null) {
                path = "/w";
            }
            this.baseURL = protocol + "://" + this.server + (portString != null ? ":" + portString : "") + path + "/api.php?format=xml&";
            int socketTimeout = 900000;
            int connectionTimeout = 300000;
            SSLSocketFactory httpsSocketFactory = KeystoreManagerFactory.getTrustingSecureSocketFactory();
            SSLConnectionSocketFactory myFactory = new SSLConnectionSocketFactory((SSLSocketFactory)new InterruptibleSocketFactory(httpsSocketFactory, (long)connectionTimeout), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            PoolingHttpClientConnectionManager poolingConnectionManager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)myFactory).build());
            poolingConnectionManager.setDefaultMaxPerRoute(1);
            poolingConnectionManager.setValidateAfterInactivity(2000);
            poolingConnectionManager.setDefaultSocketConfig(SocketConfig.custom().setTcpNoDelay(true).setSoTimeout(socketTimeout).build());
            this.connectionManager = poolingConnectionManager;
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            if (this.accessUser != null && this.accessUser.length() > 0 && this.accessPassword != null) {
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.accessUser, this.accessPassword);
                if (this.accessRealm != null && this.accessRealm.length() > 0) {
                    credentialsProvider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, this.accessRealm), (Credentials)credentials);
                } else {
                    credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)credentials);
                }
            }
            RequestConfig.Builder requestBuilder = RequestConfig.custom().setCircularRedirectsAllowed(true).setSocketTimeout(socketTimeout).setExpectContinueEnabled(true).setConnectTimeout(connectionTimeout).setConnectionRequestTimeout(socketTimeout);
            if (this.proxyHost != null && this.proxyHost.length() > 0) {
                int proxyPortInt;
                if (this.proxyPort != null && this.proxyPort.length() > 0) {
                    try {
                        proxyPortInt = Integer.parseInt(this.proxyPort);
                    }
                    catch (NumberFormatException e) {
                        throw new ManifoldCFException("Bad number: " + e.getMessage(), (Throwable)e);
                    }
                } else {
                    proxyPortInt = 8080;
                }
                if (this.proxyUsername != null && this.proxyUsername.length() > 0) {
                    if (this.proxyPassword == null) {
                        this.proxyPassword = "";
                    }
                    if (this.proxyDomain == null) {
                        this.proxyDomain = "";
                    }
                    credentialsProvider.setCredentials(new AuthScope(this.proxyHost, proxyPortInt), (Credentials)new NTCredentials(this.proxyUsername, this.proxyPassword, currentHost, this.proxyDomain));
                }
                HttpHost proxy = new HttpHost(this.proxyHost, proxyPortInt);
                requestBuilder.setProxy(proxy);
            }
            this.httpClient = HttpClients.custom().setConnectionManager(this.connectionManager).disableAutomaticRetries().setDefaultRequestConfig(requestBuilder.build()).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).setSSLSocketFactory((LayeredConnectionSocketFactory)myFactory).setRequestExecutor(new HttpRequestExecutor(socketTimeout)).build();
            this.loginToAPI();
            this.hasBeenSetup = true;
        }
    }

    protected boolean loginToAPI() throws ManifoldCFException, ServiceInterruption {
        Thread t;
        HttpRequestBase method;
        if (this.serverLogin == null || this.serverLogin.length() == 0) {
            return false;
        }
        HttpClient client = this.httpClient;
        HashMap<String, String> loginParams = new HashMap<String, String>();
        String token = null;
        String loginURL = this.baseURL + "action=login";
        loginParams.put("action", "login");
        loginParams.put("lgname", this.serverLogin);
        loginParams.put("lgpassword", this.serverPass);
        if (this.serverDomain != null && !"".equals(this.serverDomain)) {
            loginParams.put("lgdomain", this.serverDomain);
        }
        APILoginResult result = new APILoginResult();
        try {
            method = this.getInitializedPostMethod(loginURL, loginParams);
            t = new ExecuteAPILoginThread(client, method, result);
            try {
                t.start();
                token = ((ExecuteAPILoginThread)t).finishUp();
            }
            catch (ManifoldCFException e) {
                t.interrupt();
                throw e;
            }
            catch (ServiceInterruption e) {
                t.interrupt();
                throw e;
            }
            catch (IOException e) {
                t.interrupt();
                throw e;
            }
            catch (HttpException e) {
                t.interrupt();
                throw e;
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw e;
            }
            if (result.result) {
                return true;
            }
            if (token == null) {
                Logging.connectors.debug((Object)("WIKI API login error: '" + result.reason + "'"));
                throw new ManifoldCFException("WIKI API login error: " + result.reason, null, 5);
            }
        }
        catch (InterruptedException e) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (ManifoldCFException e) {
            throw e;
        }
        catch (SocketTimeoutException e) {
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption("Login timed out reading from the Wiki server: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 720000L, -1, false);
        }
        catch (SocketException e) {
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption("Login received a socket error reading from Wiki server: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 720000L, -1, false);
        }
        catch (ConnectTimeoutException e) {
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption("Login connection timed out reading from Wiki server: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 720000L, -1, false);
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (IOException e) {
            throw new ManifoldCFException("Login had an IO failure: " + e.getMessage(), (Throwable)e);
        }
        catch (HttpException e) {
            throw new ManifoldCFException("Login had an Http exception: " + e.getMessage(), (Throwable)e);
        }
        loginParams.put("lgtoken", token);
        try {
            method = this.getInitializedPostMethod(loginURL, loginParams);
            t = new ExecuteTokenAPILoginThread(this.httpClient, method, result);
            try {
                t.start();
                ((ExecuteTokenAPILoginThread)t).finishUp();
            }
            catch (ManifoldCFException e) {
                t.interrupt();
                throw e;
            }
            catch (ServiceInterruption e) {
                t.interrupt();
                throw e;
            }
            catch (IOException e) {
                t.interrupt();
                throw e;
            }
            catch (HttpException e) {
                t.interrupt();
                throw e;
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw e;
            }
        }
        catch (InterruptedException e) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (ManifoldCFException e) {
            throw e;
        }
        catch (SocketTimeoutException e) {
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption("Login timed out reading from the Wiki server: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 720000L, -1, false);
        }
        catch (SocketException e) {
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption("Login received a socket error reading from Wiki server: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 720000L, -1, false);
        }
        catch (ConnectTimeoutException e) {
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption("Login connection timed out reading from Wiki server: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 720000L, -1, false);
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (IOException e) {
            throw new ManifoldCFException("Login had an IO failure: " + e.getMessage(), (Throwable)e);
        }
        catch (HttpException e) {
            throw new ManifoldCFException("Login had an Http exception: " + e.getMessage(), (Throwable)e);
        }
        if (!result.result) {
            Logging.connectors.debug((Object)("WIKI API login error: '" + result.reason + "'"));
            throw new ManifoldCFException("WIKI API login error: " + result.reason, null, 5);
        }
        return true;
    }

    public String check() throws ManifoldCFException {
        try {
            this.hasBeenSetup = false;
            this.performCheck();
            return super.check();
        }
        catch (ServiceInterruption e) {
            return "Transient error: " + e.getMessage();
        }
        catch (ManifoldCFException e) {
            if (e.getErrorCode() == 2) {
                throw e;
            }
            return "Error: " + e.getMessage();
        }
    }

    public void poll() throws ManifoldCFException {
        if (this.connectionManager != null) {
            this.connectionManager.closeIdleConnections(60000L, TimeUnit.MILLISECONDS);
        }
    }

    public void disconnect() throws ManifoldCFException {
        this.hasBeenSetup = false;
        this.server = null;
        this.serverLogin = null;
        this.serverPass = null;
        this.serverDomain = null;
        this.accessUser = null;
        this.accessPassword = null;
        this.accessRealm = null;
        this.proxyHost = null;
        this.proxyPort = null;
        this.proxyDomain = null;
        this.proxyUsername = null;
        this.proxyPassword = null;
        this.baseURL = null;
        this.userAgent = null;
        if (this.httpClient != null) {
            this.httpClient = null;
        }
        if (this.connectionManager != null) {
            this.connectionManager.shutdown();
            this.connectionManager = null;
        }
        super.disconnect();
    }

    public int getMaxDocumentRequest() {
        return 20;
    }

    public String addSeedDocuments(ISeedingActivity activities, Specification spec, String lastSeedVersion, long seedTime, int jobMode) throws ManifoldCFException, ServiceInterruption {
        long startTime = lastSeedVersion == null ? 0L : new Long(lastSeedVersion);
        boolean seenAny = false;
        for (int i = 0; i < spec.getChildCount(); ++i) {
            SpecificationNode sn = spec.getChild(i);
            if (!sn.getType().equals("namespaceandprefix")) continue;
            String namespace = sn.getAttributeValue("namespace");
            String titleprefix = sn.getAttributeValue("titleprefix");
            this.listAllPages(activities, namespace, titleprefix, startTime, seedTime);
            seenAny = true;
        }
        if (!seenAny) {
            this.listAllPages(activities, null, null, startTime, seedTime);
        }
        return new Long(seedTime).toString();
    }

    public void processDocuments(String[] documentIdentifiers, IExistingVersions statuses, Specification spec, IProcessActivity activities, int jobMode, boolean usesDefaultAuthority) throws ManifoldCFException, ServiceInterruption {
        String[] acls = WikiConnector.getAcls(spec);
        HashMap<String, String> versions = new HashMap<String, String>();
        this.getTimestamps(documentIdentifiers, versions, activities);
        ArrayList<String> fetchDocuments = new ArrayList<String>();
        for (String documentIdentifier : documentIdentifiers) {
            String versionString = (String)versions.get(documentIdentifier);
            if (versionString == null) {
                activities.deleteDocument(documentIdentifier);
                continue;
            }
            if (!activities.checkDocumentNeedsReindexing(documentIdentifier, versionString)) continue;
            fetchDocuments.add(documentIdentifier);
        }
        if (fetchDocuments.size() == 0) {
            return;
        }
        String[] fetchDocumentsArray = fetchDocuments.toArray(new String[0]);
        HashMap<String, String> urls = new HashMap<String, String>();
        this.getDocURLs(documentIdentifiers, urls);
        for (String documentIdentifier : fetchDocumentsArray) {
            String url = (String)urls.get(documentIdentifier);
            String versionString = (String)versions.get(documentIdentifier);
            if (url != null) {
                this.getDocInfo(documentIdentifier, versionString, url, activities, acls);
                continue;
            }
            activities.noDocument(documentIdentifier, versionString);
        }
    }

    protected static String[] getAcls(Specification spec) {
        HashSet<String> aclMap = new HashSet<String>();
        for (int i = 0; i < spec.getChildCount(); ++i) {
            SpecificationNode sn = spec.getChild(i);
            if (!sn.getType().equals("access")) continue;
            String token = sn.getAttributeValue("token");
            aclMap.add(token);
        }
        String[] rval = new String[aclMap.size()];
        int j = 0;
        for (String acl : aclMap) {
            rval[j++] = acl;
        }
        return rval;
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "WikiConnector.Server"));
        tabsArray.add(Messages.getString(locale, "WikiConnector.Email"));
        tabsArray.add(Messages.getString(locale, "WikiConnector.Proxy"));
        out.print("<script type=\"text/javascript\">\n<!--\nfunction checkConfig()\n{\n  if (editconnection.email.value != \"\" && editconnection.email.value.indexOf(\"@\") == -1)\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "WikiConnector.NeedAValidEmailAddress") + "\");\n    editconnection.email.focus();\n    return false;\n  }\n  if (editconnection.serverport.value != \"\" && !isInteger(editconnection.serverport.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "WikiConnector.WikiServerPortMustBeAValidInteger") + "\");\n    editconnection.serverport.focus();\n    return false;\n  }\n  if (editconnection.serverpath.value != \"\" && editconnection.serverpath.value.indexOf(\"/\") != 0)\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "WikiConnector.PathMustStartWithACharacter") + "\");\n    editconnection.serverpath.focus();\n    return false;\n  }\n  if (editconnection.proxyport.value != \"\" && !isInteger(editconnection.proxyport.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "WikiConnector.ProxyPortMustBeAValidInteger") + "\");\n    editconnection.proxyport.focus();\n    return false;\n  }\n  return true;\n}\n\nfunction checkConfigForSave()\n{\n  if (editconnection.email.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "WikiConnector.EmailAddressRequiredToBeIncludedInAllRequestHeaders") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "WikiConnector.Email") + "\");\n    editconnection.email.focus();\n    return false;\n  }\n  if (editconnection.servername.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "WikiConnector.PleaseSupplyAValidWikiServerName") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "WikiConnector.Server") + "\");\n    editconnection.servername.focus();\n    return false;\n  }\n  if (editconnection.serverport.value != \"\" && !isInteger(editconnection.serverport.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "WikiConnector.WikiServerPortMustBeAValidInteger") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "WikiConnector.Server") + "\");\n    editconnection.serverport.focus();\n    return false;\n  }\n  if (editconnection.serverpath.value != \"\" && editconnection.serverpath.value.indexOf(\"/\") != 0)\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "WikiConnector.PathMustStartWithACharacter") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "WikiConnector.Server") + "\");\n    editconnection.serverpath.focus();\n    return false;\n  }\n  if (editconnection.proxyport.value != \"\" && !isInteger(editconnection.proxyport.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "WikiConnector.ProxyPortMustBeAValidInteger") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "WikiConnector.Proxy") + "\");\n    editconnection.proxyport.focus();\n    return false;\n  }\n  return true;\n}\n\n//-->\n</script>\n");
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        String proxyPassword;
        String proxyUsername;
        String proxyDomain;
        String proxyPort;
        String accessPassword;
        String accessUser;
        String accessRealm;
        String pass;
        String login;
        String path;
        String port;
        String server;
        String protocol;
        String email = parameters.getParameter("Email");
        if (email == null) {
            email = "";
        }
        if ((protocol = parameters.getParameter("Server protocol")) == null) {
            protocol = "http";
        }
        if ((server = parameters.getParameter("Server name")) == null) {
            server = "";
        }
        if ((port = parameters.getParameter("Server port")) == null) {
            port = "";
        }
        if ((path = parameters.getParameter("Server path")) == null) {
            path = "/w";
        }
        if ((login = parameters.getParameter("serverlogin")) == null) {
            login = "";
        }
        pass = (pass = parameters.getObfuscatedParameter("serverpass")) == null ? "" : out.mapPasswordToKey(pass);
        String domain = parameters.getParameter("serverdomain");
        if (domain == null) {
            domain = "";
        }
        if ((accessRealm = parameters.getParameter("accessrealm")) == null) {
            accessRealm = "";
        }
        if ((accessUser = parameters.getParameter("accessuser")) == null) {
            accessUser = "";
        }
        accessPassword = (accessPassword = parameters.getObfuscatedParameter("accesspassword")) == null ? "" : out.mapPasswordToKey(accessPassword);
        String proxyHost = parameters.getParameter("Proxy host");
        if (proxyHost == null) {
            proxyHost = "";
        }
        if ((proxyPort = parameters.getParameter("Proxy port")) == null) {
            proxyPort = "";
        }
        if ((proxyDomain = parameters.getParameter("Proxy domain")) == null) {
            proxyDomain = "";
        }
        if ((proxyUsername = parameters.getParameter("Proxy username")) == null) {
            proxyUsername = "";
        }
        proxyPassword = (proxyPassword = parameters.getObfuscatedParameter("Proxy password")) == null ? "" : out.mapPasswordToKey(proxyPassword);
        if (tabName.equals(Messages.getString(locale, "WikiConnector.Proxy"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "WikiConnector.ProxyHostColon") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"32\" name=\"proxyhost\" value=\"" + Encoder.attributeEscape((String)proxyHost) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "WikiConnector.ProxyPortColon") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"5\" name=\"proxyport\" value=\"" + Encoder.attributeEscape((String)proxyPort) + "\"/></td>\n  </tr>\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "WikiConnector.ProxyDomainColon") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"32\" name=\"proxydomain\" value=\"" + Encoder.attributeEscape((String)proxyDomain) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "WikiConnector.ProxyUsernameColon") + "</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"16\" name=\"proxyusername\" value=\"" + Encoder.attributeEscape((String)proxyUsername) + "\"/></td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "WikiConnector.ProxyPasswordColon") + "</nobr></td>\n    <td class=\"value\"><input type=\"password\" size=\"16\" name=\"proxypassword\" value=\"" + Encoder.attributeEscape((String)proxyPassword) + "\"/></td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"proxyhost\" value=\"" + Encoder.attributeEscape((String)proxyHost) + "\"/>\n<input type=\"hidden\" name=\"proxyport\" value=\"" + Encoder.attributeEscape((String)proxyPort) + "\"/>\n<input type=\"hidden\" name=\"proxydomain\" value=\"" + Encoder.attributeEscape((String)proxyDomain) + "\"/>\n<input type=\"hidden\" name=\"proxyusername\" value=\"" + Encoder.attributeEscape((String)proxyUsername) + "\"/>\n<input type=\"hidden\" name=\"proxypassword\" value=\"" + Encoder.attributeEscape((String)proxyPassword) + "\"/>\n");
        }
        if (tabName.equals(Messages.getString(locale, "WikiConnector.Email"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "WikiConnector.EmailAddressToContactColon") + "</nobr></td><td class=\"value\"><input type=\"text\" size=\"32\" name=\"email\" value=\"" + Encoder.attributeEscape((String)email) + "\"/></td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"email\" value=\"" + Encoder.attributeEscape((String)email) + "\"/>\n");
        }
        if (tabName.equals(Messages.getString(locale, "WikiConnector.Server"))) {
            out.print("<table class=\"displaytable\">\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "WikiConnector.Protocol") + "</nobr></td>\n    <td class=\"value\">\n      <select name=\"serverprotocol\">\n        <option value=\"http\"" + (protocol.equals("http") ? " selected=\"true\"" : "") + ">http</option>\n        <option value=\"https\"" + (protocol.equals("https") ? " selected=\"true\"" : "") + ">https</option>\n      </select>\n    </td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "WikiConnector.ServerName") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"servername\" type=\"text\" size=\"32\" value=\"" + Encoder.attributeEscape((String)server) + "\"/>\n    </td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "WikiConnector.Port") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"serverport\" type=\"text\" size=\"5\" value=\"" + Encoder.attributeEscape((String)port) + "\"/>\n    </td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "WikiConnector.PathName") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"serverpath\" type=\"text\" size=\"16\" value=\"" + Encoder.attributeEscape((String)path) + "\"/>\n    </td>\n  </tr>\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "WikiConnector.ServerLogin") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"serverlogin\" type=\"text\" size=\"16\" value=\"" + Encoder.attributeEscape((String)login) + "\"/>\n    </td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "WikiConnector.ServerPassword") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"serverpass\" type=\"password\" size=\"16\" value=\"" + Encoder.attributeEscape((String)pass) + "\"/>\n    </td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "WikiConnector.ServerDomain") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"serverdomain\" type=\"text\" size=\"16\" value=\"" + Encoder.attributeEscape((String)domain) + "\"/>\n    </td>\n  </tr>\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "WikiConnector.AccessUser") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"accessuser\" type=\"text\" size=\"16\" value=\"" + Encoder.attributeEscape((String)accessUser) + "\"/>\n    </td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "WikiConnector.AccessPassword") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"accesspassword\" type=\"password\" size=\"16\" value=\"" + Encoder.attributeEscape((String)accessPassword) + "\"/>\n    </td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "WikiConnector.AccessRealm") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"accessrealm\" type=\"text\" size=\"16\" value=\"" + Encoder.attributeEscape((String)accessRealm) + "\"/>\n    </td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"serverprotocol\" value=\"" + Encoder.attributeEscape((String)protocol) + "\"/>\n<input type=\"hidden\" name=\"servername\" value=\"" + Encoder.attributeEscape((String)server) + "\"/>\n<input type=\"hidden\" name=\"serverport\" value=\"" + Encoder.attributeEscape((String)port) + "\"/>\n<input type=\"hidden\" name=\"serverpath\" value=\"" + Encoder.attributeEscape((String)path) + "\"/>\n<input type=\"hidden\" name=\"serverlogin\" value=\"" + Encoder.attributeEscape((String)login) + "\"/>\n<input type=\"hidden\" name=\"serverpass\" value=\"" + Encoder.attributeEscape((String)pass) + "\"/>\n<input type=\"hidden\" name=\"serverdomain\" value=\"" + Encoder.attributeEscape((String)domain) + "\"/>\n<input type=\"hidden\" name=\"accessuser\" value=\"" + Encoder.attributeEscape((String)accessUser) + "\"/>\n<input type=\"hidden\" name=\"accesspassword\" value=\"" + Encoder.attributeEscape((String)accessPassword) + "\"/>\n<input type=\"hidden\" name=\"accessrealm\" value=\"" + Encoder.attributeEscape((String)accessRealm) + "\"/>\n");
        }
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        String proxyPassword;
        String proxyUsername;
        String proxyDomain;
        String proxyPort;
        String proxyHost;
        String accessRealm;
        String accessPassword;
        String accessUser;
        String domain;
        String pass;
        String login;
        String path;
        String port;
        String server;
        String protocol;
        String email = variableContext.getParameter("email");
        if (email != null) {
            parameters.setParameter("Email", email);
        }
        if ((protocol = variableContext.getParameter("serverprotocol")) != null) {
            parameters.setParameter("Server protocol", protocol);
        }
        if ((server = variableContext.getParameter("servername")) != null) {
            parameters.setParameter("Server name", server);
        }
        if ((port = variableContext.getParameter("serverport")) != null) {
            parameters.setParameter("Server port", port);
        }
        if ((path = variableContext.getParameter("serverpath")) != null) {
            parameters.setParameter("Server path", path);
        }
        if ((login = variableContext.getParameter("serverlogin")) != null) {
            parameters.setParameter("serverlogin", login);
        }
        if ((pass = variableContext.getParameter("serverpass")) != null) {
            parameters.setObfuscatedParameter("serverpass", variableContext.mapKeyToPassword(pass));
        }
        if ((domain = variableContext.getParameter("serverdomain")) != null) {
            parameters.setParameter("serverdomain", domain);
        }
        if ((accessUser = variableContext.getParameter("accessuser")) != null) {
            parameters.setParameter("accessuser", accessUser);
        }
        if ((accessPassword = variableContext.getParameter("accesspassword")) != null) {
            parameters.setObfuscatedParameter("accesspassword", variableContext.mapKeyToPassword(accessPassword));
        }
        if ((accessRealm = variableContext.getParameter("accessrealm")) != null) {
            parameters.setParameter("accessrealm", accessRealm);
        }
        if ((proxyHost = variableContext.getParameter("proxyhost")) != null) {
            parameters.setParameter("Proxy host", proxyHost);
        }
        if ((proxyPort = variableContext.getParameter("proxyport")) != null) {
            parameters.setParameter("Proxy port", proxyPort);
        }
        if ((proxyDomain = variableContext.getParameter("proxydomain")) != null) {
            parameters.setParameter("Proxy domain", proxyDomain);
        }
        if ((proxyUsername = variableContext.getParameter("proxyusername")) != null) {
            parameters.setParameter("Proxy username", proxyUsername);
        }
        if ((proxyPassword = variableContext.getParameter("proxypassword")) != null) {
            parameters.setObfuscatedParameter("Proxy password", variableContext.mapKeyToPassword(proxyPassword));
        }
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        out.print("<table class=\"displaytable\">\n  <tr>\n    <td class=\"description\" colspan=\"1\"><nobr>" + Messages.getBodyString(locale, "WikiConnector.Parameters") + "</nobr></td>\n    <td class=\"value\" colspan=\"3\">\n");
        Iterator iter = parameters.listParameters();
        while (iter.hasNext()) {
            String param = (String)iter.next();
            String value = parameters.getParameter(param);
            if (param.length() >= "password".length() && param.substring(param.length() - "password".length()).equalsIgnoreCase("password")) {
                out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=********</nobr><br/>\n");
                continue;
            }
            if (param.length() >= "keystore".length() && param.substring(param.length() - "keystore".length()).equalsIgnoreCase("keystore")) {
                IKeystoreManager kmanager = KeystoreManagerFactory.make((String)"", (String)value);
                out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=&lt;" + Integer.toString(kmanager.getContents().length) + Messages.getBodyString(locale, "WikiConnector.certificates") + "&gt;</nobr><br/>\n");
                continue;
            }
            out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=" + Encoder.bodyEscape((String)value) + "</nobr><br/>\n");
        }
        out.print("    </td>\n  </tr>\n</table>\n");
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "WikiConnector.NamespaceAndTitles"));
        tabsArray.add(Messages.getString(locale, "WikiConnector.Security"));
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        out.print("<script type=\"text/javascript\">\n<!--\nfunction " + seqPrefix + "NsDelete(k)\n{\n  " + seqPrefix + "SpecOp(\"" + seqPrefix + "nsop_\"+k, \"Delete\", \"" + seqPrefix + "ns_\"+k);\n}\n\nfunction " + seqPrefix + "NsAdd(k)\n{\n  " + seqPrefix + "SpecOp(\"" + seqPrefix + "nsop\", \"Add\", \"" + seqPrefix + "ns_\"+k);\n}\n\nfunction " + seqPrefix + "SpecAddToken(anchorvalue)\n{\n  if (editjob." + seqPrefix + "spectoken.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "WikiConnector.TypeInAnAccessToken") + "\");\n    editjob." + seqPrefix + "spectoken.focus();\n    return;\n  }\n  " + seqPrefix + "SpecOp(\"" + seqPrefix + "accessop\",\"Add\",anchorvalue);\n}\n\nfunction " + seqPrefix + "SpecOp(n, opValue, anchorvalue)\n{\n  eval(\"editjob.\"+n+\".value = \\\"\"+opValue+\"\\\"\");\n  postFormSetAnchor(anchorvalue);\n}\n\n//-->\n</script>\n");
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        String accessDescription;
        int i;
        SpecificationNode sn;
        int k;
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        if (tabName.equals(Messages.getString(locale, "WikiConnector.NamespaceAndTitles")) && connectionSequenceNumber == actualSequenceNumber) {
            boolean seenAny = false;
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "WikiConnector.NamespaceAndTitles2") + "</nobr></td>\n    <td class=\"boxcell\">\n      <table class=\"formtable\">\n        <tr class=\"formheaderrow\">\n          <td class=\"formcolumnheader\"></td>\n          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "WikiConnector.Namespace") + "</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "WikiConnector.TitlePrefix") + "</nobr></td>\n        </tr>\n");
            k = 0;
            for (int i2 = 0; i2 < ds.getChildCount(); ++i2) {
                SpecificationNode sn2 = ds.getChild(i2);
                if (!sn2.getType().equals("namespaceandprefix")) continue;
                String namespace = sn2.getAttributeValue("namespace");
                String titlePrefix = sn2.getAttributeValue("titleprefix");
                String nsOpName = seqPrefix + "nsop_" + k;
                String nsNsName = seqPrefix + "nsnsname_" + k;
                String nsTitlePrefix = seqPrefix + "nstitleprefix_" + k;
                out.print("        <tr class=\"" + (k % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n          <td class=\"formcolumncell\">\n            <nobr>\n              <a name=\"" + seqPrefix + "ns_" + Integer.toString(k) + "\"/>\n              <input type=\"hidden\" name=\"" + nsOpName + "\" value=\"\"/>\n              <input type=\"hidden\" name=\"" + nsNsName + "\" value=\"" + (namespace == null ? "" : Encoder.attributeEscape((String)namespace)) + "\"/>\n              <input type=\"hidden\" name=\"" + nsTitlePrefix + "\" value=\"" + (titlePrefix == null ? "" : Encoder.attributeEscape((String)titlePrefix)) + "\"/>\n              <input type=\"button\" value=\"" + Messages.getAttributeString(locale, "WikiConnector.Delete") + "\" onClick='Javascript:" + seqPrefix + "NsDelete(" + Integer.toString(k) + ")' alt=\"" + Messages.getAttributeString(locale, "WikiConnector.DeleteNamespaceTitle") + Integer.toString(k) + "\"/>\n            </nobr>\n          </td>\n          <td class=\"formcolumncell\">\n            <nobr>\n              " + (namespace == null ? "(default)" : Encoder.bodyEscape((String)namespace)) + "\n            </nobr>\n          </td>\n          <td class=\"formcolumncell\">\n            <nobr>\n              " + (titlePrefix == null ? "(all titles)" : Encoder.bodyEscape((String)titlePrefix)) + "\n            </nobr>\n          </td>\n        </tr>\n");
                ++k;
            }
            if (k == 0) {
                out.print("        <tr class=\"formrow\"><td colspan=\"3\" class=\"formmessage\">" + Messages.getBodyString(locale, "WikiConnector.NoSpecification") + "</td></tr>\n");
            }
            out.print("        <tr class=\"formrow\"><td colspan=\"4\" class=\"formseparator\"><hr/></td></tr>\n");
            HashMap<String, String> namespaces = new HashMap<String, String>();
            try {
                this.getNamespaces(namespaces);
                Object[] nameSpaceNames = new String[namespaces.size()];
                Iterator keyIter = namespaces.keySet().iterator();
                int j = 0;
                while (keyIter.hasNext()) {
                    nameSpaceNames[j++] = (String)keyIter.next();
                }
                Arrays.sort(nameSpaceNames);
                out.print("        <tr class=\"formrow\">\n          <td class=\"formcolumncell\">\n            <nobr>\n              <a name=\"" + seqPrefix + "ns_" + Integer.toString(k) + "\"/>\n              <input type=\"hidden\" name=\"" + seqPrefix + "nsop\" value=\"\"/>\n              <input type=\"hidden\" name=\"" + seqPrefix + "nscount\" value=\"" + Integer.toString(k) + "\"/>\n              <input type=\"button\" value=\"" + Messages.getAttributeString(locale, "WikiConnector.Add") + "\" onClick='Javascript:" + seqPrefix + "NsAdd(" + Integer.toString(k) + ")' alt=\"" + Messages.getAttributeString(locale, "WikiConnector.AddNamespacePrefix") + "\"/>\n            </nobr>\n          </td>\n          <td class=\"formcolumncell\">\n            <nobr>\n              <select name=\"" + seqPrefix + "nsnsname\">\n                <option value=\"\" selected=\"true\">-- " + Messages.getBodyString(locale, "WikiConnector.UseDefault") + " --</option>\n");
                for (int l = 0; l < nameSpaceNames.length; ++l) {
                    Object prettyName = nameSpaceNames[l];
                    String canonicalName = (String)namespaces.get(prettyName);
                    out.print("                <option value=\"" + Encoder.attributeEscape((String)canonicalName) + "\">" + Encoder.bodyEscape((String)prettyName) + "</option>\n");
                }
                out.print("              </select>\n            </nobr>\n          </td>\n          <td class=\"formcolumncell\">\n            <nobr>\n              <input type=\"text\" name=\"" + seqPrefix + "nstitleprefix\" size=\"16\" value=\"\"/>\n            </nobr>\n          </td>\n        </tr>\n");
            }
            catch (ServiceInterruption e) {
                out.print("        <tr class=\"formrow\"><td colspan=\"3\" class=\"formmessage\">" + Messages.getBodyString(locale, "WikiConnector.TransientError") + Encoder.bodyEscape((String)e.getMessage()) + "</td></tr>\n");
            }
            out.print("      </table>\n    </td>\n  </tr>\n</table>\n");
        } else {
            int k2 = 0;
            for (int i3 = 0; i3 < ds.getChildCount(); ++i3) {
                sn = ds.getChild(i3);
                if (!sn.getType().equals("namespaceandprefix")) continue;
                String namespace = sn.getAttributeValue("namespace");
                String titlePrefix = sn.getAttributeValue("titleprefix");
                String nsNsName = seqPrefix + "nsnsname_" + k2;
                String nsTitlePrefix = seqPrefix + "nstitleprefix_" + k2;
                out.print("<input type=\"hidden\" name=\"" + nsNsName + "\" value=\"" + (namespace == null ? "" : Encoder.attributeEscape((String)namespace)) + "\"/>\n<input type=\"hidden\" name=\"" + nsTitlePrefix + "\" value=\"" + (titlePrefix == null ? "" : Encoder.attributeEscape((String)titlePrefix)) + "\"/>\n");
                ++k2;
            }
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "nscount\" value=\"" + new Integer(k2) + "\"/>\n");
        }
        if (tabName.equals(Messages.getString(locale, "WikiConnector.Security")) && connectionSequenceNumber == actualSequenceNumber) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
            i = 0;
            k = 0;
            while (i < ds.getChildCount()) {
                if (!(sn = ds.getChild(i++)).getType().equals("access")) continue;
                accessDescription = "_" + Integer.toString(k);
                String accessOpName = seqPrefix + "accessop" + accessDescription;
                String token = sn.getAttributeValue("token");
                out.print("  <tr>\n    <td class=\"description\">\n      <input type=\"hidden\" name=\"" + accessOpName + "\" value=\"\"/>\n      <input type=\"hidden\" name=\"" + seqPrefix + "spectoken" + accessDescription + "\" value=\"" + Encoder.attributeEscape((String)token) + "\"/>\n      <a name=\"" + seqPrefix + "token_" + Integer.toString(k) + "\">\n        <input type=\"button\" value=\"" + Messages.getAttributeString(locale, "WikiConnector.Delete") + "\" onClick='Javascript:" + seqPrefix + "SpecOp(\"" + accessOpName + "\",\"Delete\",\"" + seqPrefix + "token_" + Integer.toString(k) + "\")' alt=\"" + Messages.getAttributeString(locale, "WikiConnector.Delete") + Integer.toString(k) + "\"/>\n      </a>&nbsp;\n    </td>\n    <td class=\"value\">\n      " + Encoder.bodyEscape((String)token) + "\n    </td>\n  </tr>\n");
                ++k;
            }
            if (k == 0) {
                out.print("  <tr>\n    <td class=\"message\" colspan=\"2\">" + Messages.getBodyString(locale, "WikiConnector.NoAccessTokensPresent") + "</td>\n  </tr>\n");
            }
            out.print("  <tr><td class=\"lightseparator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\">\n      <input type=\"hidden\" name=\"" + seqPrefix + "tokencount\" value=\"" + Integer.toString(k) + "\"/>\n      <input type=\"hidden\" name=\"" + seqPrefix + "accessop\" value=\"\"/>\n      <a name=\"" + seqPrefix + "token_" + Integer.toString(k) + "\">\n        <input type=\"button\" value=\"" + Messages.getAttributeString(locale, "WikiConnector.Add") + "\" onClick='Javascript:" + seqPrefix + "SpecAddToken(\"" + seqPrefix + "token_" + Integer.toString(k + 1) + "\")' alt=\"" + Messages.getAttributeString(locale, "WikiConnector.Add") + "\"/>\n      </a>&nbsp;\n    </td>\n    <td class=\"value\">\n      <input type=\"text\" size=\"30\" name=\"" + seqPrefix + "spectoken\" value=\"\"/>\n    </td>\n  </tr>\n</table>\n");
        } else {
            i = 0;
            k = 0;
            while (i < ds.getChildCount()) {
                if (!(sn = ds.getChild(i++)).getType().equals("access")) continue;
                accessDescription = "_" + Integer.toString(k);
                String token = sn.getAttributeValue("token");
                out.print("<input type=\"hidden\" name=\"" + seqPrefix + "spectoken" + accessDescription + "\" value=\"" + Encoder.attributeEscape((String)token) + "\"/>\n");
                ++k;
            }
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "tokencount\" value=\"" + Integer.toString(k) + "\"/>\n");
        }
    }

    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException {
        String xc;
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        String countString = variableContext.getParameter(seqPrefix + "nscount");
        if (countString != null) {
            for (int i = 0; i < ds.getChildCount(); ++i) {
                SpecificationNode sn = ds.getChild(i);
                if (sn.getType().equals("namespaceandprefix")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            int nsCount = Integer.parseInt(countString);
            for (int i = 0; i < nsCount; ++i) {
                String titlePrefix;
                String nsOpName = seqPrefix + "nsop_" + i;
                String nsNsName = seqPrefix + "nsnsname_" + i;
                String nsTitlePrefix = seqPrefix + "nstitleprefix_" + i;
                String nsOp = variableContext.getParameter(nsOpName);
                if (nsOp != null && nsOp.equals("Delete")) continue;
                String namespaceName = variableContext.getParameter(nsNsName);
                if (namespaceName != null && namespaceName.length() == 0) {
                    namespaceName = null;
                }
                if ((titlePrefix = variableContext.getParameter(nsTitlePrefix)) != null && titlePrefix.length() == 0) {
                    titlePrefix = null;
                }
                SpecificationNode sn = new SpecificationNode("namespaceandprefix");
                if (namespaceName != null) {
                    sn.setAttribute("namespace", namespaceName);
                }
                if (titlePrefix != null) {
                    sn.setAttribute("titleprefix", titlePrefix);
                }
                ds.addChild(ds.getChildCount(), (ConfigurationNode)sn);
            }
            String newOp = variableContext.getParameter(seqPrefix + "nsop");
            if (newOp != null && newOp.equals("Add")) {
                String titlePrefix;
                String namespaceName = variableContext.getParameter(seqPrefix + "nsnsname");
                if (namespaceName != null && namespaceName.length() == 0) {
                    namespaceName = null;
                }
                if ((titlePrefix = variableContext.getParameter(seqPrefix + "nstitleprefix")) != null && titlePrefix.length() == 0) {
                    titlePrefix = null;
                }
                SpecificationNode sn = new SpecificationNode("namespaceandprefix");
                if (namespaceName != null) {
                    sn.setAttribute("namespace", namespaceName);
                }
                if (titlePrefix != null) {
                    sn.setAttribute("titleprefix", titlePrefix);
                }
                ds.addChild(ds.getChildCount(), (ConfigurationNode)sn);
            }
        }
        if ((xc = variableContext.getParameter(seqPrefix + "tokencount")) != null) {
            int i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn = ds.getChild(i);
                if (sn.getType().equals("access")) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            int accessCount = Integer.parseInt(xc);
            i = 0;
            while (i < accessCount) {
                String accessDescription = "_" + Integer.toString(i);
                String accessOpName = seqPrefix + "accessop" + accessDescription;
                xc = variableContext.getParameter(accessOpName);
                if (xc != null && xc.equals("Delete")) {
                    ++i;
                    continue;
                }
                String accessSpec = variableContext.getParameter(seqPrefix + "spectoken" + accessDescription);
                SpecificationNode node = new SpecificationNode("access");
                node.setAttribute("token", accessSpec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
                ++i;
            }
            String op = variableContext.getParameter(seqPrefix + "accessop");
            if (op != null && op.equals("Add")) {
                String accessspec = variableContext.getParameter(seqPrefix + "spectoken");
                SpecificationNode node = new SpecificationNode("access");
                node.setAttribute("token", accessspec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
            }
        }
        return null;
    }

    public void viewSpecification(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        out.print("<table class=\"displaytable\">\n  <tr>\n");
        out.print("    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "WikiConnector.NamespaceAndTitles2") + "</nobr></td>\n    <td class=\"boxcell\">\n      <table class=\"formtable\">\n        <tr class=\"formheaderrow\">\n          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "WikiConnector.Namespace") + "</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "WikiConnector.TitlePrefix") + "</nobr></td>\n        </tr>\n");
        int k = 0;
        for (int i = 0; i < ds.getChildCount(); ++i) {
            SpecificationNode sn = ds.getChild(i);
            if (!sn.getType().equals("namespaceandprefix")) continue;
            String namespace = sn.getAttributeValue("namespace");
            String titlePrefix = sn.getAttributeValue("titleprefix");
            out.print("        <tr class=\"" + (k % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n          <td class=\"formcolumncell\">\n            <nobr>\n              " + (namespace == null ? "(default)" : Encoder.bodyEscape((String)namespace)) + "\n            </nobr>\n          </td>\n          <td class=\"formcolumncell\">\n            <nobr>\n              " + (titlePrefix == null ? "(all documents)" : Encoder.bodyEscape((String)titlePrefix)) + "\n            </nobr>\n          </td>\n        </tr>\n");
            ++k;
        }
        if (k == 0) {
            out.print("        <tr class=\"formrow\"><td class=\"formmessage\" colspan=\"2\">" + Messages.getBodyString(locale, "WikiConnector.AllDefaultNamespaceDocumentsIncluded") + "</td></tr>\n");
        }
        out.print("      </table>\n    </td>\n  </tr>\n");
        boolean seenAny = false;
        int i = 0;
        while (i < ds.getChildCount()) {
            SpecificationNode sn;
            if (!(sn = ds.getChild(i++)).getType().equals("access")) continue;
            if (!seenAny) {
                out.print("  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "WikiConnector.AccessTokens") + "</nobr></td>\n    <td class=\"value\">\n");
                seenAny = true;
            }
            String token = sn.getAttributeValue("token");
            out.print("      " + Encoder.bodyEscape((String)token) + "<br/>\n");
        }
        if (seenAny) {
            out.print("    </td>\n  </tr>\n");
        } else {
            out.print("  <tr><td class=\"message\" colspan=\"2\"><nobr>" + Messages.getBodyString(locale, "WikiConnector.NoAccessTokensSpecified") + "</nobr></td></tr>\n");
        }
        out.print("</table>\n");
    }

    protected HttpRequestBase getInitializedGetMethod(String URL2) throws IOException {
        HttpGet method = new HttpGet(URL2);
        if (this.userAgent != null) {
            method.setHeader((Header)new BasicHeader("User-Agent", this.userAgent));
        }
        method.setHeader((Header)new BasicHeader("Accept", "*/*"));
        return method;
    }

    protected HttpRequestBase getInitializedPostMethod(String URL2, Map<String, String> params) throws IOException {
        HttpPost method = new HttpPost(URL2);
        if (this.userAgent != null) {
            method.setHeader((Header)new BasicHeader("User-Agent", this.userAgent));
        }
        ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>();
        for (String key : params.keySet()) {
            pairs.add(new BasicNameValuePair(key, params.get(key)));
        }
        method.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, StandardCharsets.UTF_8));
        return method;
    }

    protected void performCheck() throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        boolean loginAttempted = false;
        while (true) {
            HttpClient client = this.httpClient;
            try {
                HttpRequestBase executeMethod = this.getInitializedGetMethod(this.getCheckURL());
                ExecuteCheckThread t = new ExecuteCheckThread(client, executeMethod);
                try {
                    t.start();
                    if (!t.finishUp() || loginAttempted) {
                        return;
                    }
                }
                catch (ManifoldCFException e) {
                    t.interrupt();
                    throw e;
                }
                catch (ServiceInterruption e) {
                    t.interrupt();
                    throw e;
                }
                catch (IOException e) {
                    t.interrupt();
                    throw e;
                }
                catch (HttpException e) {
                    t.interrupt();
                    throw e;
                }
                catch (InterruptedException e) {
                    t.interrupt();
                    throw e;
                }
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (ManifoldCFException e) {
                throw e;
            }
            catch (SocketTimeoutException e) {
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption("Fetch test timed out reading from the Wiki server: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 720000L, -1, false);
            }
            catch (SocketException e) {
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption("Fetch test received a socket error reading from Wiki server: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 720000L, -1, false);
            }
            catch (ConnectTimeoutException e) {
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption("Fetch test connection timed out reading from Wiki server: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 720000L, -1, false);
            }
            catch (InterruptedIOException e) {
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (IOException e) {
                throw new ManifoldCFException("Fetch test had an IO failure: " + e.getMessage(), (Throwable)e);
            }
            catch (HttpException e) {
                throw new ManifoldCFException("Fetch test had Http exception: " + e.getMessage(), (Throwable)e);
            }
            if (!this.loginToAPI()) break;
            loginAttempted = true;
        }
    }

    protected String getCheckURL() throws ManifoldCFException {
        return this.baseURL + "action=query&list=allpages&aplimit=1";
    }

    protected static boolean parseCheckResponse(InputStream is) throws ManifoldCFException, ServiceInterruption {
        XMLStream x = new XMLStream(false);
        WikiCheckAPIContext c = new WikiCheckAPIContext(x);
        x.setContext((XMLContext)c);
        try {
            x.parse(is);
            if (c.isLoginRequired()) {
                boolean bl = true;
                return bl;
            }
            if (!c.hasResponse()) {
                throw new ManifoldCFException("Valid API response not detected");
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            long time = System.currentTimeMillis();
            throw new ServiceInterruption(e.getMessage(), (Throwable)e, time + 300000L, time + 720000L, -1, false);
        }
        finally {
            x.cleanup();
        }
    }

    protected void listAllPages(ISeedingActivity activities, String namespace, String prefix, long startTime, long endTime) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        String lastTitle = null;
        while (true) {
            activities.checkJobStillActive();
            String newLastTitle = this.executeListPagesViaThread(lastTitle, namespace, prefix, activities);
            if (newLastTitle == null) break;
            lastTitle = newLastTitle;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String executeListPagesViaThread(String startPageTitle, String namespace, String prefix, ISeedingActivity activities) throws ManifoldCFException, ServiceInterruption {
        boolean loginAttempted = false;
        while (true) {
            block27: {
                try {
                    HttpRequestBase executeMethod = this.getInitializedGetMethod(this.getListPagesURL(startPageTitle, namespace, prefix));
                    XThreadStringBuffer pageBuffer = new XThreadStringBuffer();
                    ExecuteListPagesThread t = new ExecuteListPagesThread(this.httpClient, executeMethod, pageBuffer, startPageTitle);
                    try {
                        String pageID;
                        block26: {
                            t.start();
                            while (true) {
                                if ((pageID = pageBuffer.fetch()) == null) {
                                    if (t.finishUp()) {
                                        break;
                                    }
                                    break block26;
                                }
                                activities.addSeedDocument(pageID);
                            }
                            if (!loginAttempted) break block27;
                        }
                        pageID = t.getLastPageTitle();
                        return pageID;
                    }
                    catch (ManifoldCFException e) {
                        t.interrupt();
                        throw e;
                    }
                    catch (ServiceInterruption e) {
                        t.interrupt();
                        throw e;
                    }
                    catch (IOException e) {
                        t.interrupt();
                        throw e;
                    }
                    catch (HttpException e) {
                        t.interrupt();
                        throw e;
                    }
                    catch (InterruptedException e) {
                        t.interrupt();
                        throw e;
                    }
                    finally {
                        pageBuffer.abandon();
                    }
                }
                catch (InterruptedException e) {
                    throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                }
                catch (ManifoldCFException e) {
                    if (e.getErrorCode() == 2) {
                        throw e;
                    }
                }
                catch (SocketTimeoutException e) {
                    long currentTime = System.currentTimeMillis();
                    throw new ServiceInterruption("ListPages timed out reading from the Wiki server: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 720000L, -1, false);
                }
                catch (SocketException e) {
                    long currentTime = System.currentTimeMillis();
                    throw new ServiceInterruption("ListPages received a socket error reading from Wiki server: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 720000L, -1, false);
                }
                catch (ConnectTimeoutException e) {
                    long currentTime = System.currentTimeMillis();
                    throw new ServiceInterruption("ListPages connection timed out reading from Wiki server: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 720000L, -1, false);
                }
                catch (InterruptedIOException e) {
                    throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                }
                catch (IOException e) {
                    throw new ManifoldCFException("ListPages had an IO failure: " + e.getMessage(), (Throwable)e);
                }
                catch (HttpException e) {
                    throw new ManifoldCFException("ListPages had an HTTP exception: " + e.getMessage(), (Throwable)e);
                }
            }
            if (!this.loginToAPI()) {
                return null;
            }
            loginAttempted = true;
        }
    }

    protected String getListPagesURL(String startingTitle, String namespace, String prefix) throws ManifoldCFException {
        return this.baseURL + "action=query&list=allpages" + (prefix != null ? "&apprefix=" + URLEncoder.encode((String)prefix) : "") + (namespace != null ? "&apnamespace=" + URLEncoder.encode((String)namespace) : "") + (startingTitle != null ? "&apfrom=" + URLEncoder.encode((String)startingTitle) : "") + "&aplimit=500";
    }

    protected static boolean parseListPagesResponse(InputStream is, XThreadStringBuffer buffer, String startPageTitle, ReturnString lastTitle) throws ManifoldCFException, ServiceInterruption {
        XMLStream x = new XMLStream(false);
        WikiListPagesAPIContext c = new WikiListPagesAPIContext(x, buffer, startPageTitle);
        x.setContext((XMLContext)c);
        try {
            String lastTitleString;
            x.parse(is);
            lastTitle.returnValue = lastTitleString = c.getLastTitle();
            boolean bl = c.isLoginRequired();
            return bl;
        }
        catch (IOException e) {
            long time = System.currentTimeMillis();
            throw new ServiceInterruption(e.getMessage(), (Throwable)e, time + 300000L, time + 720000L, -1, false);
        }
        finally {
            x.cleanup();
        }
    }

    protected void getDocURLs(String[] documentIdentifiers, Map<String, String> urls) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        boolean loginAttempted = false;
        while (true) {
            try {
                HttpRequestBase executeMethod = this.getInitializedGetMethod(this.getGetDocURLsURL(documentIdentifiers));
                ExecuteGetDocURLsThread t = new ExecuteGetDocURLsThread(this.httpClient, executeMethod, urls);
                try {
                    t.start();
                    if (!t.finishUp() || loginAttempted) {
                        return;
                    }
                }
                catch (ManifoldCFException e) {
                    t.interrupt();
                    throw e;
                }
                catch (ServiceInterruption e) {
                    t.interrupt();
                    throw e;
                }
                catch (IOException e) {
                    t.interrupt();
                    throw e;
                }
                catch (HttpException e) {
                    t.interrupt();
                    throw e;
                }
                catch (InterruptedException e) {
                    t.interrupt();
                    throw e;
                }
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (ManifoldCFException e) {
                throw e;
            }
            catch (SocketTimeoutException e) {
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption("URL fetch timed out reading from the Wiki server: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 720000L, -1, false);
            }
            catch (SocketException e) {
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption("URL fetch received a socket error reading from Wiki server: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 720000L, -1, false);
            }
            catch (ConnectTimeoutException e) {
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption("URL fetch connection timed out reading from Wiki server: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 720000L, -1, false);
            }
            catch (InterruptedIOException e) {
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (IOException e) {
                throw new ManifoldCFException("URL fetch had an IO failure: " + e.getMessage(), (Throwable)e);
            }
            catch (HttpException e) {
                throw new ManifoldCFException("URL fetch had an HTTP exception: " + e.getMessage(), (Throwable)e);
            }
            if (!this.loginToAPI()) break;
            loginAttempted = true;
        }
    }

    protected String getGetDocURLsURL(String[] documentIdentifiers) throws ManifoldCFException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < documentIdentifiers.length; ++i) {
            if (i > 0) {
                sb.append("|");
            }
            sb.append(documentIdentifiers[i]);
        }
        return this.baseURL + "action=query&prop=info&pageids=" + URLEncoder.encode((String)sb.toString()) + "&inprop=url";
    }

    protected static boolean parseGetDocURLsResponse(InputStream is, Map<String, String> urls) throws ManifoldCFException, ServiceInterruption {
        XMLStream x = new XMLStream(false);
        WikiGetDocURLsAPIContext c = new WikiGetDocURLsAPIContext(x, urls);
        x.setContext((XMLContext)c);
        try {
            x.parse(is);
            boolean bl = c.isLoginRequired();
            return bl;
        }
        catch (IOException e) {
            long time = System.currentTimeMillis();
            throw new ServiceInterruption(e.getMessage(), (Throwable)e, time + 300000L, time + 720000L, -1, false);
        }
        finally {
            x.cleanup();
        }
    }

    protected void getTimestamps(String[] documentIdentifiers, Map<String, String> versions, IProcessActivity activities) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        boolean loginAttempted = false;
        while (true) {
            try {
                HttpRequestBase executeMethod = this.getInitializedGetMethod(this.getGetTimestampURL(documentIdentifiers));
                ExecuteGetTimestampThread t = new ExecuteGetTimestampThread(this.httpClient, executeMethod, versions);
                try {
                    t.start();
                    if (!t.finishUp() || loginAttempted) {
                        return;
                    }
                }
                catch (ManifoldCFException e) {
                    t.interrupt();
                    throw e;
                }
                catch (ServiceInterruption e) {
                    t.interrupt();
                    throw e;
                }
                catch (IOException e) {
                    t.interrupt();
                    throw e;
                }
                catch (HttpException e) {
                    t.interrupt();
                    throw e;
                }
                catch (InterruptedException e) {
                    t.interrupt();
                    throw e;
                }
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (ManifoldCFException e) {
                throw e;
            }
            catch (SocketTimeoutException e) {
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption("Version fetch timed out reading from the Wiki server: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 720000L, -1, false);
            }
            catch (SocketException e) {
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption("Version fetch received a socket error reading from Wiki server: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 720000L, -1, false);
            }
            catch (ConnectTimeoutException e) {
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption("Version fetch connection timed out reading from Wiki server: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 720000L, -1, false);
            }
            catch (InterruptedIOException e) {
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (IOException e) {
                throw new ManifoldCFException("Version fetch had an IO failure: " + e.getMessage(), (Throwable)e);
            }
            catch (HttpException e) {
                throw new ManifoldCFException("Version fetch had an HTTP exception: " + e.getMessage(), (Throwable)e);
            }
            if (!this.loginToAPI()) break;
            loginAttempted = true;
        }
    }

    protected String getGetTimestampURL(String[] documentIdentifiers) throws ManifoldCFException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < documentIdentifiers.length; ++i) {
            if (i > 0) {
                sb.append("|");
            }
            sb.append(documentIdentifiers[i]);
        }
        return this.baseURL + "action=query&prop=revisions&pageids=" + URLEncoder.encode((String)sb.toString()) + "&rvprop=timestamp";
    }

    protected static boolean parseGetTimestampResponse(InputStream is, Map<String, String> versions) throws ManifoldCFException, ServiceInterruption {
        XMLStream x = new XMLStream(false);
        WikiGetTimestampAPIContext c = new WikiGetTimestampAPIContext(x, versions);
        x.setContext((XMLContext)c);
        try {
            x.parse(is);
            boolean bl = c.isLoginRequired();
            return bl;
        }
        catch (IOException e) {
            long time = System.currentTimeMillis();
            throw new ServiceInterruption(e.getMessage(), (Throwable)e, time + 300000L, time + 720000L, -1, false);
        }
        finally {
            x.cleanup();
        }
    }

    protected void getNamespaces(Map<String, String> namespaces) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        boolean loginAttempted = false;
        while (true) {
            try {
                HttpRequestBase executeMethod = this.getInitializedGetMethod(this.getGetNamespacesURL());
                ExecuteGetNamespacesThread t = new ExecuteGetNamespacesThread(this.httpClient, executeMethod, namespaces);
                try {
                    t.start();
                    if (!t.finishUp() || loginAttempted) {
                        return;
                    }
                }
                catch (ManifoldCFException e) {
                    t.interrupt();
                    throw e;
                }
                catch (ServiceInterruption e) {
                    t.interrupt();
                    throw e;
                }
                catch (IOException e) {
                    t.interrupt();
                    throw e;
                }
                catch (HttpException e) {
                    t.interrupt();
                    throw e;
                }
                catch (InterruptedException e) {
                    t.interrupt();
                    throw e;
                }
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (ManifoldCFException e) {
                throw e;
            }
            catch (SocketTimeoutException e) {
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption("Get namespaces timed out reading from the Wiki server: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 720000L, -1, false);
            }
            catch (SocketException e) {
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption("Get namespaces received a socket error reading from Wiki server: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 720000L, -1, false);
            }
            catch (ConnectTimeoutException e) {
                long currentTime = System.currentTimeMillis();
                throw new ServiceInterruption("Get namespaces connection timed out reading from Wiki server: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 720000L, -1, false);
            }
            catch (InterruptedIOException e) {
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (IOException e) {
                throw new ManifoldCFException("Get namespaces had an IO failure: " + e.getMessage(), (Throwable)e);
            }
            catch (HttpException e) {
                throw new ManifoldCFException("Get namespaces had an HTTP exception: " + e.getMessage(), (Throwable)e);
            }
            if (!this.loginToAPI()) break;
            loginAttempted = true;
        }
    }

    protected String getGetNamespacesURL() throws ManifoldCFException {
        return this.baseURL + "action=query&meta=siteinfo&siprop=namespaces";
    }

    /*
     * Exception decompiling
     */
    protected void getDocInfo(String documentIdentifier, String documentVersion, String fullURL, IProcessActivity activities, String[] allowACL) throws ManifoldCFException, ServiceInterruption {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String getGetDocInfoURL(String documentIdentifier) throws ManifoldCFException {
        return this.baseURL + "action=query&prop=revisions&pageids=" + documentIdentifier + "&rvprop=user%7ccomment%7ccontent%7ctimestamp";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String readResponseAsString(HttpResponse httpResponse) throws IOException {
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            try (InputStream is = entity.getContent();){
                Charset charSet;
                try {
                    ContentType ct = ContentType.get((HttpEntity)entity);
                    charSet = ct == null ? StandardCharsets.UTF_8 : ct.getCharset();
                }
                catch (ParseException e) {
                    charSet = StandardCharsets.UTF_8;
                }
                char[] buffer = new char[65536];
                InputStreamReader r = new InputStreamReader(is, charSet);
                StringWriter w = new StringWriter();
                try {
                    int amt;
                    while ((amt = r.read(buffer)) != -1) {
                        ((Writer)w).write(buffer, 0, amt);
                    }
                }
                finally {
                    ((Writer)w).flush();
                }
                String string = ((Object)w).toString();
                return string;
            }
        }
        return "";
    }

    protected static void handleException(Throwable thr) throws InterruptedException, ManifoldCFException, ServiceInterruption, IOException, HttpException {
        if (thr != null) {
            if (thr instanceof ManifoldCFException) {
                if (((ManifoldCFException)thr).getErrorCode() == 2) {
                    throw new InterruptedException(thr.getMessage());
                }
                throw (ManifoldCFException)thr;
            }
            if (thr instanceof ServiceInterruption) {
                throw (ServiceInterruption)thr;
            }
            if (thr instanceof IOException) {
                throw (IOException)thr;
            }
            if (thr instanceof HttpException) {
                throw (HttpException)thr;
            }
            if (thr instanceof RuntimeException) {
                throw (RuntimeException)thr;
            }
            if (thr instanceof Error) {
                throw (Error)thr;
            }
            throw new RuntimeException("Unexpected exception class: " + thr.getClass().getName() + ": " + thr.getMessage(), thr);
        }
    }

    static {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            currentHost = addr.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    protected static class WikiGetDocInfoRevContext
    extends BaseProcessingContext {
        protected String author = null;
        protected String comment = null;
        protected File contentFile = null;
        protected String lastModified = null;

        public WikiGetDocInfoRevContext(XMLStream theStream, String namespaceURI, String localName, String qName, Attributes atts) {
            super(theStream, namespaceURI, localName, qName, atts);
        }

        @Override
        protected XMLContext beginTag(String namespaceURI, String localName, String qName, Attributes atts) throws ManifoldCFException, ServiceInterruption {
            if (qName.equals("rev")) {
                this.author = atts.getValue("user");
                this.comment = atts.getValue("comment");
                this.lastModified = atts.getValue("timestamp");
                try {
                    File tempFile = File.createTempFile("_wikidata_", "tmp");
                    return new XMLFileContext(this.theStream, namespaceURI, localName, qName, atts, tempFile);
                }
                catch (SocketTimeoutException e) {
                    throw new ManifoldCFException("IO exception creating temp file: " + e.getMessage(), (Throwable)e);
                }
                catch (InterruptedIOException e) {
                    throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                }
                catch (IOException e) {
                    throw new ManifoldCFException("IO exception creating temp file: " + e.getMessage(), (Throwable)e);
                }
            }
            return super.beginTag(namespaceURI, localName, qName, atts);
        }

        @Override
        protected void endTag() throws ManifoldCFException, ServiceInterruption {
            XMLContext theContext = this.theStream.getContext();
            String theTag = theContext.getQname();
            if (theTag.equals("rev")) {
                XMLFileContext rc = (XMLFileContext)theContext;
                this.tagCleanup();
                this.contentFile = rc.getCompletedFile();
            } else {
                super.endTag();
            }
        }

        protected void tagCleanup() throws ManifoldCFException {
            if (this.contentFile != null) {
                this.contentFile.delete();
                this.contentFile = null;
            }
        }

        public String getAuthor() {
            return this.author;
        }

        public String getLastModified() {
            return this.lastModified;
        }

        public String getComment() {
            return this.comment;
        }

        public File getContentFile() {
            File rval = this.contentFile;
            this.contentFile = null;
            return rval;
        }
    }

    protected static class WikiGetDocInfoRevisionsContext
    extends SingleLevelContext {
        protected File contentFile = null;
        protected String author = null;
        protected String comment = null;
        protected String lastModified = null;

        public WikiGetDocInfoRevisionsContext(XMLStream theStream, String namespaceURI, String localName, String qName, Attributes atts) {
            super(theStream, namespaceURI, localName, qName, atts, "revisions");
        }

        @Override
        protected BaseProcessingContext createChild(String namespaceURI, String localName, String qName, Attributes atts) {
            return new WikiGetDocInfoRevContext(this.theStream, namespaceURI, localName, qName, atts);
        }

        @Override
        protected void finishChild(BaseProcessingContext child) throws ManifoldCFException {
            WikiGetDocInfoRevContext rc = (WikiGetDocInfoRevContext)child;
            this.tagCleanup();
            this.contentFile = rc.getContentFile();
            this.author = rc.getAuthor();
            this.comment = rc.getComment();
            this.lastModified = rc.getLastModified();
        }

        protected void tagCleanup() throws ManifoldCFException {
            if (this.contentFile != null) {
                this.contentFile.delete();
                this.contentFile = null;
            }
        }

        public File getContentFile() {
            File rval = this.contentFile;
            this.contentFile = null;
            return rval;
        }

        public String getAuthor() {
            return this.author;
        }

        public String getComment() {
            return this.comment;
        }

        public String getLastModified() {
            return this.lastModified;
        }
    }

    protected static class WikiGetDocInfoPageContext
    extends BaseProcessingContext {
        protected String title = null;
        protected File contentFile = null;
        protected String author = null;
        protected String comment = null;
        protected String lastModified = null;

        public WikiGetDocInfoPageContext(XMLStream theStream, String namespaceURI, String localName, String qName, Attributes atts) {
            super(theStream, namespaceURI, localName, qName, atts);
        }

        @Override
        protected XMLContext beginTag(String namespaceURI, String localName, String qName, Attributes atts) throws ManifoldCFException, ServiceInterruption {
            if (qName.equals("page")) {
                this.title = atts.getValue("title");
                return new WikiGetDocInfoRevisionsContext(this.theStream, namespaceURI, localName, qName, atts);
            }
            return super.beginTag(namespaceURI, localName, qName, atts);
        }

        @Override
        protected void endTag() throws ManifoldCFException, ServiceInterruption {
            XMLContext theContext = this.theStream.getContext();
            String theTag = theContext.getQname();
            if (theTag.equals("page")) {
                WikiGetDocInfoRevisionsContext rc = (WikiGetDocInfoRevisionsContext)theContext;
                this.tagCleanup();
                this.contentFile = rc.getContentFile();
                this.author = rc.getAuthor();
                this.comment = rc.getComment();
                this.lastModified = rc.getLastModified();
            }
            super.endTag();
        }

        protected void tagCleanup() throws ManifoldCFException {
            if (this.contentFile != null) {
                this.contentFile.delete();
                this.contentFile = null;
            }
        }

        public String getTitle() {
            return this.title;
        }

        public File getContentFile() {
            File rval = this.contentFile;
            this.contentFile = null;
            return rval;
        }

        public String getAuthor() {
            return this.author;
        }

        public String getComment() {
            return this.comment;
        }

        public String getLastModified() {
            return this.lastModified;
        }
    }

    protected static class WikiGetDocInfoPagesContext
    extends SingleLevelContext {
        protected String title = null;
        protected File contentFile = null;
        protected String author = null;
        protected String comment = null;
        protected String lastModified = null;

        public WikiGetDocInfoPagesContext(XMLStream theStream, String namespaceURI, String localName, String qName, Attributes atts) {
            super(theStream, namespaceURI, localName, qName, atts, "pages");
        }

        @Override
        protected BaseProcessingContext createChild(String namespaceURI, String localName, String qName, Attributes atts) {
            return new WikiGetDocInfoPageContext(this.theStream, namespaceURI, localName, qName, atts);
        }

        @Override
        protected void finishChild(BaseProcessingContext child) throws ManifoldCFException {
            WikiGetDocInfoPageContext pc = (WikiGetDocInfoPageContext)child;
            this.tagCleanup();
            this.title = pc.getTitle();
            this.contentFile = pc.getContentFile();
            this.author = pc.getAuthor();
            this.lastModified = pc.getLastModified();
            this.comment = pc.getComment();
        }

        protected void tagCleanup() throws ManifoldCFException {
            if (this.contentFile != null) {
                this.contentFile.delete();
                this.contentFile = null;
            }
        }

        public String getTitle() {
            return this.title;
        }

        public File getContentFile() {
            File rval = this.contentFile;
            this.contentFile = null;
            return rval;
        }

        public String getAuthor() {
            return this.author;
        }

        public String getLastModified() {
            return this.lastModified;
        }

        public String getComment() {
            return this.comment;
        }
    }

    protected static class WikiGetDocInfoQueryContext
    extends SingleLevelErrorContext {
        protected String title = null;
        protected File contentFile = null;
        protected String author = null;
        protected String comment = null;
        protected String lastModified = null;

        public WikiGetDocInfoQueryContext(XMLStream theStream, String namespaceURI, String localName, String qName, Attributes atts) {
            super(theStream, namespaceURI, localName, qName, atts, "query");
        }

        @Override
        protected BaseProcessingContext createChild(String namespaceURI, String localName, String qName, Attributes atts) {
            return new WikiGetDocInfoPagesContext(this.theStream, namespaceURI, localName, qName, atts);
        }

        @Override
        protected void finishChild(BaseProcessingContext child) throws ManifoldCFException {
            WikiGetDocInfoPagesContext pc = (WikiGetDocInfoPagesContext)child;
            this.tagCleanup();
            this.title = pc.getTitle();
            this.contentFile = pc.getContentFile();
            this.author = pc.getAuthor();
            this.comment = pc.getComment();
            this.lastModified = pc.getLastModified();
        }

        protected void tagCleanup() throws ManifoldCFException {
            if (this.contentFile != null) {
                this.contentFile.delete();
                this.contentFile = null;
            }
        }

        public String getTitle() {
            return this.title;
        }

        public File getContentFile() {
            File rval = this.contentFile;
            this.contentFile = null;
            return rval;
        }

        public String getAuthor() {
            return this.author;
        }

        public String getLastModified() {
            return this.lastModified;
        }

        public String getComment() {
            return this.comment;
        }
    }

    protected static class WikiGetDocInfoAPIContext
    extends SingleLevelContext {
        protected String title = null;
        protected File contentFile = null;
        protected String author = null;
        protected String comment = null;
        protected String lastModified = null;
        protected boolean loginNeeded = false;

        public WikiGetDocInfoAPIContext(XMLStream theStream) {
            super(theStream, "api");
        }

        @Override
        protected BaseProcessingContext createChild(String namespaceURI, String localName, String qName, Attributes atts) {
            return new WikiGetDocInfoQueryContext(this.theStream, namespaceURI, localName, qName, atts);
        }

        @Override
        protected void finishChild(BaseProcessingContext child) throws ManifoldCFException {
            WikiGetDocInfoQueryContext pc = (WikiGetDocInfoQueryContext)child;
            this.tagCleanup();
            this.title = pc.getTitle();
            this.contentFile = pc.getContentFile();
            this.author = pc.getAuthor();
            this.comment = pc.getComment();
            this.lastModified = pc.getLastModified();
            this.loginNeeded |= pc.isLoginRequired();
        }

        protected void tagCleanup() throws ManifoldCFException {
            if (this.contentFile != null) {
                this.contentFile.delete();
                this.contentFile = null;
            }
        }

        public String getTitle() {
            return this.title;
        }

        public File getContentFile() {
            File rval = this.contentFile;
            this.contentFile = null;
            return rval;
        }

        public String getAuthor() {
            return this.author;
        }

        public String getLastModified() {
            return this.lastModified;
        }

        public String getComment() {
            return this.comment;
        }

        public boolean isLoginRequired() {
            return this.loginNeeded;
        }
    }

    protected static class ExecuteGetDocInfoThread
    extends Thread {
        protected HttpClient client;
        protected HttpRequestBase executeMethod;
        protected Throwable exception = null;
        protected String documentIdentifier;
        protected File contentFile = null;
        protected String author = null;
        protected String title = null;
        protected String comment = null;
        protected String lastModified = null;
        protected String statusCode = null;
        protected String errorMessage = null;
        protected boolean loginNeeded = false;

        public ExecuteGetDocInfoThread(HttpClient client, HttpRequestBase executeMethod, String documentIdentifier) {
            this.setDaemon(true);
            this.client = client;
            this.executeMethod = executeMethod;
            this.documentIdentifier = documentIdentifier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                HttpResponse rval = this.client.execute((HttpUriRequest)this.executeMethod);
                if (rval.getStatusLine().getStatusCode() != 200) {
                    throw new ManifoldCFException("Unexpected HTTP response code " + rval.getStatusLine().getStatusCode() + ": " + WikiConnector.readResponseAsString(rval));
                }
                InputStream is = rval.getEntity().getContent();
                try {
                    XMLStream x = new XMLStream(false);
                    WikiGetDocInfoAPIContext c = new WikiGetDocInfoAPIContext(x);
                    x.setContext((XMLContext)c);
                    try {
                        try {
                            x.parse(is);
                            this.contentFile = c.getContentFile();
                            this.title = c.getTitle();
                            this.author = c.getAuthor();
                            this.comment = c.getComment();
                            this.lastModified = c.getLastModified();
                            this.statusCode = "OK";
                            this.loginNeeded = c.isLoginRequired();
                        }
                        catch (InterruptedIOException e) {
                            throw e;
                        }
                        catch (IOException e) {
                            long time = System.currentTimeMillis();
                            throw new ServiceInterruption(e.getMessage(), (Throwable)e, time + 300000L, time + 720000L, -1, false);
                        }
                    }
                    finally {
                        x.cleanup();
                    }
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
            }
            catch (Throwable e) {
                this.statusCode = e.getClass().getSimpleName().toUpperCase(Locale.ROOT);
                this.errorMessage = e.getMessage();
                this.exception = e;
            }
            finally {
                this.executeMethod.abort();
            }
        }

        public boolean finishUp() throws InterruptedException, ManifoldCFException, ServiceInterruption, IOException, HttpException {
            this.join();
            WikiConnector.handleException(this.exception);
            return this.loginNeeded;
        }

        public String getStatusCode() {
            return this.statusCode;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public File getContentFile() {
            File rval = this.contentFile;
            this.contentFile = null;
            return rval;
        }

        public String getAuthor() {
            return this.author;
        }

        public String getComment() {
            return this.comment;
        }

        public String getTitle() {
            return this.title;
        }

        public String getLastModified() {
            return this.lastModified;
        }

        public void cleanup() {
            if (this.contentFile != null) {
                this.contentFile.delete();
                this.contentFile = null;
            }
        }
    }

    protected static class WikiGetNamespacesNsContext
    extends BaseProcessingContext {
        protected Map<String, String> namespaces;
        protected String canonical = null;
        protected String nsid = null;

        public WikiGetNamespacesNsContext(XMLStream theStream, String namespaceURI, String localName, String qName, Attributes atts, Map<String, String> namespaces) {
            super(theStream, namespaceURI, localName, qName, atts);
            this.namespaces = namespaces;
        }

        @Override
        protected XMLContext beginTag(String namespaceURI, String localName, String qName, Attributes atts) throws ManifoldCFException, ServiceInterruption {
            if (qName.equals("ns")) {
                this.nsid = atts.getValue("id");
                this.canonical = atts.getValue("canonical");
                if (this.canonical != null && this.nsid != null) {
                    return new XMLStringContext(this.theStream, namespaceURI, localName, qName, atts);
                }
            }
            return super.beginTag(namespaceURI, localName, qName, atts);
        }

        @Override
        protected void endTag() throws ManifoldCFException, ServiceInterruption {
            XMLContext theContext = this.theStream.getContext();
            String theTag = theContext.getQname();
            if (theTag.equals("ns")) {
                if (this.canonical != null && this.nsid != null) {
                    XMLStringContext sc = (XMLStringContext)theContext;
                    this.namespaces.put(sc.getValue(), this.nsid);
                } else {
                    super.endTag();
                }
            } else {
                super.endTag();
            }
        }

        protected void tagCleanup() throws ManifoldCFException {
        }
    }

    protected static class WikiGetNamespacesNamespacesContext
    extends SingleLevelContext {
        protected Map<String, String> namespaces;

        public WikiGetNamespacesNamespacesContext(XMLStream theStream, String namespaceURI, String localName, String qName, Attributes atts, Map<String, String> namespaces) {
            super(theStream, namespaceURI, localName, qName, atts, "namespaces");
            this.namespaces = namespaces;
        }

        @Override
        protected BaseProcessingContext createChild(String namespaceURI, String localName, String qName, Attributes atts) {
            return new WikiGetNamespacesNsContext(this.theStream, namespaceURI, localName, qName, atts, this.namespaces);
        }

        @Override
        protected void finishChild(BaseProcessingContext child) throws ManifoldCFException {
        }
    }

    protected static class WikiGetNamespacesQueryContext
    extends SingleLevelErrorContext {
        protected Map<String, String> namespaces;

        public WikiGetNamespacesQueryContext(XMLStream theStream, String namespaceURI, String localName, String qName, Attributes atts, Map<String, String> namespaces) {
            super(theStream, namespaceURI, localName, qName, atts, "query");
            this.namespaces = namespaces;
        }

        @Override
        protected BaseProcessingContext createChild(String namespaceURI, String localName, String qName, Attributes atts) {
            return new WikiGetNamespacesNamespacesContext(this.theStream, namespaceURI, localName, qName, atts, this.namespaces);
        }

        @Override
        protected void finishChild(BaseProcessingContext child) throws ManifoldCFException {
        }
    }

    protected static class WikiGetNamespacesAPIContext
    extends SingleLevelContext {
        protected Map<String, String> namespaces;
        protected boolean loginNeeded = false;

        public WikiGetNamespacesAPIContext(XMLStream theStream, Map<String, String> namespaces) {
            super(theStream, "api");
            this.namespaces = namespaces;
        }

        @Override
        protected BaseProcessingContext createChild(String namespaceURI, String localName, String qName, Attributes atts) {
            return new WikiGetNamespacesQueryContext(this.theStream, namespaceURI, localName, qName, atts, this.namespaces);
        }

        @Override
        protected void finishChild(BaseProcessingContext child) throws ManifoldCFException {
            this.loginNeeded |= ((WikiGetNamespacesQueryContext)child).isLoginRequired();
        }

        public boolean isLoginRequired() {
            return this.loginNeeded;
        }
    }

    protected static class ExecuteGetNamespacesThread
    extends Thread {
        protected HttpClient client;
        protected HttpRequestBase executeMethod;
        protected Throwable exception = null;
        protected Map<String, String> namespaces;
        protected boolean loginNeeded = false;

        public ExecuteGetNamespacesThread(HttpClient client, HttpRequestBase executeMethod, Map<String, String> namespaces) {
            this.setDaemon(true);
            this.client = client;
            this.executeMethod = executeMethod;
            this.namespaces = namespaces;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                HttpResponse rval = this.client.execute((HttpUriRequest)this.executeMethod);
                if (rval.getStatusLine().getStatusCode() != 200) {
                    throw new ManifoldCFException("Unexpected HTTP response code " + rval.getStatusLine().getStatusCode() + ": " + WikiConnector.readResponseAsString(rval));
                }
                InputStream is = rval.getEntity().getContent();
                try {
                    XMLStream x = new XMLStream(false);
                    WikiGetNamespacesAPIContext c = new WikiGetNamespacesAPIContext(x, this.namespaces);
                    x.setContext((XMLContext)c);
                    try {
                        try {
                            x.parse(is);
                            this.loginNeeded = c.isLoginRequired();
                        }
                        catch (IOException e) {
                            long time = System.currentTimeMillis();
                            throw new ServiceInterruption(e.getMessage(), (Throwable)e, time + 300000L, time + 720000L, -1, false);
                        }
                    }
                    finally {
                        x.cleanup();
                    }
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
            }
            catch (Throwable e) {
                this.exception = e;
            }
            finally {
                this.executeMethod.abort();
            }
        }

        public boolean finishUp() throws InterruptedException, ManifoldCFException, ServiceInterruption, IOException, HttpException {
            this.join();
            WikiConnector.handleException(this.exception);
            return this.loginNeeded;
        }
    }

    protected static class WikiGetTimestampRevContext
    extends BaseProcessingContext {
        protected String timestamp = null;

        public WikiGetTimestampRevContext(XMLStream theStream, String namespaceURI, String localName, String qName, Attributes atts) {
            super(theStream, namespaceURI, localName, qName, atts);
        }

        @Override
        protected XMLContext beginTag(String namespaceURI, String localName, String qName, Attributes atts) throws ManifoldCFException, ServiceInterruption {
            if (qName.equals("rev")) {
                this.timestamp = atts.getValue("timestamp");
            }
            return super.beginTag(namespaceURI, localName, qName, atts);
        }

        public String getTimestamp() {
            return this.timestamp;
        }
    }

    protected static class WikiGetTimestampRevisionsContext
    extends SingleLevelContext {
        protected String timestamp = null;

        public WikiGetTimestampRevisionsContext(XMLStream theStream, String namespaceURI, String localName, String qName, Attributes atts) {
            super(theStream, namespaceURI, localName, qName, atts, "revisions");
        }

        @Override
        protected BaseProcessingContext createChild(String namespaceURI, String localName, String qName, Attributes atts) {
            return new WikiGetTimestampRevContext(this.theStream, namespaceURI, localName, qName, atts);
        }

        @Override
        protected void finishChild(BaseProcessingContext child) throws ManifoldCFException {
            WikiGetTimestampRevContext rc = (WikiGetTimestampRevContext)child;
            if (this.timestamp == null) {
                this.timestamp = rc.getTimestamp();
            }
        }

        public String getTimestamp() {
            return this.timestamp;
        }
    }

    protected static class WikiGetTimestampPageContext
    extends BaseProcessingContext {
        protected String pageID = null;
        protected Map<String, String> versions;

        public WikiGetTimestampPageContext(XMLStream theStream, String namespaceURI, String localName, String qName, Attributes atts, Map<String, String> versions) {
            super(theStream, namespaceURI, localName, qName, atts);
            this.versions = versions;
        }

        @Override
        protected XMLContext beginTag(String namespaceURI, String localName, String qName, Attributes atts) throws ManifoldCFException, ServiceInterruption {
            if (qName.equals("page")) {
                this.pageID = atts.getValue("pageid");
                return new WikiGetTimestampRevisionsContext(this.theStream, namespaceURI, localName, qName, atts);
            }
            return super.beginTag(namespaceURI, localName, qName, atts);
        }

        @Override
        protected void endTag() throws ManifoldCFException, ServiceInterruption {
            XMLContext theContext = this.theStream.getContext();
            String theTag = theContext.getQname();
            if (theTag.equals("page")) {
                String lastRevEdit = ((WikiGetTimestampRevisionsContext)theContext).getTimestamp();
                this.versions.put(this.pageID, lastRevEdit);
            } else {
                super.endTag();
            }
        }
    }

    protected static class WikiGetTimestampPagesContext
    extends SingleLevelContext {
        protected Map<String, String> versions;

        public WikiGetTimestampPagesContext(XMLStream theStream, String namespaceURI, String localName, String qName, Attributes atts, Map<String, String> versions) {
            super(theStream, namespaceURI, localName, qName, atts, "pages");
            this.versions = versions;
        }

        @Override
        protected BaseProcessingContext createChild(String namespaceURI, String localName, String qName, Attributes atts) {
            return new WikiGetTimestampPageContext(this.theStream, namespaceURI, localName, qName, atts, this.versions);
        }

        @Override
        protected void finishChild(BaseProcessingContext child) throws ManifoldCFException {
        }
    }

    protected static class WikiGetTimestampQueryContext
    extends SingleLevelErrorContext {
        protected Map<String, String> versions;

        public WikiGetTimestampQueryContext(XMLStream theStream, String namespaceURI, String localName, String qName, Attributes atts, Map<String, String> versions) {
            super(theStream, namespaceURI, localName, qName, atts, "query");
            this.versions = versions;
        }

        @Override
        protected BaseProcessingContext createChild(String namespaceURI, String localName, String qName, Attributes atts) {
            return new WikiGetTimestampPagesContext(this.theStream, namespaceURI, localName, qName, atts, this.versions);
        }

        @Override
        protected void finishChild(BaseProcessingContext child) throws ManifoldCFException {
        }
    }

    protected static class WikiGetTimestampAPIContext
    extends SingleLevelContext {
        protected Map<String, String> versions;
        protected boolean loginNeeded = false;

        public WikiGetTimestampAPIContext(XMLStream theStream, Map<String, String> versions) {
            super(theStream, "api");
            this.versions = versions;
        }

        @Override
        protected BaseProcessingContext createChild(String namespaceURI, String localName, String qName, Attributes atts) {
            return new WikiGetTimestampQueryContext(this.theStream, namespaceURI, localName, qName, atts, this.versions);
        }

        @Override
        protected void finishChild(BaseProcessingContext child) throws ManifoldCFException {
            this.loginNeeded |= ((WikiGetTimestampQueryContext)child).isLoginRequired();
        }

        public boolean isLoginRequired() {
            return this.loginNeeded;
        }
    }

    protected static class ExecuteGetTimestampThread
    extends Thread {
        protected final HttpClient client;
        protected final HttpRequestBase executeMethod;
        protected Throwable exception = null;
        protected final Map<String, String> versions;
        protected boolean loginNeeded = false;

        public ExecuteGetTimestampThread(HttpClient client, HttpRequestBase executeMethod, Map<String, String> versions) {
            this.setDaemon(true);
            this.client = client;
            this.executeMethod = executeMethod;
            this.versions = versions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                HttpResponse rval = this.client.execute((HttpUriRequest)this.executeMethod);
                if (rval.getStatusLine().getStatusCode() != 200) {
                    throw new ManifoldCFException("Unexpected HTTP response code: " + rval.getStatusLine().getStatusCode() + ": " + WikiConnector.readResponseAsString(rval));
                }
                InputStream is = rval.getEntity().getContent();
                try {
                    this.loginNeeded = WikiConnector.parseGetTimestampResponse(is, this.versions);
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
            }
            catch (Throwable e) {
                this.exception = e;
            }
            finally {
                this.executeMethod.abort();
            }
        }

        public boolean finishUp() throws InterruptedException, ManifoldCFException, ServiceInterruption, IOException, HttpException {
            this.join();
            WikiConnector.handleException(this.exception);
            return this.loginNeeded;
        }
    }

    protected static class WikiGetDocURLsPageContext
    extends BaseProcessingContext {
        protected Map<String, String> urls;

        public WikiGetDocURLsPageContext(XMLStream theStream, String namespaceURI, String localName, String qName, Attributes atts, Map<String, String> urls) {
            super(theStream, namespaceURI, localName, qName, atts);
            this.urls = urls;
        }

        @Override
        protected XMLContext beginTag(String namespaceURI, String localName, String qName, Attributes atts) throws ManifoldCFException, ServiceInterruption {
            if (qName.equals("page")) {
                String pageID = atts.getValue("pageid");
                String fullURL = atts.getValue("fullurl");
                if (pageID != null && fullURL != null) {
                    this.urls.put(pageID, fullURL);
                }
            }
            return super.beginTag(namespaceURI, localName, qName, atts);
        }
    }

    protected static class WikiGetDocURLsPagesContext
    extends SingleLevelContext {
        protected Map<String, String> urls;

        public WikiGetDocURLsPagesContext(XMLStream theStream, String namespaceURI, String localName, String qName, Attributes atts, Map<String, String> urls) {
            super(theStream, namespaceURI, localName, qName, atts, "pages");
            this.urls = urls;
        }

        @Override
        protected BaseProcessingContext createChild(String namespaceURI, String localName, String qName, Attributes atts) {
            return new WikiGetDocURLsPageContext(this.theStream, namespaceURI, localName, qName, atts, this.urls);
        }

        @Override
        protected void finishChild(BaseProcessingContext child) throws ManifoldCFException {
        }
    }

    protected static class WikiGetDocURLsQueryContext
    extends SingleLevelErrorContext {
        protected Map<String, String> urls;

        public WikiGetDocURLsQueryContext(XMLStream theStream, String namespaceURI, String localName, String qName, Attributes atts, Map<String, String> urls) {
            super(theStream, namespaceURI, localName, qName, atts, "query");
            this.urls = urls;
        }

        @Override
        protected BaseProcessingContext createChild(String namespaceURI, String localName, String qName, Attributes atts) {
            return new WikiGetDocURLsPagesContext(this.theStream, namespaceURI, localName, qName, atts, this.urls);
        }

        @Override
        protected void finishChild(BaseProcessingContext child) throws ManifoldCFException {
        }
    }

    protected static class WikiGetDocURLsAPIContext
    extends SingleLevelContext {
        protected Map<String, String> urls;
        protected boolean loginNeeded = false;

        public WikiGetDocURLsAPIContext(XMLStream theStream, Map<String, String> urls) {
            super(theStream, "api");
            this.urls = urls;
        }

        @Override
        protected BaseProcessingContext createChild(String namespaceURI, String localName, String qName, Attributes atts) {
            return new WikiGetDocURLsQueryContext(this.theStream, namespaceURI, localName, qName, atts, this.urls);
        }

        @Override
        protected void finishChild(BaseProcessingContext child) throws ManifoldCFException {
            this.loginNeeded |= ((WikiGetDocURLsQueryContext)child).isLoginRequired();
        }

        public boolean isLoginRequired() {
            return this.loginNeeded;
        }
    }

    protected static class ExecuteGetDocURLsThread
    extends Thread {
        protected HttpClient client;
        protected HttpRequestBase executeMethod;
        protected Throwable exception = null;
        protected Map<String, String> urls;
        protected boolean loginNeeded = false;

        public ExecuteGetDocURLsThread(HttpClient client, HttpRequestBase executeMethod, Map<String, String> urls) {
            this.setDaemon(true);
            this.client = client;
            this.executeMethod = executeMethod;
            this.urls = urls;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                HttpResponse rval = this.client.execute((HttpUriRequest)this.executeMethod);
                if (rval.getStatusLine().getStatusCode() != 200) {
                    throw new ManifoldCFException("Unexpected HTTP response code: " + rval.getStatusLine().getStatusCode() + ": " + WikiConnector.readResponseAsString(rval));
                }
                InputStream is = rval.getEntity().getContent();
                try {
                    this.loginNeeded = WikiConnector.parseGetDocURLsResponse(is, this.urls);
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
            }
            catch (Throwable e) {
                this.exception = e;
            }
            finally {
                this.executeMethod.abort();
            }
        }

        public boolean finishUp() throws InterruptedException, ManifoldCFException, ServiceInterruption, IOException, HttpException {
            this.join();
            WikiConnector.handleException(this.exception);
            return this.loginNeeded;
        }
    }

    protected static class WikiListPagesPContext
    extends BaseProcessingContext {
        protected String lastTitle = null;
        protected XThreadStringBuffer buffer;
        protected String startPageTitle;

        public WikiListPagesPContext(XMLStream theStream, String namespaceURI, String localName, String qName, Attributes atts, XThreadStringBuffer buffer, String startPageTitle) {
            super(theStream, namespaceURI, localName, qName, atts);
            this.buffer = buffer;
            this.startPageTitle = startPageTitle;
        }

        @Override
        protected XMLContext beginTag(String namespaceURI, String localName, String qName, Attributes atts) throws ManifoldCFException, ServiceInterruption {
            if (qName.equals("p")) {
                String currentTitle = atts.getValue("title");
                if (this.startPageTitle == null || !currentTitle.equals(this.startPageTitle)) {
                    this.lastTitle = currentTitle;
                    String pageID = atts.getValue("pageid");
                    try {
                        this.buffer.add(pageID);
                    }
                    catch (InterruptedException e) {
                        throw new ManifoldCFException(e.getMessage(), (Throwable)e, 2);
                    }
                }
            }
            return super.beginTag(namespaceURI, localName, qName, atts);
        }

        public String getLastTitle() {
            return this.lastTitle;
        }
    }

    protected static class WikiListPagesAllPagesContext
    extends SingleLevelContext {
        protected String lastTitle = null;
        protected XThreadStringBuffer buffer;
        protected String startPageTitle;

        public WikiListPagesAllPagesContext(XMLStream theStream, String namespaceURI, String localName, String qName, Attributes atts, XThreadStringBuffer buffer, String startPageTitle) {
            super(theStream, namespaceURI, localName, qName, atts, "allpages");
            this.buffer = buffer;
            this.startPageTitle = startPageTitle;
        }

        @Override
        protected BaseProcessingContext createChild(String namespaceURI, String localName, String qName, Attributes atts) {
            return new WikiListPagesPContext(this.theStream, namespaceURI, localName, qName, atts, this.buffer, this.startPageTitle);
        }

        @Override
        protected void finishChild(BaseProcessingContext child) throws ManifoldCFException {
            this.lastTitle = ((WikiListPagesPContext)child).getLastTitle();
        }

        public String getLastTitle() {
            return this.lastTitle;
        }
    }

    protected static class WikiListPagesQueryContext
    extends SingleLevelErrorContext {
        protected String lastTitle = null;
        protected XThreadStringBuffer buffer;
        protected String startPageTitle;

        public WikiListPagesQueryContext(XMLStream theStream, String namespaceURI, String localName, String qName, Attributes atts, XThreadStringBuffer buffer, String startPageTitle) {
            super(theStream, namespaceURI, localName, qName, atts, "query");
            this.buffer = buffer;
            this.startPageTitle = startPageTitle;
        }

        @Override
        protected BaseProcessingContext createChild(String namespaceURI, String localName, String qName, Attributes atts) {
            return new WikiListPagesAllPagesContext(this.theStream, namespaceURI, localName, qName, atts, this.buffer, this.startPageTitle);
        }

        @Override
        protected void finishChild(BaseProcessingContext child) throws ManifoldCFException {
            this.lastTitle = ((WikiListPagesAllPagesContext)child).getLastTitle();
        }

        public String getLastTitle() {
            return this.lastTitle;
        }
    }

    protected static class WikiListPagesAPIContext
    extends SingleLevelContext {
        protected String lastTitle = null;
        protected XThreadStringBuffer buffer;
        protected String startPageTitle;
        protected boolean loginNeeded = false;

        public WikiListPagesAPIContext(XMLStream theStream, XThreadStringBuffer buffer, String startPageTitle) {
            super(theStream, "api");
            this.buffer = buffer;
            this.startPageTitle = startPageTitle;
        }

        @Override
        protected BaseProcessingContext createChild(String namespaceURI, String localName, String qName, Attributes atts) {
            return new WikiListPagesQueryContext(this.theStream, namespaceURI, localName, qName, atts, this.buffer, this.startPageTitle);
        }

        @Override
        protected void finishChild(BaseProcessingContext child) throws ManifoldCFException {
            this.lastTitle = ((WikiListPagesQueryContext)child).getLastTitle();
            this.loginNeeded |= ((WikiListPagesQueryContext)child).isLoginRequired();
        }

        public String getLastTitle() {
            return this.lastTitle;
        }

        public boolean isLoginRequired() {
            return this.loginNeeded;
        }
    }

    protected static class ExecuteListPagesThread
    extends Thread {
        protected HttpClient client;
        protected HttpRequestBase executeMethod;
        protected Throwable exception = null;
        protected XThreadStringBuffer pageBuffer;
        protected String lastPageTitle = null;
        protected String startPageTitle;
        protected boolean loginNeeded = false;

        public ExecuteListPagesThread(HttpClient client, HttpRequestBase executeMethod, XThreadStringBuffer pageBuffer, String startPageTitle) {
            this.setDaemon(true);
            this.client = client;
            this.executeMethod = executeMethod;
            this.pageBuffer = pageBuffer;
            this.startPageTitle = startPageTitle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                HttpResponse rval = this.client.execute((HttpUriRequest)this.executeMethod);
                if (rval.getStatusLine().getStatusCode() != 200) {
                    throw new ManifoldCFException("Unexpected HTTP response code: " + rval.getStatusLine().getStatusCode() + ": " + WikiConnector.readResponseAsString(rval));
                }
                InputStream is = rval.getEntity().getContent();
                try {
                    ReturnString returnString = new ReturnString();
                    this.loginNeeded = WikiConnector.parseListPagesResponse(is, this.pageBuffer, this.startPageTitle, returnString);
                    this.lastPageTitle = returnString.returnValue;
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
            }
            catch (Throwable e) {
                this.exception = e;
            }
            finally {
                this.pageBuffer.signalDone();
                this.executeMethod.abort();
            }
        }

        public boolean finishUp() throws InterruptedException, ManifoldCFException, ServiceInterruption, IOException, HttpException {
            this.join();
            WikiConnector.handleException(this.exception);
            return this.loginNeeded;
        }

        public String getLastPageTitle() {
            return this.lastPageTitle;
        }
    }

    protected static class ReturnString {
        public String returnValue = null;

        protected ReturnString() {
        }
    }

    protected static class WikiCheckPContext
    extends BaseProcessingContext {
        public WikiCheckPContext(XMLStream theStream, String namespaceURI, String localName, String qName, Attributes atts) {
            super(theStream, namespaceURI, localName, qName, atts);
        }
    }

    protected static class WikiCheckAllPagesContext
    extends SingleLevelContext {
        protected boolean responseSeen = false;

        public WikiCheckAllPagesContext(XMLStream theStream, String namespaceURI, String localName, String qName, Attributes atts) {
            super(theStream, namespaceURI, localName, qName, atts, "allpages");
        }

        @Override
        protected BaseProcessingContext createChild(String namespaceURI, String localName, String qName, Attributes atts) {
            return new WikiCheckPContext(this.theStream, namespaceURI, localName, qName, atts);
        }

        @Override
        protected void finishChild(BaseProcessingContext child) throws ManifoldCFException {
            this.responseSeen |= true;
        }

        public boolean hasResponse() {
            return this.responseSeen;
        }
    }

    protected static class WikiCheckQueryContext
    extends SingleLevelErrorContext {
        protected boolean responseSeen = false;

        public WikiCheckQueryContext(XMLStream theStream, String namespaceURI, String localName, String qName, Attributes atts) {
            super(theStream, namespaceURI, localName, qName, atts, "query");
        }

        @Override
        protected BaseProcessingContext createChild(String namespaceURI, String localName, String qName, Attributes atts) {
            return new WikiCheckAllPagesContext(this.theStream, namespaceURI, localName, qName, atts);
        }

        @Override
        protected void finishChild(BaseProcessingContext child) throws ManifoldCFException {
            this.responseSeen |= ((WikiCheckAllPagesContext)child).hasResponse();
        }

        public boolean hasResponse() {
            return this.responseSeen;
        }
    }

    protected static class WikiCheckAPIContext
    extends SingleLevelContext {
        boolean responseSeen = false;
        boolean needLogin = false;

        public WikiCheckAPIContext(XMLStream theStream) {
            super(theStream, "api");
        }

        @Override
        protected BaseProcessingContext createChild(String namespaceURI, String localName, String qName, Attributes atts) {
            return new WikiCheckQueryContext(this.theStream, namespaceURI, localName, qName, atts);
        }

        @Override
        protected void finishChild(BaseProcessingContext child) throws ManifoldCFException {
            this.responseSeen |= ((WikiCheckQueryContext)child).hasResponse();
            this.needLogin |= ((WikiCheckQueryContext)child).isLoginRequired();
        }

        public boolean hasResponse() {
            return this.responseSeen;
        }

        public boolean isLoginRequired() {
            return this.needLogin;
        }
    }

    protected static class ExecuteCheckThread
    extends Thread {
        protected final HttpClient client;
        protected final HttpRequestBase executeMethod;
        protected Throwable exception = null;
        protected boolean loginNeeded = false;

        public ExecuteCheckThread(HttpClient client, HttpRequestBase executeMethod) {
            this.setDaemon(true);
            this.client = client;
            this.executeMethod = executeMethod;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                HttpResponse rval = this.client.execute((HttpUriRequest)this.executeMethod);
                if (rval.getStatusLine().getStatusCode() != 200) {
                    throw new ManifoldCFException("Unexpected HTTP response code: " + rval.getStatusLine().getStatusCode() + ": " + WikiConnector.readResponseAsString(rval));
                }
                InputStream is = rval.getEntity().getContent();
                try {
                    this.loginNeeded = WikiConnector.parseCheckResponse(is);
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
            }
            catch (Throwable e) {
                this.exception = e;
            }
            finally {
                this.executeMethod.abort();
            }
        }

        public boolean finishUp() throws InterruptedException, ManifoldCFException, ServiceInterruption, IOException, HttpException {
            this.join();
            WikiConnector.handleException(this.exception);
            return this.loginNeeded;
        }
    }

    protected class WikiTokenLoginAPIResultAPIContext
    extends BaseProcessingContext {
        protected APILoginResult result;

        public WikiTokenLoginAPIResultAPIContext(XMLStream theStream, String namespaceURI, String localName, String qName, Attributes atts, APILoginResult result) {
            super(theStream, namespaceURI, localName, qName, atts);
            this.result = result;
        }

        @Override
        protected XMLContext beginTag(String namespaceURI, String localName, String qName, Attributes atts) throws ManifoldCFException, ServiceInterruption {
            if (qName.equals("login")) {
                String loginResult = atts.getValue("result");
                if ("Success".equals(loginResult)) {
                    this.result.result = true;
                } else {
                    this.result.reason = loginResult;
                }
            }
            return super.beginTag(namespaceURI, localName, qName, atts);
        }
    }

    protected class WikiTokenLoginAPIContext
    extends SingleLevelContext {
        protected APILoginResult result;

        public WikiTokenLoginAPIContext(XMLStream theStream, APILoginResult result) {
            super(theStream, "api");
            this.result = result;
        }

        @Override
        protected BaseProcessingContext createChild(String namespaceURI, String localName, String qName, Attributes atts) {
            return new WikiTokenLoginAPIResultAPIContext(this.theStream, namespaceURI, localName, qName, atts, this.result);
        }

        @Override
        protected void finishChild(BaseProcessingContext child) throws ManifoldCFException {
        }
    }

    protected class ExecuteTokenAPILoginThread
    extends Thread {
        protected HttpClient client;
        protected HttpRequestBase executeMethod;
        protected Throwable exception = null;
        protected APILoginResult result;

        public ExecuteTokenAPILoginThread(HttpClient client, HttpRequestBase executeMethod, APILoginResult result) {
            this.setDaemon(true);
            this.client = client;
            this.executeMethod = executeMethod;
            this.result = result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                HttpResponse rval = this.client.execute((HttpUriRequest)this.executeMethod);
                if (rval.getStatusLine().getStatusCode() != 200) {
                    throw new ManifoldCFException("Unexpected HTTP response code " + rval.getStatusLine().getStatusCode() + ": " + WikiConnector.readResponseAsString(rval));
                }
                InputStream is = rval.getEntity().getContent();
                try {
                    XMLStream x = new XMLStream(false);
                    WikiTokenLoginAPIContext c = new WikiTokenLoginAPIContext(x, this.result);
                    x.setContext((XMLContext)c);
                    try {
                        try {
                            x.parse(is);
                        }
                        catch (IOException e) {
                            long time = System.currentTimeMillis();
                            throw new ServiceInterruption(e.getMessage(), (Throwable)e, time + 300000L, time + 720000L, -1, false);
                        }
                    }
                    finally {
                        x.cleanup();
                    }
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
            }
            catch (Throwable e) {
                this.exception = e;
            }
            finally {
                this.executeMethod.abort();
            }
        }

        public void finishUp() throws InterruptedException, ManifoldCFException, ServiceInterruption, IOException, HttpException {
            this.join();
            WikiConnector.handleException(this.exception);
        }
    }

    protected static class APILoginResult {
        public boolean result = false;
        public String reason = "";

        protected APILoginResult() {
        }
    }

    protected class WikiLoginAPIResultAPIContext
    extends BaseProcessingContext {
        protected APILoginResult result;
        protected String token;

        public WikiLoginAPIResultAPIContext(XMLStream theStream, String namespaceURI, String localName, String qName, Attributes atts, APILoginResult result) {
            super(theStream, namespaceURI, localName, qName, atts);
            this.token = null;
            this.result = result;
        }

        @Override
        protected XMLContext beginTag(String namespaceURI, String localName, String qName, Attributes atts) throws ManifoldCFException, ServiceInterruption {
            if (qName.equals("login")) {
                String loginResult = atts.getValue("result");
                if ("NeedToken".equals(loginResult)) {
                    this.token = atts.getValue("token");
                } else if ("Success".equals(loginResult)) {
                    this.result.result = true;
                } else {
                    this.result.reason = loginResult;
                }
            }
            return super.beginTag(namespaceURI, localName, qName, atts);
        }

        public String getToken() {
            return this.token;
        }
    }

    protected class WikiLoginAPIContext
    extends SingleLevelContext {
        protected APILoginResult result;
        protected String token;

        public WikiLoginAPIContext(XMLStream theStream, APILoginResult result) {
            super(theStream, "api");
            this.token = null;
            this.result = result;
        }

        @Override
        protected BaseProcessingContext createChild(String namespaceURI, String localName, String qName, Attributes atts) {
            return new WikiLoginAPIResultAPIContext(this.theStream, namespaceURI, localName, qName, atts, this.result);
        }

        @Override
        protected void finishChild(BaseProcessingContext child) throws ManifoldCFException {
            this.token = ((WikiLoginAPIResultAPIContext)child).getToken();
        }

        public String getToken() {
            return this.token;
        }
    }

    protected class ExecuteAPILoginThread
    extends Thread {
        protected HttpClient client;
        protected HttpRequestBase executeMethod;
        protected APILoginResult result;
        protected Throwable exception = null;
        protected String token = null;

        public ExecuteAPILoginThread(HttpClient client, HttpRequestBase executeMethod, APILoginResult result) {
            this.setDaemon(true);
            this.client = client;
            this.executeMethod = executeMethod;
            this.result = result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                HttpResponse rval = this.client.execute((HttpUriRequest)this.executeMethod);
                if (rval.getStatusLine().getStatusCode() != 200) {
                    throw new ManifoldCFException("Unexpected HTTP response code " + rval.getStatusLine().getStatusCode() + ": " + WikiConnector.readResponseAsString(rval));
                }
                InputStream is = rval.getEntity().getContent();
                try {
                    XMLStream x = new XMLStream(false);
                    WikiLoginAPIContext c = new WikiLoginAPIContext(x, this.result);
                    x.setContext((XMLContext)c);
                    try {
                        try {
                            x.parse(is);
                            this.token = c.getToken();
                        }
                        catch (InterruptedIOException e) {
                            throw e;
                        }
                        catch (IOException e) {
                            long time = System.currentTimeMillis();
                            throw new ServiceInterruption(e.getMessage(), (Throwable)e, time + 300000L, time + 720000L, -1, false);
                        }
                    }
                    finally {
                        x.cleanup();
                    }
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
            }
            catch (Throwable e) {
                this.exception = e;
            }
            finally {
                this.executeMethod.abort();
            }
        }

        public String finishUp() throws InterruptedException, ManifoldCFException, ServiceInterruption, IOException, HttpException {
            this.join();
            WikiConnector.handleException(this.exception);
            return this.token;
        }
    }
}

