/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.server;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.RelationshipDirection;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectListImpl;
import org.apache.chemistry.opencmis.commons.impl.server.ObjectInfoImpl;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.apache.chemistry.opencmis.commons.server.ObjectInfoHandler;
import org.apache.chemistry.opencmis.inmemory.server.InMemoryAbstractServiceImpl;
import org.apache.chemistry.opencmis.inmemory.server.InMemoryRepositoryServiceImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.ObjectStore;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoreManager;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoredObject;
import org.apache.chemistry.opencmis.inmemory.types.PropertyCreationHelper;
import org.apache.chemistry.opencmis.server.support.TypeManager;

public class InMemoryRelationshipServiceImpl
extends InMemoryAbstractServiceImpl {
    private InMemoryRepositoryServiceImpl repSvc;

    protected InMemoryRelationshipServiceImpl(StoreManager storeManager, InMemoryRepositoryServiceImpl repSvc) {
        super(storeManager);
        this.repSvc = repSvc;
    }

    public ObjectList getObjectRelationships(CallContext context, String repositoryId, String objectId, Boolean includeSubRelationshipTypes, RelationshipDirection relationshipDirection, String typeId, String filter, Boolean includeAllowableActions, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension, ObjectInfoHandler objectInfos) {
        int skip = null == skipCount ? 0 : skipCount.intValue();
        ObjectStore objStore = this.fStoreManager.getObjectStore(repositoryId);
        StoredObject so = this.validator.getObjectRelationships(context, repositoryId, objectId, relationshipDirection, typeId, extension);
        if (so == null) {
            throw new CmisObjectNotFoundException("Unknown object id: " + objectId);
        }
        String user = context.getUsername();
        TypeManager tm = this.fStoreManager.getTypeManager(repositoryId);
        ArrayList<String> typeIds = null;
        if (null != typeId) {
            List<TypeDefinitionContainer> typeDescs;
            typeIds = new ArrayList<String>();
            typeIds.add(typeId);
            if (includeSubRelationshipTypes.booleanValue() && null != (typeDescs = this.repSvc.getTypeDescendants(context, repositoryId, typeId, null, true, null))) {
                for (TypeDefinitionContainer t : typeDescs) {
                    typeIds.add(t.getTypeDefinition().getId());
                }
            }
        }
        List<StoredObject> rels = objStore.getRelationships(objectId, typeIds, relationshipDirection);
        ObjectListImpl result = new ObjectListImpl();
        ArrayList<ObjectData> odList = new ArrayList<ObjectData>();
        for (StoredObject rel : rels) {
            ObjectData od = PropertyCreationHelper.getObjectData(context, tm, objStore, rel, filter, user, includeAllowableActions, IncludeRelationships.NONE, null, false, false, extension);
            odList.add(od);
        }
        if (context.isObjectInfoRequired()) {
            ObjectInfoImpl objectInfo = new ObjectInfoImpl();
            this.fAtomLinkProvider.fillInformationForAtomLinks(context, repositoryId, so, objectInfo);
            objectInfos.addObjectInfo((ObjectInfo)objectInfo);
        }
        result.setObjects(odList);
        result.setNumItems(BigInteger.valueOf(rels.size()));
        result.setHasMoreItems(Boolean.valueOf(rels.size() > skip + rels.size()));
        return result;
    }
}

