/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.selectors;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Extend;
import com.github.sommeri.less4j.core.ast.MultiTargetExtend;
import com.github.sommeri.less4j.core.ast.RuleSet;
import com.github.sommeri.less4j.core.ast.Selector;
import com.github.sommeri.less4j.core.compiler.selectors.GeneralComparatorForExtend;
import com.github.sommeri.less4j.core.compiler.stages.ASTManipulator;
import com.github.sommeri.less4j.utils.ArraysUtils;
import com.github.sommeri.less4j.utils.Couple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExtendsSolver {
    private GeneralComparatorForExtend comparator = new GeneralComparatorForExtend();
    private ASTManipulator manipulator = new ASTManipulator();
    private List<RuleSet> allRulesets = new ArrayList<RuleSet>();
    private List<Selector> inlineExtends = new ArrayList<Selector>();
    private PerformedExtendsDB performedExtends = new PerformedExtendsDB();

    public void solveExtends(ASTCssNode node) {
        this.collectRulesets(node);
        this.solveInlineExtends();
    }

    private void solveInlineExtends() {
        for (Selector selector : this.inlineExtends) {
            this.solveInlineExtends(selector);
        }
    }

    private void solveInlineExtends(Selector extendingSelector) {
        ArrayList<ExtendRefs> doExtends = null;
        for (RuleSet ruleSet : this.allRulesets) {
            for (Selector targetSelector : ruleSet.getSelectors()) {
                Selector newSelector = this.constructNewSelector(extendingSelector, targetSelector);
                if (newSelector == null || !this.canExtend(extendingSelector, newSelector, ruleSet)) continue;
                if (doExtends == null) {
                    doExtends = new ArrayList<ExtendRefs>();
                }
                doExtends.add(new ExtendRefs(ruleSet, targetSelector, newSelector));
            }
        }
        if (doExtends != null) {
            for (ExtendRefs refs : doExtends) {
                this.doTheExtend(extendingSelector, refs.newSelector, refs.ruleSet, refs.targetSelector);
            }
        }
    }

    private void doTheExtend(Selector originalExtendingSelector, Selector addSelector, RuleSet target, Selector targetSelector) {
        this.addSelector(target, addSelector);
        this.performedExtends.register(targetSelector, originalExtendingSelector, addSelector.getVisibility());
        List<PerformedExtend> mayNeedToExtendTargetToo = this.performedExtends.getThoseWhoExtended(originalExtendingSelector);
        for (PerformedExtend info : mayNeedToExtendTargetToo) {
            Selector selector = info.getSelector();
            if (!this.canExtend(selector, target)) continue;
            Selector nextSelector = selector.clone();
            this.manipulator.setTreeVisibility(nextSelector, info.getVisibility());
            this.doTheExtend(selector, nextSelector, target, targetSelector);
        }
    }

    private boolean canExtend(Selector extendingSelector, RuleSet targetRuleSet) {
        return this.canExtend(extendingSelector, extendingSelector, targetRuleSet);
    }

    private boolean canExtend(Selector extendingSelector, Selector newSelector, RuleSet targetRuleSet) {
        if (this.containsSelector(newSelector, targetRuleSet)) {
            return false;
        }
        return this.compatibleMediaLocation(extendingSelector, targetRuleSet);
    }

    private boolean compatibleMediaLocation(Selector extendingSelector, RuleSet targetRuleSet) {
        ASTCssNode grandParent = this.findOwnerNode(extendingSelector);
        if (grandParent == null || grandParent.getType() == ASTCssNodeType.STYLE_SHEET) {
            return true;
        }
        boolean result = grandParent == this.findOwnerNode(targetRuleSet);
        return result;
    }

    private boolean containsSelector(Selector extendingSelector, RuleSet targetRuleSet) {
        for (Selector selector : targetRuleSet.getSelectors()) {
            if (!this.comparator.equals(selector, extendingSelector)) continue;
            return true;
        }
        return false;
    }

    private ASTCssNode findOwnerNode(ASTCssNode extendingSelector) {
        return this.manipulator.findParentOfType(extendingSelector, ASTCssNodeType.STYLE_SHEET, ASTCssNodeType.MEDIA);
    }

    private void addSelector(RuleSet ruleSet, Selector selector) {
        selector.setParent(ruleSet);
        ruleSet.addSelector(selector);
        if (selector.getVisibility() == ASTCssNode.Visibility.VISIBLE) {
            this.manipulator.setTreeVisibility(ruleSet.getBody(), ASTCssNode.Visibility.VISIBLE);
            ruleSet.setVisibility(ASTCssNode.Visibility.VISIBLE);
            ASTCssNode node = ruleSet;
            while (node.hasParent()) {
                node = node.getParent();
                switch (node.getVisibility()) {
                    case DEFAULT: {
                        node.setVisibility(ASTCssNode.Visibility.VISIBLE);
                        break;
                    }
                }
            }
        }
    }

    private Selector constructNewSelector(Selector extending, Selector possibleTarget) {
        if (possibleTarget == extending) {
            return null;
        }
        List<Extend> allExtends = extending.getExtend();
        for (Extend extend : allExtends) {
            Selector addSelector;
            if (!extend.isAll() && this.comparator.equals(possibleTarget, extend.getTarget())) {
                return this.setNewSelectorVisibility(extend, extending.clone());
            }
            if (!extend.isAll() || (addSelector = this.comparator.replaceInside(extend.getTarget(), possibleTarget, extend.getParentAsSelector())) == null) continue;
            return this.setNewSelectorVisibility(extend, addSelector);
        }
        return null;
    }

    private Selector setNewSelectorVisibility(Extend extend, Selector newSelector) {
        this.manipulator.setTreeVisibility(newSelector, extend.getVisibility());
        return newSelector;
    }

    private void collectRulesets(ASTCssNode node) {
        switch (node.getType()) {
            case RULE_SET: {
                RuleSet ruleset = (RuleSet)node;
                this.allRulesets.add(ruleset);
                this.collectExtendingSelectors(ruleset);
                break;
            }
            default: {
                ArrayList<? extends ASTCssNode> childs = new ArrayList<ASTCssNode>(node.getChilds());
                for (ASTCssNode aSTCssNode : childs) {
                    this.collectRulesets(aSTCssNode);
                }
            }
        }
    }

    private void collectExtendingSelectors(RuleSet ruleset) {
        List<Extend> directExtends = this.collectDirectExtendDeclarations(ruleset);
        for (Selector selector : ruleset.getSelectors()) {
            this.addClones(selector, directExtends);
            if (!selector.isExtending()) continue;
            this.inlineExtends.add(selector);
        }
    }

    private void addClones(Selector selector, List<Extend> newExtends) {
        List<Extend> clones = ArraysUtils.deeplyClonedList(newExtends);
        selector.addExtends(clones);
        for (Extend extend : clones) {
            extend.setParent(selector);
        }
    }

    private List<Extend> collectDirectExtendDeclarations(RuleSet ruleset) {
        ArrayList<Extend> result = new ArrayList<Extend>();
        ArrayList<ASTCssNode> members = new ArrayList<ASTCssNode>(ruleset.getBody().getMembers());
        for (ASTCssNode node : members) {
            ASTCssNode extend;
            if (node.getType() == ASTCssNodeType.EXTEND) {
                extend = (Extend)node;
                this.manipulator.removeFromBody(extend);
                result.add((Extend)extend);
                continue;
            }
            if (node.getType() != ASTCssNodeType.MULTI_TARGET_EXTEND) continue;
            extend = (MultiTargetExtend)node;
            this.manipulator.removeFromBody(extend);
            result.addAll(((MultiTargetExtend)extend).getAllExtends());
        }
        return result;
    }

    private static class PerformedExtend
    extends Couple<Selector, ASTCssNode.Visibility> {
        public PerformedExtend(Selector extendingSelector, ASTCssNode.Visibility extendingSelectorVisibility) {
            super(extendingSelector, extendingSelectorVisibility);
        }

        public Selector getSelector() {
            return (Selector)this.getT();
        }

        public ASTCssNode.Visibility getVisibility() {
            return (ASTCssNode.Visibility)((Object)this.getM());
        }
    }

    private static class PerformedExtendsDB {
        private Map<Selector, List<PerformedExtend>> allSelectorExtends = new HashMap<Selector, List<PerformedExtend>>();

        private PerformedExtendsDB() {
        }

        protected List<PerformedExtend> getThoseWhoExtended(Selector selector) {
            List<PerformedExtend> result = this.allSelectorExtends.get(selector);
            if (result == null) {
                result = new ArrayList<PerformedExtend>();
                this.allSelectorExtends.put(selector, result);
            }
            return result;
        }

        protected void register(Selector targetSelector, Selector extendingSelector, ASTCssNode.Visibility extendingSelectorVisibility) {
            List<PerformedExtend> tied = this.getThoseWhoExtended(targetSelector);
            tied.add(new PerformedExtend(extendingSelector, extendingSelectorVisibility));
        }
    }

    private static class ExtendRefs {
        RuleSet ruleSet;
        Selector targetSelector;
        Selector newSelector;

        ExtendRefs(RuleSet ruleSet, Selector targetSelector, Selector newSelector) {
            this.ruleSet = ruleSet;
            this.targetSelector = targetSelector;
            this.newSelector = newSelector;
        }

        public String toString() {
            String visibility = "[" + (Object)((Object)this.ruleSet.getVisibility()) + ", " + (Object)((Object)this.targetSelector.getVisibility()) + ", " + (Object)((Object)this.newSelector.getVisibility()) + "]";
            String string = "ExtendRefs " + visibility + "[\n  ruleSet=" + this.ruleSet + ",\n" + "  targetSelector=" + this.targetSelector + ",\n" + "  newSelector=" + this.newSelector + "\n]";
            return string;
        }
    }
}

