/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.MixinReference;
import com.github.sommeri.less4j.core.compiler.expressions.GuardValue;
import com.github.sommeri.less4j.core.compiler.stages.BodyCompilationData;
import com.github.sommeri.less4j.core.problems.BugHappened;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DefaultGuardHelper {
    private final ProblemsHandler problemsHandler;

    public DefaultGuardHelper(ProblemsHandler problemsHandler) {
        this.problemsHandler = problemsHandler;
    }

    public List<BodyCompilationData> chooseMixinsToBeUsed(List<BodyCompilationData> compiledMixins, MixinReference reference) {
        int doNotUse;
        int ifDefaultCnt;
        int ifNotCnt;
        int normalMixinsCnt = ArraysUtils.count(compiledMixins, GuardValue.USE.filter());
        if (normalMixinsCnt + (ifNotCnt = ArraysUtils.count(compiledMixins, GuardValue.USE_IF_NOT_DEFAULT.filter())) + (ifDefaultCnt = ArraysUtils.count(compiledMixins, GuardValue.USE_IF_DEFAULT.filter())) + (doNotUse = ArraysUtils.count(compiledMixins, GuardValue.DO_NOT_USE.filter())) != compiledMixins.size()) {
            throw new BugHappened("Unexpected mixin type in compiled mixins list.", (ASTCssNode)reference);
        }
        if (normalMixinsCnt > 0) {
            return this.keepOnly(compiledMixins, GuardValue.USE, GuardValue.USE_IF_NOT_DEFAULT);
        }
        if (ifDefaultCnt + ifNotCnt > 1) {
            List<BodyCompilationData> errorSet = this.keepOnly(compiledMixins, GuardValue.USE_IF_DEFAULT, GuardValue.USE_IF_NOT_DEFAULT);
            this.problemsHandler.ambiguousDefaultSet(reference, this.extractOriginalMixins(errorSet));
            return Collections.emptyList();
        }
        return this.keepOnly(compiledMixins, GuardValue.USE_IF_DEFAULT);
    }

    private List<BodyCompilationData> keepOnly(List<BodyCompilationData> compiledMixins, GuardValue ... kind) {
        Set<GuardValue> expectedUses = ArraysUtils.asSet(kind);
        Iterator<BodyCompilationData> iterator = compiledMixins.iterator();
        while (iterator.hasNext()) {
            BodyCompilationData compiled = iterator.next();
            if (expectedUses.contains((Object)compiled.getGuardValue())) continue;
            iterator.remove();
        }
        return compiledMixins;
    }

    private List<ASTCssNode> extractOriginalMixins(List<BodyCompilationData> compiledMixins) {
        ArrayList<ASTCssNode> result = new ArrayList<ASTCssNode>();
        for (BodyCompilationData compiled : compiledMixins) {
            result.add((ASTCssNode)((Object)compiled.getCompiledBodyOwner()));
        }
        return result;
    }
}

