/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.output.gts;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.manifoldcf.agents.interfaces.IOutputAddActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputCheckActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputRemoveActivity;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.agents.output.BaseOutputConnector;
import org.apache.manifoldcf.agents.output.gts.HttpPoster;
import org.apache.manifoldcf.agents.output.gts.Messages;
import org.apache.manifoldcf.agents.system.Logging;
import org.apache.manifoldcf.connectorcommon.interfaces.IKeystoreManager;
import org.apache.manifoldcf.connectorcommon.interfaces.KeystoreManagerFactory;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.core.interfaces.VersionContext;
import org.apache.manifoldcf.ui.util.Encoder;
import org.apache.poi.hpsf.MarkUnsupportedException;
import org.apache.poi.hpsf.NoPropertySetStreamException;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.PropertySetFactory;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.poifs.eventfilesystem.POIFSReader;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderEvent;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderListener;
import org.apache.poi.poifs.filesystem.DocumentInputStream;

public class GTSConnector
extends BaseOutputConnector {
    public static final String _rcsid = "@(#)$Id: GTSConnector.java 988245 2010-08-23 18:39:35Z kwright $";
    public static final String INGEST_ACTIVITY = "document ingest";
    public static final String REMOVE_ACTIVITY = "document deletion";
    protected static final int DT_UNKNOWN = -1;
    protected static final int DT_COMPOUND_DOC = 0;
    protected static final int DT_MSWORD = 1;
    protected static final int DT_MSEXCEL = 2;
    protected static final int DT_MSPOWERPOINT = 3;
    protected static final int DT_MSOUTLOOK = 4;
    protected static final int DT_TEXT = 5;
    protected static final int DT_ZERO = 6;
    protected static final int DT_PDF = 7;
    protected HttpPoster poster = null;
    protected static final String[] ingestableMimeTypeArray = new String[]{"application/excel", "application/powerpoint", "application/ppt", "application/rtf", "application/xls", "text/html", "text/rtf", "text/pdf", "application/x-excel", "application/x-msexcel", "application/x-mspowerpoint", "application/x-msword-doc", "application/x-msword", "application/x-word", "Application/pdf", "text/xml", "no-type", "text/plain", "application/pdf", "application/x-rtf", "application/vnd.ms-excel", "application/vnd.ms-pps", "application/vnd.ms-powerpoint", "application/vnd.ms-word", "application/msword", "application/msexcel", "application/mspowerpoint", "application/ms-powerpoint", "application/ms-word", "application/ms-excel", "Adobe", "application/Vnd.Ms-Excel", "vnd.ms-powerpoint", "application/x-pdf", "winword", "text/richtext", "Text", "Text/html", "application/MSWORD", "application/PDF", "application/MSEXCEL", "application/MSPOWERPOINT"};
    protected static final Map ingestableMimeTypeMap = new HashMap();

    public String[] getActivitiesList() {
        return new String[]{INGEST_ACTIVITY, REMOVE_ACTIVITY};
    }

    public void connect(ConfigParams configParameters) {
        super.connect(configParameters);
    }

    public void disconnect() throws ManifoldCFException {
        this.poster = null;
        super.disconnect();
    }

    protected void getSession() throws ManifoldCFException {
        if (this.poster == null) {
            String ingestURI = this.params.getParameter("Ingestion URI");
            if (ingestURI == null) {
                throw new ManifoldCFException("Missing parameter 'Ingestion URI'");
            }
            String userID = this.params.getParameter("User ID");
            String password = this.params.getObfuscatedParameter("Password");
            String realm = this.params.getParameter("Realm");
            this.poster = new HttpPoster(this.currentContext, realm, userID, password, ingestURI);
        }
    }

    public String check() throws ManifoldCFException {
        try {
            this.getSession();
            this.poster.checkPost();
            return super.check();
        }
        catch (ServiceInterruption e) {
            return "Transient error: " + e.getMessage();
        }
    }

    public boolean checkMimeTypeIndexable(VersionContext outputDescription, String mimeType, IOutputCheckActivity activities) throws ManifoldCFException, ServiceInterruption {
        return ingestableMimeTypeMap.get(mimeType) != null;
    }

    public boolean checkDocumentIndexable(VersionContext outputDescription, File localFile, IOutputCheckActivity activities) throws ManifoldCFException, ServiceInterruption {
        int docType = GTSConnector.fingerprint(localFile);
        return docType == 5 || docType == 1 || docType == 2 || docType == 7 || docType == 3;
    }

    public VersionContext getPipelineDescription(Specification spec) throws ManifoldCFException, ServiceInterruption {
        ArrayList<String> collectionList = new ArrayList<String>();
        String documentTemplate = "";
        for (int i = 0; i < spec.getChildCount(); ++i) {
            SpecificationNode sn = spec.getChild(i);
            if (sn.getType().equals("collection")) {
                collectionList.add(sn.getAttributeValue("value"));
                continue;
            }
            if (!sn.getType().equals("documenttemplate")) continue;
            documentTemplate = sn.getAttributeValue("value");
        }
        String ingestURI = this.params.getParameter("Ingestion URI");
        Object[] sortArray = new String[collectionList.size()];
        int j = 0;
        for (String collection : collectionList) {
            sortArray[j++] = collection;
        }
        Arrays.sort(sortArray);
        StringBuilder sb = new StringBuilder();
        GTSConnector.packList((StringBuilder)sb, (String[])sortArray, (char)'+');
        GTSConnector.pack((StringBuilder)sb, (String)documentTemplate, (char)'+');
        sb.append(ingestURI);
        return new VersionContext(sb.toString(), this.params, spec);
    }

    public int addOrReplaceDocumentWithException(String documentURI, VersionContext pipelineDescription, RepositoryDocument document, String authorityNameString, IOutputAddActivity activities) throws ManifoldCFException, ServiceInterruption, IOException {
        Specification spec = pipelineDescription.getSpecification();
        ArrayList<String> collectionList = new ArrayList<String>();
        String documentTemplate = "";
        for (int i = 0; i < spec.getChildCount(); ++i) {
            SpecificationNode sn = spec.getChild(i);
            if (sn.getType().equals("collection")) {
                collectionList.add(sn.getAttributeValue("value"));
                continue;
            }
            if (!sn.getType().equals("documenttemplate")) continue;
            documentTemplate = sn.getAttributeValue("value");
        }
        this.getSession();
        if (this.poster.indexPost(documentURI, collectionList, documentTemplate, authorityNameString, document, activities)) {
            return 0;
        }
        return 1;
    }

    public void removeDocument(String documentURI, String outputDescription, IOutputRemoveActivity activities) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        this.poster.deletePost(documentURI, activities);
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "GTSConnector.Appliance"));
        out.print("\n<script type=\"text/javascript\">\n<!--\nfunction checkConfig()\n{\n  if (editconnection.ingesturi.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "GTSConnector.PleaseSupplyAValidIngestionURI") + "\");\n    editconnection.ingesturi.focus();\n    return false;\n  }\n  return true;\n}\n\nfunction checkConfigForSave()\n{\n  if (editconnection.ingesturi.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "GTSConnector.PleaseSupplyAValidIngestionURI") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "GTSConnector.Appliance") + "\");\n    editconnection.ingesturi.focus();\n    return false;\n  }\n  return true;\n}\n\n//-->\n</script>\n");
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        String password;
        String userID;
        String realm;
        String ingestURI = parameters.getParameter("Ingestion URI");
        if (ingestURI == null) {
            ingestURI = "http://localhost:7031/HTTPIngest";
        }
        if ((realm = parameters.getParameter("Realm")) == null) {
            realm = "";
        }
        if ((userID = parameters.getParameter("User ID")) == null) {
            userID = "";
        }
        if ((password = parameters.getObfuscatedParameter("Password")) == null) {
            password = "";
        }
        if (tabName.equals(Messages.getString(locale, "GTSConnector.Appliance"))) {
            out.print("\n<table class=\"displaytable\">\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "GTSConnector.IngestURI") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"ingesturi\" type=\"text\" size=\"32\" value=\"" + Encoder.attributeEscape((String)ingestURI) + "\"/>\n    </td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "GTSConnector.Realm") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"realm\" type=\"text\" size=\"32\" value=\"" + Encoder.attributeEscape((String)realm) + "\"/>\n    </td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "GTSConnector.UserID") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"userid\" type=\"text\" size=\"32\" value=\"" + Encoder.attributeEscape((String)userID) + "\"/>\n    </td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "GTSConnector.Password") + "</nobr></td>\n    <td class=\"value\">\n      <input type=\"password\" size=\"32\" name=\"password\" value=\"" + Encoder.attributeEscape((String)password) + "\"/>\n    </td>\n  </tr>\n</table>\n");
        } else {
            out.print("\n<input type=\"hidden\" name=\"ingesturi\" value=\"" + Encoder.attributeEscape((String)ingestURI) + "\"/>\n<input type=\"hidden\" name=\"userid\" value=\"" + Encoder.attributeEscape((String)userID) + "\"/>\n<input type=\"hidden\" name=\"password\" value=\"" + Encoder.attributeEscape((String)password) + "\"/>\n");
        }
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        String password;
        String userID;
        String realm;
        String ingestURI = variableContext.getParameter("ingesturi");
        if (ingestURI != null) {
            parameters.setParameter("Ingestion URI", ingestURI);
        }
        if ((realm = variableContext.getParameter("realm")) != null) {
            parameters.setParameter("Realm", realm);
        }
        if ((userID = variableContext.getParameter("userid")) != null) {
            parameters.setParameter("User ID", userID);
        }
        if ((password = variableContext.getParameter("password")) != null) {
            parameters.setObfuscatedParameter("Password", password);
        }
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        out.print("\n<table class=\"displaytable\">\n  <tr>\n    <td class=\"description\" colspan=\"1\"><nobr>" + Messages.getBodyString(locale, "GTSConnector.Parameters") + "</nobr></td>\n    <td class=\"value\" colspan=\"3\">\n");
        Iterator iter = parameters.listParameters();
        while (iter.hasNext()) {
            String param = (String)iter.next();
            String value = parameters.getParameter(param);
            if (param.length() >= "password".length() && param.substring(param.length() - "password".length()).equalsIgnoreCase("password")) {
                out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=********</nobr><br/>\n");
                continue;
            }
            if (param.length() >= "keystore".length() && param.substring(param.length() - "keystore".length()).equalsIgnoreCase("keystore")) {
                IKeystoreManager kmanager = KeystoreManagerFactory.make((String)"", (String)value);
                out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=&lt;" + Integer.toString(kmanager.getContents().length) + " certificate(s)&gt;</nobr><br/>\n");
                continue;
            }
            out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=" + Encoder.bodyEscape((String)value) + "</nobr><br/>\n");
        }
        out.print("    </td>\n  </tr>\n</table>\n");
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        tabsArray.add(Messages.getString(locale, "GTSConnector.GTSCollections"));
        tabsArray.add(Messages.getString(locale, "GTSConnector.GTSTemplate"));
        out.print("\n<script type=\"text/javascript\">\n<!--\n\nfunction " + seqPrefix + "checkSpecification()\n{\n  if (editjob." + seqPrefix + "gts_collectionname.value.length > 230)\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "GTSConnector.CollectionNameMustBeLessThanOrEqualToCharacters") + "\");\n    editjob." + seqPrefix + "gts_collectionname.focus();\n    return false;\n  }\n  return true;\n}\n\n//-->\n</script>\n");
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        int i = 0;
        String collectionName = null;
        String documentTemplate = null;
        while (i < os.getChildCount()) {
            SpecificationNode sn;
            if ((sn = os.getChild(i++)).getType().equals("collection")) {
                collectionName = sn.getAttributeValue("value");
                continue;
            }
            if (!sn.getType().equals("documenttemplate")) continue;
            documentTemplate = sn.getAttributeValue("value");
        }
        if (collectionName == null) {
            collectionName = "";
        }
        if (documentTemplate == null) {
            documentTemplate = "";
        }
        if (tabName.equals(Messages.getString(locale, "GTSConnector.GTSCollections")) && connectionSequenceNumber == actualSequenceNumber) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "GTSConnector.CollectionName") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"" + seqPrefix + "gts_collectionname\" type=\"text\" size=\"32\" value=\"" + Encoder.attributeEscape((String)collectionName) + "\"/>\n    </td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "gts_collectionname\" value=\"" + Encoder.attributeEscape((String)collectionName) + "\"/>\n");
        }
        if (tabName.equals(Messages.getString(locale, "GTSConnector.GTSTemplate")) && connectionSequenceNumber == actualSequenceNumber) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "GTSConnector.DocumentTemplate") + "</nobr></td>\n    <td class=\"value\">\n      <textarea rows=\"10\" cols=\"96\" name=\"" + seqPrefix + "gts_documenttemplate\">" + Encoder.bodyEscape((String)documentTemplate) + "</textarea>\n    </td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"" + seqPrefix + "gts_documenttemplate\" value=\"" + Encoder.attributeEscape((String)documentTemplate) + "\"/>\n");
        }
    }

    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification os, int connectionSequenceNumber) throws ManifoldCFException {
        String documentTemplate;
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        String collectionName = variableContext.getParameter(seqPrefix + "gts_collectionname");
        if (collectionName != null) {
            int i = 0;
            while (i < os.getChildCount()) {
                SpecificationNode sn = os.getChild(i);
                if (sn.getType().equals("collection")) {
                    os.removeChild(i);
                    continue;
                }
                ++i;
            }
            if (collectionName.length() > 0) {
                SpecificationNode newspec = new SpecificationNode("collection");
                newspec.setAttribute("value", collectionName);
                os.addChild(os.getChildCount(), (ConfigurationNode)newspec);
            }
        }
        if ((documentTemplate = variableContext.getParameter(seqPrefix + "gts_documenttemplate")) != null) {
            int i = 0;
            while (i < os.getChildCount()) {
                SpecificationNode sn = os.getChild(i);
                if (sn.getType().equals("documenttemplate")) {
                    os.removeChild(i);
                    continue;
                }
                ++i;
            }
            SpecificationNode newspec = new SpecificationNode("documenttemplate");
            newspec.setAttribute("value", documentTemplate);
            os.addChild(os.getChildCount(), (ConfigurationNode)newspec);
        }
        return null;
    }

    public void viewSpecification(IHTTPOutput out, Locale locale, Specification os, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        int i = 0;
        String collectionName = null;
        String documentTemplate = null;
        while (i < os.getChildCount()) {
            SpecificationNode sn;
            if ((sn = os.getChild(i++)).getType().equals("collection")) {
                collectionName = sn.getAttributeValue("value");
                continue;
            }
            if (!sn.getType().equals("documenttemplate")) continue;
            documentTemplate = sn.getAttributeValue("value");
        }
        if (collectionName == null) {
            collectionName = "";
        }
        if (documentTemplate == null) {
            documentTemplate = "";
        }
        out.print("\n<table class=\"displaytable\">\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "GTSConnector.Collection") + "</nobr></td>\n    <td class=\"value\">" + Encoder.bodyEscape((String)collectionName) + "</td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "GTSConnector.DocumentTemplate") + "</nobr></td>\n    <td class=\"value\">\n");
        if (documentTemplate == null || documentTemplate.length() == 0) {
            out.println("None specified");
        } else {
            out.print("        <textarea name=\"documenttemplate\" cols=\"96\" rows=\"5\" readonly=\"true\">" + Encoder.bodyEscape((String)documentTemplate) + "</textarea>\n");
        }
        out.print("    </td>\n  </tr>\n</table>\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int fingerprint(File file) throws ManifoldCFException {
        try {
            int amt;
            byte[] byteBuffer = new byte[4096];
            try (FileInputStream is = new FileInputStream(file);){
                int incr;
                for (amt = 0; amt < byteBuffer.length; amt += incr) {
                    incr = ((InputStream)is).read(byteBuffer, amt, byteBuffer.length - amt);
                    if (incr != -1) continue;
                    break;
                }
            }
            if (amt == 0) {
                return 6;
            }
            if (GTSConnector.isText(byteBuffer, amt)) {
                return 5;
            }
            if (byteBuffer[0] == 37 && byteBuffer[1] == 80 && byteBuffer[2] == 68 && byteBuffer[3] == 70) {
                return 7;
            }
            if (Logging.ingest.isDebugEnabled()) {
                Logging.ingest.debug((Object)("GTS: Document begins with: " + GTSConnector.hexprint(byteBuffer[0]) + GTSConnector.hexprint(byteBuffer[1]) + GTSConnector.hexprint(byteBuffer[2]) + GTSConnector.hexprint(byteBuffer[3]) + GTSConnector.hexprint(byteBuffer[4]) + GTSConnector.hexprint(byteBuffer[5]) + GTSConnector.hexprint(byteBuffer[6]) + GTSConnector.hexprint(byteBuffer[7])));
            }
            if (byteBuffer[0] == -48 && byteBuffer[1] == -49 && byteBuffer[2] == 17 && byteBuffer[3] == -32 && byteBuffer[4] == -95 && byteBuffer[5] == -79 && byteBuffer[6] == 26 && byteBuffer[7] == -31) {
                Logging.ingest.debug((Object)"GTS: Compound document signature detected");
                String appName = GTSConnector.getAppName(file);
                if (appName == null) {
                    return -1;
                }
                if (Logging.ingest.isDebugEnabled()) {
                    Logging.ingest.debug((Object)("GTS: Appname is '" + appName + "'"));
                }
                return GTSConnector.recognizeApp(appName);
            }
            return -1;
        }
        catch (SocketTimeoutException e) {
            return -1;
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (IOException e) {
            return -1;
        }
        catch (IllegalArgumentException e) {
            return -1;
        }
        catch (IllegalStateException e) {
            return -1;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return -1;
        }
        catch (ClassCastException e) {
            return -1;
        }
        catch (OutOfMemoryError e) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getAppName(File documentPath) throws ManifoldCFException {
        try {
            String string;
            FileInputStream is = new FileInputStream(documentPath);
            try {
                POIFSReader reader = new POIFSReader();
                ReaderListener listener = new ReaderListener();
                reader.registerListener((POIFSReaderListener)listener, "\u0005SummaryInformation");
                reader.read((InputStream)is);
                if (Logging.ingest.isDebugEnabled()) {
                    Logging.ingest.debug((Object)("GTS: Done finding appname for '" + documentPath.toString() + "'"));
                }
                string = listener.getAppName();
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)is).close();
                    throw throwable;
                }
                catch (SocketTimeoutException e) {}
                catch (InterruptedIOException e) {
                    throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                }
                catch (Throwable e) {}
            }
            ((InputStream)is).close();
            return string;
        }
        finally {
            return null;
        }
    }

    protected static int recognizeApp(String appName) {
        if ((appName = appName.toUpperCase(Locale.ROOT)).indexOf("MICROSOFT WORD") != -1) {
            return 1;
        }
        if (appName.indexOf("MICROSOFT OFFICE WORD") != -1) {
            return 1;
        }
        if (appName.indexOf("MICROSOFT EXCEL") != -1) {
            return 2;
        }
        if (appName.indexOf("MICROSOFT POWERPOINT") != -1) {
            return 3;
        }
        if (appName.indexOf("MICROSOFT OFFICE POWERPOINT") != -1) {
            return 3;
        }
        if (appName.indexOf("MICROSOFT OUTLOOK") != -1) {
            return 4;
        }
        return 0;
    }

    protected static boolean isText(byte[] beginChunk, int chunkLength) {
        if (chunkLength == 0) {
            return true;
        }
        int i = 0;
        int count = 0;
        while (i < chunkLength) {
            byte x;
            if ((x = beginChunk[i++]) == 0) {
                return false;
            }
            if (!GTSConnector.isStrange(x)) continue;
            ++count;
        }
        return (double)count / (double)chunkLength < 0.3;
    }

    protected static boolean isStrange(byte x) {
        return (x > 127 || x < 32) && !GTSConnector.isWhiteSpace(x);
    }

    protected static boolean isWhiteSpace(byte x) {
        return x == 9 || x == 10 || x == 13 || x == 32;
    }

    protected static String hexprint(byte x) {
        StringBuilder sb = new StringBuilder();
        sb.append(GTSConnector.nibbleprint(0xF & x >> 4)).append(GTSConnector.nibbleprint(0xF & x));
        return sb.toString();
    }

    protected static char nibbleprint(int x) {
        if (x >= 10) {
            return (char)(x - 10 + 97);
        }
        return (char)(x + 48);
    }

    static {
        int i = 0;
        while (i < ingestableMimeTypeArray.length) {
            String type = ingestableMimeTypeArray[i++];
            ingestableMimeTypeMap.put(type, type);
        }
    }

    protected static class ReaderListener
    implements POIFSReaderListener {
        protected String appName = null;

        public String getAppName() {
            return this.appName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processPOIFSReaderEvent(POIFSReaderEvent event) {
            try (DocumentInputStream is = event.getStream();){
                PropertySet ps = PropertySetFactory.create((InputStream)is);
                if (!(ps instanceof SummaryInformation)) {
                    this.appName = null;
                    return;
                }
                this.appName = ((SummaryInformation)ps).getApplicationName();
            }
            catch (NoPropertySetStreamException e) {
                this.appName = null;
                return;
            }
            catch (MarkUnsupportedException e) {
                Logging.ingest.error((Object)("Need to feed a stream that supports mark(): " + e.getMessage()), (Throwable)e);
                this.appName = null;
                return;
            }
            catch (UnsupportedEncodingException e) {
                Logging.ingest.error((Object)("Need to support encoding: " + e.getMessage()), (Throwable)e);
                this.appName = null;
                return;
            }
            catch (IOException e) {
                this.appName = null;
                return;
            }
        }
    }
}

