/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequestResponse;

public class ConsumerMetadataRequest
extends AbstractRequestResponse {
    public static Schema curSchema = ProtoUtils.currentRequestSchema(ApiKeys.CONSUMER_METADATA.id);
    private static String GROUP_ID_KEY_NAME = "group_id";
    private final String groupId;

    public ConsumerMetadataRequest(String groupId) {
        super(new Struct(curSchema));
        this.struct.set(GROUP_ID_KEY_NAME, (Object)groupId);
        this.groupId = groupId;
    }

    public ConsumerMetadataRequest(Struct struct) {
        super(struct);
        this.groupId = struct.getString(GROUP_ID_KEY_NAME);
    }

    public String groupId() {
        return this.groupId;
    }

    public static ConsumerMetadataRequest parse(ByteBuffer buffer) {
        return new ConsumerMetadataRequest((Struct)curSchema.read(buffer));
    }
}

