/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.lockmanager;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ZooKeeperServerMain;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;

public class ZooKeeperInstance {
    protected final int zkPort;
    protected final File tempDir;
    protected ZooKeeperThread zookeeperThread = null;

    public ZooKeeperInstance(int zkPort, File tempDir) {
        this.zkPort = zkPort;
        this.tempDir = tempDir;
    }

    public void start() throws Exception {
        Properties startupProperties = new Properties();
        startupProperties.setProperty("tickTime", "2000");
        startupProperties.setProperty("dataDir", this.tempDir.toString());
        startupProperties.setProperty("clientPort", Integer.toString(this.zkPort));
        QuorumPeerConfig quorumConfiguration = new QuorumPeerConfig();
        quorumConfiguration.parseProperties(startupProperties);
        ServerConfig configuration = new ServerConfig();
        configuration.readFrom(quorumConfiguration);
        this.zookeeperThread = new ZooKeeperThread(configuration);
        this.zookeeperThread.start();
        Thread.sleep(5000L);
    }

    public void stop() throws Exception {
        while (this.zookeeperThread != null) {
            if (!this.zookeeperThread.isAlive()) {
                Throwable e = this.zookeeperThread.finishUp();
                if (e != null) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    if (e instanceof Exception) {
                        throw (Exception)e;
                    }
                    if (e instanceof Error) {
                        throw (Error)e;
                    }
                }
                this.zookeeperThread = null;
                continue;
            }
            this.zookeeperThread.interrupt();
            Thread.sleep(1000L);
        }
    }

    protected static class ZooKeeperThread
    extends Thread {
        protected final ServerConfig config;
        protected Throwable exception = null;

        public ZooKeeperThread(ServerConfig config) {
            this.config = config;
        }

        @Override
        public void run() {
            try {
                ZooKeeperServerMain server = new ZooKeeperServerMain();
                server.runFromConfig(this.config);
            }
            catch (IOException server) {
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public Throwable finishUp() throws InterruptedException {
            this.join();
            return this.exception;
        }
    }
}

