/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequestResponse;

public class ConsumerMetadataResponse
extends AbstractRequestResponse {
    private static Schema curSchema = ProtoUtils.currentResponseSchema(ApiKeys.CONSUMER_METADATA.id);
    private static String ERROR_CODE_KEY_NAME = "error_code";
    private static String COORDINATOR_KEY_NAME = "coordinator";
    private static String NODE_ID_KEY_NAME = "node_id";
    private static String HOST_KEY_NAME = "host";
    private static String PORT_KEY_NAME = "port";
    private final short errorCode;
    private final Node node;

    public ConsumerMetadataResponse(short errorCode, Node node) {
        super(new Struct(curSchema));
        this.struct.set(ERROR_CODE_KEY_NAME, (Object)errorCode);
        Struct coordinator = this.struct.instance(COORDINATOR_KEY_NAME);
        coordinator.set(NODE_ID_KEY_NAME, (Object)node.id());
        coordinator.set(HOST_KEY_NAME, (Object)node.host());
        coordinator.set(PORT_KEY_NAME, (Object)node.port());
        this.struct.set(COORDINATOR_KEY_NAME, (Object)coordinator);
        this.errorCode = errorCode;
        this.node = node;
    }

    public ConsumerMetadataResponse(Struct struct) {
        super(struct);
        this.errorCode = struct.getShort(ERROR_CODE_KEY_NAME);
        Struct broker = (Struct)struct.get(COORDINATOR_KEY_NAME);
        int nodeId = broker.getInt(NODE_ID_KEY_NAME);
        String host = broker.getString(HOST_KEY_NAME);
        int port = broker.getInt(PORT_KEY_NAME);
        this.node = new Node(nodeId, host, port);
    }

    public short errorCode() {
        return this.errorCode;
    }

    public Node node() {
        return this.node;
    }

    public static ConsumerMetadataResponse parse(ByteBuffer buffer) {
        return new ConsumerMetadataResponse((Struct)curSchema.read(buffer));
    }
}

