/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.alfresco;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.alfresco.webservice.types.NamedValue;
import org.apache.commons.lang.StringUtils;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.core.common.DateParser;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.connectors.alfresco.Constants;

public class PropertiesUtils {
    private static final String PROP_CONTENT_PREFIX = "contentUrl";
    private static final String PROP_CONTENT_SEP = "|";
    private static final String PROP_MIMETYPE_SEP = "=";
    private static final String PROP_MODIFIED = Constants.createQNameString((String)"http://www.alfresco.org/model/content/1.0", (String)"modified");

    public static String[] getPropertyValues(NamedValue[] properties, String qname) {
        String[] propertyValues = null;
        for (NamedValue property : properties) {
            if (!property.getName().endsWith(qname)) continue;
            propertyValues = property.getIsMultiValue() != false ? property.getValues() : new String[]{property.getValue()};
        }
        return propertyValues;
    }

    public static void ingestProperties(RepositoryDocument rd, NamedValue[] properties, List<NamedValue> contentProperties) throws ManifoldCFException, ParseException {
        for (NamedValue property : properties) {
            if (property == null || !StringUtils.isNotEmpty((String)property.getName())) continue;
            if (property.getIsMultiValue().booleanValue()) {
                String[] values = property.getValues();
                if (values == null) continue;
                for (String value : values) {
                    if (!StringUtils.isNotEmpty((String)value)) continue;
                    rd.addField(property.getName(), value);
                }
                continue;
            }
            if (!StringUtils.isNotEmpty((String)property.getValue())) continue;
            rd.addField(property.getName(), property.getValue());
        }
        String fileName = "";
        String[] propertyValues = PropertiesUtils.getPropertyValues(properties, Constants.PROP_NAME);
        if (propertyValues != null && propertyValues.length > 0) {
            fileName = propertyValues[0];
        }
        String mimeType = PropertiesUtils.getMimeType(contentProperties);
        Date createdDate = PropertiesUtils.getDatePropertyValue(properties, Constants.PROP_CREATED);
        Date modifiedDate = PropertiesUtils.getDatePropertyValue(properties, PROP_MODIFIED);
        if (StringUtils.isNotEmpty((String)fileName)) {
            rd.setFileName(fileName);
        }
        if (StringUtils.isNotEmpty((String)mimeType)) {
            rd.setMimeType(mimeType);
        }
        if (createdDate != null) {
            rd.setCreatedDate(createdDate);
        }
        if (modifiedDate != null) {
            rd.setModifiedDate(modifiedDate);
        }
    }

    public static List<NamedValue> getContentProperties(NamedValue[] properties) {
        ArrayList<NamedValue> contentProperties = new ArrayList<NamedValue>();
        if (properties != null) {
            for (NamedValue property : properties) {
                if (property == null || property.getIsMultiValue() == null || property.getIsMultiValue().booleanValue() || !StringUtils.isNotEmpty((String)property.getValue()) || !property.getValue().startsWith(PROP_CONTENT_PREFIX)) continue;
                contentProperties.add(property);
            }
        }
        return contentProperties;
    }

    public static String getNodeReference(NamedValue[] properties) {
        String nodeReference = "";
        String storeProtocol = "";
        String storeId = "";
        String uuid = "";
        if (properties != null) {
            for (NamedValue property : properties) {
                if (Constants.PROP_STORE_PROTOCOL.equals(property.getName())) {
                    storeProtocol = property.getValue();
                    continue;
                }
                if (Constants.PROP_STORE_ID.equals(property.getName())) {
                    storeId = property.getValue();
                    continue;
                }
                if (!Constants.PROP_NODE_UUID.equals(property.getName())) continue;
                uuid = property.getValue();
            }
        }
        if (StringUtils.isNotEmpty((String)storeProtocol) && StringUtils.isNotEmpty((String)storeId) && StringUtils.isNotEmpty((String)uuid)) {
            nodeReference = storeProtocol + "://" + storeId + "/" + uuid;
        }
        return nodeReference;
    }

    public static String getVersionLabel(NamedValue[] properties) {
        String[] versionLabelList = PropertiesUtils.getPropertyValues(properties, Constants.PROP_VERSION_LABEL);
        String versionLabel = "";
        if (versionLabelList != null && versionLabelList.length > 0) {
            versionLabel = versionLabelList[0];
        }
        return versionLabel;
    }

    public static String getMimeType(List<NamedValue> contentProperties) {
        if (contentProperties != null && contentProperties.size() > 0) {
            for (NamedValue contentProperty : contentProperties) {
                if (!Constants.PROP_CONTENT.equals(contentProperty.getName())) continue;
                String defaultContentPropertyValue = contentProperty.getValue();
                String[] contentSplitted = StringUtils.split((String)defaultContentPropertyValue, (String)PROP_CONTENT_SEP);
                if (contentSplitted.length > 1) {
                    String[] mimeTypeSplitted = StringUtils.split((String)contentSplitted[1], (String)PROP_MIMETYPE_SEP);
                    return mimeTypeSplitted[1];
                }
                return contentSplitted[0];
            }
        }
        return "";
    }

    public static Date getDatePropertyValue(NamedValue[] properties, String qname) throws ParseException {
        String dateString;
        String[] propertyValues;
        Date date = null;
        if (properties != null && properties.length > 0 && (propertyValues = PropertiesUtils.getPropertyValues(properties, qname)) != null && propertyValues.length > 0 && StringUtils.isNotEmpty((String)(dateString = propertyValues[0]))) {
            date = DateParser.parseISO8601Date((String)dateString);
        }
        return date;
    }
}

