/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.output.solr;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.manifoldcf.agents.interfaces.IOutputAddActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputCheckActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputNotifyActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputRemoveActivity;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.agents.output.BaseOutputConnector;
import org.apache.manifoldcf.agents.output.solr.HttpPoster;
import org.apache.manifoldcf.agents.output.solr.Messages;
import org.apache.manifoldcf.connectorcommon.interfaces.IKeystoreManager;
import org.apache.manifoldcf.connectorcommon.interfaces.KeystoreManagerFactory;
import org.apache.manifoldcf.core.interfaces.ConfigNode;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IDFactory;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.VersionContext;
import org.apache.manifoldcf.ui.util.Encoder;

public class SolrConnector
extends BaseOutputConnector {
    public static final String _rcsid = "@(#)$Id: SolrConnector.java 998081 2010-09-17 11:33:15Z kwright $";
    public static final String INGEST_ACTIVITY = "document ingest";
    public static final String REMOVE_ACTIVITY = "document deletion";
    protected HttpPoster poster = null;
    protected long expirationTime = -1L;
    protected String allowAttributeName = "allow_token_";
    protected String denyAttributeName = "deny_token_";
    protected Long maxDocumentLength = null;
    protected String includedMimeTypesString = null;
    protected Set<String> includedMimeTypes = null;
    protected String excludedMimeTypesString = null;
    protected Set<String> excludedMimeTypes = null;
    protected String idAttributeName = null;
    protected String originalSizeAttributeName = null;
    protected String modifiedDateAttributeName = null;
    protected String createdDateAttributeName = null;
    protected String indexedDateAttributeName = null;
    protected String fileNameAttributeName = null;
    protected String mimeTypeAttributeName = null;
    protected String contentAttributeName = null;
    protected boolean useExtractUpdateHandler = true;
    protected static final boolean allowCompression = true;
    protected boolean doCommits = false;
    protected String collectionName = null;
    protected static final long EXPIRATION_INTERVAL = 300000L;

    public String[] getActivitiesList() {
        return new String[]{INGEST_ACTIVITY, REMOVE_ACTIVITY};
    }

    public void connect(ConfigParams configParameters) {
        super.connect(configParameters);
    }

    public void poll() throws ManifoldCFException {
        if (this.poster != null && this.expirationTime <= System.currentTimeMillis()) {
            this.poster.shutdown();
            this.poster = null;
            this.expirationTime = -1L;
        }
    }

    public boolean isConnected() {
        return this.poster != null;
    }

    public void disconnect() throws ManifoldCFException {
        if (this.poster != null) {
            this.poster.shutdown();
            this.poster = null;
            this.expirationTime = -1L;
        }
        this.maxDocumentLength = null;
        this.includedMimeTypesString = null;
        this.includedMimeTypes = null;
        this.excludedMimeTypesString = null;
        this.excludedMimeTypes = null;
        this.idAttributeName = null;
        this.originalSizeAttributeName = null;
        this.modifiedDateAttributeName = null;
        this.createdDateAttributeName = null;
        this.indexedDateAttributeName = null;
        this.fileNameAttributeName = null;
        this.mimeTypeAttributeName = null;
        this.contentAttributeName = null;
        this.useExtractUpdateHandler = true;
        this.collectionName = null;
        super.disconnect();
    }

    protected void getSession() throws ManifoldCFException {
        if (this.poster == null) {
            String docMax;
            String useExtractUpdateHandlerValue;
            String statusPath;
            String removePath;
            String updatePath = this.params.getParameter("Server update handler");
            if (updatePath == null || updatePath.length() == 0) {
                updatePath = "";
            }
            if ((removePath = this.params.getParameter("Server remove handler")) == null || removePath.length() == 0) {
                removePath = "";
            }
            if ((statusPath = this.params.getParameter("Server status handler")) == null || statusPath.length() == 0) {
                statusPath = "";
            }
            this.idAttributeName = this.params.getParameter("Solr id field name");
            if (this.idAttributeName == null || this.idAttributeName.length() == 0) {
                this.idAttributeName = "id";
            }
            this.originalSizeAttributeName = this.params.getParameter("Solr original size field name");
            if (this.originalSizeAttributeName == null || this.originalSizeAttributeName.length() == 0) {
                this.originalSizeAttributeName = null;
            }
            this.modifiedDateAttributeName = this.params.getParameter("Solr modified date field name");
            if (this.modifiedDateAttributeName == null || this.modifiedDateAttributeName.length() == 0) {
                this.modifiedDateAttributeName = null;
            }
            this.createdDateAttributeName = this.params.getParameter("Solr created date field name");
            if (this.createdDateAttributeName == null || this.createdDateAttributeName.length() == 0) {
                this.createdDateAttributeName = null;
            }
            this.indexedDateAttributeName = this.params.getParameter("Solr indexed date field name");
            if (this.indexedDateAttributeName == null || this.indexedDateAttributeName.length() == 0) {
                this.indexedDateAttributeName = null;
            }
            this.fileNameAttributeName = this.params.getParameter("Solr filename field name");
            if (this.fileNameAttributeName == null || this.fileNameAttributeName.length() == 0) {
                this.fileNameAttributeName = null;
            }
            this.mimeTypeAttributeName = this.params.getParameter("Solr mime type field name");
            if (this.mimeTypeAttributeName == null || this.mimeTypeAttributeName.length() == 0) {
                this.mimeTypeAttributeName = null;
            }
            this.contentAttributeName = this.params.getParameter("Solr content field name");
            if (this.contentAttributeName == null || this.contentAttributeName.length() == 0) {
                this.contentAttributeName = null;
            }
            if ((useExtractUpdateHandlerValue = this.params.getParameter("Use extract update handler")) == null || useExtractUpdateHandlerValue.length() == 0) {
                this.useExtractUpdateHandler = true;
            } else {
                boolean bl = this.useExtractUpdateHandler = !useExtractUpdateHandlerValue.equals("false");
            }
            if (this.contentAttributeName == null && !this.useExtractUpdateHandler) {
                throw new ManifoldCFException("Content attribute name required for non-extract-update indexing");
            }
            String commits = this.params.getParameter("Commits");
            if (commits == null || commits.length() == 0) {
                commits = "true";
            }
            this.doCommits = commits.equals("true");
            String commitWithin = this.params.getParameter("Commit within");
            if (commitWithin == null || commitWithin.length() == 0) {
                commitWithin = null;
            }
            this.maxDocumentLength = (docMax = this.params.getParameter("Maximum document length")) == null || docMax.length() == 0 ? null : new Long(docMax);
            if (this.maxDocumentLength == null && !this.useExtractUpdateHandler) {
                throw new ManifoldCFException("Maximum document length required for non-extract-update indexing");
            }
            this.includedMimeTypesString = this.params.getParameter("Included mime types");
            if (this.includedMimeTypesString == null || this.includedMimeTypesString.length() == 0) {
                this.includedMimeTypesString = null;
                this.includedMimeTypes = null;
            } else {
                this.includedMimeTypes = SolrConnector.parseMimeTypes(this.includedMimeTypesString);
                if (this.includedMimeTypes.size() == 0) {
                    this.includedMimeTypesString = null;
                    this.includedMimeTypes = null;
                }
            }
            this.excludedMimeTypesString = this.params.getParameter("Excluded mime types");
            if (this.excludedMimeTypesString == null || this.excludedMimeTypesString.length() == 0) {
                this.excludedMimeTypesString = null;
                this.excludedMimeTypes = null;
            } else {
                this.excludedMimeTypes = SolrConnector.parseMimeTypes(this.excludedMimeTypesString);
                if (this.excludedMimeTypes.size() == 0) {
                    this.excludedMimeTypesString = null;
                    this.excludedMimeTypes = null;
                }
            }
            String solrType = this.params.getParameter("Solr type");
            if (solrType == null) {
                solrType = "standard";
            }
            if (solrType.equals("standard")) {
                String connectTimeoutString;
                String socketTimeoutString;
                String core;
                String webapp;
                String userID = this.params.getParameter("User ID");
                String password = this.params.getObfuscatedParameter("Password");
                String realm = this.params.getParameter("Realm");
                String keystoreData = this.params.getParameter("Keystore");
                IKeystoreManager keystoreManager = keystoreData != null ? KeystoreManagerFactory.make((String)"", (String)keystoreData) : null;
                String protocol = this.params.getParameter("Server protocol");
                if (protocol == null || protocol.length() == 0) {
                    throw new ManifoldCFException("Missing parameter: Server protocol");
                }
                String server = this.params.getParameter("Server name");
                if (server == null || server.length() == 0) {
                    throw new ManifoldCFException("Missing parameter: Server name");
                }
                String port = this.params.getParameter("Server port");
                if (port == null || port.length() == 0) {
                    port = "80";
                }
                if ((webapp = this.params.getParameter("Server web application")) != null && webapp.length() == 0) {
                    webapp = null;
                }
                if ((core = this.params.getParameter("Solr core name")) != null && core.length() == 0) {
                    core = "collection1";
                }
                if ((socketTimeoutString = this.params.getParameter("Socket timeout")) == null) {
                    socketTimeoutString = "900";
                }
                if ((connectTimeoutString = this.params.getParameter("Connection timeout")) == null) {
                    connectTimeoutString = "60";
                }
                this.collectionName = null;
                try {
                    int socketTimeout = Integer.parseInt(socketTimeoutString) * 1000;
                    int connectTimeout = Integer.parseInt(connectTimeoutString) * 1000;
                    this.poster = new HttpPoster(protocol, server, Integer.parseInt(port), webapp, core, connectTimeout, socketTimeout, updatePath, removePath, statusPath, realm, userID, password, this.allowAttributeName, this.denyAttributeName, this.idAttributeName, this.originalSizeAttributeName, this.modifiedDateAttributeName, this.createdDateAttributeName, this.indexedDateAttributeName, this.fileNameAttributeName, this.mimeTypeAttributeName, this.contentAttributeName, keystoreManager, this.maxDocumentLength, commitWithin, this.useExtractUpdateHandler, this.includedMimeTypes, this.excludedMimeTypes, true);
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException(e.getMessage());
                }
            } else if (solrType.equals("solrcloud")) {
                String zkConnectTimeoutString;
                StringBuilder zookeeperString = new StringBuilder();
                for (int i = 0; i < this.params.getChildCount(); ++i) {
                    ConfigNode cn = this.params.getChild(i);
                    if (!cn.getType().equals("zookeeper")) continue;
                    if (zookeeperString.length() > 0) {
                        zookeeperString.append(",");
                    }
                    zookeeperString.append(cn.getAttributeValue("host")).append(":").append(cn.getAttributeValue("port"));
                }
                String znodePath = this.params.getParameter("ZooKeeper znode path");
                if (znodePath == null) {
                    znodePath = "";
                }
                String zookeeperHost = zookeeperString.toString() + znodePath;
                String collection = this.params.getParameter("Collection");
                if (collection == null) {
                    collection = "collection1";
                }
                this.collectionName = collection;
                String zkClientTimeoutString = this.params.getParameter("ZooKeeper client timeout");
                if (zkClientTimeoutString == null) {
                    zkClientTimeoutString = "60";
                }
                if ((zkConnectTimeoutString = this.params.getParameter("ZooKeeper connect timeout")) == null) {
                    zkConnectTimeoutString = "60";
                }
                try {
                    int zkClientTimeout = Integer.parseInt(zkClientTimeoutString) * 1000;
                    int zkConnectTimeout = Integer.parseInt(zkConnectTimeoutString) * 1000;
                    this.poster = new HttpPoster(zookeeperHost, collection, zkClientTimeout, zkConnectTimeout, updatePath, removePath, statusPath, this.allowAttributeName, this.denyAttributeName, this.idAttributeName, this.originalSizeAttributeName, this.modifiedDateAttributeName, this.createdDateAttributeName, this.indexedDateAttributeName, this.fileNameAttributeName, this.mimeTypeAttributeName, this.contentAttributeName, this.maxDocumentLength, commitWithin, this.useExtractUpdateHandler, this.includedMimeTypes, this.excludedMimeTypes, true);
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException(e.getMessage());
                }
            } else {
                throw new ManifoldCFException("Illegal value for parameter 'Solr type': '" + solrType + "'");
            }
        }
        this.expirationTime = System.currentTimeMillis() + 300000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    protected static Set<String> parseMimeTypes(String mimeTypes) throws ManifoldCFException {
        HashSet<String> rval = new HashSet<String>();
        try (StringReader str = new StringReader(mimeTypes);){
            HashSet<String> hashSet;
            BufferedReader is = new BufferedReader(str);
            try {
                String nextString;
                while ((nextString = is.readLine()) != null) {
                    if (nextString.length() == 0) continue;
                    rval.add(nextString.toLowerCase(Locale.ROOT));
                }
                hashSet = rval;
            }
            catch (Throwable throwable) {
                is.close();
                throw throwable;
            }
            is.close();
            return hashSet;
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO error: " + e.getMessage(), (Throwable)e);
        }
    }

    public String check() throws ManifoldCFException {
        try {
            this.getSession();
            this.poster.checkPost();
            return super.check();
        }
        catch (ServiceInterruption e) {
            return "Transient error: " + e.getMessage();
        }
    }

    public VersionContext getPipelineDescription(Specification spec) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        SpecPacker sp = new SpecPacker(spec);
        return new VersionContext(sp.toPackedString(), this.params, spec);
    }

    public boolean checkMimeTypeIndexable(VersionContext outputDescription, String mimeType, IOutputCheckActivity activities) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        return HttpPoster.checkMimeTypeIndexable(mimeType, this.useExtractUpdateHandler, this.includedMimeTypes, this.excludedMimeTypes);
    }

    public boolean checkLengthIndexable(VersionContext outputDescription, long length, IOutputCheckActivity activities) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        return this.maxDocumentLength == null || length <= this.maxDocumentLength;
    }

    public int addOrReplaceDocumentWithException(String documentURI, VersionContext pipelineDescription, RepositoryDocument document, String authorityNameString, IOutputAddActivity activities) throws ManifoldCFException, ServiceInterruption, IOException {
        SpecPacker sp = new SpecPacker(pipelineDescription.getSpecification());
        this.getSession();
        if (this.poster.indexPost(documentURI, document, sp.getArgs(), authorityNameString, activities)) {
            return 0;
        }
        return 1;
    }

    public void removeDocument(String documentURI, String outputDescription, IOutputRemoveActivity activities) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        this.poster.deletePost(documentURI, activities);
    }

    public void noteJobComplete(IOutputNotifyActivity activities) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        if (this.doCommits) {
            this.poster.commitPost();
        }
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "SolrConnector.SolrType"));
        tabsArray.add(Messages.getString(locale, "SolrConnector.Server"));
        tabsArray.add(Messages.getString(locale, "SolrConnector.Zookeeper"));
        tabsArray.add(Messages.getString(locale, "SolrConnector.Paths"));
        tabsArray.add(Messages.getString(locale, "SolrConnector.Schema"));
        tabsArray.add(Messages.getString(locale, "SolrConnector.Arguments"));
        tabsArray.add(Messages.getString(locale, "SolrConnector.Documents"));
        tabsArray.add(Messages.getString(locale, "SolrConnector.Commits"));
        out.print("<script type=\"text/javascript\">\n<!--\nfunction SolrDeleteCertificate(aliasName)\n{\n  editconnection.solrkeystorealias.value = aliasName;\n  editconnection.configop.value = \"Delete\";\n  postForm();\n}\n\nfunction SolrAddCertificate()\n{\n  if (editconnection.solrcertificate.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.ChooseACertificateFile") + "\");\n    editconnection.solrcertificate.focus();\n  }\n  else\n  {\n    editconnection.configop.value = \"Add\";\n    postForm();\n  }\n}\n\nfunction checkConfig()\n{\n  if (editconnection.servername.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.PleaseSupplyAValidSolrServerName") + "\");\n    editconnection.servername.focus();\n    return false;\n  }\n  if (editconnection.serverport.value != \"\" && !isInteger(editconnection.serverport.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.SolrServerPortMustBeAValidInteger") + "\");\n    editconnection.serverport.focus();\n    return false;\n  }\n  if (editconnection.webappname.value != \"\" && editconnection.webappname.value.indexOf(\"/\") != -1)\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.WebApplicationNameCannotHaveCharacters") + "\");\n    editconnection.webappname.focus();\n    return false;\n  }\n  if (editconnection.core.value != \"\" && editconnection.core.value.indexOf(\"/\") != -1)\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.CoreNameCannotHaveCharacters") + "\");\n    editconnection.core.focus();\n    return false;\n  }\n  if (editconnection.webappname.value == \"\" && editconnection.core.value != \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.WebApplicationMustBeSpecifiedIfCoreIsSpecified") + "\");\n    editconnection.webappname.focus();\n    return false;\n  }\n  if (!isInteger(editconnection.connectiontimeout.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.ConnectionTimeoutMustBeInteger") + "\");\n    editconnection.connectiontimeout.focus();\n    return false;\n  }\n  if (!isInteger(editconnection.sockettimeout.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.SocketTimeoutMustBeInteger") + "\");\n    editconnection.sockettimeout.focus();\n    return false;\n  }\n  if (editconnection.updatepath.value != \"\" && editconnection.updatepath.value.substring(0,1) != \"/\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.UpdatePathMustStartWithACharacter") + "\");\n    editconnection.updatepath.focus();\n    return false;\n  }\n  if (editconnection.removepath.value != \"\" && editconnection.removepath.value.substring(0,1) != \"/\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.RemovePathMustStartWithACharacter") + "\");\n    editconnection.removepath.focus();\n    return false;\n  }\n  if (editconnection.statuspath.value != \"\" && editconnection.statuspath.value.substring(0,1) != \"/\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.StatusPathMustStartWithACharacter") + "\");\n    editconnection.statuspath.focus();\n    return false;\n  }\n  if (editconnection.maxdocumentlength.value != \"\" && !isInteger(editconnection.maxdocumentlength.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.MaximumDocumentLengthMustBAnInteger") + "\");\n    editconnection.maxdocumentlength.focus();\n    return false;\n  }\n  if (editconnection.commitwithin.value != \"\" && !isInteger(editconnection.commitwithin.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.CommitWithinValueMustBeAnInteger") + "\");\n    editconnection.commitwithin.focus();\n    return false;\n  }\n  if (editconnection.znodepath.value != \"\" && editconnection.znodepath.value.substring(0,1) != \"/\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.ZnodePathMustStartWithACharacter") + "\");\n    editconnection.znodepath.focus();\n    return false;\n  }\n  return true;\n}\n\nfunction checkConfigForSave()\n{\n  if (editconnection.servername.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.PleaseSupplyAValidSolrServerName") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.Server") + "\");\n    editconnection.servername.focus();\n    return false;\n  }\n  if (editconnection.serverport.value != \"\" && !isInteger(editconnection.serverport.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.SolrServerPortMustBeAValidInteger") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.Server") + "\");\n    editconnection.serverport.focus();\n    return false;\n  }\n  if (editconnection.webappname.value != \"\" && editconnection.webappname.value.indexOf(\"/\") != -1)\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.WebApplicationNameCannotHaveCharacters") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.Server") + "\");\n    editconnection.webappname.focus();\n    return false;\n  }\n  if (editconnection.core.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.PleaseSupplySolrCoreName") + "\");\n    editconnection.core.focus();\n    return false;\n  }\n  if (editconnection.core.value != \"\" && editconnection.core.value.indexOf(\"/\") != -1)\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.CoreNameCannotHaveCharacters") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.Server") + "\");\n    editconnection.core.focus();\n    return false;\n  }\n  if (editconnection.webappname.value == \"\" && editconnection.core.value != \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.WebApplicationMustBeSpecifiedIfCoreIsSpecified") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.Server") + "\");\n    editconnection.webappname.focus();\n    return false;\n  }\n  if (!isInteger(editconnection.connectiontimeout.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.ConnectionTimeoutMustBeInteger") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.Server") + "\");\n    editconnection.connectiontimeout.focus();\n    return false;\n  }\n  if (!isInteger(editconnection.sockettimeout.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.SocketTimeoutMustBeInteger") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.Server") + "\");\n    editconnection.sockettimeout.focus();\n    return false;\n  }\n  if (editconnection.updatepath.value != \"\" && editconnection.updatepath.value.substring(0,1) != \"/\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.UpdatePathMustStartWithACharacter") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.Paths") + "\");\n    editconnection.updatepath.focus();\n    return false;\n  }\n  if (editconnection.removepath.value != \"\" && editconnection.removepath.value.substring(0,1) != \"/\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.RemovePathMustStartWithACharacter") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.Paths") + "\");\n    editconnection.removepath.focus();\n    return false;\n  }\n  if (editconnection.statuspath.value != \"\" && editconnection.statuspath.value.substring(0,1) != \"/\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.StatusPathMustStartWithACharacter") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.Paths") + "\");\n    editconnection.statuspath.focus();\n    return false;\n  }\n  if (editconnection.maxdocumentlength.value != \"\" && !isInteger(editconnection.maxdocumentlength.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.MaximumDocumentLengthMustBeAnInteger") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.Documents") + "\");\n    editconnection.maxdocumentlength.focus();\n    return false;\n  }\n  if (editconnection.maxdocumentlength.value == \"\" && ((editconnection.extractupdatecheckbox.value == \"true\" && editconnection.extractupdate.checked == false) || (editconnection.extractupdatecheckbox.value != \"true\" && editconnection.extractupdate.value != \"true\")))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.MaximumDocumentLengthRequiredUnlessExtractingUpdateHandler") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.Documents") + "\");\n    editconnection.maxdocumentlength.focus();\n    return false;\n  }\n  if (editconnection.contentfield.value == \"\" && ((editconnection.extractupdatecheckbox.value == \"true\" && editconnection.extractupdate.checked == false) || (editconnection.extractupdatecheckbox.value != \"true\" && editconnection.extractupdate.value != \"true\")))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.ContentFieldNameRequiredUnlessExtractingUpdateHandler") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.Schema") + "\");\n    editconnection.contentfield.focus();\n    return false;\n  }\n  if (editconnection.commitwithin.value != \"\" && !isInteger(editconnection.commitwithin.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.CommitWithinValueMustBeAnInteger") + "\");\n    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.Commits") + "\");\n    editconnection.commitwithin.focus();\n    return false;\n  }\n  if (editconnection.znodepath.value != \"\" && editconnection.znodepath.value.substring(0,1) != \"/\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.ZnodePathMustStartWithACharacter") + "\");\n    editconnection.znodepath.focus();\n    return false;\n  }\n  return true;\n}\n\nfunction deleteZookeeperHost(i)\n{\n  // Set the operation\n  eval(\"editconnection.op_zookeeper_\"+i+\".value=\\\"Delete\\\"\");\n  // Submit\n  if (editconnection.count_zookeeper.value==i)\n    postFormSetAnchor(\"zookeeper\");\n  else\n    postFormSetAnchor(\"zookeeper_\"+i)\n  // Undo, so we won't get two deletes next time\n  eval(\"editconnection.op_zookeeper_\"+i+\".value=\\\"Continue\\\"\");\n}\n\nfunction addZookeeperHost()\n{\n  if (editconnection.host_zookeeper.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.ZookeeperHostCannotBeNull") + "\");\n    editconnection.host_zookeeper.focus();\n    return;\n  }\n  if (editconnection.port_zookeeper.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.ZookeeperPortCannotBeNull") + "\");\n    editconnection.port_zookeeper.focus();\n    return;\n  }\n  if (!isInteger(editconnection.port_zookeeper.value))\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.ZookeeperPortMustBeAnInteger") + "\");\n    editconnection.port_zookeeper.focus();\n    return;\n  }\n  editconnection.op_zookeeper.value=\"Add\";\n  postFormSetAnchor(\"zookeeper\");\n}\n\nfunction deleteArgument(i)\n{\n  // Set the operation\n  eval(\"editconnection.argument_\"+i+\"_op.value=\\\"Delete\\\"\");\n  // Submit\n  if (editconnection.argument_count.value==i)\n    postFormSetAnchor(\"argument\");\n  else\n    postFormSetAnchor(\"argument_\"+i)\n  // Undo, so we won't get two deletes next time\n  eval(\"editconnection.argument_\"+i+\"_op.value=\\\"Continue\\\"\");\n}\n\nfunction addArgument()\n{\n  if (editconnection.argument_name.value == \"\")\n  {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "SolrConnector.ArgumentNameCannotBeAnEmptyString") + "\");\n    editconnection.argument_name.focus();\n    return;\n  }\n  editconnection.argument_op.value=\"Add\";\n  postFormSetAnchor(\"argument\");\n}\n\n//-->\n</script>\n");
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        String postfix;
        String zkport;
        String host;
        ConfigNode cn;
        int k;
        int i;
        String excludedMimeTypes;
        String includedMimeTypes;
        String solrKeystore;
        String commitWithin;
        String password;
        String userID;
        String realm;
        String useExtractUpdate;
        String contentField;
        String mimeTypeField;
        String fileNameField;
        String indexedDateField;
        String createdDateField;
        String modifiedDateField;
        String originalSizeField;
        String idField;
        String statusPath;
        String removePath;
        String updatePath;
        String zkConnectTimeout;
        String zkClientTimeout;
        String socketTimeout;
        String connectionTimeout;
        String collection;
        String znodePath;
        String core;
        String webapp;
        String port;
        String server;
        String protocol;
        String type = parameters.getParameter("Solr type");
        if (type == null) {
            type = "standard";
        }
        if ((protocol = parameters.getParameter("Server protocol")) == null) {
            protocol = "http";
        }
        if ((server = parameters.getParameter("Server name")) == null) {
            server = "localhost";
        }
        if ((port = parameters.getParameter("Server port")) == null) {
            port = "8983";
        }
        if ((webapp = parameters.getParameter("Server web application")) == null) {
            webapp = "solr";
        }
        if ((core = parameters.getParameter("Solr core name")) == null) {
            core = "collection1";
        }
        if ((znodePath = parameters.getParameter("ZooKeeper znode path")) == null) {
            znodePath = "";
        }
        if ((collection = parameters.getParameter("Collection")) == null) {
            collection = "collection1";
        }
        if ((connectionTimeout = parameters.getParameter("Connection timeout")) == null) {
            connectionTimeout = "60";
        }
        if ((socketTimeout = parameters.getParameter("Socket timeout")) == null) {
            socketTimeout = "900";
        }
        if ((zkClientTimeout = parameters.getParameter("ZooKeeper client timeout")) == null) {
            zkClientTimeout = "60";
        }
        if ((zkConnectTimeout = parameters.getParameter("ZooKeeper connect timeout")) == null) {
            zkConnectTimeout = "60";
        }
        if ((updatePath = parameters.getParameter("Server update handler")) == null) {
            updatePath = "/update/extract";
        }
        if ((removePath = parameters.getParameter("Server remove handler")) == null) {
            removePath = "/update";
        }
        if ((statusPath = parameters.getParameter("Server status handler")) == null) {
            statusPath = "/admin/ping";
        }
        if ((idField = parameters.getParameter("Solr id field name")) == null) {
            idField = "id";
        }
        if ((originalSizeField = parameters.getParameter("Solr original size field name")) == null) {
            originalSizeField = "";
        }
        if ((modifiedDateField = parameters.getParameter("Solr modified date field name")) == null) {
            modifiedDateField = "";
        }
        if ((createdDateField = parameters.getParameter("Solr created date field name")) == null) {
            createdDateField = "";
        }
        if ((indexedDateField = parameters.getParameter("Solr indexed date field name")) == null) {
            indexedDateField = "";
        }
        if ((fileNameField = parameters.getParameter("Solr filename field name")) == null) {
            fileNameField = "";
        }
        if ((mimeTypeField = parameters.getParameter("Solr mime type field name")) == null) {
            mimeTypeField = "";
        }
        if ((contentField = parameters.getParameter("Solr content field name")) == null) {
            contentField = "";
        }
        if ((useExtractUpdate = parameters.getParameter("Use extract update handler")) == null || useExtractUpdate.length() == 0) {
            useExtractUpdate = "true";
        }
        if ((realm = parameters.getParameter("Realm")) == null) {
            realm = "";
        }
        if ((userID = parameters.getParameter("User ID")) == null) {
            userID = "";
        }
        password = (password = parameters.getObfuscatedParameter("Password")) == null ? "" : out.mapPasswordToKey(password);
        String commits = parameters.getParameter("Commits");
        if (commits == null) {
            commits = "true";
        }
        if ((commitWithin = parameters.getParameter("Commit within")) == null) {
            commitWithin = "";
        }
        IKeystoreManager localKeystore = (solrKeystore = parameters.getParameter("Keystore")) == null ? KeystoreManagerFactory.make((String)"") : KeystoreManagerFactory.make((String)"", (String)solrKeystore);
        String maxLength = parameters.getParameter("Maximum document length");
        if (maxLength == null) {
            maxLength = "";
        }
        if ((includedMimeTypes = parameters.getParameter("Included mime types")) == null) {
            includedMimeTypes = "";
        }
        if ((excludedMimeTypes = parameters.getParameter("Excluded mime types")) == null) {
            excludedMimeTypes = "";
        }
        if (tabName.equals(Messages.getString(locale, "SolrConnector.SolrType"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td colspan=\"2\" class=\"separator\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.SolrType2") + "</nobr></td>\n    <td class=\"value\">\n      <select name=\"solrtype\">\n        <option value=\"" + "standard" + "\"" + (type.equals("standard") ? " selected=\"true\"" : "") + ">" + Messages.getBodyString(locale, "SolrConnector.SingleServer") + "</option>\n        <option value=\"" + "solrcloud" + "\"" + (type.equals("solrcloud") ? " selected=\"true\"" : "") + ">" + Messages.getBodyString(locale, "SolrConnector.SolrCloud") + "</option>\n      </select>\n    </td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"solrtype\" value=\"" + Encoder.attributeEscape((String)type) + "\"/>\n");
        }
        if (solrKeystore != null) {
            out.print("<input type=\"hidden\" name=\"keystoredata\" value=\"" + Encoder.attributeEscape((String)solrKeystore) + "\"/>\n");
        }
        out.print("<input name=\"configop\" type=\"hidden\" value=\"Continue\"/>\n");
        if (tabName.equals(Messages.getString(locale, "SolrConnector.Server"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td colspan=\"2\" class=\"separator\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.Protocol") + "</nobr></td>\n    <td class=\"value\">\n      <select name=\"serverprotocol\">\n        <option value=\"" + "http" + "\"" + (protocol.equals("http") ? " selected=\"true\"" : "") + ">http</option>\n        <option value=\"" + "https" + "\"" + (protocol.equals("https") ? " selected=\"true\"" : "") + ">https</option>\n      </select>\n    </td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.ServerName") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"servername\" type=\"text\" size=\"32\" value=\"" + Encoder.attributeEscape((String)server) + "\"/>\n    </td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.Port") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"serverport\" type=\"text\" size=\"5\" value=\"" + Encoder.attributeEscape((String)port) + "\"/>\n    </td>\n  </tr>\n  <tr><td colspan=\"2\" class=\"separator\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.WebApplicationName") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"webappname\" type=\"text\" size=\"16\" value=\"" + Encoder.attributeEscape((String)webapp) + "\"/>\n    </td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.CoreName") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"core\" type=\"text\" size=\"16\" value=\"" + Encoder.attributeEscape((String)core) + "\"/>\n    </td>\n  </tr>\n  <tr><td colspan=\"2\" class=\"separator\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.ConnectionTimeout") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"connectiontimeout\" type=\"text\" size=\"5\" value=\"" + Encoder.attributeEscape((String)connectionTimeout) + "\"/>\n    </td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.SocketTimeout") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"sockettimeout\" type=\"text\" size=\"5\" value=\"" + Encoder.attributeEscape((String)socketTimeout) + "\"/>\n    </td>\n  </tr>\n  <tr><td colspan=\"2\" class=\"separator\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.Realm") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"realm\" type=\"text\" size=\"32\" value=\"" + Encoder.attributeEscape((String)realm) + "\"/>\n    </td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.UserID") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"userid\" type=\"text\" size=\"32\" value=\"" + Encoder.attributeEscape((String)userID) + "\"/>\n    </td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.Password") + "</nobr></td>\n    <td class=\"value\">\n      <input type=\"password\" size=\"32\" name=\"password\" value=\"" + Encoder.attributeEscape((String)password) + "\"/>\n    </td>\n  </tr>\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.SSLTrustCertificateList") + "</nobr></td>\n    <td class=\"value\">\n      <input type=\"hidden\" name=\"solrkeystorealias\" value=\"\"/>\n      <table class=\"displaytable\">\n");
            String[] contents = localKeystore.getContents();
            if (contents.length == 0) {
                out.print("        <tr><td class=\"message\" colspan=\"2\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.NoCertificatesPresent") + "</nobr></td></tr>\n");
            } else {
                for (i = 0; i < contents.length; ++i) {
                    String alias = contents[i];
                    String description = localKeystore.getDescription(alias);
                    if (description.length() > 128) {
                        description = description.substring(0, 125) + "...";
                    }
                    out.print("        <tr>\n          <td class=\"value\"><input type=\"button\" onclick='Javascript:SolrDeleteCertificate(\"" + Encoder.attributeJavascriptEscape((String)alias) + "\")' alt=\"" + Messages.getAttributeString(locale, "SolrConnector.DeleteCert") + " " + Encoder.attributeEscape((String)alias) + "\" value=\"Delete\"/></td>\n          <td>" + Encoder.bodyEscape((String)description) + "</td>\n        </tr>\n");
                }
            }
            out.print("      </table>\n      <input type=\"button\" onclick='Javascript:SolrAddCertificate()' alt=\"" + Messages.getAttributeString(locale, "SolrConnector.AddCert") + "\" value=\"" + Messages.getAttributeString(locale, "SolrConnector.Add") + "\"/>&nbsp;\n      " + Messages.getBodyString(locale, "SolrConnector.Certificate") + "&nbsp;<input name=\"solrcertificate\" size=\"50\" type=\"file\"/>\n    </td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"serverprotocol\" value=\"" + Encoder.attributeEscape((String)protocol) + "\"/>\n<input type=\"hidden\" name=\"servername\" value=\"" + Encoder.attributeEscape((String)server) + "\"/>\n<input type=\"hidden\" name=\"serverport\" value=\"" + Encoder.attributeEscape((String)port) + "\"/>\n<input type=\"hidden\" name=\"webappname\" value=\"" + Encoder.attributeEscape((String)webapp) + "\"/>\n<input type=\"hidden\" name=\"core\" value=\"" + Encoder.attributeEscape((String)core) + "\"/>\n<input type=\"hidden\" name=\"connectiontimeout\" value=\"" + Encoder.attributeEscape((String)connectionTimeout) + "\"/>\n<input type=\"hidden\" name=\"sockettimeout\" value=\"" + Encoder.attributeEscape((String)socketTimeout) + "\"/>\n<input type=\"hidden\" name=\"realm\" value=\"" + Encoder.attributeEscape((String)realm) + "\"/>\n<input type=\"hidden\" name=\"userid\" value=\"" + Encoder.attributeEscape((String)userID) + "\"/>\n<input type=\"hidden\" name=\"password\" value=\"" + Encoder.attributeEscape((String)password) + "\"/>\n");
        }
        if (tabName.equals(Messages.getString(locale, "SolrConnector.Zookeeper"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.ZookeeperHosts") + "</nobr></td>\n    <td class=\"boxcell\">\n      <table class=\"formtable\">\n        <tr class=\"formheaderrow\">\n          <td class=\"formcolumnheader\"></td>\n          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.Host") + "</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.Port") + "</nobr></td>\n        </tr>\n");
            k = 0;
            for (i = 0; i < parameters.getChildCount(); ++i) {
                cn = parameters.getChild(i);
                if (!cn.getType().equals("zookeeper")) continue;
                host = cn.getAttributeValue("host");
                zkport = cn.getAttributeValue("port");
                postfix = "zookeeper_" + k;
                out.print("        <tr class=\"" + (k % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n          <td class=\"formcolumncell\">\n            <a name=\"" + postfix + "\">\n              <input type=\"button\" value=\"" + Messages.getAttributeString(locale, "SolrConnector.Delete") + "\" alt=\"" + Messages.getAttributeString(locale, "SolrConnector.DeleteZookeeperHost") + Integer.toString(k + 1) + "\" onclick='javascript:deleteZookeeperHost(" + Integer.toString(k) + ");'/>\n              <input type=\"hidden\" name=\"op_" + postfix + "\" value=\"Continue\"/>\n              <input type=\"hidden\" name=\"host_" + postfix + "\" value=\"" + Encoder.attributeEscape((String)host) + "\"/>\n              <input type=\"hidden\" name=\"port_" + postfix + "\" value=\"" + Encoder.attributeEscape((String)zkport) + "\"/>\n            </a>\n          </td>\n          <td class=\"formcolumncell\">\n            <nobr>" + Encoder.bodyEscape((String)host) + "</nobr>\n          </td>\n          <td class=\"formcolumncell\">\n            <nobr>" + Encoder.bodyEscape((String)zkport) + "</nobr>\n          </td>\n        </tr>\n");
                ++k;
            }
            if (parameters.getChildCount() == 0) {
                String postfix2 = "zookeeper_" + k;
                out.print("        <tr class=\"" + (k % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n          <td class=\"formcolumncell\">\n            <a name=\"" + postfix2 + "\">\n              <input type=\"button\" value=\"" + Messages.getAttributeString(locale, "SolrConnector.Delete") + "\" alt=\"" + Messages.getAttributeString(locale, "SolrConnector.DeleteZookeeperHost") + Integer.toString(k + 1) + "\" onclick='javascript:deleteZookeeperHost(" + Integer.toString(k) + ");'/>\n              <input type=\"hidden\" name=\"op_" + postfix2 + "\" value=\"Continue\"/>\n              <input type=\"hidden\" name=\"host_" + postfix2 + "\" value=\"localhost\"/>\n              <input type=\"hidden\" name=\"port_" + postfix2 + "\" value=\"2181\"/>\n            </a>\n          </td>\n          <td class=\"formcolumncell\">\n            <nobr>localhost</nobr>\n          </td>\n          <td class=\"formcolumncell\">\n            <nobr>2181</nobr>\n          </td>\n        </tr>\n");
                ++k;
            }
            if (k == 0) {
                out.print("        <tr class=\"formrow\"><td class=\"formmessage\" colspan=\"3\">" + Messages.getBodyString(locale, "SolrConnector.NoZookeeperHostsSpecified") + "</td></tr>\n");
            }
            out.print("        <tr class=\"formrow\"><td class=\"formseparator\" colspan=\"3\"><hr/></td></tr>\n        <tr class=\"formrow\">\n          <td class=\"formcolumncell\">\n            <a name=\"zookeeper\">\n              <input type=\"button\" value=\"" + Messages.getAttributeString(locale, "SolrConnector.Add") + "\" alt=\"" + Messages.getAttributeString(locale, "SolrConnector.AddZookeeperHost") + "\" onclick=\"javascript:addZookeeperHost();\"/>\n            </a>\n            <input type=\"hidden\" name=\"count_zookeeper\" value=\"" + k + "\"/>\n            <input type=\"hidden\" name=\"op_zookeeper\" value=\"Continue\"/>\n          </td>\n          <td class=\"formcolumncell\">\n            <nobr><input type=\"text\" size=\"30\" name=\"host_zookeeper\" value=\"\"/></nobr>\n          </td>\n          <td class=\"formcolumncell\">\n            <nobr><input type=\"text\" size=\"5\" name=\"port_zookeeper\" value=\"\"/></nobr>\n          </td>\n        </tr>\n      </table>\n    </td>\n  </tr>\n  <tr><td colspan=\"2\" class=\"separator\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.ZnodePath") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"znodepath\" type=\"text\" size=\"16\" value=\"" + Encoder.attributeEscape((String)znodePath) + "\"/>\n    </td>\n  </tr>\n  <tr><td colspan=\"2\" class=\"separator\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.CollectionName") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"collection\" type=\"text\" size=\"16\" value=\"" + Encoder.attributeEscape((String)collection) + "\"/>\n    </td>\n  </tr>\n  <tr><td colspan=\"2\" class=\"separator\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.ZookeeperClientTimeout") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"zkclienttimeout\" type=\"text\" size=\"5\" value=\"" + Encoder.attributeEscape((String)zkClientTimeout) + "\"/>\n    </td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.ZookeeperConnectTimeout") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"zkconnecttimeout\" type=\"text\" size=\"5\" value=\"" + Encoder.attributeEscape((String)zkConnectTimeout) + "\"/>\n    </td>\n  </tr>\n</table>\n");
        } else {
            k = 0;
            for (i = 0; i < parameters.getChildCount(); ++i) {
                cn = parameters.getChild(i);
                if (!cn.getType().equals("zookeeper")) continue;
                host = cn.getAttributeValue("host");
                zkport = cn.getAttributeValue("port");
                postfix = "zookeeper_" + k;
                out.print("<input type=\"hidden\" name=\"host_" + postfix + "\" value=\"" + Encoder.attributeEscape((String)host) + "\"/>\n<input type=\"hidden\" name=\"port_" + postfix + "\" value=\"" + Encoder.attributeEscape((String)zkport) + "\"/>\n");
                ++k;
            }
            if (parameters.getChildCount() == 0) {
                String postfix3 = "zookeeper_" + k;
                out.print("<input type=\"hidden\" name=\"host_" + postfix3 + "\" value=\"localhost\"/>\n<input type=\"hidden\" name=\"port_" + postfix3 + "\" value=\"2181\"/>\n");
                ++k;
            }
            out.print("<input type=\"hidden\" name=\"count_zookeeper\" value=\"" + k + "\"/>\n<input type=\"hidden\" name=\"znodepath\" value=\"" + znodePath + "\"/>\n<input type=\"hidden\" name=\"collection\" value=\"" + collection + "\"/>\n<input type=\"hidden\" name=\"zkclienttimeout\" value=\"" + zkClientTimeout + "\"/>\n<input type=\"hidden\" name=\"zkconnecttimeout\" value=\"" + zkConnectTimeout + "\"/>\n");
        }
        if (tabName.equals(Messages.getString(locale, "SolrConnector.Paths"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td colspan=\"2\" class=\"separator\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.UpdateHandler") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"updatepath\" type=\"text\" size=\"32\" value=\"" + Encoder.attributeEscape((String)updatePath) + "\"/>\n    </td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.RemoveHandler") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"removepath\" type=\"text\" size=\"32\" value=\"" + Encoder.attributeEscape((String)removePath) + "\"/>\n    </td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.StatusHandler") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"statuspath\" type=\"text\" size=\"32\" value=\"" + Encoder.attributeEscape((String)statusPath) + "\"/>\n    </td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"updatepath\" value=\"" + Encoder.attributeEscape((String)updatePath) + "\"/>\n<input type=\"hidden\" name=\"removepath\" value=\"" + Encoder.attributeEscape((String)removePath) + "\"/>\n<input type=\"hidden\" name=\"statuspath\" value=\"" + Encoder.attributeEscape((String)statusPath) + "\"/>\n");
        }
        if (tabName.equals(Messages.getString(locale, "SolrConnector.Schema"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td colspan=\"2\" class=\"separator\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.IDFieldName") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"idfield\" type=\"text\" size=\"32\" value=\"" + Encoder.attributeEscape((String)idField) + "\"/>\n    </td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.OriginalSizeFieldName") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"originalsizefield\" type=\"text\" size=\"32\" value=\"" + Encoder.attributeEscape((String)originalSizeField) + "\"/>\n    </td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.ModifiedDateFieldName") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"modifieddatefield\" type=\"text\" size=\"32\" value=\"" + Encoder.attributeEscape((String)modifiedDateField) + "\"/>\n    </td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.CreatedDateFieldName") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"createddatefield\" type=\"text\" size=\"32\" value=\"" + Encoder.attributeEscape((String)createdDateField) + "\"/>\n    </td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.IndexedDateFieldName") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"indexeddatefield\" type=\"text\" size=\"32\" value=\"" + Encoder.attributeEscape((String)indexedDateField) + "\"/>\n    </td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.FileNameFieldName") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"filenamefield\" type=\"text\" size=\"32\" value=\"" + Encoder.attributeEscape((String)fileNameField) + "\"/>\n    </td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.MimeTypeFieldName") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"mimetypefield\" type=\"text\" size=\"32\" value=\"" + Encoder.attributeEscape((String)mimeTypeField) + "\"/>\n    </td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.UseExtractUpdateHandler") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"extractupdatecheckbox\" type=\"hidden\" value=\"true\"/>\n      <input name=\"extractupdatepresent\" type=\"hidden\" value=\"true\"/>\n");
            if (!useExtractUpdate.equals("false")) {
                out.print("      <input name=\"extractupdate\" type=\"checkbox\" value=\"true\" checked=\"true\"/>\n");
            } else {
                out.print("      <input name=\"extractupdate\" type=\"checkbox\" value=\"true\"/>\n");
            }
            out.print("    </td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.ContentFieldName") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"contentfield\" type=\"text\" size=\"32\" value=\"" + Encoder.attributeEscape((String)contentField) + "\"/>\n    </td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"idfield\" value=\"" + Encoder.attributeEscape((String)idField) + "\"/>\n<input type=\"hidden\" name=\"originalsizefield\" value=\"" + Encoder.attributeEscape((String)originalSizeField) + "\"/>\n<input type=\"hidden\" name=\"modifieddatefield\" value=\"" + Encoder.attributeEscape((String)modifiedDateField) + "\"/>\n<input type=\"hidden\" name=\"createddatefield\" value=\"" + Encoder.attributeEscape((String)createdDateField) + "\"/>\n<input type=\"hidden\" name=\"indexeddatefield\" value=\"" + Encoder.attributeEscape((String)indexedDateField) + "\"/>\n<input type=\"hidden\" name=\"filenamefield\" value=\"" + Encoder.attributeEscape((String)fileNameField) + "\"/>\n<input type=\"hidden\" name=\"mimetypefield\" value=\"" + Encoder.attributeEscape((String)mimeTypeField) + "\"/>\n<input type=\"hidden\" name=\"contentfield\" value=\"" + Encoder.attributeEscape((String)contentField) + "\"/>\n<input name=\"extractupdatecheckbox\" type=\"hidden\" value=\"false\"/>\n<input type=\"hidden\" name=\"extractupdate\" value=\"" + Encoder.attributeEscape((String)useExtractUpdate) + "\"/>\n<input name=\"extractupdatepresent\" type=\"hidden\" value=\"true\"/>\n");
        }
        if (tabName.equals(Messages.getString(locale, "SolrConnector.Documents"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td colspan=\"2\" class=\"separator\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.MaximumDocumentLength") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"maxdocumentlength\" type=\"text\" size=\"16\" value=\"" + Encoder.attributeEscape((String)maxLength) + "\"/>\n    </td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.IncludedMimeTypes") + "</nobr></td>\n    <td class=\"value\">\n      <textarea rows=\"10\" cols=\"20\" name=\"includedmimetypes\">" + Encoder.bodyEscape((String)includedMimeTypes) + "</textarea>\n    </td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.ExcludedMimeTypes") + "</nobr></td>\n    <td class=\"value\">\n      <textarea rows=\"10\" cols=\"20\" name=\"excludedmimetypes\">" + Encoder.bodyEscape((String)excludedMimeTypes) + "</textarea>\n    </td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"maxdocumentlength\" value=\"" + Encoder.attributeEscape((String)maxLength) + "\"/>\n<input type=\"hidden\" name=\"includedmimetypes\" value=\"" + Encoder.attributeEscape((String)includedMimeTypes) + "\"/>\n<input type=\"hidden\" name=\"excludedmimetypes\" value=\"" + Encoder.attributeEscape((String)excludedMimeTypes) + "\"/>\n");
        }
        if (tabName.equals(Messages.getString(locale, "SolrConnector.Commits"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td colspan=\"2\" class=\"separator\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.CommitAtEndOfEveryJob") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"commits_present\" type=\"hidden\" value=\"true\"/>\n      <input name=\"commits\" type=\"checkbox\" value=\"true\"" + (commits.equals("true") ? " checked=\"yes\"" : "") + "/>\n    </td>\n  </tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.CommitEachDocumentWithin") + "</nobr></td>\n    <td class=\"value\">\n      <input name=\"commitwithin\" type=\"text\" size=\"16\" value=\"" + commitWithin + "\"/>\n    </td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"commits_present\" value=\"true\"/>\n<input name=\"commits\" type=\"hidden\" value=\"" + commits + "\"/>\n<input name=\"commitwithin\" type=\"hidden\" value=\"" + commitWithin + "\"/>\n");
        }
        HashMap<String, ArrayList<String>> argumentMap = new HashMap<String, ArrayList<String>>();
        int i2 = 0;
        while (i2 < parameters.getChildCount()) {
            ConfigNode sn;
            if (!(sn = parameters.getChild(i2++)).getType().equals("argument")) continue;
            String name = sn.getAttributeValue("name");
            String value = sn.getAttributeValue("value");
            ArrayList<String> values = (ArrayList<String>)argumentMap.get(name);
            if (values == null) {
                values = new ArrayList<String>();
                argumentMap.put(name, values);
            }
            values.add(value);
        }
        if (tabName.equals(Messages.getString(locale, "SolrConnector.Arguments"))) {
            Object[] sortArray = new String[argumentMap.size()];
            i2 = 0;
            Iterator iter = argumentMap.keySet().iterator();
            while (iter.hasNext()) {
                sortArray[i2++] = (String)iter.next();
            }
            Arrays.sort(sortArray);
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.Arguments2") + "</nobr></td>\n    <td class=\"boxcell\">\n      <table class=\"formtable\">\n        <tr class=\"formheaderrow\">\n          <td class=\"formcolumnheader\"></td>\n          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.Name") + "</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.Value") + "</nobr></td>\n        </tr>\n");
            i2 = 0;
            int k2 = 0;
            while (k2 < sortArray.length) {
                Object name = sortArray[k2++];
                ArrayList values = (ArrayList)argumentMap.get(name);
                int j = 0;
                while (j < values.size()) {
                    String value = (String)values.get(j++);
                    String prefix = "argument_" + Integer.toString(i2);
                    out.print("        <tr class=\"" + (i2 % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n          <td class=\"formcolumncell\">\n            <a name=\"" + prefix + "\"><input type=\"button\" value=\"Delete\" alt=\"" + Messages.getAttributeString(locale, "SolrConnector.DeleteArgument") + " " + Integer.toString(i2 + 1) + "\" onclick=\"javascript:deleteArgument(" + Integer.toString(i2) + ");\"/>\n              <input type=\"hidden\" name=\"" + prefix + "_op\" value=\"Continue\"/>\n              <input type=\"hidden\" name=\"" + prefix + "_name\" value=\"" + Encoder.attributeEscape((String)name) + "\"/>\n            </a>\n          </td>\n          <td class=\"formcolumncell\">\n            <nobr>" + Encoder.bodyEscape((String)name) + "</nobr>\n          </td>\n          <td class=\"formcolumncell\">\n            <nobr><input type=\"text\" size=\"30\" name=\"" + prefix + "_value\" value=\"" + Encoder.attributeEscape((String)value) + "\"</nobr>\n          </td>\n        </tr>\n");
                    ++i2;
                }
            }
            if (i2 == 0) {
                out.print("        <tr class=\"formrow\"><td class=\"formmessage\" colspan=\"3\">" + Messages.getBodyString(locale, "SolrConnector.NoArgumentsSpecified") + "</td></tr>\n");
            }
            out.print("        <tr class=\"formrow\"><td class=\"formseparator\" colspan=\"3\"><hr/></td></tr>\n        <tr class=\"formrow\">\n          <td class=\"formcolumncell\">\n            <a name=\"argument\"><input type=\"button\" value=\"Add\" alt=\"Add argument\" onclick=\"javascript:addArgument();\"/>\n              <input type=\"hidden\" name=\"argument_count\" value=\"" + Integer.toString(i2) + "\"/>\n              <input type=\"hidden\" name=\"argument_op\" value=\"Continue\"/>\n            </a>\n          </td>\n          <td class=\"formcolumncell\">\n            <nobr><input type=\"text\" size=\"30\" name=\"argument_name\" value=\"\"/></nobr>\n          </td>\n          <td class=\"formcolumncell\">\n            <nobr><input type=\"text\" size=\"30\" name=\"argument_value\" value=\"\"/></nobr>\n          </td>\n        </tr>\n      </table>\n    </td>\n  </tr>\n</table>\n");
        } else {
            i2 = 0;
            for (String name : argumentMap.keySet()) {
                ArrayList values = (ArrayList)argumentMap.get(name);
                int j = 0;
                while (j < values.size()) {
                    String value = (String)values.get(j++);
                    String prefix = "argument_" + Integer.toString(i2++);
                    out.print("<input type=\"hidden\" name=\"" + prefix + "_name\" value=\"" + Encoder.attributeEscape((String)name) + "\"/>\n<input type=\"hidden\" name=\"" + prefix + "_value\" value=\"" + Encoder.attributeEscape((String)value) + "\"/>\n");
                }
            }
            out.print("<input type=\"hidden\" name=\"argument_count\" value=\"" + Integer.toString(i2) + "\"/>\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        String configOp;
        ConfigNode node;
        String addop;
        ConfigNode node2;
        String op;
        int count;
        int i;
        String x;
        String keystoreValue;
        String commitWithin;
        String commitsPresent;
        String excludedMimeTypes;
        String includedMimeTypes;
        String maxLength;
        String password;
        String userID;
        String realm;
        String extractUpdatePresent;
        String contentField;
        String mimeTypeField;
        String fileNameField;
        String indexedDateField;
        String createdDateField;
        String modifiedDateField;
        String originalSizeField;
        String idField;
        String statusPath;
        String removePath;
        String updatePath;
        String zkConnectTimeout;
        String zkClientTimeout;
        String znodePath;
        String socketTimeout;
        String connectionTimeout;
        String collection;
        String core;
        String webapp;
        String port;
        String server;
        String protocol;
        String type = variableContext.getParameter("solrtype");
        if (type != null) {
            parameters.setParameter("Solr type", type);
        }
        if ((protocol = variableContext.getParameter("serverprotocol")) != null) {
            parameters.setParameter("Server protocol", protocol);
        }
        if ((server = variableContext.getParameter("servername")) != null) {
            parameters.setParameter("Server name", server);
        }
        if ((port = variableContext.getParameter("serverport")) != null) {
            parameters.setParameter("Server port", port);
        }
        if ((webapp = variableContext.getParameter("webappname")) != null) {
            parameters.setParameter("Server web application", webapp);
        }
        if ((core = variableContext.getParameter("core")) != null) {
            parameters.setParameter("Solr core name", core);
        }
        if ((collection = variableContext.getParameter("collection")) != null) {
            parameters.setParameter("Collection", collection);
        }
        if ((connectionTimeout = variableContext.getParameter("connectiontimeout")) != null) {
            parameters.setParameter("Connection timeout", connectionTimeout);
        }
        if ((socketTimeout = variableContext.getParameter("sockettimeout")) != null) {
            parameters.setParameter("Socket timeout", socketTimeout);
        }
        if ((znodePath = variableContext.getParameter("znodepath")) != null) {
            parameters.setParameter("ZooKeeper znode path", znodePath);
        }
        if ((zkClientTimeout = variableContext.getParameter("zkclienttimeout")) != null) {
            parameters.setParameter("ZooKeeper client timeout", zkClientTimeout);
        }
        if ((zkConnectTimeout = variableContext.getParameter("zkconnecttimeout")) != null) {
            parameters.setParameter("ZooKeeper connect timeout", zkConnectTimeout);
        }
        if ((updatePath = variableContext.getParameter("updatepath")) != null) {
            parameters.setParameter("Server update handler", updatePath);
        }
        if ((removePath = variableContext.getParameter("removepath")) != null) {
            parameters.setParameter("Server remove handler", removePath);
        }
        if ((statusPath = variableContext.getParameter("statuspath")) != null) {
            parameters.setParameter("Server status handler", statusPath);
        }
        if ((idField = variableContext.getParameter("idfield")) != null) {
            parameters.setParameter("Solr id field name", idField);
        }
        if ((originalSizeField = variableContext.getParameter("originalsizefield")) != null) {
            parameters.setParameter("Solr original size field name", originalSizeField);
        }
        if ((modifiedDateField = variableContext.getParameter("modifieddatefield")) != null) {
            parameters.setParameter("Solr modified date field name", modifiedDateField);
        }
        if ((createdDateField = variableContext.getParameter("createddatefield")) != null) {
            parameters.setParameter("Solr created date field name", createdDateField);
        }
        if ((indexedDateField = variableContext.getParameter("indexeddatefield")) != null) {
            parameters.setParameter("Solr indexed date field name", indexedDateField);
        }
        if ((fileNameField = variableContext.getParameter("filenamefield")) != null) {
            parameters.setParameter("Solr filename field name", fileNameField);
        }
        if ((mimeTypeField = variableContext.getParameter("mimetypefield")) != null) {
            parameters.setParameter("Solr mime type field name", mimeTypeField);
        }
        if ((contentField = variableContext.getParameter("contentfield")) != null) {
            parameters.setParameter("Solr content field name", contentField);
        }
        if ((extractUpdatePresent = variableContext.getParameter("extractupdatepresent")) != null) {
            String extractUpdate = variableContext.getParameter("extractupdate");
            if (extractUpdate == null || extractUpdate.length() == 0) {
                extractUpdate = "false";
            }
            parameters.setParameter("Use extract update handler", extractUpdate);
        }
        if ((realm = variableContext.getParameter("realm")) != null) {
            parameters.setParameter("Realm", realm);
        }
        if ((userID = variableContext.getParameter("userid")) != null) {
            parameters.setParameter("User ID", userID);
        }
        if ((password = variableContext.getParameter("password")) != null) {
            parameters.setObfuscatedParameter("Password", variableContext.mapKeyToPassword(password));
        }
        if ((maxLength = variableContext.getParameter("maxdocumentlength")) != null) {
            parameters.setParameter("Maximum document length", maxLength);
        }
        if ((includedMimeTypes = variableContext.getParameter("includedmimetypes")) != null) {
            parameters.setParameter("Included mime types", includedMimeTypes);
        }
        if ((excludedMimeTypes = variableContext.getParameter("excludedmimetypes")) != null) {
            parameters.setParameter("Excluded mime types", excludedMimeTypes);
        }
        if ((commitsPresent = variableContext.getParameter("commits_present")) != null) {
            String commits = variableContext.getParameter("commits");
            if (commits == null) {
                commits = "false";
            }
            parameters.setParameter("Commits", commits);
        }
        if ((commitWithin = variableContext.getParameter("commitwithin")) != null) {
            parameters.setParameter("Commit within", commitWithin);
        }
        if ((keystoreValue = variableContext.getParameter("keystoredata")) != null) {
            IKeystoreManager mgr = KeystoreManagerFactory.make((String)"", (String)keystoreValue);
            parameters.setParameter("Keystore", mgr.getString());
        }
        if ((x = variableContext.getParameter("count_zookeeper")) != null && x.length() > 0) {
            i = 0;
            while (i < parameters.getChildCount()) {
                ConfigNode node3 = parameters.getChild(i);
                if (node3.getType().equals("zookeeper")) {
                    parameters.removeChild(i);
                    continue;
                }
                ++i;
            }
            count = Integer.parseInt(x);
            for (i = 0; i < count; ++i) {
                String postfix = "zookeeper_" + Integer.toString(i);
                op = variableContext.getParameter("op_" + postfix);
                if (op != null && op.equals("Delete")) continue;
                String host = variableContext.getParameter("host_" + postfix);
                String zkport = variableContext.getParameter("port_" + postfix);
                node2 = new ConfigNode("zookeeper");
                node2.setAttribute("host", host);
                node2.setAttribute("port", zkport);
                parameters.addChild(parameters.getChildCount(), (ConfigurationNode)node2);
            }
            addop = variableContext.getParameter("op_zookeeper");
            if (addop != null && addop.equals("Add")) {
                String host = variableContext.getParameter("host_zookeeper");
                String zkport = variableContext.getParameter("port_zookeeper");
                node = new ConfigNode("zookeeper");
                node.setAttribute("host", host);
                node.setAttribute("port", zkport);
                parameters.addChild(parameters.getChildCount(), (ConfigurationNode)node);
            }
        }
        if ((x = variableContext.getParameter("argument_count")) != null && x.length() > 0) {
            i = 0;
            while (i < parameters.getChildCount()) {
                ConfigNode node4 = parameters.getChild(i);
                if (node4.getType().equals("argument")) {
                    parameters.removeChild(i);
                    continue;
                }
                ++i;
            }
            count = Integer.parseInt(x);
            for (i = 0; i < count; ++i) {
                String prefix = "argument_" + Integer.toString(i);
                op = variableContext.getParameter(prefix + "_op");
                if (op != null && op.equals("Delete")) continue;
                String name = variableContext.getParameter(prefix + "_name");
                String value = variableContext.getParameter(prefix + "_value");
                node2 = new ConfigNode("argument");
                node2.setAttribute("name", name);
                node2.setAttribute("value", value);
                parameters.addChild(parameters.getChildCount(), (ConfigurationNode)node2);
            }
            addop = variableContext.getParameter("argument_op");
            if (addop != null && addop.equals("Add")) {
                String name = variableContext.getParameter("argument_name");
                String value = variableContext.getParameter("argument_value");
                node = new ConfigNode("argument");
                node.setAttribute("name", name);
                node.setAttribute("value", value);
                parameters.addChild(parameters.getChildCount(), (ConfigurationNode)node);
            }
        }
        if ((configOp = variableContext.getParameter("configop")) != null) {
            String alias;
            if (configOp.equals("Delete")) {
                alias = variableContext.getParameter("solrkeystorealias");
                keystoreValue = parameters.getParameter("Keystore");
                IKeystoreManager mgr = keystoreValue != null ? KeystoreManagerFactory.make((String)"", (String)keystoreValue) : KeystoreManagerFactory.make((String)"");
                mgr.remove(alias);
                parameters.setParameter("Keystore", mgr.getString());
            } else if (configOp.equals("Add")) {
                alias = IDFactory.make((IThreadContext)threadContext);
                byte[] certificateValue = variableContext.getBinaryBytes("solrcertificate");
                keystoreValue = parameters.getParameter("Keystore");
                IKeystoreManager mgr = keystoreValue != null ? KeystoreManagerFactory.make((String)"", (String)keystoreValue) : KeystoreManagerFactory.make((String)"");
                ByteArrayInputStream is = new ByteArrayInputStream(certificateValue);
                String certError = null;
                try {
                    mgr.importCertificate(alias, (InputStream)is);
                }
                catch (Throwable e) {
                    certError = e.getMessage();
                }
                finally {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException node5) {}
                }
                if (certError != null) {
                    return "Illegal certificate: " + certError;
                }
                parameters.setParameter("Keystore", mgr.getString());
            }
        }
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        ConfigNode cn;
        int i;
        out.print("<table class=\"displaytable\">\n  <tr>\n    <td class=\"description\" colspan=\"1\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.Parameters") + "</nobr></td>\n    <td class=\"value\" colspan=\"3\">\n");
        Iterator iter = parameters.listParameters();
        while (iter.hasNext()) {
            String param = (String)iter.next();
            String value = parameters.getParameter(param);
            if (param.length() >= "password".length() && param.substring(param.length() - "password".length()).equalsIgnoreCase("password")) {
                out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=********</nobr><br/>\n");
                continue;
            }
            if (param.length() >= "keystore".length() && param.substring(param.length() - "keystore".length()).equalsIgnoreCase("keystore")) {
                IKeystoreManager kmanager = KeystoreManagerFactory.make((String)"", (String)value);
                out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=&lt;" + Integer.toString(kmanager.getContents().length) + " certificate(s)&gt;</nobr><br/>\n");
                continue;
            }
            out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=" + Encoder.bodyEscape((String)value) + "</nobr><br/>\n");
        }
        out.print("    </td>\n  </tr>\n");
        out.print("\n");
        out.print("  <tr>\n    <td class=\"description\" colspan=\"1\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.ZookeeperHosts") + "</nobr></td>\n    <td class=\"boxcell\" colspan=\"3\">\n      <table class=\"formtable\">\n        <tr class=\"formheaderrow\">\n          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.Host") + "</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.Port") + "</nobr></td>\n        </tr>\n");
        int instanceNumber = 0;
        for (i = 0; i < parameters.getChildCount(); ++i) {
            cn = parameters.getChild(i);
            if (!cn.getType().equals("zookeeper")) continue;
            String host = cn.getAttributeValue("host");
            String zkport = cn.getAttributeValue("port");
            out.print("        <tr class=\"" + (instanceNumber % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n          <td class=\"formcolumncell\"><nobr>" + Encoder.bodyEscape((String)host) + "</nobr></td>\n          <td class=\"formcolumncell\"><nobr>" + Encoder.bodyEscape((String)zkport) + "</nobr></td>\n        </tr>\n");
            ++instanceNumber;
        }
        if (instanceNumber == 0) {
            out.print("        <tr class=\"formrow\"><td class=\"formmessage\" colspan=\"5\">" + Messages.getBodyString(locale, "SolrConnector.NoZookeeperHostsSpecified") + "</td></tr>\n");
        }
        out.print("      </table>\n    </td>\n  </tr>\n");
        out.print("\n");
        out.print("  <tr>\n    <td class=\"description\" colspan=\"1\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.Arguments3") + "</nobr></td>\n    <td class=\"boxcell\" colspan=\"3\">\n      <table class=\"formtable\">\n        <tr class=\"formheaderrow\">\n          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.Name") + "</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>" + Messages.getBodyString(locale, "SolrConnector.Value") + "</nobr></td>\n        </tr>\n");
        instanceNumber = 0;
        for (i = 0; i < parameters.getChildCount(); ++i) {
            cn = parameters.getChild(i);
            if (!cn.getType().equals("argument")) continue;
            String name = cn.getAttributeValue("name");
            String value = cn.getAttributeValue("value");
            out.print("        <tr class=\"" + (instanceNumber % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n          <td class=\"formcolumncell\"><nobr>" + Encoder.bodyEscape((String)name) + "</nobr></td>\n          <td class=\"formcolumncell\"><nobr>" + Encoder.bodyEscape((String)value) + "</nobr></td>\n        </tr>\n");
            ++instanceNumber;
        }
        if (instanceNumber == 0) {
            out.print("        <tr class=\"formrow\"><td class=\"formmessage\" colspan=\"5\">" + Messages.getBodyString(locale, "SolrConnector.NoArguments") + "</td></tr>\n");
        }
        out.print("      </table>\n    </td>\n  </tr>\n");
        out.print("</table>\n");
    }

    static {
        System.setProperty("jdk.xml.maxGeneralEntitySizeLimit", new Integer(Integer.MAX_VALUE).toString());
    }

    protected class SpecPacker {
        private final Map<String, List<String>> args = new HashMap<String, List<String>>();

        public SpecPacker(Specification spec) {
            for (int i = 0; i < SolrConnector.this.params.getChildCount(); ++i) {
                ConfigNode node = SolrConnector.this.params.getChild(i);
                if (!node.getType().equals("argument")) continue;
                String attrName = node.getAttributeValue("name");
                List<String> list = this.args.get(attrName);
                if (list == null) {
                    list = new ArrayList<String>();
                    this.args.put(attrName, list);
                }
                list.add(node.getAttributeValue("value"));
            }
        }

        public String toPackedString() {
            StringBuilder sb = new StringBuilder();
            Object[] sortArray = new String[this.args.size()];
            Iterator<String> iter = this.args.keySet().iterator();
            int i = 0;
            while (iter.hasNext()) {
                sortArray[i++] = iter.next();
            }
            Arrays.sort(sortArray);
            String[] fixedList = new String[2];
            ArrayList<String> nameValues = new ArrayList<String>();
            for (int k = 0; k < sortArray.length; ++k) {
                Object name = sortArray[k];
                List<String> values = this.args.get(name);
                Collections.sort(values);
                for (String value : values) {
                    fixedList[0] = name;
                    fixedList[1] = value;
                    StringBuilder pairBuffer = new StringBuilder();
                    SolrConnector.packFixedList((StringBuilder)pairBuffer, (String[])fixedList, (char)'=');
                    nameValues.add(pairBuffer.toString());
                }
            }
            SolrConnector.packList((StringBuilder)sb, (List)nameValues, (char)'+');
            if (SolrConnector.this.idAttributeName != null) {
                sb.append('+');
                SolrConnector.pack((StringBuilder)sb, (String)SolrConnector.this.idAttributeName, (char)'+');
            } else {
                sb.append('-');
            }
            if (SolrConnector.this.originalSizeAttributeName != null) {
                sb.append('+');
                SolrConnector.pack((StringBuilder)sb, (String)SolrConnector.this.originalSizeAttributeName, (char)'+');
            } else {
                sb.append('-');
            }
            if (SolrConnector.this.modifiedDateAttributeName != null) {
                sb.append('+');
                SolrConnector.pack((StringBuilder)sb, (String)SolrConnector.this.modifiedDateAttributeName, (char)'+');
            } else {
                sb.append('-');
            }
            if (SolrConnector.this.createdDateAttributeName != null) {
                sb.append('+');
                SolrConnector.pack((StringBuilder)sb, (String)SolrConnector.this.createdDateAttributeName, (char)'+');
            } else {
                sb.append('-');
            }
            if (SolrConnector.this.indexedDateAttributeName != null) {
                sb.append('+');
                SolrConnector.pack((StringBuilder)sb, (String)SolrConnector.this.indexedDateAttributeName, (char)'+');
            } else {
                sb.append('-');
            }
            if (SolrConnector.this.fileNameAttributeName != null) {
                sb.append('+');
                SolrConnector.pack((StringBuilder)sb, (String)SolrConnector.this.fileNameAttributeName, (char)'+');
            } else {
                sb.append('-');
            }
            if (SolrConnector.this.mimeTypeAttributeName != null) {
                sb.append('+');
                SolrConnector.pack((StringBuilder)sb, (String)SolrConnector.this.mimeTypeAttributeName, (char)'+');
            } else {
                sb.append('-');
            }
            if (SolrConnector.this.contentAttributeName != null) {
                sb.append('+');
                SolrConnector.pack((StringBuilder)sb, (String)SolrConnector.this.contentAttributeName, (char)'+');
            } else {
                sb.append('-');
            }
            if (SolrConnector.this.useExtractUpdateHandler) {
                sb.append('+');
            } else {
                sb.append('-');
            }
            if (SolrConnector.this.maxDocumentLength != null) {
                sb.append('+');
                SolrConnector.pack((StringBuilder)sb, (String)SolrConnector.this.maxDocumentLength.toString(), (char)'+');
            } else {
                sb.append('-');
            }
            if (SolrConnector.this.includedMimeTypesString != null) {
                sb.append('+');
                SolrConnector.pack((StringBuilder)sb, (String)SolrConnector.this.includedMimeTypesString, (char)'+');
            } else {
                sb.append('-');
            }
            if (SolrConnector.this.excludedMimeTypesString != null) {
                sb.append('+');
                SolrConnector.pack((StringBuilder)sb, (String)SolrConnector.this.excludedMimeTypesString, (char)'+');
            } else {
                sb.append('-');
            }
            if (SolrConnector.this.collectionName != null) {
                sb.append('+');
                SolrConnector.pack((StringBuilder)sb, (String)SolrConnector.this.collectionName, (char)'+');
            } else {
                sb.append('-');
            }
            return sb.toString();
        }

        public Map<String, List<String>> getArgs() {
            return this.args;
        }
    }
}

