/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.cachemanager;

import org.apache.manifoldcf.core.interfaces.ICacheClass;
import org.apache.manifoldcf.core.interfaces.ICacheDescription;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.LockManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public abstract class BaseDescription
implements ICacheDescription {
    public static final String _rcsid = "@(#)$Id: BaseDescription.java 988245 2010-08-23 18:39:35Z kwright $";
    protected ICacheClass cacheClass = null;
    protected static final int MAX_VALUE = Integer.MAX_VALUE;

    public BaseDescription(String objectClassName) {
        if (objectClassName != null) {
            this.cacheClass = new LocalCacheClass(objectClassName);
        }
    }

    public BaseDescription(String objectClassName, IThreadContext threadContext) throws ManifoldCFException {
        if (objectClassName != null) {
            this.cacheClass = new LocalCacheClass(objectClassName, threadContext);
        }
    }

    public BaseDescription(String objectClassName, int maxLRUCount) {
        if (objectClassName != null) {
            this.cacheClass = new LocalCacheClass(objectClassName, maxLRUCount);
        }
    }

    @Override
    public ICacheClass getObjectClass() {
        return this.cacheClass;
    }

    @Override
    public long getObjectExpirationTime(long currentTime) {
        return -1L;
    }

    protected class LocalCacheClass
    implements ICacheClass {
        protected String objectClassName;
        protected Integer maxLRUCount = null;

        public LocalCacheClass(String objectClassName, IThreadContext threadContext) throws ManifoldCFException {
            this(objectClassName, new Integer(LockManagerFactory.getIntProperty(threadContext, "cache." + objectClassName + ".lrusize", Integer.MAX_VALUE)));
        }

        public LocalCacheClass(String objectClassName) {
            this(objectClassName, (Integer)null);
        }

        public LocalCacheClass(String objectClassName, Integer maxLRUCount) {
            this.objectClassName = objectClassName;
            this.maxLRUCount = maxLRUCount;
        }

        @Override
        public String getClassName() {
            return this.objectClassName;
        }

        @Override
        public int getMaxLRUCount() {
            if (this.maxLRUCount == null) {
                return Integer.MAX_VALUE;
            }
            return this.maxLRUCount;
        }
    }
}

