/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.connectorcommon.fuzzyml;

import java.io.IOException;
import java.io.InputStream;
import org.apache.manifoldcf.connectorcommon.fuzzyml.ByteBuffer;

public class ReplayableInputStream
extends InputStream {
    protected final ByteBuffer bytes = new ByteBuffer();
    protected final InputStream wrappedStream;
    protected int bytePosition = 0;
    protected boolean doBuffering = true;

    public ReplayableInputStream(InputStream wrappedStream) {
        this.wrappedStream = wrappedStream;
    }

    public void restart(boolean lastRestart) {
        if (!this.doBuffering) {
            throw new IllegalStateException("Can't restart a stream after it has been restarted the last time");
        }
        this.doBuffering = !lastRestart;
        this.bytePosition = 0;
    }

    @Override
    public int read() throws IOException {
        if (this.bytePosition < this.bytes.size()) {
            return 0xFF & this.bytes.readByte(this.bytePosition++);
        }
        int theByte = this.wrappedStream.read();
        if (theByte == -1) {
            return theByte;
        }
        if (this.doBuffering) {
            this.bytes.appendByte((byte)theByte);
            ++this.bytePosition;
        }
        return theByte;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.bytePosition < this.bytes.size() || this.doBuffering) {
            return super.read(b, off, len);
        }
        return this.wrappedStream.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.bytePosition < this.bytes.size()) {
            return super.skip(n);
        }
        return this.wrappedStream.skip(n);
    }

    @Override
    public void close() throws IOException {
    }
}

