/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities.system;

import org.apache.manifoldcf.authorities.interfaces.IMappingConnector;
import org.apache.manifoldcf.authorities.interfaces.IMappingConnectorPool;
import org.apache.manifoldcf.authorities.interfaces.MappingConnectorPoolFactory;
import org.apache.manifoldcf.authorities.system.Logging;
import org.apache.manifoldcf.authorities.system.ManifoldCF;
import org.apache.manifoldcf.authorities.system.MappingRequest;
import org.apache.manifoldcf.authorities.system.RequestQueue;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;

public class MappingThread
extends Thread {
    public static final String _rcsid = "@(#)$Id: MappingThread.java 1859195 2019-05-13 17:35:04Z kwright $";
    protected RequestQueue<MappingRequest> requestQueue;

    public MappingThread(String id, RequestQueue<MappingRequest> requestQueue) throws ManifoldCFException {
        this.requestQueue = requestQueue;
        this.setName("Mapping thread " + id);
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        IThreadContext threadContext = ThreadContextFactory.make();
        try {
            IMappingConnectorPool mappingConnectorPool = MappingConnectorPoolFactory.make(threadContext);
            while (true) {
                try {
                    while (true) {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new ManifoldCFException("Interrupted", 2);
                        }
                        MappingRequest theRequest = this.requestQueue.getRequest();
                        if (Logging.authorityService.isDebugEnabled()) {
                            Logging.authorityService.debug((Object)(" Calling mapping connector class '" + theRequest.getMappingConnection().getClassName() + "'"));
                        }
                        String outputUserID = null;
                        Throwable exception = null;
                        if (theRequest.getUserID() != null) {
                            try {
                                IMappingConnector connector = mappingConnectorPool.grab(theRequest.getMappingConnection());
                                try {
                                    if (connector == null) {
                                        exception = new ManifoldCFException("Mapping connector " + theRequest.getMappingConnection().getClassName() + " is not registered.");
                                    } else {
                                        try {
                                            outputUserID = connector.mapUser(theRequest.getUserID());
                                        }
                                        catch (ManifoldCFException e) {
                                            if (e.getErrorCode() == 2) {
                                                throw e;
                                            }
                                            Logging.authorityService.warn((Object)("Mapping error: " + e.getMessage()), (Throwable)e);
                                        }
                                    }
                                }
                                finally {
                                    mappingConnectorPool.release(theRequest.getMappingConnection(), connector);
                                }
                            }
                            catch (ManifoldCFException e) {
                                if (e.getErrorCode() == 2) {
                                    throw e;
                                }
                                Logging.authorityService.warn((Object)("Mapping connection exception: " + e.getMessage()), (Throwable)e);
                                exception = e;
                            }
                            catch (Throwable e) {
                                Logging.authorityService.warn((Object)("Mapping connection error: " + e.getMessage()), e);
                                exception = e;
                            }
                        }
                        theRequest.completeRequest(outputUserID, exception);
                    }
                }
                catch (ManifoldCFException e) {
                    if (e.getErrorCode() != 2) {
                        Logging.authorityService.error((Object)("Exception tossed: " + e.getMessage()), (Throwable)e);
                        if (e.getErrorCode() != 3) continue;
                        ManifoldCF.systemExit((int)1);
                        continue;
                    }
                }
                catch (InterruptedException e) {
                }
                catch (Throwable e) {
                    Logging.authorityService.fatal((Object)("Error tossed: " + e.getMessage()), e);
                    continue;
                }
                break;
            }
        }
        catch (ManifoldCFException e) {
            System.err.println("Authority service mapping thread could not start - shutting down");
            Logging.authorityService.fatal((Object)("MappingThread initialization error tossed: " + e.getMessage()), (Throwable)e);
            ManifoldCF.systemExit((int)-300);
        }
    }
}

