/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.termvector;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.termvector.TermVectorRequest;
import org.elasticsearch.action.termvector.TermVectorResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class RestTermVectorAction
extends BaseRestHandler {
    @Inject
    public RestTermVectorAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/{id}/_termvector", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/{id}/_termvector", this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        TermVectorRequest termVectorRequest = new TermVectorRequest(request.param("index"), request.param("type"), request.param("id"));
        XContentParser parser = null;
        if (request.hasContent()) {
            try {
                parser = XContentFactory.xContent(request.content()).createParser(request.content());
                TermVectorRequest.parseRequest(termVectorRequest, parser);
            }
            catch (IOException e) {
                try {
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    channel.sendResponse(new XContentRestResponse(request, RestStatus.BAD_REQUEST, builder.startObject().field("error", e.getMessage()).endObject()));
                }
                catch (IOException e1) {
                    this.logger.warn("Failed to send response", e1, new Object[0]);
                    return;
                }
            }
            finally {
                if (parser != null) {
                    parser.close();
                }
            }
        }
        RestTermVectorAction.readURIParameters(termVectorRequest, request);
        this.client.termVector(termVectorRequest, new ActionListener<TermVectorResponse>(){

            @Override
            public void onResponse(TermVectorResponse response) {
                try {
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    response.toXContent(builder, request);
                    channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                }
                catch (Throwable e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestTermVectorAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }

    public static void readURIParameters(TermVectorRequest termVectorRequest, RestRequest request) {
        String fields = request.param("fields");
        RestTermVectorAction.addFieldStringsFromParameter(termVectorRequest, fields);
        termVectorRequest.offsets(request.paramAsBoolean("offsets", termVectorRequest.offsets()));
        termVectorRequest.positions(request.paramAsBoolean("positions", termVectorRequest.positions()));
        termVectorRequest.payloads(request.paramAsBoolean("payloads", termVectorRequest.payloads()));
        termVectorRequest.routing(request.param("routing"));
        termVectorRequest.parent(request.param("parent"));
        termVectorRequest.preference(request.param("preference"));
        termVectorRequest.termStatistics(request.paramAsBoolean("termStatistics", termVectorRequest.termStatistics()));
        termVectorRequest.termStatistics(request.paramAsBoolean("term_statistics", termVectorRequest.termStatistics()));
        termVectorRequest.fieldStatistics(request.paramAsBoolean("fieldStatistics", termVectorRequest.fieldStatistics()));
        termVectorRequest.fieldStatistics(request.paramAsBoolean("field_statistics", termVectorRequest.fieldStatistics()));
    }

    public static void addFieldStringsFromParameter(TermVectorRequest termVectorRequest, String fields) {
        Set<String> selectedFields = termVectorRequest.selectedFields();
        if (fields != null) {
            String[] paramFieldStrings;
            for (String field : paramFieldStrings = Strings.commaDelimitedListToStringArray(fields)) {
                if (selectedFields == null) {
                    selectedFields = new HashSet<String>();
                }
                if (selectedFields.contains(field)) continue;
                field = field.replaceAll("\\s", "");
                selectedFields.add(field);
            }
        }
        if (selectedFields != null) {
            termVectorRequest.selectedFields(selectedFields.toArray(new String[selectedFields.size()]));
        }
    }
}

