/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.cache.filter.terms;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.cache.Weigher;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.cache.filter.support.CacheKeyFilter;
import org.elasticsearch.indices.cache.filter.terms.TermsLookup;

public class IndicesTermsFilterCache
extends AbstractComponent {
    private static TermsFilterValue NO_TERMS = new TermsFilterValue(0L, Queries.MATCH_NO_FILTER);
    private final Client client;
    private final Cache<BytesRef, TermsFilterValue> cache;

    @Inject
    public IndicesTermsFilterCache(Settings settings, Client client) {
        super(settings);
        this.client = client;
        ByteSizeValue size = this.componentSettings.getAsBytesSize("size", new ByteSizeValue(10L, ByteSizeUnit.MB));
        TimeValue expireAfterWrite = this.componentSettings.getAsTime("expire_after_write", null);
        TimeValue expireAfterAccess = this.componentSettings.getAsTime("expire_after_access", null);
        CacheBuilder<BytesRef, TermsFilterValue> builder = CacheBuilder.newBuilder().maximumWeight(size.bytes()).weigher(new TermsFilterValueWeigher());
        if (expireAfterAccess != null) {
            builder.expireAfterAccess(expireAfterAccess.millis(), TimeUnit.MILLISECONDS);
        }
        if (expireAfterWrite != null) {
            builder.expireAfterWrite(expireAfterWrite.millis(), TimeUnit.MILLISECONDS);
        }
        this.cache = builder.build();
    }

    @Nullable
    public Filter termsFilter(final TermsLookup lookup, boolean cacheLookup, @Nullable CacheKeyFilter.Key cacheKey) throws RuntimeException {
        if (!cacheLookup) {
            return this.buildTermsFilterValue((TermsLookup)lookup).filter;
        }
        BytesRef key = cacheKey != null ? new BytesRef(cacheKey.bytes()) : new BytesRef((CharSequence)lookup.toString());
        try {
            return this.cache.get((BytesRef)key, (Callable<TermsFilterValue>)new Callable<TermsFilterValue>(){

                @Override
                public TermsFilterValue call() throws Exception {
                    return IndicesTermsFilterCache.this.buildTermsFilterValue(lookup);
                }
            }).filter;
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new ElasticsearchException(e.getMessage(), e.getCause());
        }
    }

    TermsFilterValue buildTermsFilterValue(TermsLookup lookup) {
        GetResponse getResponse = this.client.get(new GetRequest(lookup.getIndex(), lookup.getType(), lookup.getId()).preference("_local").routing(lookup.getRouting())).actionGet();
        if (!getResponse.isExists()) {
            return NO_TERMS;
        }
        List<Object> values = XContentMapValues.extractRawValues(lookup.getPath(), getResponse.getSourceAsMap());
        if (values.isEmpty()) {
            return NO_TERMS;
        }
        Filter filter = lookup.getFieldMapper().termsFilter(values, lookup.getQueryParseContext());
        return new TermsFilterValue(this.estimateSizeInBytes(values), filter);
    }

    long estimateSizeInBytes(List<Object> terms) {
        long size = 8L;
        for (Object term : terms) {
            if (term instanceof BytesRef) {
                size += (long)((BytesRef)term).length;
                continue;
            }
            if (term instanceof String) {
                size += (long)(((String)term).length() / 2);
                continue;
            }
            size += 4L;
        }
        return size;
    }

    public void clear(String reason) {
        this.cache.invalidateAll();
    }

    public void clear(String reason, String[] keys) {
        for (String key : keys) {
            this.cache.invalidate(new BytesRef((CharSequence)key));
        }
    }

    static class TermsFilterValue {
        public final long sizeInBytes;
        public final Filter filter;

        TermsFilterValue(long sizeInBytes, Filter filter) {
            this.sizeInBytes = sizeInBytes;
            this.filter = filter;
        }
    }

    static class TermsFilterValueWeigher
    implements Weigher<BytesRef, TermsFilterValue> {
        TermsFilterValueWeigher() {
        }

        @Override
        public int weigh(BytesRef key, TermsFilterValue value) {
            return (int)((long)key.length + value.sizeInBytes);
        }
    }
}

