/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.functionscore.gauss;

import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.index.query.functionscore.DecayFunction;
import org.elasticsearch.index.query.functionscore.DecayFunctionParser;

public class GaussDecayFunctionParser
extends DecayFunctionParser {
    static final DecayFunction decayFunction = new GaussScoreFunction();
    public static final String[] NAMES = new String[]{"gauss"};

    @Override
    public DecayFunction getDecayFunction() {
        return decayFunction;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }

    static final class GaussScoreFunction
    implements DecayFunction {
        GaussScoreFunction() {
        }

        @Override
        public double evaluate(double value, double scale) {
            return (float)Math.exp(0.5 * Math.pow(value, 2.0) / scale);
        }

        @Override
        public Explanation explainFunction(String valueExpl, double value, double scale) {
            ComplexExplanation ce = new ComplexExplanation();
            ce.setValue((float)this.evaluate(value, scale));
            ce.setDescription("-exp(-0.5*pow(" + valueExpl + ",2.0)/" + -1.0 * scale + ")");
            return ce;
        }

        @Override
        public double processScale(double scale, double decay) {
            return 0.5 * Math.pow(scale, 2.0) / Math.log(decay);
        }
    }
}

