/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway.fs;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.common.blobstore.fs.FsBlobStore;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.env.Environment;
import org.elasticsearch.gateway.blobstore.BlobStoreGateway;
import org.elasticsearch.index.gateway.fs.FsIndexGatewayModule;
import org.elasticsearch.threadpool.ThreadPool;

public class FsGateway
extends BlobStoreGateway {
    private final ExecutorService concurrentStreamPool;

    @Inject
    public FsGateway(Settings settings, ThreadPool threadPool, ClusterService clusterService, Environment environment, ClusterName clusterName) throws IOException {
        super(settings, threadPool, clusterService);
        File gatewayFile;
        String location = this.componentSettings.get("location");
        if (location == null) {
            this.logger.warn("using local fs location for gateway, should be changed to be a shared location across nodes", new Object[0]);
            gatewayFile = new File(environment.dataFiles()[0], "gateway");
        } else {
            gatewayFile = new File(location);
        }
        int concurrentStreams = this.componentSettings.getAsInt("concurrent_streams", (Integer)5);
        this.concurrentStreamPool = EsExecutors.newScaling(1, concurrentStreams, 60L, TimeUnit.SECONDS, EsExecutors.daemonThreadFactory(settings, "[fs_stream]"));
        this.initialize(new FsBlobStore(this.componentSettings, this.concurrentStreamPool, gatewayFile), clusterName, null);
    }

    @Override
    public String type() {
        return "fs";
    }

    @Override
    public Class<? extends Module> suggestIndexGateway() {
        return FsIndexGatewayModule.class;
    }

    @Override
    protected void doClose() throws ElasticsearchException {
        super.doClose();
        this.concurrentStreamPool.shutdown();
    }
}

