/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import org.elasticsearch.ElasticsearchIllegalArgumentException;

public final class Priority
implements Comparable<Priority> {
    public static Priority URGENT = new Priority(0);
    public static Priority HIGH = new Priority(1);
    public static Priority NORMAL = new Priority(2);
    public static Priority LOW = new Priority(3);
    public static Priority LANGUID = new Priority(4);
    private final byte value;

    public static Priority fromByte(byte b) {
        switch (b) {
            case 0: {
                return URGENT;
            }
            case 1: {
                return HIGH;
            }
            case 2: {
                return NORMAL;
            }
            case 3: {
                return LOW;
            }
            case 4: {
                return LANGUID;
            }
        }
        throw new ElasticsearchIllegalArgumentException("can't find priority for [" + b + "]");
    }

    private Priority(byte value) {
        this.value = value;
    }

    public byte value() {
        return this.value;
    }

    @Override
    public int compareTo(Priority p) {
        return this.value - p.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Priority.class != o.getClass()) {
            return false;
        }
        Priority priority = (Priority)o;
        return this.value == priority.value;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        switch (this.value) {
            case 0: {
                return "URGENT";
            }
            case 1: {
                return "HIGH";
            }
            case 2: {
                return "NORMAL";
            }
            case 3: {
                return "LOW";
            }
        }
        return "LANGUID";
    }
}

