/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.AllocationExplanation;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.compress.CompressedString;
import org.elasticsearch.common.hppc.cursors.ObjectCursor;
import org.elasticsearch.common.hppc.cursors.ObjectObjectCursor;
import org.elasticsearch.common.io.stream.BytesStreamInput;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.shard.ShardId;

public class ClusterState
implements ToXContent {
    public static Map<String, Custom.Factory> customFactories = new HashMap<String, Custom.Factory>();
    private final long version;
    private final RoutingTable routingTable;
    private final DiscoveryNodes nodes;
    private final MetaData metaData;
    private final ClusterBlocks blocks;
    private final AllocationExplanation allocationExplanation;
    private final ImmutableOpenMap<String, Custom> customs;
    private volatile RoutingNodes routingNodes;
    private SettingsFilter settingsFilter;

    public static void registerFactory(String type, Custom.Factory factory) {
        customFactories.put(type, factory);
    }

    @Nullable
    public static <T extends Custom> Custom.Factory<T> lookupFactory(String type) {
        return customFactories.get(type);
    }

    public static <T extends Custom> Custom.Factory<T> lookupFactorySafe(String type) throws ElasticsearchIllegalArgumentException {
        Custom.Factory factory = customFactories.get(type);
        if (factory == null) {
            throw new ElasticsearchIllegalArgumentException("No custom state factory registered for type [" + type + "]");
        }
        return factory;
    }

    public ClusterState(long version, ClusterState state) {
        this(version, state.metaData(), state.routingTable(), state.nodes(), state.blocks(), state.allocationExplanation(), state.customs());
    }

    public ClusterState(long version, MetaData metaData, RoutingTable routingTable, DiscoveryNodes nodes, ClusterBlocks blocks, AllocationExplanation allocationExplanation, ImmutableOpenMap<String, Custom> customs) {
        this.version = version;
        this.metaData = metaData;
        this.routingTable = routingTable;
        this.nodes = nodes;
        this.blocks = blocks;
        this.allocationExplanation = allocationExplanation;
        this.customs = customs;
    }

    public long version() {
        return this.version;
    }

    public long getVersion() {
        return this.version();
    }

    public DiscoveryNodes nodes() {
        return this.nodes;
    }

    public DiscoveryNodes getNodes() {
        return this.nodes();
    }

    public MetaData metaData() {
        return this.metaData;
    }

    public MetaData getMetaData() {
        return this.metaData();
    }

    public RoutingTable routingTable() {
        return this.routingTable;
    }

    public RoutingTable getRoutingTable() {
        return this.routingTable();
    }

    public RoutingNodes routingNodes() {
        return this.routingTable.routingNodes(this);
    }

    public RoutingNodes getRoutingNodes() {
        return this.readOnlyRoutingNodes();
    }

    public ClusterBlocks blocks() {
        return this.blocks;
    }

    public ClusterBlocks getBlocks() {
        return this.blocks;
    }

    public AllocationExplanation allocationExplanation() {
        return this.allocationExplanation;
    }

    public AllocationExplanation getAllocationExplanation() {
        return this.allocationExplanation();
    }

    public ImmutableOpenMap<String, Custom> customs() {
        return this.customs;
    }

    public ImmutableOpenMap<String, Custom> getCustoms() {
        return this.customs;
    }

    public RoutingNodes readOnlyRoutingNodes() {
        if (this.routingNodes != null) {
            return this.routingNodes;
        }
        this.routingNodes = this.routingTable.routingNodes(this);
        return this.routingNodes;
    }

    public ClusterState settingsFilter(SettingsFilter settingsFilter) {
        this.settingsFilter = settingsFilter;
        return this;
    }

    public String prettyPrint() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.nodes().prettyPrint());
        sb.append(this.routingTable().prettyPrint());
        sb.append(this.readOnlyRoutingNodes().prettyPrint());
        return sb.toString();
    }

    public String toString() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint();
            builder.startObject();
            this.toXContent(builder, EMPTY_PARAMS);
            builder.endObject();
            return builder.string();
        }
        catch (IOException e) {
            return "{ \"error\" : \"" + e.getMessage() + "\"}";
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean isAllMetricsOnly;
        Set<String> metrics = Strings.splitStringByCommaToSet(params.param("metric", "_all"));
        boolean bl = isAllMetricsOnly = metrics.size() == 1 && metrics.contains("_all");
        if (isAllMetricsOnly || metrics.contains("version")) {
            builder.field("version", this.version);
        }
        if (isAllMetricsOnly || metrics.contains("master_node")) {
            builder.field("master_node", this.nodes().masterNodeId());
        }
        if (isAllMetricsOnly || metrics.contains("blocks")) {
            builder.startObject("blocks");
            if (!this.blocks().global().isEmpty()) {
                builder.startObject("global");
                for (ClusterBlock clusterBlock : this.blocks().global()) {
                    clusterBlock.toXContent(builder, params);
                }
                builder.endObject();
            }
            if (!this.blocks().indices().isEmpty()) {
                builder.startObject("indices");
                for (Map.Entry entry : this.blocks().indices().entrySet()) {
                    builder.startObject((String)entry.getKey());
                    for (ClusterBlock block : (ImmutableSet)entry.getValue()) {
                        block.toXContent(builder, params);
                    }
                    builder.endObject();
                }
                builder.endObject();
            }
            builder.endObject();
        }
        if (isAllMetricsOnly || metrics.contains("nodes")) {
            builder.startObject("nodes");
            for (DiscoveryNode discoveryNode : this.nodes()) {
                builder.startObject(discoveryNode.id(), XContentBuilder.FieldCaseConversion.NONE);
                builder.field("name", discoveryNode.name());
                builder.field("transport_address", discoveryNode.address().toString());
                builder.startObject("attributes");
                for (Map.Entry attr : discoveryNode.attributes().entrySet()) {
                    builder.field((String)attr.getKey(), (String)attr.getValue());
                }
                builder.endObject();
                builder.endObject();
            }
            builder.endObject();
        }
        if (isAllMetricsOnly || metrics.contains("metadata")) {
            builder.startObject("metadata");
            builder.startObject("templates");
            for (ObjectCursor objectCursor : this.metaData().templates().values()) {
                IndexTemplateMetaData templateMetaData = (IndexTemplateMetaData)objectCursor.value;
                builder.startObject(templateMetaData.name(), XContentBuilder.FieldCaseConversion.NONE);
                builder.field("template", templateMetaData.template());
                builder.field("order", templateMetaData.order());
                builder.startObject("settings");
                Settings settings = templateMetaData.settings();
                if (this.settingsFilter != null) {
                    settings = this.settingsFilter.filterSettings(settings);
                }
                settings.toXContent(builder, params);
                builder.endObject();
                builder.startObject("mappings");
                for (ObjectObjectCursor<String, CompressedString> objectObjectCursor : templateMetaData.mappings()) {
                    byte[] mappingSource = ((CompressedString)objectObjectCursor.value).uncompressed();
                    XContentParser parser = XContentFactory.xContent(mappingSource).createParser(mappingSource);
                    Map mapping = parser.map();
                    if (mapping.size() == 1 && mapping.containsKey(objectObjectCursor.key)) {
                        mapping = (Map)mapping.get(objectObjectCursor.key);
                    }
                    builder.field((String)objectObjectCursor.key);
                    builder.map(mapping);
                }
                builder.endObject();
                builder.endObject();
            }
            builder.endObject();
            builder.startObject("indices");
            for (IndexMetaData indexMetaData : this.metaData()) {
                builder.startObject(indexMetaData.index(), XContentBuilder.FieldCaseConversion.NONE);
                builder.field("state", indexMetaData.state().toString().toLowerCase(Locale.ENGLISH));
                builder.startObject("settings");
                Settings settings = indexMetaData.settings();
                if (this.settingsFilter != null) {
                    settings = this.settingsFilter.filterSettings(settings);
                }
                settings.toXContent(builder, params);
                builder.endObject();
                builder.startObject("mappings");
                for (ObjectObjectCursor<String, MappingMetaData> objectObjectCursor : indexMetaData.mappings()) {
                    byte[] byArray = ((MappingMetaData)objectObjectCursor.value).source().uncompressed();
                    XContentParser parser = XContentFactory.xContent(byArray).createParser(byArray);
                    Map mapping = parser.map();
                    if (mapping.size() == 1 && mapping.containsKey(objectObjectCursor.key)) {
                        mapping = (Map)mapping.get(objectObjectCursor.key);
                    }
                    builder.field((String)objectObjectCursor.key);
                    builder.map(mapping);
                }
                builder.endObject();
                builder.startArray("aliases");
                for (ObjectCursor objectCursor : indexMetaData.aliases().keys()) {
                    builder.value((String)objectCursor.value);
                }
                builder.endArray();
                builder.endObject();
            }
            builder.endObject();
            for (ObjectObjectCursor objectObjectCursor : this.metaData.customs()) {
                builder.startObject((String)objectObjectCursor.key);
                MetaData.lookupFactorySafe((String)objectObjectCursor.key).toXContent((MetaData.Custom)objectObjectCursor.value, builder, params);
                builder.endObject();
            }
            builder.endObject();
        }
        if (isAllMetricsOnly || metrics.contains("routing_table")) {
            builder.startObject("routing_table");
            builder.startObject("indices");
            for (IndexRoutingTable indexRoutingTable : this.routingTable()) {
                builder.startObject(indexRoutingTable.index(), XContentBuilder.FieldCaseConversion.NONE);
                builder.startObject("shards");
                for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                    builder.startArray(Integer.toString(indexShardRoutingTable.shardId().id()));
                    for (ShardRouting shardRouting : indexShardRoutingTable) {
                        shardRouting.toXContent(builder, params);
                    }
                    builder.endArray();
                }
                builder.endObject();
                builder.endObject();
            }
            builder.endObject();
            builder.endObject();
        }
        if (isAllMetricsOnly || metrics.contains("routing_table")) {
            builder.startObject("routing_nodes");
            builder.startArray("unassigned");
            for (MutableShardRouting mutableShardRouting : this.readOnlyRoutingNodes().unassigned()) {
                mutableShardRouting.toXContent(builder, params);
            }
            builder.endArray();
            builder.startObject("nodes");
            for (RoutingNode routingNode : this.readOnlyRoutingNodes()) {
                builder.startArray(routingNode.nodeId(), XContentBuilder.FieldCaseConversion.NONE);
                for (MutableShardRouting shardRouting : routingNode) {
                    shardRouting.toXContent(builder, params);
                }
                builder.endArray();
            }
            builder.endObject();
            builder.endObject();
        }
        if (isAllMetricsOnly || metrics.contains("routing_table")) {
            builder.startArray("allocations");
            for (Map.Entry entry : this.allocationExplanation().explanations().entrySet()) {
                builder.startObject();
                builder.field("index", ((ShardId)entry.getKey()).index().name());
                builder.field("shard", ((ShardId)entry.getKey()).id());
                builder.startArray("explanations");
                for (AllocationExplanation.NodeExplanation nodeExplanation : (List)entry.getValue()) {
                    builder.field("desc", nodeExplanation.description());
                    if (nodeExplanation.node() == null) continue;
                    builder.startObject("node");
                    builder.field("id", nodeExplanation.node().id());
                    builder.field("name", nodeExplanation.node().name());
                    builder.endObject();
                }
                builder.endArray();
                builder.endObject();
            }
            builder.endArray();
        }
        if (isAllMetricsOnly || metrics.contains("customs")) {
            for (ObjectObjectCursor objectObjectCursor : this.customs) {
                builder.startObject((String)objectObjectCursor.key);
                ClusterState.lookupFactorySafe((String)objectObjectCursor.key).toXContent((Custom)objectObjectCursor.value, builder, params);
                builder.endObject();
            }
        }
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ClusterState state) {
        return new Builder(state);
    }

    public static class Builder {
        private long version = 0L;
        private MetaData metaData = MetaData.EMPTY_META_DATA;
        private RoutingTable routingTable = RoutingTable.EMPTY_ROUTING_TABLE;
        private DiscoveryNodes nodes = DiscoveryNodes.EMPTY_NODES;
        private ClusterBlocks blocks = ClusterBlocks.EMPTY_CLUSTER_BLOCK;
        private AllocationExplanation allocationExplanation = AllocationExplanation.EMPTY;
        private final ImmutableOpenMap.Builder<String, Custom> customs;

        public Builder() {
            this.customs = ImmutableOpenMap.builder();
        }

        public Builder(ClusterState state) {
            this.version = state.version();
            this.nodes = state.nodes();
            this.routingTable = state.routingTable();
            this.metaData = state.metaData();
            this.blocks = state.blocks();
            this.allocationExplanation = state.allocationExplanation();
            this.customs = ImmutableOpenMap.builder(state.customs());
        }

        public Builder nodes(DiscoveryNodes.Builder nodesBuilder) {
            return this.nodes(nodesBuilder.build());
        }

        public Builder nodes(DiscoveryNodes nodes) {
            this.nodes = nodes;
            return this;
        }

        public Builder routingTable(RoutingTable.Builder routingTable) {
            return this.routingTable(routingTable.build());
        }

        public Builder routingResult(RoutingAllocation.Result routingResult) {
            this.routingTable = routingResult.routingTable();
            this.allocationExplanation = routingResult.explanation();
            return this;
        }

        public Builder routingTable(RoutingTable routingTable) {
            this.routingTable = routingTable;
            return this;
        }

        public Builder metaData(MetaData.Builder metaDataBuilder) {
            return this.metaData(metaDataBuilder.build());
        }

        public Builder metaData(MetaData metaData) {
            this.metaData = metaData;
            return this;
        }

        public Builder blocks(ClusterBlocks.Builder blocksBuilder) {
            return this.blocks(blocksBuilder.build());
        }

        public Builder blocks(ClusterBlocks block) {
            this.blocks = block;
            return this;
        }

        public Builder allocationExplanation(AllocationExplanation allocationExplanation) {
            this.allocationExplanation = allocationExplanation;
            return this;
        }

        public Builder version(long version) {
            this.version = version;
            return this;
        }

        public Custom getCustom(String type) {
            return this.customs.get(type);
        }

        public Builder putCustom(String type, Custom custom) {
            this.customs.put(type, custom);
            return this;
        }

        public Builder removeCustom(String type) {
            this.customs.remove(type);
            return this;
        }

        public ClusterState build() {
            return new ClusterState(this.version, this.metaData, this.routingTable, this.nodes, this.blocks, this.allocationExplanation, this.customs.build());
        }

        public static byte[] toBytes(ClusterState state) throws IOException {
            BytesStreamOutput os = new BytesStreamOutput();
            Builder.writeTo(state, os);
            return os.bytes().toBytes();
        }

        public static ClusterState fromBytes(byte[] data, DiscoveryNode localNode) throws IOException {
            return Builder.readFrom(new BytesStreamInput(data, false), localNode);
        }

        public static void writeTo(ClusterState state, StreamOutput out) throws IOException {
            out.writeLong(state.version());
            MetaData.Builder.writeTo(state.metaData(), out);
            RoutingTable.Builder.writeTo(state.routingTable(), out);
            DiscoveryNodes.Builder.writeTo(state.nodes(), out);
            ClusterBlocks.Builder.writeClusterBlocks(state.blocks(), out);
            state.allocationExplanation().writeTo(out);
            out.writeVInt(state.customs().size());
            for (ObjectObjectCursor<String, Custom> objectObjectCursor : state.customs()) {
                out.writeString((String)objectObjectCursor.key);
                ClusterState.lookupFactorySafe((String)objectObjectCursor.key).writeTo((Custom)objectObjectCursor.value, out);
            }
        }

        public static ClusterState readFrom(StreamInput in, @Nullable DiscoveryNode localNode) throws IOException {
            Builder builder = new Builder();
            builder.version = in.readLong();
            builder.metaData = MetaData.Builder.readFrom(in);
            builder.routingTable = RoutingTable.Builder.readFrom(in);
            builder.nodes = DiscoveryNodes.Builder.readFrom(in, localNode);
            builder.blocks = ClusterBlocks.Builder.readClusterBlocks(in);
            builder.allocationExplanation = AllocationExplanation.readAllocationExplanation(in);
            int customSize = in.readVInt();
            for (int i = 0; i < customSize; ++i) {
                String type = in.readString();
                Object customIndexMetaData = ClusterState.lookupFactorySafe(type).readFrom(in);
                builder.putCustom(type, (Custom)customIndexMetaData);
            }
            return builder.build();
        }
    }

    public static interface Custom {

        public static interface Factory<T extends Custom> {
            public String type();

            public T readFrom(StreamInput var1) throws IOException;

            public void writeTo(T var1, StreamOutput var2) throws IOException;

            public void toXContent(T var1, XContentBuilder var2, ToXContent.Params var3);
        }
    }
}

