/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.open;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.open.OpenIndexClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.open.OpenIndexRequest;
import org.elasticsearch.action.admin.indices.open.OpenIndexResponse;
import org.elasticsearch.action.support.DestructiveOperations;
import org.elasticsearch.action.support.master.TransportMasterNodeOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.ClusterStateUpdateListener;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.MetaDataIndexStateService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.settings.NodeSettingsService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportOpenIndexAction
extends TransportMasterNodeOperationAction<OpenIndexRequest, OpenIndexResponse> {
    private final MetaDataIndexStateService indexStateService;
    private final DestructiveOperations destructiveOperations;

    @Inject
    public TransportOpenIndexAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetaDataIndexStateService indexStateService, NodeSettingsService nodeSettingsService) {
        super(settings, transportService, clusterService, threadPool);
        this.indexStateService = indexStateService;
        this.destructiveOperations = new DestructiveOperations(this.logger, settings, nodeSettingsService);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected String transportAction() {
        return "indices/open";
    }

    @Override
    protected OpenIndexRequest newRequest() {
        return new OpenIndexRequest();
    }

    @Override
    protected OpenIndexResponse newResponse() {
        return new OpenIndexResponse();
    }

    @Override
    protected void doExecute(OpenIndexRequest request, ActionListener<OpenIndexResponse> listener) {
        this.destructiveOperations.failDestructive(request.indices());
        super.doExecute(request, listener);
    }

    @Override
    protected ClusterBlockException checkBlock(OpenIndexRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA, request.indices());
    }

    @Override
    protected void masterOperation(final OpenIndexRequest request, ClusterState state, final ActionListener<OpenIndexResponse> listener) throws ElasticsearchException {
        request.indices(state.metaData().concreteIndices(request.indices(), request.indicesOptions()));
        OpenIndexClusterStateUpdateRequest updateRequest = (OpenIndexClusterStateUpdateRequest)((OpenIndexClusterStateUpdateRequest)((OpenIndexClusterStateUpdateRequest)new OpenIndexClusterStateUpdateRequest().ackTimeout(request.timeout())).masterNodeTimeout(request.masterNodeTimeout())).indices(request.indices());
        this.indexStateService.openIndex(updateRequest, new ClusterStateUpdateListener(){

            @Override
            public void onResponse(ClusterStateUpdateResponse response) {
                listener.onResponse(new OpenIndexResponse(response.isAcknowledged()));
            }

            @Override
            public void onFailure(Throwable t) {
                TransportOpenIndexAction.this.logger.debug("failed to open indices [{}]", t, (Object[])request.indices());
                listener.onFailure(t);
            }
        });
    }
}

