/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.system;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.manifoldcf.core.database.ConnectionFactory;
import org.apache.manifoldcf.core.interfaces.CacheManagerFactory;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.DBInterfaceFactory;
import org.apache.manifoldcf.core.interfaces.ICacheManager;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IPollingHook;
import org.apache.manifoldcf.core.interfaces.IShutdownHook;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.IThrottleGroups;
import org.apache.manifoldcf.core.interfaces.LockManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFConfiguration;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.core.interfaces.ThrottleGroupsFactory;
import org.apache.manifoldcf.core.system.Logging;
import org.apache.manifoldcf.core.system.ManifoldCFResourceLoader;

public class ManifoldCF {
    public static final String _rcsid = "@(#)$Id: ManifoldCF.java 988245 2010-08-23 18:39:35Z kwright $";
    public static final String NODE_LIBDIR = "libdir";
    public static final String ATTRIBUTE_PATH = "path";
    protected static String processID = null;
    protected static File workingDirectory = null;
    protected static ManifoldCFResourceLoader resourceLoader = null;
    protected static FileTrack tracker = null;
    protected static DatabaseShutdown dbShutdown = null;
    protected static final List<IShutdownHook> cleanupHooks = new ArrayList<IShutdownHook>();
    protected static final List<IPollingHook> pollingHooks = new ArrayList<IPollingHook>();
    protected static Thread shutdownThread = new ShutdownThread();
    protected static int initializeLevel;
    protected static boolean alreadyClosed;
    protected static boolean alreadyShutdown;
    protected static Integer initializeFlagLock;
    protected static String loginUserName;
    protected static String loginPassword;
    protected static String apiLoginUserName;
    protected static String apiLoginPassword;
    protected static String masterDatabaseName;
    protected static String masterDatabaseUsername;
    protected static String masterDatabasePassword;
    protected static ManifoldCFConfiguration localConfiguration;
    protected static long propertyFilelastMod;
    protected static String propertyFilePath;
    protected static final String applicationName = "lcf";
    public static final String lcfConfigFileProperty = "org.apache.manifoldcf.configfile";
    public static final String processIDProperty = "org.apache.manifoldcf.processid";
    public static final String loginUserNameProperty = "org.apache.manifoldcf.login.name";
    public static final String loginPasswordProperty = "org.apache.manifoldcf.login.password";
    public static final String apiLoginUserNameProperty = "org.apache.manifoldcf.apilogin.name";
    public static final String apiLoginPasswordProperty = "org.apache.manifoldcf.apilogin.password";
    public static final String masterDatabaseNameProperty = "org.apache.manifoldcf.database.name";
    public static final String masterDatabaseUsernameProperty = "org.apache.manifoldcf.database.username";
    public static final String masterDatabasePasswordProperty = "org.apache.manifoldcf.database.password";
    public static final String databaseHandleMaxcountProperty = "org.apache.manifoldcf.database.maxhandles";
    public static final String databaseHandleTimeoutProperty = "org.apache.manifoldcf.database.handletimeout";
    public static final String databaseConnectionTrackingProperty = "org.apache.manifoldcf.database.connectiontracking";
    public static final String databaseQueryMaxTimeProperty = "org.apache.manifoldcf.database.maxquerytime";
    public static final String logConfigFileProperty = "org.apache.manifoldcf.logconfigfile";
    public static final String lockManagerImplementation = "org.apache.manifoldcf.lockmanagerclass";
    public static final String databaseImplementation = "org.apache.manifoldcf.databaseimplementationclass";
    public static final String configSignalCommandProperty = "org.apache.manifoldcf.configuration.change.command";
    public static final String maintenanceFileSignalProperty = "org.apache.manifoldcf.database.maintenanceflag";

    @Deprecated
    public static void resetEnvironment() {
        ManifoldCF.resetEnvironment(ThreadContextFactory.make());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetEnvironment(IThreadContext threadContext) {
        Integer n = initializeFlagLock;
        synchronized (n) {
            if (initializeLevel > 0) {
                ManifoldCF.cleanUpEnvironment(threadContext);
                processID = null;
                loginUserName = null;
                loginPassword = null;
                apiLoginUserName = null;
                apiLoginPassword = null;
                masterDatabaseName = null;
                masterDatabaseUsername = null;
                masterDatabasePassword = null;
                localConfiguration = null;
                propertyFilelastMod = -1L;
                propertyFilePath = null;
                alreadyClosed = false;
                alreadyShutdown = false;
                initializeLevel = 0;
            }
        }
    }

    @Deprecated
    public static void initializeEnvironment() throws ManifoldCFException {
        ManifoldCF.initializeEnvironment(ThreadContextFactory.make());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeEnvironment(IThreadContext threadContext) throws ManifoldCFException {
        Integer n = initializeFlagLock;
        synchronized (n) {
            if (initializeLevel == 0) {
                try {
                    Properties props = System.getProperties();
                    propertyFilePath = (String)props.get(lcfConfigFileProperty);
                    if (propertyFilePath == null) {
                        System.err.println("Couldn't find org.apache.manifoldcf.configfile property; using default");
                        String configPath = (String)props.get("user.home") + "/" + applicationName;
                        configPath = configPath.replace('\\', '/');
                        propertyFilePath = new File(configPath, "properties.xml").toString();
                    }
                    workingDirectory = new File(propertyFilePath).getAbsoluteFile().getParentFile();
                    resourceLoader = new ManifoldCFResourceLoader(Thread.currentThread().getContextClassLoader());
                    localConfiguration = new OverrideableManifoldCFConfiguration();
                    ManifoldCF.checkProperties();
                    processID = ManifoldCF.getStringProperty(processIDProperty, "");
                    if (processID.length() > 16) {
                        throw new ManifoldCFException("Process ID cannot exceed 16 characters!");
                    }
                    File logConfigFile = ManifoldCF.getFileProperty(logConfigFileProperty);
                    if (logConfigFile == null) {
                        System.err.println("Couldn't find org.apache.manifoldcf.logconfigfile property; using default");
                        String configPath = (String)props.get("user.home") + "/" + applicationName;
                        configPath = configPath.replace('\\', '/');
                        logConfigFile = new File(configPath, "logging.ini");
                    }
                    List<Object> list = cleanupHooks;
                    synchronized (list) {
                        cleanupHooks.clear();
                    }
                    list = pollingHooks;
                    synchronized (list) {
                        pollingHooks.clear();
                    }
                    Logging.initializeLoggingSystem(logConfigFile);
                    Logging.initializeLoggers();
                    Logging.setLogLevels(threadContext);
                    loginUserName = LockManagerFactory.getStringProperty(threadContext, loginUserNameProperty, "admin");
                    loginPassword = LockManagerFactory.getPossiblyObfuscatedStringProperty(threadContext, loginPasswordProperty, "admin");
                    apiLoginUserName = LockManagerFactory.getStringProperty(threadContext, apiLoginUserNameProperty, "");
                    apiLoginPassword = LockManagerFactory.getPossiblyObfuscatedStringProperty(threadContext, apiLoginPasswordProperty, "");
                    masterDatabaseName = LockManagerFactory.getStringProperty(threadContext, masterDatabaseNameProperty, "dbname");
                    masterDatabaseUsername = LockManagerFactory.getStringProperty(threadContext, masterDatabaseUsernameProperty, "manifoldcf");
                    masterDatabasePassword = LockManagerFactory.getPossiblyObfuscatedStringProperty(threadContext, masterDatabasePasswordProperty, "local_pg_passwd");
                    ManifoldCF.addShutdownHook(new ThrottlerShutdown());
                    ManifoldCF.addPollingHook(new ThrottlerPoll());
                    ManifoldCF.addPollingHook(new CachePoll());
                    tracker = new FileTrack();
                    ManifoldCF.addShutdownHook(tracker);
                    ManifoldCF.addShutdownHook(new DatabaseShutdown());
                    DBInterfaceFactory.make(threadContext, masterDatabaseName, masterDatabaseUsername, masterDatabasePassword).openDatabase();
                }
                catch (ManifoldCFException e) {
                    throw new ManifoldCFException("Initialization failed: " + e.getMessage(), e, 3);
                }
            }
            ++initializeLevel;
        }
    }

    public static final String getProcessID() {
        return processID;
    }

    public static final ManifoldCFConfiguration getConfiguration() {
        return localConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void checkProperties() throws ManifoldCFException {
        block8: {
            File f = new File(propertyFilePath);
            try {
                if (propertyFilelastMod != f.lastModified()) {
                    try (FileInputStream is = new FileInputStream(f);){
                        localConfiguration.fromXML(is);
                        System.err.println("Configuration file successfully read");
                        propertyFilelastMod = f.lastModified();
                        break block8;
                    }
                }
                System.err.println("Configuration file not read because it didn't change");
                return;
            }
            catch (Exception e) {
                throw new ManifoldCFException("Could not read configuration file '" + f.toString() + "'", e);
            }
        }
        ArrayList<File> libDirs = new ArrayList<File>();
        int i = 0;
        while (i < localConfiguration.getChildCount()) {
            ConfigurationNode cn;
            if (!(cn = localConfiguration.findChild(i++)).getType().equals(NODE_LIBDIR)) continue;
            String path = cn.getAttributeValue(ATTRIBUTE_PATH);
            if (path == null) {
                throw new ManifoldCFException("Node type 'libdir' requires a 'path attribute");
            }
            libDirs.add(ManifoldCF.resolvePath(path));
        }
        resourceLoader.setClassPath(libDirs);
    }

    public static File resolvePath(String path) {
        File r = new File(path);
        return r.isAbsolute() ? r : new File(workingDirectory, path);
    }

    public static String getProperty(String s) {
        return localConfiguration.getProperty(s);
    }

    public static File getFileProperty(String s) {
        String value = ManifoldCF.getProperty(s);
        if (value == null) {
            return null;
        }
        return ManifoldCF.resolvePath(value);
    }

    public static String getStringProperty(String s, String defaultValue) {
        return localConfiguration.getStringProperty(s, defaultValue);
    }

    public static boolean getBooleanProperty(String s, boolean defaultValue) throws ManifoldCFException {
        return localConfiguration.getBooleanProperty(s, defaultValue);
    }

    public static int getIntProperty(String s, int defaultValue) throws ManifoldCFException {
        return localConfiguration.getIntProperty(s, defaultValue);
    }

    public static long getLongProperty(String s, long defaultValue) throws ManifoldCFException {
        return localConfiguration.getLongProperty(s, defaultValue);
    }

    public static double getDoubleProperty(String s, double defaultValue) throws ManifoldCFException {
        return localConfiguration.getDoubleProperty(s, defaultValue);
    }

    public static void ensureFolder(String path) throws ManifoldCFException {
        try {
            File f = new File(path);
            if (!f.isDirectory()) {
                f.mkdirs();
            }
        }
        catch (Exception e) {
            throw new ManifoldCFException("Can't make folder", e, 0);
        }
    }

    public static void deleteFolder(String path) {
        File directoryPath = new File(path);
        ManifoldCF.recursiveDelete(directoryPath);
    }

    public static void recursiveDelete(File directoryPath) {
        File[] children;
        if (!directoryPath.exists()) {
            return;
        }
        if (directoryPath.isDirectory() && (children = directoryPath.listFiles()) != null) {
            int i = 0;
            while (i < children.length) {
                File x = children[i++];
                ManifoldCF.recursiveDelete(x);
            }
        }
        directoryPath.delete();
    }

    public static boolean isFolder(String path) {
        File f = new File(path);
        return f.isDirectory();
    }

    public static String safeFileName(String value) {
        StringBuilder rval = new StringBuilder();
        int i = 0;
        while (i < value.length()) {
            char x;
            if ((x = value.charAt(i++)) == '/' || x == '\"' || x == '\\' || x == '|' || x >= '\u0000' && x < ' ' || x == '+' || x == ',' || x == ':' || x == ';' || x == '<' || x == '>' || x == '=' || x == '[' || x == ']' || x == '&') {
                rval.append("&").append(Integer.toString(x)).append("!");
                continue;
            }
            rval.append(x);
        }
        return rval.toString();
    }

    public static String getMasterDatabaseName() {
        return masterDatabaseName;
    }

    public static String getMasterDatabaseUsername() {
        return masterDatabaseUsername;
    }

    public static String getMasterDatabasePassword() {
        return masterDatabasePassword;
    }

    public static String getChildDatabaseName(IDBInterface companyDatabase, String childDBIdentifier) {
        return companyDatabase.getDatabaseName() + "_" + childDBIdentifier;
    }

    public static String hash(String input) throws ManifoldCFException {
        return ManifoldCF.encrypt(input);
    }

    public static MessageDigest startHash() throws ManifoldCFException {
        try {
            return MessageDigest.getInstance("SHA");
        }
        catch (Exception e) {
            throw new ManifoldCFException("Couldn't encrypt: " + e.getMessage(), e, 0);
        }
    }

    public static void addToHash(MessageDigest digest, String input) throws ManifoldCFException {
        try {
            byte[] inputBytes = input.getBytes(StandardCharsets.UTF_8);
            digest.update(inputBytes);
        }
        catch (Exception e) {
            throw new ManifoldCFException("Couldn't encrypt: " + e.getMessage(), e, 0);
        }
    }

    public static String getHashValue(MessageDigest digest) throws ManifoldCFException {
        try {
            byte[] encryptedBytes = digest.digest();
            StringBuilder rval = new StringBuilder();
            int i = 0;
            while (i < encryptedBytes.length) {
                byte x = encryptedBytes[i++];
                rval.append(ManifoldCF.writeNibble(x >> 4 & 0xF));
                rval.append(ManifoldCF.writeNibble(x & 0xF));
            }
            return rval.toString();
        }
        catch (Exception e) {
            throw new ManifoldCFException("Couldn't encrypt: " + e.getMessage(), e, 0);
        }
    }

    public static boolean verifyAPILogin(IThreadContext threadContext, String userID, String userPassword) throws ManifoldCFException {
        if (userID != null && userPassword != null) {
            return userID.equals(apiLoginUserName) && userPassword.equals(apiLoginPassword);
        }
        return false;
    }

    public static boolean verifyLogin(IThreadContext threadContext, String userID, String userPassword) throws ManifoldCFException {
        if (userID != null && userPassword != null) {
            return userID.equals(loginUserName) && userPassword.equals(loginPassword);
        }
        return false;
    }

    public static String encrypt(String input) throws ManifoldCFException {
        MessageDigest hash = ManifoldCF.startHash();
        ManifoldCF.addToHash(hash, input);
        return ManifoldCF.getHashValue(hash);
    }

    public static String obfuscate(String input) throws ManifoldCFException {
        if (input == null) {
            return null;
        }
        if (input.length() == 0) {
            return input;
        }
        byte[] array = input.getBytes(StandardCharsets.UTF_8);
        int i = 0;
        int carryover = array[array.length - 1] & 0x1F;
        while (i < array.length) {
            int x = array[i];
            int newCarryover = x & 0x1F;
            x = (x >> 5 & 7) + (carryover << 3);
            carryover = newCarryover;
            array[i++] = (byte)(x ^ 0x59);
        }
        StringBuilder rval = new StringBuilder();
        i = 0;
        while (i < array.length) {
            byte x = array[i++];
            rval.append(ManifoldCF.writeNibble(x >> 4 & 0xF));
            rval.append(ManifoldCF.writeNibble(x & 0xF));
        }
        return rval.toString();
    }

    protected static char writeNibble(int value) {
        if (value >= 10) {
            return (char)(value - 10 + 65);
        }
        return (char)(value + 48);
    }

    public static String deobfuscate(String input) throws ManifoldCFException {
        if (input == null) {
            return null;
        }
        if (input.length() == 0) {
            return input;
        }
        if ((input.length() >> 1) * 2 != input.length()) {
            throw new ManifoldCFException("Decoding error", 0);
        }
        byte[] bytes = new byte[input.length() >> 1];
        int i = 0;
        int j = 0;
        while (i < input.length()) {
            int x0 = ManifoldCF.readNibble(input.charAt(i++));
            int x1 = ManifoldCF.readNibble(input.charAt(i++));
            int x = (x0 << 4) + x1;
            bytes[j++] = (byte)x;
        }
        int carryover = (bytes[0] ^ 0x59) >> 3 & 0x1F;
        i = bytes.length;
        while (i > 0) {
            int x = bytes[--i] ^ 0x59;
            int newCarryover = x >> 3 & 0x1F;
            x = (x << 5) + carryover;
            bytes[i] = (byte)x;
            carryover = newCarryover;
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    protected static int readNibble(char value) throws ManifoldCFException {
        if (value >= 'A' && value <= 'F') {
            return value - 65 + 10;
        }
        if (value >= '0' && value <= '9') {
            return value - 48;
        }
        throw new ManifoldCFException("Bad hexadecimal value", 0);
    }

    public static void createSystemDatabase(IThreadContext threadcontext, String masterUsername, String masterPassword) throws ManifoldCFException {
        String databaseName = ManifoldCF.getMasterDatabaseName();
        String databaseUsername = ManifoldCF.getMasterDatabaseUsername();
        String databasePassword = ManifoldCF.getMasterDatabasePassword();
        IDBInterface master = DBInterfaceFactory.make(threadcontext, databaseName, databaseUsername, databasePassword);
        master.createUserAndDatabase(masterUsername, masterPassword, null);
    }

    public static void dropSystemDatabase(IThreadContext threadcontext, String masterUsername, String masterPassword) throws ManifoldCFException {
        String databaseName = ManifoldCF.getMasterDatabaseName();
        String databaseUsername = ManifoldCF.getMasterDatabaseUsername();
        String databasePassword = ManifoldCF.getMasterDatabasePassword();
        IDBInterface master = DBInterfaceFactory.make(threadcontext, databaseName, databaseUsername, databasePassword);
        master.dropUserAndDatabase(masterUsername, masterPassword, null);
    }

    public static File createTempDir(String prefix, String suffix) throws ManifoldCFException {
        String tempDirLocation = System.getProperty("java.io.tmpdir");
        if (tempDirLocation == null) {
            throw new ManifoldCFException("Can't find temporary directory!");
        }
        File tempDir = new File(tempDirLocation);
        long currentFileID = System.currentTimeMillis();
        long currentFileHash = currentFileID << 5 ^ currentFileID >> 3;
        int raceConditionRepeat = 0;
        while (raceConditionRepeat < 1000) {
            File tempCertDir = new File(tempDir, prefix + currentFileHash + suffix);
            if (tempCertDir.mkdir()) {
                return tempCertDir;
            }
            if (tempCertDir.exists()) {
                ++currentFileHash;
                continue;
            }
            ++raceConditionRepeat;
            Thread.yield();
        }
        throw new ManifoldCFException("Temporary directory appears to be unwritable");
    }

    public static void addFile(File f) {
        tracker.addFile(f);
    }

    public static void deleteFile(File f) {
        tracker.deleteFile(f);
    }

    public static boolean checkMaintenanceUnderway() {
        String fileToCheck = ManifoldCF.getProperty(maintenanceFileSignalProperty);
        if (fileToCheck != null && fileToCheck.length() > 0) {
            File f = new File(fileToCheck);
            return f.exists();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void noteConfigurationChange() throws ManifoldCFException {
        String configChangeSignalCommand = ManifoldCF.getProperty(configSignalCommandProperty);
        if (configChangeSignalCommand == null || configChangeSignalCommand.length() == 0) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        int currentIndex = 0;
        while (currentIndex < configChangeSignalCommand.length()) {
            char x;
            while (currentIndex < configChangeSignalCommand.length() && (x = configChangeSignalCommand.charAt(currentIndex)) >= '\u0000' && x <= ' ') {
                ++currentIndex;
            }
            StringBuilder argBuffer = new StringBuilder();
            boolean isQuoted = false;
            while (currentIndex < configChangeSignalCommand.length()) {
                char x2 = configChangeSignalCommand.charAt(currentIndex);
                if (isQuoted) {
                    if (x2 == '\"') {
                        ++currentIndex;
                        isQuoted = false;
                        continue;
                    }
                    if (x2 == '\\') {
                        if (++currentIndex >= configChangeSignalCommand.length()) break;
                        x2 = configChangeSignalCommand.charAt(currentIndex);
                        argBuffer.append(x2);
                        continue;
                    }
                    ++currentIndex;
                    argBuffer.append(x2);
                    continue;
                }
                if (x2 == '\"') {
                    ++currentIndex;
                    isQuoted = true;
                    continue;
                }
                if (x2 == '\\') {
                    if (++currentIndex >= configChangeSignalCommand.length()) break;
                    x2 = configChangeSignalCommand.charAt(currentIndex);
                    argBuffer.append(x2);
                    continue;
                }
                if (x2 >= '\u0000' && x2 <= ' ') break;
                ++currentIndex;
                argBuffer.append(x2);
            }
            list.add(argBuffer.toString());
        }
        String[] commandArray = new String[list.size()];
        for (int i = 0; i < commandArray.length; ++i) {
            commandArray[i] = (String)list.get(i);
        }
        if (commandArray.length == 0) {
            return;
        }
        String[] env = new String[]{};
        File dir = new File("/");
        try {
            Process p = Runtime.getRuntime().exec(commandArray, env, dir);
            try {
                int rval = p.waitFor();
                if (rval != 0) {
                    InputStream is = p.getErrorStream();
                    try {
                        InputStreamReader r = new InputStreamReader(is);
                        try {
                            BufferedReader br = new BufferedReader(r);
                            try {
                                String value;
                                StringBuilder sb = new StringBuilder();
                                while ((value = br.readLine()) != null) {
                                    sb.append(value).append("; ");
                                }
                                throw new ManifoldCFException("Shelled process '" + configChangeSignalCommand + "' failed with error " + Integer.toString(rval) + ": " + sb.toString());
                            }
                            catch (Throwable throwable) {
                                br.close();
                                throw throwable;
                            }
                        }
                        catch (Throwable throwable) {
                            ((Reader)r).close();
                            throw throwable;
                        }
                    }
                    catch (Throwable throwable) {
                        is.close();
                        throw throwable;
                    }
                }
            }
            finally {
                p.destroy();
            }
        }
        catch (InterruptedException e) {
            throw new ManifoldCFException("Process wait interrupted: " + e.getMessage(), e, 2);
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("IO with subprocess interrupted: " + e.getMessage(), e, 2);
        }
        catch (IOException e) {
            throw new ManifoldCFException("IO exception signalling change: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sleep(long milliseconds) throws InterruptedException {
        Integer x;
        Integer n = x = new Integer(0);
        synchronized (n) {
            x.wait(milliseconds);
        }
    }

    public static void writeBytes(OutputStream os, byte[] byteArray) throws IOException {
        os.write(byteArray, 0, byteArray.length);
    }

    public static void writeByte(OutputStream os, int byteValue) throws IOException {
        ManifoldCF.writeBytes(os, new byte[]{(byte)byteValue});
    }

    public static void writeWord(OutputStream os, int wordValue) throws IOException {
        byte[] buffer = new byte[]{(byte)(wordValue & 0xFF), (byte)(wordValue >>> 8 & 0xFF)};
        ManifoldCF.writeBytes(os, buffer);
    }

    public static void writeDword(OutputStream os, int dwordValue) throws IOException {
        if (dwordValue < 0) {
            throw new IllegalArgumentException("Attempt to use an unsigned operator to write a signed value");
        }
        ManifoldCF.writeSdword(os, dwordValue);
    }

    public static void writeSdword(OutputStream os, int dwordValue) throws IOException {
        byte[] buffer = new byte[]{(byte)(dwordValue & 0xFF), (byte)(dwordValue >>> 8 & 0xFF), (byte)(dwordValue >>> 16 & 0xFF), (byte)(dwordValue >>> 24 & 0xFF)};
        ManifoldCF.writeBytes(os, buffer);
    }

    public static void writeLong(OutputStream os, Long longValue) throws IOException {
        if (longValue == null) {
            ManifoldCF.writeByte(os, 1);
        } else {
            ManifoldCF.writeByte(os, 0);
            long value = longValue;
            byte[] buffer = new byte[]{(byte)(value & 0xFFL), (byte)(Long.rotateRight(value, 8) & 0xFFL), (byte)(Long.rotateRight(value, 16) & 0xFFL), (byte)(Long.rotateRight(value, 24) & 0xFFL), (byte)(Long.rotateRight(value, 32) & 0xFFL), (byte)(Long.rotateRight(value, 40) & 0xFFL), (byte)(Long.rotateRight(value, 48) & 0xFFL), (byte)(Long.rotateRight(value, 56) & 0xFFL)};
            ManifoldCF.writeBytes(os, buffer);
        }
    }

    public static void writeString(OutputStream os, String stringValue) throws IOException {
        byte[] characters = stringValue == null ? null : stringValue.getBytes(StandardCharsets.UTF_8);
        ManifoldCF.writeByteArray(os, characters);
    }

    public static void writeByteArray(OutputStream os, byte[] byteArray) throws IOException {
        if (byteArray == null) {
            ManifoldCF.writeSdword(os, -1);
        } else {
            ManifoldCF.writeSdword(os, byteArray.length);
            ManifoldCF.writeBytes(os, byteArray);
        }
    }

    public static void writefloat(OutputStream os, float floatValue) throws IOException {
        ManifoldCF.writeSdword(os, Float.floatToIntBits(floatValue));
    }

    public static void readBytes(InputStream is, byte[] byteArray) throws IOException {
        int amt;
        for (int amtSoFar = 0; amtSoFar < byteArray.length; amtSoFar += amt) {
            amt = is.read(byteArray, amtSoFar, byteArray.length - amtSoFar);
            if (amt != -1) continue;
            throw new IOException("Unexpected EOF");
        }
    }

    public static int readByte(InputStream is) throws IOException {
        byte[] inputArray = new byte[1];
        ManifoldCF.readBytes(is, inputArray);
        return inputArray[0] & 0xFF;
    }

    public static int readWord(InputStream is) throws IOException {
        byte[] inputArray = new byte[2];
        ManifoldCF.readBytes(is, inputArray);
        return (inputArray[0] & 0xFF) + ((inputArray[1] & 0xFF) << 8);
    }

    public static int readDword(InputStream is) throws IOException {
        byte[] inputArray = new byte[4];
        ManifoldCF.readBytes(is, inputArray);
        return (inputArray[0] & 0xFF) + ((inputArray[1] & 0xFF) << 8) + ((inputArray[2] & 0xFF) << 16) + ((inputArray[3] & 0xFF) << 24);
    }

    public static int readSdword(InputStream is) throws IOException {
        byte[] inputArray = new byte[4];
        ManifoldCF.readBytes(is, inputArray);
        return (inputArray[0] & 0xFF) + ((inputArray[1] & 0xFF) << 8) + ((inputArray[2] & 0xFF) << 16) + (inputArray[3] << 24);
    }

    public static Long readLong(InputStream is) throws IOException {
        int value = ManifoldCF.readByte(is);
        if (value == 1) {
            return null;
        }
        byte[] inputArray = new byte[8];
        ManifoldCF.readBytes(is, inputArray);
        return new Long((long)(inputArray[0] & 0xFF) + Long.rotateLeft(inputArray[1] & 0xFF, 8) + Long.rotateLeft(inputArray[2] & 0xFF, 16) + Long.rotateLeft(inputArray[3] & 0xFF, 24) + Long.rotateLeft(inputArray[4] & 0xFF, 32) + Long.rotateLeft(inputArray[5] & 0xFF, 40) + Long.rotateLeft(inputArray[6] & 0xFF, 48) + Long.rotateLeft(inputArray[7] & 0xFF, 56));
    }

    public static String readString(InputStream is) throws IOException {
        byte[] bytes = ManifoldCF.readByteArray(is);
        if (bytes == null) {
            return null;
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static byte[] readByteArray(InputStream is) throws IOException {
        int length = ManifoldCF.readSdword(is);
        if (length == -1) {
            return null;
        }
        byte[] byteArray = new byte[length];
        ManifoldCF.readBytes(is, byteArray);
        return byteArray;
    }

    public static float readfloat(InputStream os) throws IOException {
        return Float.intBitsToFloat(ManifoldCF.readSdword(os));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addShutdownHook(IShutdownHook hook) {
        List<IShutdownHook> list = cleanupHooks;
        synchronized (list) {
            cleanupHooks.add(hook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPollingHook(IPollingHook hook) {
        List<IPollingHook> list = pollingHooks;
        synchronized (list) {
            pollingHooks.add(hook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pollAll(IThreadContext threadContext) throws ManifoldCFException {
        List<IPollingHook> list = pollingHooks;
        synchronized (list) {
            for (IPollingHook hook : pollingHooks) {
                hook.doPoll(threadContext);
            }
        }
    }

    public static ManifoldCFResourceLoader createResourceLoader() throws ManifoldCFException {
        return new ManifoldCFResourceLoader(resourceLoader.getClassLoader());
    }

    public static Class findClass(String cname) throws ClassNotFoundException, ManifoldCFException {
        return resourceLoader.findClass(cname);
    }

    @Deprecated
    public static void cleanUpEnvironment() {
        ManifoldCF.cleanUpEnvironment(ThreadContextFactory.make());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanUpEnvironment(IThreadContext threadContext) {
        Integer n = initializeFlagLock;
        synchronized (n) {
            if (--initializeLevel == 0 && !alreadyShutdown) {
                List<Object> list = cleanupHooks;
                synchronized (list) {
                    int i = cleanupHooks.size();
                    while (i > 0) {
                        IShutdownHook hook = cleanupHooks.get(--i);
                        try {
                            hook.doCleanup(threadContext);
                        }
                        catch (ManifoldCFException e) {
                            Logging.root.warn((Object)("Error during system shutdown: " + e.getMessage()), (Throwable)e);
                        }
                    }
                    cleanupHooks.clear();
                }
                list = pollingHooks;
                synchronized (list) {
                    pollingHooks.clear();
                }
                alreadyShutdown = true;
            }
        }
    }

    static {
        try {
            Runtime.getRuntime().addShutdownHook(shutdownThread);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Error e) {
            e.printStackTrace();
        }
        initializeLevel = 0;
        alreadyClosed = false;
        alreadyShutdown = false;
        initializeFlagLock = new Integer(0);
        loginUserName = null;
        loginPassword = null;
        apiLoginUserName = null;
        apiLoginPassword = null;
        masterDatabaseName = null;
        masterDatabaseUsername = null;
        masterDatabasePassword = null;
        localConfiguration = null;
        propertyFilelastMod = -1L;
        propertyFilePath = null;
    }

    protected static class DatabaseConnectionReleaseThread
    extends Thread {
        public DatabaseConnectionReleaseThread() {
            this.setName("Database connection release thread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            ConnectionFactory.releaseAll();
        }
    }

    protected static class ShutdownThread
    extends Thread {
        public ShutdownThread() {
            this.setName("Shutdown thread");
        }

        @Override
        public void run() {
            ManifoldCF.cleanUpEnvironment(ThreadContextFactory.make());
        }
    }

    protected static class DatabaseShutdown
    implements IShutdownHook {
        @Override
        public void doCleanup(IThreadContext threadContext) throws ManifoldCFException {
            DatabaseConnectionReleaseThread t = new DatabaseConnectionReleaseThread();
            t.start();
            try {
                t.join(15000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.closeDatabase();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void closeDatabase() throws ManifoldCFException {
            Integer n = initializeFlagLock;
            synchronized (n) {
                if (initializeLevel == 0 && !alreadyClosed) {
                    IThreadContext threadcontext = ThreadContextFactory.make();
                    String databaseName = ManifoldCF.getMasterDatabaseName();
                    String databaseUsername = ManifoldCF.getMasterDatabaseUsername();
                    String databasePassword = ManifoldCF.getMasterDatabasePassword();
                    DBInterfaceFactory.make(threadcontext, databaseName, databaseUsername, databasePassword).closeDatabase();
                    alreadyClosed = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.closeDatabase();
            }
            finally {
                super.finalize();
            }
        }
    }

    protected static class CachePoll
    implements IPollingHook {
        @Override
        public void doPoll(IThreadContext threadContext) throws ManifoldCFException {
            ICacheManager cacheManager = CacheManagerFactory.make(threadContext);
            cacheManager.expireObjects(System.currentTimeMillis());
        }
    }

    protected static class ThrottlerShutdown
    implements IShutdownHook {
        @Override
        public void doCleanup(IThreadContext threadContext) throws ManifoldCFException {
            IThrottleGroups connectionThrottler = ThrottleGroupsFactory.make(threadContext);
            connectionThrottler.destroy();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.doCleanup(ThreadContextFactory.make());
            }
            finally {
                super.finalize();
            }
        }
    }

    protected static class ThrottlerPoll
    implements IPollingHook {
        @Override
        public void doPoll(IThreadContext threadContext) throws ManifoldCFException {
            IThrottleGroups connectionThrottler = ThrottleGroupsFactory.make(threadContext);
            connectionThrottler.poll();
        }
    }

    protected static class FileTrack
    implements IShutdownHook {
        protected Set<File> filesToDelete = new HashSet<File>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addFile(File f) {
            FileTrack fileTrack = this;
            synchronized (fileTrack) {
                this.filesToDelete.add(f);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteFile(File f) {
            ManifoldCF.recursiveDelete(f);
            FileTrack fileTrack = this;
            synchronized (fileTrack) {
                this.filesToDelete.remove(f);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doCleanup(IThreadContext threadContext) throws ManifoldCFException {
            FileTrack fileTrack = this;
            synchronized (fileTrack) {
                for (File f : this.filesToDelete) {
                    f.delete();
                }
                this.filesToDelete.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.doCleanup(ThreadContextFactory.make());
            }
            finally {
                super.finalize();
            }
        }
    }

    protected static class OverrideableManifoldCFConfiguration
    extends ManifoldCFConfiguration {
        @Override
        public String getProperty(String s) {
            String rval = System.getProperty(s);
            if (rval == null) {
                rval = super.getProperty(s);
            }
            return rval;
        }
    }
}

