/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.scriptengine;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.manifoldcf.core.interfaces.Configuration;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.scriptengine.Command;
import org.apache.manifoldcf.scriptengine.ScriptException;
import org.apache.manifoldcf.scriptengine.ScriptParser;
import org.apache.manifoldcf.scriptengine.Token;
import org.apache.manifoldcf.scriptengine.TokenStream;
import org.apache.manifoldcf.scriptengine.VariableReference;
import org.apache.manifoldcf.scriptengine.VariableResult;

public class PUTCommand
implements Command {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean parseAndExecute(ScriptParser sp, TokenStream currentStream) throws ScriptException {
        Token t;
        VariableReference result = sp.evaluateExpression(currentStream);
        if (result == null) {
            ScriptParser.syntaxError(currentStream, "Missing result expression");
        }
        if ((t = currentStream.peek()) == null || t.getPunctuation() == null || !t.getPunctuation().equals("=")) {
            ScriptParser.syntaxError(currentStream, "Missing '=' sign");
        }
        currentStream.skip();
        VariableReference send = sp.evaluateExpression(currentStream);
        if (send == null) {
            ScriptParser.syntaxError(currentStream, "Missing send expression");
        }
        if ((t = currentStream.peek()) == null || t.getToken() == null || !t.getToken().equals("to")) {
            ScriptParser.syntaxError(currentStream, "Missing 'to'");
        }
        currentStream.skip();
        VariableReference url = sp.evaluateExpression(currentStream);
        if (url == null) {
            ScriptParser.syntaxError(currentStream, "Missing URL expression");
        }
        String urlString = ScriptParser.resolveMustExist(currentStream, url).getStringValue();
        Configuration configuration = ScriptParser.resolveMustExist(currentStream, send).getConfigurationValue();
        String json = configuration.toJSON();
        HttpClient client = sp.getHttpClient();
        HttpPut method = new HttpPut(urlString);
        try {
            method.setEntity((HttpEntity)new StringEntity(json, ContentType.create((String)"text/plain", (Charset)StandardCharsets.UTF_8)));
            HttpResponse httpResponse = client.execute((HttpUriRequest)method);
            int resultCode = httpResponse.getStatusLine().getStatusCode();
            String resultJSON = ScriptParser.convertToString(httpResponse);
            result.setReference(new VariableResult(resultCode, resultJSON));
            boolean bl = false;
            return bl;
        }
        catch (Throwable throwable) {
            try {
                throw throwable;
            }
            catch (ManifoldCFException e) {
                throw new ScriptException(e.getMessage(), e);
            }
            catch (IOException e) {
                throw new ScriptException(e.getMessage(), e);
            }
        }
    }

    @Override
    public void parseAndSkip(ScriptParser sp, TokenStream currentStream) throws ScriptException {
        Token t;
        if (!sp.skipExpression(currentStream)) {
            ScriptParser.syntaxError(currentStream, "Missing result expression");
        }
        if ((t = currentStream.peek()) == null || t.getPunctuation() == null || !t.getPunctuation().equals("=")) {
            ScriptParser.syntaxError(currentStream, "Missing '=' sign");
        }
        currentStream.skip();
        if (!sp.skipExpression(currentStream)) {
            ScriptParser.syntaxError(currentStream, "Missing send expression");
        }
        if ((t = currentStream.peek()) == null || t.getToken() == null || !t.getToken().equals("to")) {
            ScriptParser.syntaxError(currentStream, "Missing 'to'");
        }
        currentStream.skip();
        if (!sp.skipExpression(currentStream)) {
            ScriptParser.syntaxError(currentStream, "Missing URL expression");
        }
    }
}

