/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.report.claim.impl.xml;

import java.io.IOException;
import java.util.Calendar;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.rat.api.Document;
import org.apache.rat.api.MetaData;
import org.apache.rat.api.RatException;
import org.apache.rat.report.AbstractReport;
import org.apache.rat.report.xml.writer.IXmlWriter;

public class SimpleXmlClaimReporter
extends AbstractReport {
    public static final String RAT_REPORT = "rat-report";
    public static final String TIMESTAMP = "timestamp";
    public static final String LICENSE_APPROVAL_PREDICATE = "license-approval";
    public static final String LICENSE_FAMILY_PREDICATE = "license-family";
    public static final String HEADER_SAMPLE_PREDICATE = "header-sample";
    public static final String HEADER_TYPE_PREDICATE = "header-type";
    public static final String FILE_TYPE_PREDICATE = "type";
    public static final String ARCHIVE_TYPE_PREDICATE = "archive-type";
    public static final String ARCHIVE_TYPE_UNREADABLE = "unreadable";
    public static final String ARCHIVE_TYPE_READABLE = "readable";
    private final IXmlWriter writer;
    private static final String NAME = "name";
    private boolean firstTime = true;

    public SimpleXmlClaimReporter(IXmlWriter writer) {
        this.writer = writer;
    }

    protected void writeClaim(String pPredicate, String pObject, boolean pLiteral) throws IOException, RatException {
        if (pLiteral) {
            this.writer.openElement(pPredicate).content(pObject).closeElement();
        } else {
            this.writer.openElement(pPredicate).attribute(NAME, pObject).closeElement();
        }
    }

    public void report(Document subject) throws RatException {
        try {
            if (this.firstTime) {
                this.firstTime = false;
            } else {
                this.writer.closeElement();
            }
            this.writer.openElement("resource").attribute(NAME, subject.getName());
            this.writeDocumentClaims(subject);
        }
        catch (IOException e) {
            throw new RatException("XML writing failure: " + e.getMessage() + " subject: " + subject, e);
        }
    }

    private void writeDocumentClaims(Document subject) throws IOException, RatException {
        MetaData metaData = subject.getMetaData();
        this.writeHeaderSample(metaData);
        this.writeHeaderCategory(metaData);
        this.writeLicenseFamilyName(metaData);
        this.writeApprovedLicense(metaData);
        this.writeDocumentCategory(metaData);
    }

    private void writeApprovedLicense(MetaData metaData) throws IOException, RatException {
        String approvedLicense = metaData.value("http://org/apache/rat/meta-data#ApprovedLicense");
        if (approvedLicense != null) {
            this.writeClaim(LICENSE_APPROVAL_PREDICATE, approvedLicense, false);
        }
    }

    private void writeLicenseFamilyName(MetaData metaData) throws IOException, RatException {
        String licenseFamilyName = metaData.value("http://org/apache/rat/meta-data#LicenseFamilyName");
        if (licenseFamilyName != null) {
            this.writeClaim(LICENSE_FAMILY_PREDICATE, licenseFamilyName, false);
        }
    }

    private void writeHeaderCategory(MetaData metaData) throws IOException, RatException {
        String headerCategory = metaData.value("http://org/apache/rat/meta-data#HeaderCategory");
        if (headerCategory != null) {
            this.writeClaim(HEADER_TYPE_PREDICATE, headerCategory, false);
        }
    }

    private void writeHeaderSample(MetaData metaData) throws IOException, RatException {
        String sample = metaData.value("http://org/apache/rat/meta-data#HeaderSample");
        if (sample != null) {
            this.writeClaim(HEADER_SAMPLE_PREDICATE, sample, true);
        }
    }

    private void writeDocumentCategory(MetaData metaData) throws IOException, RatException {
        String documentCategory = metaData.value("http://org/apache/rat/meta-data#FileCategory");
        if (documentCategory != null) {
            this.writeClaim(FILE_TYPE_PREDICATE, documentCategory, false);
        }
    }

    public void startReport() throws RatException {
        try {
            this.writer.openElement(RAT_REPORT).attribute(TIMESTAMP, DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(Calendar.getInstance()));
        }
        catch (IOException e) {
            throw new RatException("Cannot open start element", e);
        }
    }

    public void endReport() throws RatException {
        try {
            this.writer.closeDocument();
        }
        catch (IOException e) {
            throw new RatException("Cannot close last element", e);
        }
    }
}

