/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.listeners;

import java.io.Writer;

class LineFlushingWriter
extends Writer {
    private Writer w;

    public LineFlushingWriter(Writer writer) {
        this.w = writer;
    }

    @Override
    public void write(int n) {
        this.w.write(n);
        if (n == 10) {
            this.flush();
        }
    }

    @Override
    public void write(char[] cArray, int n, int n2) {
        this.w.write(cArray, n, n2);
        for (int i = 0; i < n2; ++i) {
            if (cArray[n + i] != '\n') continue;
            this.flush();
            break;
        }
    }

    @Override
    public void write(String string, int n, int n2) {
        this.w.write(string, n, n2);
        for (int i = 0; i < n2; ++i) {
            if (string.charAt(n + i) != '\n') continue;
            this.flush();
            break;
        }
    }

    @Override
    public Writer append(char c) {
        this.w.append(c);
        if (c == '\n') {
            this.flush();
        }
        return this;
    }

    @Override
    public Writer append(CharSequence charSequence) {
        this.w.append(charSequence);
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            if (charSequence.charAt(i) != '\n') continue;
            this.flush();
            break;
        }
        return this;
    }

    @Override
    public Writer append(CharSequence charSequence, int n, int n2) {
        this.w.append(charSequence, n, n2);
        for (int i = n; i < n2; ++i) {
            if (charSequence.charAt(i) != '\n') continue;
            this.flush();
            break;
        }
        return this;
    }

    @Override
    public void flush() {
        this.w.flush();
    }

    @Override
    public void close() {
        this.w.close();
    }
}

