/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.test.junit;

import java.util.Optional;
import java.util.stream.Stream;
import org.apache.logging.log4j.core.test.AvailablePortFinder;
import org.apache.logging.log4j.core.test.junit.AllocatePorts;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

class PortAllocatorCallback
implements BeforeEachCallback,
AfterEachCallback,
BeforeAllCallback,
AfterAllCallback {
    PortAllocatorCallback() {
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        AnnotationSupport.findAnnotation((Optional)context.getTestClass(), AllocatePorts.class).map(AllocatePorts::value).stream().flatMap(Stream::of).forEach(PortAllocatorCallback::setSystemPropertyToAllocatedPort);
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        AnnotationSupport.findAnnotation((Optional)context.getTestMethod(), AllocatePorts.class).map(AllocatePorts::value).stream().flatMap(Stream::of).forEach(PortAllocatorCallback::setSystemPropertyToAllocatedPort);
    }

    public void afterEach(ExtensionContext context) throws Exception {
        AnnotationSupport.findAnnotation((Optional)context.getTestMethod(), AllocatePorts.class).map(AllocatePorts::value).stream().flatMap(Stream::of).forEach(System::clearProperty);
    }

    public void afterAll(ExtensionContext context) throws Exception {
        AnnotationSupport.findAnnotation((Optional)context.getTestClass(), AllocatePorts.class).map(AllocatePorts::value).stream().flatMap(Stream::of).forEach(System::clearProperty);
    }

    private static void setSystemPropertyToAllocatedPort(String key) {
        int port = AvailablePortFinder.getNextAvailable();
        System.setProperty(key, Integer.toString(port));
    }
}

