/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.test;

import java.net.URI;
import java.nio.file.Path;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.xml.XmlConfiguration;
import org.apache.logging.log4j.core.impl.Log4jContextFactory;
import org.assertj.core.api.Assertions;

public class LateConfigAbstractTest {
    private static final String CONFIG = "LateConfigAbstractTest.xml";
    private static final String FQCN = Log4jContextFactory.class.getName();

    protected static void testReconfiguration(Log4jContextFactory factory, Path loggingPath) throws Exception {
        try (LoggerContext context = factory.getContext(FQCN, null, null, false);){
            Configuration defaultConfig = context.getConfiguration();
            Assertions.assertThat((Object)defaultConfig).isInstanceOf(DefaultConfiguration.class);
            URI configLocation = LateConfigAbstractTest.class.getResource(CONFIG).toURI();
            LoggerContext context1 = factory.getContext(FQCN, null, null, false, configLocation, null);
            Assertions.assertThat((Object)context1).isSameAs((Object)context);
            Assertions.assertThat((Path)loggingPath.resolve("test-xml.log")).exists();
            Configuration newConfig = context.getConfiguration();
            Assertions.assertThat((Object)newConfig).isInstanceOf(XmlConfiguration.class);
            LoggerContext context2 = factory.getContext(FQCN, null, null, false);
            Assertions.assertThat((Object)context2).isSameAs((Object)context);
            Configuration sameConfig = context.getConfiguration();
            org.junit.jupiter.api.Assertions.assertSame((Object)newConfig, (Object)sameConfig, (String)"Configuration should not have been reset");
        }
    }
}

