/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AppenderControl;
import org.apache.logging.log4j.core.config.AppenderControlArraySet;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.ReliabilityStrategy;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.filter.AbstractFilterable;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.impl.LogEventFactory;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginAttribute;
import org.apache.logging.log4j.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.plugins.PluginElement;
import org.apache.logging.log4j.plugins.PluginFactory;
import org.apache.logging.log4j.plugins.di.Key;
import org.apache.logging.log4j.plugins.validation.constraints.Required;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.StackLocatorUtil;
import org.apache.logging.log4j.util.Strings;
import org.jspecify.annotations.Nullable;

@Configurable(printObject=true)
@Plugin(value="Logger")
public class LoggerConfig
extends AbstractFilterable {
    public static final String ROOT = "root";
    static Key<LoggerConfig> KEY = Key.forClass(LoggerConfig.class).withQualifierType(PluginElement.class);
    private List<AppenderRef> appenderRefs = new ArrayList<AppenderRef>();
    private final AppenderControlArraySet appenders = new AppenderControlArraySet();
    private final String name;
    private LogEventFactory logEventFactory;
    private Level level;
    private boolean additive = true;
    private boolean includeLocation = true;
    private LoggerConfig parent;
    private Map<Property, Boolean> propertiesMap;
    private final List<Property> properties;
    private final boolean propertiesRequireLookup;
    private final Configuration config;
    private final ReliabilityStrategy reliabilityStrategy;

    @PluginFactory
    public static <B extends Builder<B>> B newBuilder() {
        return new Builder().asBuilder();
    }

    public LoggerConfig(String name, Level level, boolean additive, Configuration config) {
        this(name, Collections.emptyList(), null, level, additive, null, config, LoggerConfig.includeLocation(null, config));
    }

    protected LoggerConfig(String name, List<AppenderRef> appenders, Filter filter, Level level, boolean additive, Property[] properties, Configuration config, boolean includeLocation) {
        super(filter, null);
        this.logEventFactory = config.getLogEventFactory();
        this.name = name;
        this.appenderRefs = appenders;
        this.level = level;
        this.additive = additive;
        this.includeLocation = includeLocation;
        this.config = config;
        this.properties = properties != null && properties.length > 0 ? Arrays.asList((Property[])properties.clone()) : null;
        this.propertiesRequireLookup = LoggerConfig.containsPropertyRequiringLookup(properties);
        this.reliabilityStrategy = config.getReliabilityStrategy(this);
    }

    private static boolean containsPropertyRequiringLookup(Property[] properties) {
        if (properties == null) {
            return false;
        }
        for (int i = 0; i < properties.length; ++i) {
            if (!properties[i].isValueNeedsLookup()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Filter getFilter() {
        return super.getFilter();
    }

    public String getName() {
        return this.name;
    }

    public void setParent(LoggerConfig parent) {
        this.parent = parent;
    }

    public LoggerConfig getParent() {
        return this.parent;
    }

    public void addAppender(Appender appender, Level level, Filter filter) {
        this.appenders.add(new AppenderControl(appender, level, filter));
    }

    public void removeAppender(String name) {
        AppenderControl removed = null;
        while ((removed = this.appenders.remove(name)) != null) {
            this.cleanupFilter(removed);
        }
    }

    public Map<String, Appender> getAppenders() {
        return this.appenders.asMap();
    }

    protected void clearAppenders() {
        do {
            AppenderControl[] original;
            for (AppenderControl ctl : original = this.appenders.clear()) {
                this.cleanupFilter(ctl);
            }
        } while (!this.appenders.isEmpty());
    }

    private void cleanupFilter(AppenderControl ctl) {
        Filter filter = ctl.getFilter();
        if (filter != null) {
            ctl.removeFilter(filter);
            filter.stop();
        }
    }

    public List<AppenderRef> getAppenderRefs() {
        return this.appenderRefs;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public Level getLevel() {
        return this.level == null ? (this.parent == null ? Level.ERROR : this.parent.getLevel()) : this.level;
    }

    public Level getExplicitLevel() {
        return this.level;
    }

    public LogEventFactory getLogEventFactory() {
        return this.logEventFactory;
    }

    public void setLogEventFactory(LogEventFactory logEventFactory) {
        this.logEventFactory = logEventFactory;
    }

    public boolean isAdditive() {
        return this.additive;
    }

    public void setAdditive(boolean additive) {
        this.additive = additive;
    }

    public boolean isIncludeLocation() {
        return this.includeLocation;
    }

    public List<Property> getPropertyList() {
        return this.properties;
    }

    public boolean isPropertiesRequireLookup() {
        return this.propertiesRequireLookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PerformanceSensitive(value={"allocation"})
    public void log(String loggerName, String fqcn, Marker marker, Level level, Message data, Throwable t) {
        List<Property> props = this.getProperties(loggerName, fqcn, marker, level, data, t);
        LogEvent logEvent = this.logEventFactory.createEvent(loggerName, marker, fqcn, this.location(fqcn), level, data, props, t);
        try {
            this.log(logEvent, null);
        }
        finally {
            this.logEventFactory.recycle(logEvent);
        }
    }

    private StackTraceElement location(String fqcn) {
        return this.requiresLocation() ? StackLocatorUtil.calcLocation((String)fqcn) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PerformanceSensitive(value={"allocation"})
    public void log(String loggerName, String fqcn, StackTraceElement location, Marker marker, Level level, Message data, Throwable t) {
        List<Property> props = this.getProperties(loggerName, fqcn, marker, level, data, t);
        LogEvent logEvent = this.logEventFactory.createEvent(loggerName, marker, fqcn, location, level, data, props, t);
        try {
            this.log(logEvent, null);
        }
        finally {
            this.logEventFactory.recycle(logEvent);
        }
    }

    private List<Property> getProperties(String loggerName, String fqcn, Marker marker, Level level, Message data, Throwable t) {
        List<Property> snapshot = this.properties;
        if (snapshot == null || !this.propertiesRequireLookup) {
            return snapshot;
        }
        return this.getPropertiesWithLookups(loggerName, fqcn, marker, level, data, t, snapshot);
    }

    private List<Property> getPropertiesWithLookups(String loggerName, String fqcn, Marker marker, Level level, Message data, Throwable t, List<Property> props) {
        ArrayList<Property> results = new ArrayList<Property>(props.size());
        Log4jLogEvent event = Log4jLogEvent.newBuilder().setMessage(data).setMarker(marker).setLevel(level).setLoggerName(loggerName).setLoggerFqcn(fqcn).setThrown(t).build();
        for (int i = 0; i < props.size(); ++i) {
            Property prop = props.get(i);
            String value = prop.isValueNeedsLookup() ? this.config.getStrSubstitutor().replace((LogEvent)event, prop.getValue()) : prop.getValue();
            results.add(Property.createProperty(prop.getName(), value));
        }
        return results;
    }

    public void log(LogEvent event) {
        this.log(event, null);
    }

    protected void log(LogEvent event, Predicate<LoggerConfig> predicate) {
        if (!this.isFiltered(event)) {
            this.processLogEvent(event, predicate);
        }
    }

    public ReliabilityStrategy getReliabilityStrategy() {
        return this.reliabilityStrategy;
    }

    protected void processLogEvent(LogEvent event, Predicate<LoggerConfig> predicate) {
        event.setIncludeLocation(this.isIncludeLocation());
        if (predicate == null || predicate.test(this)) {
            this.callAppenders(event);
        }
        this.logParent(event, predicate);
    }

    public boolean requiresLocation() {
        if (!this.includeLocation) {
            return false;
        }
        AppenderControl[] controls = this.appenders.get();
        LoggerConfig loggerConfig = this;
        while (loggerConfig != null) {
            for (AppenderControl control : controls) {
                if (!control.getAppender().requiresLocation()) continue;
                return true;
            }
            if (!loggerConfig.additive) break;
            loggerConfig = loggerConfig.parent;
            if (loggerConfig == null) continue;
            controls = loggerConfig.appenders.get();
        }
        return false;
    }

    private void logParent(LogEvent event, Predicate<LoggerConfig> predicate) {
        if (this.additive && this.parent != null) {
            this.parent.log(event, predicate);
        }
    }

    @PerformanceSensitive(value={"allocation"})
    protected void callAppenders(LogEvent event) {
        AppenderControl[] controls = this.appenders.get();
        for (int i = 0; i < controls.length; ++i) {
            controls[i].callAppender(event);
        }
    }

    public String toString() {
        return Strings.isEmpty((CharSequence)this.name) ? ROOT : this.name;
    }

    protected static boolean includeLocation(Boolean configuredValue, Configuration configuration) {
        if (configuredValue == null) {
            LoggerContext context = configuration.getLoggerContext();
            return context != null && context.includeLocation();
        }
        return configuredValue;
    }

    protected final boolean hasAppenders() {
        return !this.appenders.isEmpty();
    }

    protected static LevelAndRefs getLevelAndRefs(Level level, AppenderRef[] refs, String levelAndRefs, Configuration config) {
        LevelAndRefs result = new LevelAndRefs();
        if (levelAndRefs != null) {
            if (level != null) {
                LOGGER.warn("Level is ignored when levelAndRefs syntax is used.");
            }
            if (refs != null && refs.length > 0) {
                LOGGER.warn("Appender references are ignored when levelAndRefs syntax is used");
            }
            String[] parts = Strings.splitList((String)levelAndRefs);
            result.level = Level.getLevel((String)parts[0]);
            if (parts.length > 1) {
                ArrayList<AppenderRef> refList = new ArrayList<AppenderRef>();
                Arrays.stream(parts).skip(1L).forEach(ref -> refList.add(AppenderRef.createAppenderRef(ref, null, null)));
                result.refs = refList;
            }
        } else {
            result.level = level;
            result.refs = refs != null ? Arrays.asList(refs) : new ArrayList<AppenderRef>();
        }
        return result;
    }

    protected Configuration getConfiguration() {
        return this.config;
    }

    public static class Builder<B extends Builder<B>>
    implements org.apache.logging.log4j.plugins.util.Builder<LoggerConfig> {
        @PluginBuilderAttribute
        private boolean additivity = true;
        private Level level;
        private String levelAndRefs;
        private String loggerName;
        private @Nullable Boolean includeLocation;
        private AppenderRef[] refs;
        private Property[] properties;
        private Configuration config;
        private Filter filter;

        public boolean isAdditivity() {
            return this.additivity;
        }

        public B setAdditivity(boolean additivity) {
            this.additivity = additivity;
            return this.asBuilder();
        }

        public Level getLevel() {
            return this.level;
        }

        public B setLevel(@PluginAttribute Level level) {
            this.level = level;
            return this.asBuilder();
        }

        public String getLevelAndRefs() {
            return this.levelAndRefs;
        }

        public B setLevelAndRefs(@PluginAttribute String levelAndRefs) {
            this.levelAndRefs = levelAndRefs;
            return this.asBuilder();
        }

        public String getLoggerName() {
            return this.loggerName;
        }

        public B setLoggerName(@Required(message="Loggers cannot be configured without a name") @PluginAttribute String name) {
            this.loggerName = name;
            return this.asBuilder();
        }

        public @Nullable Boolean getIncludeLocation() {
            return this.includeLocation;
        }

        public B setIncludeLocation(@Nullable Boolean includeLocation) {
            this.includeLocation = includeLocation;
            return this.asBuilder();
        }

        @Deprecated
        public B setIncludeLocation(@PluginAttribute @Nullable String includeLocation) {
            return this.setIncludeLocation(includeLocation != null ? Boolean.valueOf(includeLocation) : null);
        }

        public AppenderRef[] getRefs() {
            return this.refs;
        }

        public B setRefs(AppenderRef ... refs) {
            this.refs = refs;
            return this.asBuilder();
        }

        public Property[] getProperties() {
            return this.properties;
        }

        public B setProperties(Property ... properties) {
            this.properties = properties;
            return this.asBuilder();
        }

        public Configuration getConfig() {
            return this.config;
        }

        public B setConfig(@PluginConfiguration Configuration config) {
            this.config = config;
            return this.asBuilder();
        }

        public Filter getFilter() {
            return this.filter;
        }

        public B setFilter(@PluginElement Filter filter) {
            this.filter = filter;
            return this.asBuilder();
        }

        public LoggerConfig build() {
            String name = this.loggerName.equals(LoggerConfig.ROOT) ? "" : this.loggerName;
            LevelAndRefs container = LoggerConfig.getLevelAndRefs(this.level, this.refs, this.levelAndRefs, this.config);
            boolean useLocation = LoggerConfig.includeLocation(this.getIncludeLocation(), this.config);
            return new LoggerConfig(name, container.refs, this.filter, container.level, this.isAdditivity(), this.properties, this.config, useLocation);
        }

        public B asBuilder() {
            return (B)this;
        }
    }

    protected static class LevelAndRefs {
        public Level level;
        public List<AppenderRef> refs;

        protected LevelAndRefs() {
        }
    }

    @Configurable(printObject=true)
    @Plugin(value="Root")
    public static final class RootLogger
    extends LoggerConfig {
        @PluginFactory
        public static Builder newRootBuilder() {
            return new Builder();
        }

        private RootLogger() {
            super("", Level.ERROR, false, null);
        }

        public static class Builder
        implements org.apache.logging.log4j.plugins.util.Builder<LoggerConfig> {
            protected static final boolean ADDITIVITY = true;
            private Level level;
            private String levelAndRefs;
            private @Nullable Boolean includeLocation;
            private AppenderRef[] refs;
            private Property[] properties;
            private Configuration config;
            private Filter filter;

            public Level getLevel() {
                return this.level;
            }

            public Builder setLevel(@PluginAttribute Level level) {
                this.level = level;
                return this;
            }

            public String getLevelAndRefs() {
                return this.levelAndRefs;
            }

            public Builder setLevelAndRefs(@PluginAttribute String levelAndRefs) {
                this.levelAndRefs = levelAndRefs;
                return this;
            }

            public @Nullable Boolean getIncludeLocation() {
                return this.includeLocation;
            }

            public Builder setIncludeLocation(@Nullable Boolean includeLocation) {
                this.includeLocation = includeLocation;
                return this;
            }

            @Deprecated
            public Builder setIncludeLocation(@PluginAttribute @Nullable String includeLocation) {
                return this.setIncludeLocation(includeLocation != null ? Boolean.valueOf(includeLocation) : null);
            }

            public AppenderRef[] getRefs() {
                return this.refs;
            }

            public Builder setRefs(@PluginElement AppenderRef[] refs) {
                this.refs = refs;
                return this;
            }

            public Property[] getProperties() {
                return this.properties;
            }

            public Builder setProperties(@PluginElement Property[] properties) {
                this.properties = properties;
                return this;
            }

            public Configuration getConfig() {
                return this.config;
            }

            public Builder setConfig(@PluginConfiguration Configuration config) {
                this.config = config;
                return this;
            }

            public Filter getFilter() {
                return this.filter;
            }

            public Builder setFilter(@PluginElement Filter filter) {
                this.filter = filter;
                return this;
            }

            public LoggerConfig build() {
                LevelAndRefs container = LoggerConfig.getLevelAndRefs(this.level, this.refs, this.levelAndRefs, this.config);
                return new LoggerConfig("", container.refs, this.filter, container.level, true, this.properties, this.config, LoggerConfig.includeLocation(this.getIncludeLocation(), this.config));
            }
        }
    }
}

