/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.di;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.plugins.di.ConfigurableInstanceFactory;
import org.apache.logging.log4j.plugins.di.DefaultInstanceFactory;
import org.apache.logging.log4j.plugins.di.InstanceFactory;
import org.apache.logging.log4j.plugins.di.Key;
import org.apache.logging.log4j.plugins.di.spi.ConfigurableInstanceFactoryPostProcessor;
import org.apache.logging.log4j.plugins.di.spi.Scope;
import org.apache.logging.log4j.plugins.util.OrderedComparator;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Lazy;
import org.apache.logging.log4j.util.ServiceLoaderUtil;

public final class DI {
    private DI() {
        throw new IllegalStateException("Utility class");
    }

    public static ConfigurableInstanceFactory createInitializedFactory() {
        return DI.builder().build();
    }

    public static FactoryBuilder builder() {
        return new FactoryBuilder();
    }

    public static class FactoryBuilder {
        private final Supplier<ConfigurableInstanceFactory> provider;
        private final List<ConfigurableInstanceFactoryPostProcessor> preInitializationBindings = new ArrayList<ConfigurableInstanceFactoryPostProcessor>();
        private final ConfigurableInstanceFactoryPostProcessor initializer;
        private final List<ConfigurableInstanceFactoryPostProcessor> postInitializationBindings = new ArrayList<ConfigurableInstanceFactoryPostProcessor>();

        public FactoryBuilder() {
            this.provider = DefaultInstanceFactory::new;
            this.initializer = factory -> ServiceLoaderUtil.safeStream(ConfigurableInstanceFactoryPostProcessor.class, ServiceLoader.load(ConfigurableInstanceFactoryPostProcessor.class, DI.class.getClassLoader()), (Logger)StatusLogger.getLogger()).sorted(Comparator.comparing(Object::getClass, OrderedComparator.INSTANCE)).forEachOrdered(processor -> processor.postProcessFactory(factory));
        }

        private FactoryBuilder(FactoryBuilder copy) {
            this.provider = copy.provider;
            this.preInitializationBindings.addAll(copy.preInitializationBindings);
            this.initializer = copy.initializer;
            this.postInitializationBindings.addAll(copy.postInitializationBindings);
        }

        public <T> UnscopedBindingBuilder<T> addInitialBindingFrom(Key<T> key) {
            return new UnscopedBindingBuilder<T>(key, this, this.preInitializationBindings::add);
        }

        public <T> UnscopedBindingBuilder<T> addInitialBindingFrom(Class<T> type) {
            return this.addInitialBindingFrom(Key.forClass(type));
        }

        public <T> UnscopedBindingBuilder<T> addBindingFrom(Key<T> key) {
            return new UnscopedBindingBuilder<T>(key, this, this.postInitializationBindings::add);
        }

        public <T> UnscopedBindingBuilder<T> addBindingFrom(Class<T> type) {
            return this.addBindingFrom(Key.forClass(type));
        }

        public FactoryBuilder addInitialBundle(Object bundle) {
            this.preInitializationBindings.add(factory -> factory.registerBundle(bundle));
            return this;
        }

        public FactoryBuilder addBundle(Object bundle) {
            this.postInitializationBindings.add(factory -> factory.registerBundle(bundle));
            return this;
        }

        public ConfigurableInstanceFactory build() {
            ConfigurableInstanceFactory factory = this.provider.get();
            this.preInitializationBindings.forEach(binding -> binding.postProcessFactory(factory));
            this.initializer.postProcessFactory(factory);
            this.postInitializationBindings.forEach(binding -> binding.postProcessFactory(factory));
            return factory;
        }

        public FactoryBuilder copy() {
            return new FactoryBuilder(this);
        }
    }

    public static class ScopedBindingBuilder<T>
    extends UnscopedBindingBuilder<T> {
        private final Class<? extends Annotation> scopeType;

        private ScopedBindingBuilder(UnscopedBindingBuilder<T> builder, Class<? extends Annotation> scopeType) {
            super(builder);
            this.scopeType = scopeType;
        }

        public FactoryBuilder toProvider(Supplier<? extends T> provider) {
            this.addBinding.accept(factory -> {
                Scope scope = factory.getRegisteredScope(this.scopeType);
                if (scope != null) {
                    Supplier<Object> scoped = scope.get(this.key, ((Supplier)provider)::get);
                    factory.registerBinding(this.key, scoped);
                } else {
                    factory.registerBinding(this.key, provider);
                }
            });
            return this.builder;
        }
    }

    public static class UnscopedBindingBuilder<T> {
        final Key<T> key;
        final FactoryBuilder builder;
        final Consumer<ConfigurableInstanceFactoryPostProcessor> addBinding;

        private UnscopedBindingBuilder(Key<T> key, FactoryBuilder builder, Consumer<ConfigurableInstanceFactoryPostProcessor> addBinding) {
            this.key = key;
            this.builder = builder;
            this.addBinding = addBinding;
        }

        private UnscopedBindingBuilder(UnscopedBindingBuilder<T> copy) {
            this(copy.key, copy.builder, copy.addBinding);
        }

        public ScopedBindingBuilder<T> inScope(Class<? extends Annotation> scopeType) {
            return new ScopedBindingBuilder(this, scopeType);
        }

        public FactoryBuilder toInstance(T instance) {
            this.addBinding.accept(factory -> factory.registerBinding(this.key, Lazy.value((Object)instance)));
            return this.builder;
        }

        public FactoryBuilder toSingleton(Supplier<? extends T> provider) {
            this.addBinding.accept(factory -> factory.registerBinding(this.key, Lazy.lazy((Supplier)provider)));
            return this.builder;
        }

        public FactoryBuilder toUnscoped(Supplier<? extends T> provider) {
            this.addBinding.accept(factory -> factory.registerBinding(this.key, provider));
            return this.builder;
        }

        public FactoryBuilder toFunction(Function<InstanceFactory, ? extends Supplier<? extends T>> function) {
            this.addBinding.accept(factory -> factory.registerBinding(this.key, (Supplier)function.apply(factory)));
            return this.builder;
        }
    }
}

