/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.kit.recycler.internal;

import aQute.bnd.annotation.spi.ServiceProvider;
import java.util.Objects;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.kit.env.PropertyEnvironment;
import org.apache.logging.log4j.kit.recycler.Recycler;
import org.apache.logging.log4j.kit.recycler.RecyclerFactory;
import org.apache.logging.log4j.kit.recycler.RecyclerFactoryProvider;
import org.apache.logging.log4j.kit.recycler.RecyclerProperties;
import org.apache.logging.log4j.kit.recycler.internal.ArrayQueue;
import org.apache.logging.log4j.kit.recycler.support.AbstractRecycler;
import org.apache.logging.log4j.util.LoaderUtil;

@ServiceProvider(value=RecyclerFactoryProvider.class)
public final class ThreadLocalRecyclerFactoryProvider
implements RecyclerFactoryProvider {
    private static final boolean SERVLET_API_PRESENT = LoaderUtil.isClassAvailable((String)"javax.servlet.Servlet") || LoaderUtil.isClassAvailable((String)"jakarta.servlet.Servlet");

    @Override
    public int getOrder() {
        return SERVLET_API_PRESENT ? Integer.MAX_VALUE : 700;
    }

    @Override
    public String getName() {
        return "threadLocal";
    }

    @Override
    public RecyclerFactory createForEnvironment(PropertyEnvironment environment) {
        Objects.requireNonNull(environment, "environment");
        int capacity = environment.getProperty(RecyclerProperties.class).capacity();
        return new ThreadLocalRecyclerFactory(capacity);
    }

    static final class ThreadLocalRecyclerFactory
    implements RecyclerFactory {
        final int capacity;

        private ThreadLocalRecyclerFactory(int capacity) {
            this.capacity = capacity;
        }

        @Override
        public <V> Recycler<V> create(Supplier<V> supplier, Consumer<V> cleaner) {
            Objects.requireNonNull(supplier, "supplier");
            Objects.requireNonNull(cleaner, "cleaner");
            return new ThreadLocalRecycler<V>(supplier, cleaner, this.capacity);
        }

        static final class ThreadLocalRecycler<V>
        extends AbstractRecycler<V> {
            private final Consumer<V> cleaner;
            final ThreadLocal<Queue<V>> queueRef = ThreadLocal.withInitial(() -> new ArrayQueue(capacity));

            private ThreadLocalRecycler(Supplier<V> supplier, Consumer<V> cleaner, int capacity) {
                super(supplier);
                this.cleaner = cleaner;
            }

            @Override
            public V acquire() {
                Queue<V> queue = this.queueRef.get();
                V value = queue.poll();
                return value != null ? value : this.createInstance();
            }

            @Override
            public void release(V value) {
                Objects.requireNonNull(value, "value");
                this.cleaner.accept(value);
                Queue<V> queue = this.queueRef.get();
                queue.offer(value);
            }
        }
    }
}

