/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.changelog.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.logging.log4j.changelog.util.PositionalSaxEventHandler;
import org.apache.logging.log4j.changelog.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.helpers.DefaultHandler;

public final class XmlReader {
    private XmlReader() {
    }

    public static Element readXmlFileRootElement(Path path, String rootElementName) {
        Element element;
        block9: {
            InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
            try {
                Document document = XmlReader.readXml(inputStream);
                Element rootElement = document.getDocumentElement();
                if (!rootElementName.equals(rootElement.getNodeName())) {
                    String message = String.format("was expecting root element to be called `%s`, found: `%s`", rootElementName, rootElement.getNodeName());
                    throw new IllegalArgumentException(message);
                }
                element = rootElement;
                if (inputStream == null) break block9;
            }
            catch (Throwable document) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable) {
                            document.addSuppressed(throwable);
                        }
                    }
                    throw document;
                }
                catch (Exception error) {
                    String message = String.format("XML read failure for file `%s` and root element `%s`", path, rootElementName);
                    throw new RuntimeException(message, error);
                }
            }
            inputStream.close();
        }
        return element;
    }

    @SuppressFBWarnings(value={"XXE_SAXPARSER"})
    private static Document readXml(InputStream inputStream) throws Exception {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        SAXParser parser = parserFactory.newSAXParser();
        DocumentBuilderFactory documentBuilderFactory = XmlUtils.createDocumentBuilderFactory();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        PositionalSaxEventHandler handler = new PositionalSaxEventHandler(document);
        parser.parse(inputStream, (DefaultHandler)handler);
        return document;
    }

    public static Stream<Element> findChildElementsMatchingName(Element parentElement, String childElementName) {
        NodeList childNodes = parentElement.getChildNodes();
        return IntStream.range(0, childNodes.getLength()).mapToObj(childNodes::item).filter(childNode -> childNode.getNodeType() == 1 && childElementName.equals(childNode.getNodeName())).map(childNode -> (Element)childNode);
    }

    public static Element requireChildElementMatchingName(Element parentElement, String childElementName) {
        List childElements = XmlReader.findChildElementsMatchingName(parentElement, childElementName).collect(Collectors.toList());
        int childElementCount = childElements.size();
        if (childElementCount != 1) {
            throw XmlReader.failureAtXmlNode(parentElement, "was expecting a single `%s` element, found: %d", childElementName, childElementCount);
        }
        return (Element)childElements.get(0);
    }

    public static String requireAttribute(Element element, String attributeName) {
        if (!element.hasAttribute(attributeName)) {
            throw XmlReader.failureAtXmlNode(element, "missing attribute: `%s`", attributeName);
        }
        return element.getAttribute(attributeName);
    }

    public static RuntimeException failureAtXmlNode(Node node, String messageFormat, Object ... messageArgs) {
        return XmlReader.failureAtXmlNode(null, node, messageFormat, messageArgs);
    }

    public static RuntimeException failureAtXmlNode(Throwable cause, Node node, String messageFormat, Object ... messageArgs) {
        Object lineNumber = node.getUserData("lineNumber");
        String messagePrefix = String.format("[line %s] ", lineNumber);
        String message = String.format(messagePrefix + messageFormat, messageArgs);
        return new IllegalArgumentException(message, cause);
    }
}

