/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.catalog.jpa.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.logging.log4j.catalog.jpa.model.EventAttributeModel;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.ItemLinks;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;

@Entity
@Table(name="CATALOG_EVENT", uniqueConstraints={@UniqueConstraint(columnNames={"NAME"})})
public class EventModel
implements Serializable,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject,
FetchGroupTracker,
PersistenceWeavedFetchGroups,
PersistenceWeavedRest {
    private static final long serialVersionUID = 1512172827909901054L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="ID", updatable=false, nullable=false)
    private Long id;
    @Column(name="NAME")
    private String name;
    @Column(name="DISPLAY_NAME")
    private String displayName;
    @Column(name="DESCRIPTION")
    private String description;
    @Column(name="CATALOG_ID")
    private String catalogId = "DEFAULT";
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="event_aliases", joinColumns={@JoinColumn(name="event_id")})
    @Column(name="alias")
    private Set<String> aliases;
    @OneToMany(fetch=FetchType.EAGER, mappedBy="event", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<EventAttributeModel> attributes = new HashSet<EventAttributeModel>();
    protected transient Object _persistence_primaryKey;
    protected transient CacheKey _persistence_cacheKey;
    @Transient
    @XmlTransient
    protected FetchGroup _persistence_fetchGroup;
    protected transient boolean _persistence_shouldRefreshFetchGroup;
    protected transient Session _persistence_session;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;
    protected transient ItemLinks _persistence_links;

    public Long getId() {
        return this._persistence_get_id();
    }

    public void setId(Long id) {
        this._persistence_set_id(id);
    }

    public String getName() {
        return this._persistence_get_name();
    }

    public void setName(String name) {
        this._persistence_set_name(name);
    }

    public String getDisplayName() {
        return this._persistence_get_displayName();
    }

    public void setDisplayName(String name) {
        this._persistence_set_displayName(name);
    }

    public String getDescription() {
        return this._persistence_get_description();
    }

    public void setDescription(String description) {
        this._persistence_set_description(description);
    }

    public Set<String> getAliases() {
        return this._persistence_get_aliases();
    }

    public void setAliases(Set<String> aliases) {
        this._persistence_set_aliases(aliases);
    }

    public String getCatalogId() {
        return this._persistence_get_catalogId();
    }

    public void setCatalogId(String catalogId) {
        this._persistence_set_catalogId(catalogId);
    }

    public Set<EventAttributeModel> getAttributes() {
        return this._persistence_get_attributes();
    }

    public List<String> getAttributeNames() {
        ArrayList<String> names = new ArrayList<String>(this._persistence_get_attributes().size());
        for (EventAttributeModel model : this._persistence_get_attributes()) {
            names.add(model.getAttribute().getName());
        }
        return names;
    }

    public EventAttributeModel getAttribute(String name) {
        for (EventAttributeModel model : this._persistence_get_attributes()) {
            if (!name.equals(model.getAttribute().getName())) continue;
            return model;
        }
        return null;
    }

    public void addEventAttribute(EventAttributeModel attribute) {
        this._persistence_get_attributes().add(attribute);
    }

    public void setAttributes(Set<EventAttributeModel> attributes) {
        this._persistence_set_attributes(attributes);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this._persistence_get_name()).toHashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof EventModel)) {
            return false;
        }
        EventModel other = (EventModel)o;
        return new EqualsBuilder().append((Object)this._persistence_get_name(), (Object)other._persistence_get_name()).isEquals();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{\"id\" : \"").append(this._persistence_get_id()).append("\"");
        sb.append(", \"name\" : \"").append(this._persistence_get_name()).append("\", \"displayName\" : \"").append(this._persistence_get_displayName()).append("\"");
        sb.append(", \"description\" : ").append(this._persistence_get_description()).append("\", \"attributes\" : [");
        boolean first = true;
        for (EventAttributeModel attribute : this._persistence_get_attributes()) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append("{\"name\" : \"").append(attribute.getAttribute().getName()).append("\", \"required\" : ").append(attribute.isRequired()).append("}");
        }
        sb.append("]}");
        return sb.toString();
    }

    public Object _persistence_post_clone() {
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public CacheKey _persistence_getCacheKey() {
        return this._persistence_cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this._persistence_cacheKey = cacheKey;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new EventModel();
    }

    public Object _persistence_get(String string) {
        if (string == "catalogId") {
            return this.catalogId;
        }
        if (string == "aliases") {
            return this.aliases;
        }
        if (string == "displayName") {
            return this.displayName;
        }
        if (string == "name") {
            return this.name;
        }
        if (string == "description") {
            return this.description;
        }
        if (string == "attributes") {
            return this.attributes;
        }
        if (string == "id") {
            return this.id;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "catalogId") {
            this.catalogId = (String)object;
            return;
        }
        if (string == "aliases") {
            this.aliases = (Set)object;
            return;
        }
        if (string == "displayName") {
            this.displayName = (String)object;
            return;
        }
        if (string == "name") {
            this.name = (String)object;
            return;
        }
        if (string == "description") {
            this.description = (String)object;
            return;
        }
        if (string == "attributes") {
            this.attributes = (Set)object;
            return;
        }
        if (string == "id") {
            this.id = (Long)object;
            return;
        }
    }

    public String _persistence_get_catalogId() {
        this._persistence_checkFetched("catalogId");
        return this.catalogId;
    }

    public void _persistence_set_catalogId(String string) {
        this._persistence_checkFetchedForSet("catalogId");
        this.catalogId = string;
    }

    public Set _persistence_get_aliases() {
        this._persistence_checkFetched("aliases");
        return this.aliases;
    }

    public void _persistence_set_aliases(Set set) {
        this._persistence_checkFetchedForSet("aliases");
        this.aliases = set;
    }

    public String _persistence_get_displayName() {
        this._persistence_checkFetched("displayName");
        return this.displayName;
    }

    public void _persistence_set_displayName(String string) {
        this._persistence_checkFetchedForSet("displayName");
        this.displayName = string;
    }

    public String _persistence_get_name() {
        this._persistence_checkFetched("name");
        return this.name;
    }

    public void _persistence_set_name(String string) {
        this._persistence_checkFetchedForSet("name");
        this.name = string;
    }

    public String _persistence_get_description() {
        this._persistence_checkFetched("description");
        return this.description;
    }

    public void _persistence_set_description(String string) {
        this._persistence_checkFetchedForSet("description");
        this.description = string;
    }

    public Set _persistence_get_attributes() {
        this._persistence_checkFetched("attributes");
        return this.attributes;
    }

    public void _persistence_set_attributes(Set set) {
        this._persistence_checkFetchedForSet("attributes");
        this.attributes = set;
    }

    public Long _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(Long l) {
        this._persistence_checkFetchedForSet("id");
        this.id = l;
    }

    public Session _persistence_getSession() {
        return this._persistence_session;
    }

    public void _persistence_setSession(Session session) {
        this._persistence_session = session;
    }

    public FetchGroup _persistence_getFetchGroup() {
        return this._persistence_fetchGroup;
    }

    public void _persistence_setFetchGroup(FetchGroup fetchGroup) {
        this._persistence_fetchGroup = fetchGroup;
    }

    public boolean _persistence_shouldRefreshFetchGroup() {
        return this._persistence_shouldRefreshFetchGroup;
    }

    public void _persistence_setShouldRefreshFetchGroup(boolean bl) {
        this._persistence_shouldRefreshFetchGroup = bl;
    }

    public void _persistence_resetFetchGroup() {
    }

    public boolean _persistence_isAttributeFetched(String string) {
        return this._persistence_fetchGroup == null || this._persistence_fetchGroup.containsAttributeInternal(string);
    }

    public void _persistence_checkFetched(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttribute((FetchGroupTracker)this, (String)string);
        }
    }

    public void _persistence_checkFetchedForSet(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttributeForSet((FetchGroupTracker)this, (String)string);
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }

    public ItemLinks _persistence_getLinks() {
        return this._persistence_links;
    }

    public void _persistence_setLinks(ItemLinks itemLinks) {
        this._persistence_links = itemLinks;
    }
}

