/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.zeroconf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.chainsaw.zeroconf.ZeroConfPlugin;
import org.apache.log4j.chainsaw.zeroconf.ZeroConfPreferenceModel;

public class ZeroConfDeviceModel
extends AbstractTableModel
implements ServiceListener {
    private List<ServiceInfo> deviceList = new ArrayList<ServiceInfo>();
    private ZeroConfPreferenceModel zeroConfPreferenceModel;
    private transient ZeroConfPlugin plugin;

    @Override
    public int getRowCount() {
        return this.deviceList.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    public ServiceInfo getServiceInfoAtRow(int row) {
        return this.deviceList.get(row);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ServiceInfo info = this.deviceList.get(rowIndex);
        if (info == null) {
            return "";
        }
        switch (columnIndex) {
            case 0: {
                return this.getAutoConnectHandle(info);
            }
            case 1: {
                return info.getAddress().getHostName() + ":" + info.getPort();
            }
            case 2: {
                return this.zeroConfPreferenceModel.getAutoConnectDevices().contains(this.getAutoConnectHandle(info)) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 3: {
                return this.plugin.isConnectedTo(info) ? "Connected" : "Not Connected";
            }
        }
        return "";
    }

    private String getAutoConnectHandle(ServiceInfo info) {
        return info.getName();
    }

    public void serviceAdded(ServiceEvent event) {
    }

    public void serviceRemoved(ServiceEvent event) {
        Iterator<ServiceInfo> iter = this.deviceList.iterator();
        while (iter.hasNext()) {
            ServiceInfo info = iter.next();
            if (!info.getName().equals(event.getName())) continue;
            iter.remove();
        }
        this.fireTableDataChanged();
    }

    public void serviceResolved(ServiceEvent event) {
        this.deviceList.add(event.getInfo());
        this.fireTableDataChanged();
    }

    public void setZeroConfPreferenceModel(ZeroConfPreferenceModel zeroConfPreferenceModel) {
        this.zeroConfPreferenceModel = zeroConfPreferenceModel;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "ZeroConf name";
            }
            case 1: {
                return "Address:Port";
            }
            case 2: {
                return "Auto-connect";
            }
            case 3: {
                return "Connection Status";
            }
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 2;
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 2: {
                return Boolean.class;
            }
        }
        return super.getColumnClass(columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex != 2 || !(aValue instanceof Boolean)) {
            return;
        }
        boolean autoConnect = (Boolean)aValue;
        ServiceInfo device = this.deviceList.get(rowIndex);
        String autoConnectHandle = this.getAutoConnectHandle(device);
        if (autoConnect) {
            this.zeroConfPreferenceModel.getAutoConnectDevices().add(autoConnectHandle);
        } else {
            this.zeroConfPreferenceModel.getAutoConnectDevices().remove(autoConnectHandle);
        }
        this.fireTableDataChanged();
    }

    void setZeroConfPluginParent(ZeroConfPlugin parent) {
        this.plugin = parent;
    }
}

