/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.shared.common.error;

import java.sql.DataTruncation;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.derby.shared.common.error.ShutdownException;

public class MessageUtils {
    private static final Locale EN = new Locale("en", "US");
    public static final String SQLERRMC_MESSAGE_DELIMITER = new String(new char[]{'\u0014', '\u0014', '\u0014'});
    public static final int DB2_JCC_MAX_EXCEPTION_PARAM_LENGTH = 2400;
    public static String SQLERRMC_TOKEN_DELIMITER = new String(new char[]{'\u0014'});
    private static String SQLERRMC_PREFORMATTED_MESSAGE_DELIMITER = "::";

    protected int supportedMessageParamLength() {
        return 2400;
    }

    public static Object[] getArgs(String string, String string2) {
        String string3 = string;
        Object[] objectArray = null;
        if (string2 != null && string2.length() > 0) {
            int n;
            char[] cArray = string2.toCharArray();
            int n2 = 0;
            int n3 = -1;
            for (n = 0; n < cArray.length; ++n) {
                if (cArray[n] != '\u0014') continue;
                ++n2;
                n3 = n;
            }
            if (n2 == 0) {
                string3 = new String(cArray);
                objectArray = new Object[1];
            } else {
                string3 = new String(cArray, n3 + 1, cArray.length - n3 - 1);
                objectArray = new Object[n2 + 1];
                n = 0;
                int n4 = 0;
                for (int i = 0; i < n3 + 1; ++i) {
                    if (i != n3 && cArray[i] != '\u0014') continue;
                    objectArray[n4++] = new String(cArray, n, i - n);
                    n = i + 1;
                }
            }
            objectArray[objectArray.length - 1] = string3;
        } else {
            objectArray = new Object[1];
            objectArray[objectArray.length - 1] = string3;
        }
        return objectArray;
    }

    public static String encodeMessageAndArgumentsAsSqlerrmc(String string, Object[] objectArray) {
        String string2 = "";
        for (int i = 0; objectArray != null && i < objectArray.length; ++i) {
            string2 = string2 + objectArray[i] + SQLERRMC_TOKEN_DELIMITER;
        }
        string2 = string2 + string;
        return string2;
    }

    public static String encodeExceptionAsSqlerrmc(SQLException sQLException) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(sQLException.getLocalizedMessage());
        sQLException = sQLException.getNextException();
        if (sQLException != null) {
            stringBuilder.append(SQLERRMC_TOKEN_DELIMITER);
            stringBuilder.append("SQLSTATE: ").append(sQLException.getSQLState());
        }
        return stringBuilder.toString();
    }

    private String buildDataTruncationSqlerrmc(DataTruncation dataTruncation) {
        return dataTruncation.getIndex() + SQLERRMC_TOKEN_DELIMITER + dataTruncation.getParameter() + SQLERRMC_TOKEN_DELIMITER + dataTruncation.getRead() + SQLERRMC_TOKEN_DELIMITER + dataTruncation.getDataSize() + SQLERRMC_TOKEN_DELIMITER + dataTruncation.getTransferSize();
    }

    private String buildPreformattedSqlerrmc(SQLException sQLException) {
        if (sQLException == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(sQLException.getLocalizedMessage());
        while ((sQLException = sQLException.getNextException()) != null) {
            stringBuilder.append(SQLERRMC_PREFORMATTED_MESSAGE_DELIMITER);
            stringBuilder.append("SQLSTATE: ");
            stringBuilder.append(sQLException.getSQLState());
        }
        return stringBuilder.toString();
    }

    public static int hashString50(String string) {
        int n = 0;
        int n2 = string.length();
        if (n2 > 5) {
            n2 = 5;
        }
        for (int i = 0; i < n2; ++i) {
            n += string.charAt(i);
        }
        return n %= 50;
    }

    public static ResourceBundle getBundleWithEnDefault(String string, Locale locale) {
        try {
            return ResourceBundle.getBundle(string, locale);
        }
        catch (MissingResourceException missingResourceException) {
            return ResourceBundle.getBundle(string, EN);
        }
    }

    public static ResourceBundle getBundleForLocale(Locale locale, String string) {
        try {
            return MessageUtils.getBundleWithEnDefault("org.apache.derby.loc.m" + MessageUtils.hashString50(string), locale);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public static String formatMessage(ResourceBundle resourceBundle, String string, Object[] objectArray, boolean bl) {
        block12: {
            if (objectArray == null) {
                objectArray = new Object[]{};
            }
            if (resourceBundle != null) {
                try {
                    string = resourceBundle.getString(string);
                    try {
                        return MessageFormat.format(string, objectArray);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    if (!bl) break block12;
                    throw missingResourceException;
                }
            }
        }
        if (string == null) {
            string = "UNKNOWN";
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = objectArray.length;
        if (n > 0) {
            stringBuffer.append(" : ");
        }
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append('[');
            stringBuffer.append(i);
            stringBuffer.append("] ");
            if (objectArray[i] == null) {
                stringBuffer.append("null");
                continue;
            }
            stringBuffer.append(objectArray[i].toString());
        }
        return stringBuffer.toString();
    }

    public static void getLocalizedMessage(int n, short s, String string, String string2, int n2, int n3, int n4, int n5, int n6, int n7, String string3, String string4, String string5, String string6, String[] stringArray, int[] nArray) {
        Object[] objectArray;
        Object object;
        int n8 = string6.indexOf("_");
        Locale locale = EN;
        if (n8 != -1) {
            int n9 = string6.lastIndexOf("_");
            object = string6.substring(0, n8);
            if (n9 == n8) {
                objectArray = string6.substring(n8 + 1);
                locale = new Locale((String)object, (String)objectArray);
            } else {
                objectArray = string6.substring(n8 + 1, n9);
                String string7 = string6.substring(n9 + 1);
                locale = new Locale((String)object, (String)objectArray, string7);
            }
        }
        String string8 = string4;
        object = MessageUtils.getArgs(string4, string);
        string8 = (String)object[((Object[])object).length - 1];
        objectArray = new Object[((Object[])object).length - 1];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = object[i];
        }
        try {
            stringArray[0] = MessageUtils.formatMessage(MessageUtils.getBundleForLocale(locale, string8), string8, objectArray, true);
            nArray[0] = 0;
            return;
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (ShutdownException shutdownException) {
            // empty catch block
        }
        stringArray[0] = MessageUtils.formatMessage(MessageUtils.getBundleForLocale(EN, string8), string8, objectArray, false);
        nArray[0] = 0;
    }

    public static String getLocalizedMessage(Locale locale, String string, Object[] objectArray) {
        String string2 = null;
        try {
            string2 = MessageUtils.formatMessage(MessageUtils.getBundleForLocale(locale, string), string, objectArray, true);
            return string2;
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (ShutdownException shutdownException) {
            // empty catch block
        }
        string2 = MessageUtils.formatMessage(MessageUtils.getBundleForLocale(EN, string), string, objectArray, false);
        return string2;
    }
}

